/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSFailover;
import weblogic.jms.common.LoadBalancer;
import weblogic.jms.common.RRLoadBalancer;
import weblogic.jms.common.RandomLoadBalancer;
import weblogic.jms.dd.DDConstants;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.dd.DDMember;
import weblogic.jms.frontend.FESession;
import weblogic.rmi.extensions.RemoteHelper;

public final class JMSLoadBalancer
implements DDConstants {
    private int size;
    private boolean doInit = true;
    private boolean isTopic;
    private boolean isPartitionedDistributedTopic;
    private LoadBalancer durableSubscriberLB;
    private LoadBalancer connectionConsumerLB;
    private LoadBalancer consumerLB;
    private LoadBalancer npProducerLB;
    private LoadBalancer pProducerLB;
    private LoadBalancer consumerAllLB;
    private LoadBalancer npProducerAllLB;
    private LoadBalancer pProducerAllLB;
    private DDHandler ddHandler;

    public JMSLoadBalancer(DDHandler dDHandler) {
        this.ddHandler = dDHandler;
        this.isTopic = !dDHandler.isQueue();
        this.isPartitionedDistributedTopic = dDHandler.getForwardingPolicy() == 0;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        DDHandler dDHandler = this.ddHandler;
        synchronized (dDHandler) {
            if (this.isTopic && !this.isPartitionedDistributedTopic) {
                this.refreshTopic();
            } else {
                this.refreshQueue();
            }
        }
    }

    private void makeOrder(DistributedDestinationImpl[] distributedDestinationImplArray) {
        for (int i = 0; i < distributedDestinationImplArray.length; ++i) {
            distributedDestinationImplArray[i].setOrder(i);
        }
    }

    private DistributedDestinationImpl[] getUpMembers() {
        LinkedList<DistributedDestinationImpl> linkedList = new LinkedList<DistributedDestinationImpl>();
        Iterator iterator = this.ddHandler.memberCloneIterator();
        while (iterator.hasNext()) {
            DDMember dDMember = (DDMember)iterator.next();
            if (dDMember.isUp() && dDMember.getDDImpl() != null) {
                linkedList.add(dDMember.getDDImpl());
            }
            if (!JMSDebug.JMSCommon.isDebugEnabled()) continue;
            JMSDebug.JMSCommon.debug(this.ddHandler.getName() + " getUpMembers() " + dDMember + " is up? " + dDMember.isUp() + " DDImpl " + dDMember.getDDImpl());
            if (dDMember.getDDImpl() != null) continue;
            JMSDebug.JMSCommon.debug(this.ddHandler.getName() + " getUpMembers() UNEXPECTED... getDDImpl is null for member " + dDMember);
        }
        return linkedList.toArray(new DistributedDestinationImpl[0]);
    }

    private void consumptionPauseFilter(DistributedDestinationImpl[] distributedDestinationImplArray) {
        int n = 0;
        for (int i = 0; i < this.size && distributedDestinationImplArray[i] != null; ++i) {
            if (distributedDestinationImplArray[i].isConsumptionPaused()) continue;
            distributedDestinationImplArray[n++] = distributedDestinationImplArray[i];
        }
        if (n != 0 && n < this.size) {
            distributedDestinationImplArray[n] = null;
        }
    }

    private void productionPauseFilter(DistributedDestinationImpl[] distributedDestinationImplArray) {
        int n = 0;
        for (int i = 0; i < this.size && distributedDestinationImplArray[i] != null; ++i) {
            if (distributedDestinationImplArray[i].isProductionPaused() || distributedDestinationImplArray[i].isInsertionPaused()) continue;
            distributedDestinationImplArray[n++] = distributedDestinationImplArray[i];
        }
        if (n != 0 && n < this.size) {
            distributedDestinationImplArray[n] = null;
        }
    }

    private void refreshQueue() {
        DistributedDestinationImpl[] distributedDestinationImplArray = this.getUpMembers();
        this.makeOrder(distributedDestinationImplArray);
        this.size = distributedDestinationImplArray.length;
        if (this.size <= 0) {
            return;
        }
        Arrays.sort(distributedDestinationImplArray, new JMSComparator(2, false));
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        DistributedDestinationImpl[] distributedDestinationImplArray2 = new DistributedDestinationImpl[this.size];
        DistributedDestinationImpl[] distributedDestinationImplArray3 = new DistributedDestinationImpl[this.size];
        DistributedDestinationImpl[] distributedDestinationImplArray4 = new DistributedDestinationImpl[this.size];
        DistributedDestinationImpl[] distributedDestinationImplArray5 = new DistributedDestinationImpl[this.size];
        DistributedDestinationImpl[] distributedDestinationImplArray6 = new DistributedDestinationImpl[this.size];
        DistributedDestinationImpl[] distributedDestinationImplArray7 = new DistributedDestinationImpl[this.size];
        DistributedDestinationImpl[] distributedDestinationImplArray8 = new DistributedDestinationImpl[this.size];
        DistributedDestinationImpl[] distributedDestinationImplArray9 = new DistributedDestinationImpl[this.size];
        DistributedDestinationImpl[] distributedDestinationImplArray10 = new DistributedDestinationImpl[this.size];
        DistributedDestinationImpl[] distributedDestinationImplArray11 = new DistributedDestinationImpl[this.size];
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug(this.ddHandler.getName() + " with load balancing policy " + this.loadBalanceString(this.ddHandler.getLoadBalancingPolicyAsInt()) + " has the following members: ");
        }
        int n11 = 0;
        int n12 = 0;
        for (int i = 0; i < this.size; ++i) {
            DistributedDestinationImpl distributedDestinationImpl = distributedDestinationImplArray[i];
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug(" " + distributedDestinationImpl.debugString());
            }
            if (distributedDestinationImpl.isProductionPaused() || distributedDestinationImpl.isInsertionPaused()) {
                ++n11;
            }
            if (distributedDestinationImpl.isConsumptionPaused()) {
                ++n12;
            }
            distributedDestinationImplArray11[n++] = distributedDestinationImpl;
            if (distributedDestinationImpl.isLocal()) {
                distributedDestinationImplArray10[n2++] = distributedDestinationImpl;
                if (distributedDestinationImpl.isPersistent()) {
                    distributedDestinationImplArray6[n6++] = distributedDestinationImpl;
                    if (distributedDestinationImpl.hasConsumer()) {
                        distributedDestinationImplArray2[n10++] = distributedDestinationImpl;
                    }
                }
                if (distributedDestinationImpl.hasConsumer()) {
                    distributedDestinationImplArray4[n8++] = distributedDestinationImpl;
                } else {
                    distributedDestinationImplArray5[n7++] = distributedDestinationImpl;
                }
            }
            if (distributedDestinationImpl.isPersistent()) {
                distributedDestinationImplArray7[n5++] = distributedDestinationImpl;
                if (distributedDestinationImpl.hasConsumer()) {
                    distributedDestinationImplArray3[n9++] = distributedDestinationImpl;
                }
            }
            if (distributedDestinationImpl.hasConsumer()) {
                distributedDestinationImplArray8[n4++] = distributedDestinationImpl;
                continue;
            }
            distributedDestinationImplArray9[n3++] = distributedDestinationImpl;
        }
        DistributedDestinationImpl[] distributedDestinationImplArray12 = distributedDestinationImplArray10;
        if (n2 < 1) {
            distributedDestinationImplArray10 = distributedDestinationImplArray11;
            n2 = n;
        }
        DistributedDestinationImpl[] distributedDestinationImplArray13 = distributedDestinationImplArray8;
        if (n4 < 1) {
            distributedDestinationImplArray13 = distributedDestinationImplArray11;
            distributedDestinationImplArray8 = distributedDestinationImplArray10;
            n4 = n2;
        }
        DistributedDestinationImpl[] distributedDestinationImplArray14 = distributedDestinationImplArray9;
        if (n3 < 1) {
            distributedDestinationImplArray14 = distributedDestinationImplArray11;
            distributedDestinationImplArray9 = distributedDestinationImplArray10;
            n3 = n2;
        }
        if (n10 < 1) {
            distributedDestinationImplArray2 = distributedDestinationImplArray3;
            n10 = n9;
        }
        if (n8 < 1) {
            distributedDestinationImplArray4 = distributedDestinationImplArray8;
            n8 = n4;
        }
        if (n7 < 1) {
            distributedDestinationImplArray5 = distributedDestinationImplArray10;
            n7 = n2;
        }
        if (n6 < 1) {
            distributedDestinationImplArray6 = distributedDestinationImplArray7;
            n6 = n5;
        }
        if (n10 == 0) {
            if (n6 == 0) {
                distributedDestinationImplArray2 = distributedDestinationImplArray4;
                n10 = n8;
            } else {
                distributedDestinationImplArray2 = distributedDestinationImplArray6;
                n10 = n6;
            }
        }
        if (n9 == 0) {
            distributedDestinationImplArray3 = n5 == 0 ? distributedDestinationImplArray13 : distributedDestinationImplArray7;
        }
        if (n11 != 0 && n11 != this.size) {
            this.productionPauseFilter(distributedDestinationImplArray4);
            this.productionPauseFilter(distributedDestinationImplArray13);
            this.productionPauseFilter(distributedDestinationImplArray2);
            this.productionPauseFilter(distributedDestinationImplArray3);
        }
        if (n12 != 0 && n11 != this.size) {
            this.consumptionPauseFilter(distributedDestinationImplArray12);
            this.consumptionPauseFilter(distributedDestinationImplArray5);
            this.consumptionPauseFilter(distributedDestinationImplArray14);
        }
        if (this.ddHandler.getLoadBalancingPolicyAsInt() == 1) {
            this.connectionConsumerLB = new RandomLoadBalancer(distributedDestinationImplArray12);
            this.consumerLB = new RandomLoadBalancer(distributedDestinationImplArray5);
            this.consumerAllLB = new RandomLoadBalancer(distributedDestinationImplArray14);
            this.npProducerLB = new RandomLoadBalancer(distributedDestinationImplArray4);
            this.npProducerAllLB = new RandomLoadBalancer(distributedDestinationImplArray13);
            this.pProducerLB = new RandomLoadBalancer(distributedDestinationImplArray2);
            this.pProducerAllLB = new RandomLoadBalancer(distributedDestinationImplArray3);
        } else if (this.doInit) {
            this.connectionConsumerLB = new RRLoadBalancer(distributedDestinationImplArray12);
            this.consumerLB = new RRLoadBalancer(distributedDestinationImplArray5);
            this.consumerAllLB = new RRLoadBalancer(distributedDestinationImplArray14);
            this.npProducerLB = new RRLoadBalancer(distributedDestinationImplArray4);
            this.npProducerAllLB = new RRLoadBalancer(distributedDestinationImplArray13);
            this.pProducerLB = new RRLoadBalancer(distributedDestinationImplArray2);
            this.pProducerAllLB = new RRLoadBalancer(distributedDestinationImplArray3);
        } else {
            this.connectionConsumerLB.refresh(distributedDestinationImplArray12);
            this.consumerLB.refresh(distributedDestinationImplArray5);
            this.consumerAllLB.refresh(distributedDestinationImplArray14);
            this.npProducerLB.refresh(distributedDestinationImplArray4);
            this.npProducerAllLB.refresh(distributedDestinationImplArray13);
            this.pProducerLB.refresh(distributedDestinationImplArray2);
            this.pProducerAllLB.refresh(distributedDestinationImplArray3);
        }
        this.doInit = false;
    }

    private void refreshTopic() {
        DistributedDestinationImpl[] distributedDestinationImplArray = this.getUpMembers();
        this.makeOrder(distributedDestinationImplArray);
        this.size = distributedDestinationImplArray.length;
        if (this.size <= 0) {
            return;
        }
        Arrays.sort(distributedDestinationImplArray, new JMSComparator(2, false));
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        DistributedDestinationImpl[] distributedDestinationImplArray2 = new DistributedDestinationImpl[this.size];
        DistributedDestinationImpl[] distributedDestinationImplArray3 = new DistributedDestinationImpl[this.size];
        DistributedDestinationImpl[] distributedDestinationImplArray4 = new DistributedDestinationImpl[this.size];
        DistributedDestinationImpl[] distributedDestinationImplArray5 = new DistributedDestinationImpl[this.size];
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug(this.ddHandler.getName() + " with load balancing policy " + this.loadBalanceString(this.ddHandler.getLoadBalancingPolicyAsInt()) + " has the following members: ");
        }
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < this.size; ++i) {
            DistributedDestinationImpl distributedDestinationImpl = distributedDestinationImplArray[i];
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug(" " + distributedDestinationImpl.debugString());
            }
            if (distributedDestinationImpl.isProductionPaused() || distributedDestinationImpl.isInsertionPaused()) {
                ++n5;
            }
            if (distributedDestinationImpl.isConsumptionPaused()) {
                ++n6;
            }
            distributedDestinationImplArray5[n++] = distributedDestinationImpl;
            if (distributedDestinationImpl.isLocal()) {
                distributedDestinationImplArray4[n2++] = distributedDestinationImpl;
                if (distributedDestinationImpl.isPersistent()) {
                    distributedDestinationImplArray2[n4++] = distributedDestinationImpl;
                }
            }
            if (!distributedDestinationImpl.isPersistent()) continue;
            distributedDestinationImplArray3[n3++] = distributedDestinationImpl;
        }
        DistributedDestinationImpl[] distributedDestinationImplArray6 = distributedDestinationImplArray4;
        if (n2 < 1) {
            distributedDestinationImplArray4 = distributedDestinationImplArray5;
            n2 = n;
        }
        if (n4 < 1) {
            distributedDestinationImplArray2 = distributedDestinationImplArray3;
            n4 = n3;
        }
        DistributedDestinationImpl[] distributedDestinationImplArray7 = distributedDestinationImplArray2;
        if (n4 == 0) {
            distributedDestinationImplArray2 = distributedDestinationImplArray4;
            n4 = n2;
        }
        DistributedDestinationImpl[] distributedDestinationImplArray8 = (DistributedDestinationImpl[])distributedDestinationImplArray4.clone();
        if (n5 != 0 && n5 != this.size) {
            this.productionPauseFilter(distributedDestinationImplArray8);
            this.productionPauseFilter(distributedDestinationImplArray2);
        }
        if (n6 != 0 && n5 != this.size) {
            this.consumptionPauseFilter(distributedDestinationImplArray6);
            this.consumptionPauseFilter(distributedDestinationImplArray7);
            this.consumptionPauseFilter(distributedDestinationImplArray4);
        }
        if (this.ddHandler.getLoadBalancingPolicyAsInt() == 1) {
            this.connectionConsumerLB = new RandomLoadBalancer(distributedDestinationImplArray6);
            this.durableSubscriberLB = new RandomLoadBalancer(distributedDestinationImplArray7);
            this.consumerLB = new RandomLoadBalancer(distributedDestinationImplArray4);
            this.npProducerLB = new RandomLoadBalancer(distributedDestinationImplArray8);
            this.pProducerLB = new RandomLoadBalancer(distributedDestinationImplArray2);
        } else if (this.doInit) {
            this.connectionConsumerLB = new RRLoadBalancer(distributedDestinationImplArray6);
            this.durableSubscriberLB = new RRLoadBalancer(distributedDestinationImplArray7);
            this.consumerLB = new RRLoadBalancer(distributedDestinationImplArray4);
            this.npProducerLB = new RRLoadBalancer(distributedDestinationImplArray8);
            this.pProducerLB = new RRLoadBalancer(distributedDestinationImplArray2);
        } else {
            this.connectionConsumerLB.refresh(distributedDestinationImplArray6);
            this.durableSubscriberLB.refresh(distributedDestinationImplArray7);
            this.consumerLB.refresh(distributedDestinationImplArray4);
            this.npProducerLB.refresh(distributedDestinationImplArray8);
            this.pProducerLB.refresh(distributedDestinationImplArray2);
        }
        this.doInit = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestinationImpl durableSubscriberLoadBalance() {
        DDHandler dDHandler = this.ddHandler;
        synchronized (dDHandler) {
            if (this.size <= 0) {
                return null;
            }
            return this.durableSubscriberLB.getNext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestinationImpl connectionConsumerLoadBalance() {
        DDHandler dDHandler = this.ddHandler;
        synchronized (dDHandler) {
            if (this.size <= 0) {
                return null;
            }
            return this.connectionConsumerLB.getNext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestinationImpl consumerLoadBalance(FESession fESession) {
        DDHandler dDHandler = this.ddHandler;
        synchronized (dDHandler) {
            DistributedDestinationImpl distributedDestinationImpl;
            if (this.size <= 0) {
                return null;
            }
            if (fESession != null && fESession.isTransacted()) {
                distributedDestinationImpl = fESession.getCachedDest(this.ddHandler.getName(), false);
                if (distributedDestinationImpl != null) {
                    if (JMSDebug.JMSCommon.isDebugEnabled()) {
                        JMSDebug.JMSCommon.debug("Tx Pick " + distributedDestinationImpl.debugString());
                    }
                    return distributedDestinationImpl;
                }
                distributedDestinationImpl = !fESession.isServerAffinityEnabled() ? this.consumerAllLB.getNext(fESession) : this.consumerLB.getNext(fESession);
                fESession.addCachedDest(distributedDestinationImpl);
            } else {
                distributedDestinationImpl = fESession != null && !fESession.isServerAffinityEnabled() ? this.consumerAllLB.getNext(null) : this.consumerLB.getNext(null);
            }
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("Returning destination: " + distributedDestinationImpl.getInstanceName());
            }
            return distributedDestinationImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestinationImpl producerLoadBalance(boolean bl, FESession fESession) {
        DDHandler dDHandler = this.ddHandler;
        synchronized (dDHandler) {
            if (this.size <= 0) {
                return null;
            }
            if (fESession != null && fESession.isTransacted()) {
                DistributedDestinationImpl distributedDestinationImpl = fESession.getCachedDest(this.ddHandler.getName(), bl);
                if (distributedDestinationImpl != null) {
                    if (JMSDebug.JMSCommon.isDebugEnabled()) {
                        JMSDebug.JMSCommon.debug("Tx Pick " + distributedDestinationImpl.debugString());
                    }
                    return distributedDestinationImpl;
                }
                distributedDestinationImpl = this.getDestination(bl, fESession, fESession);
                fESession.addCachedDest(distributedDestinationImpl);
                if (JMSDebug.JMSCommon.isDebugEnabled()) {
                    JMSDebug.JMSCommon.debug("Returning destination: " + distributedDestinationImpl.getInstanceName());
                }
                return distributedDestinationImpl;
            }
            DistributedDestinationImpl distributedDestinationImpl = this.getDestination(bl, fESession, null);
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("Returning destination: " + (distributedDestinationImpl == null ? "null" : distributedDestinationImpl.getInstanceName()));
            }
            return distributedDestinationImpl;
        }
    }

    public JMSFailover getProducerFailover(DistributedDestinationImpl distributedDestinationImpl, Throwable throwable, boolean bl, FESession fESession) {
        Exception exception = null;
        if (throwable instanceof JMSException) {
            exception = ((JMSException)((Object)throwable)).getLinkedException();
        }
        if (throwable instanceof RemoteException && !RemoteHelper.isRecoverablePreInvokeFailure((RemoteException)((RemoteException)throwable))) {
            return null;
        }
        if (exception instanceof RemoteException && !RemoteHelper.isRecoverablePreInvokeFailure((RemoteException)((RemoteException)exception))) {
            return null;
        }
        DistributedDestinationImpl[] distributedDestinationImplArray = this.getUpMembers();
        this.makeOrder(distributedDestinationImplArray);
        if (!this.isTopic) {
            Arrays.sort(distributedDestinationImplArray, new JMSComparator(0, bl));
        } else {
            Arrays.sort(distributedDestinationImplArray, new JMSComparator(1, bl));
        }
        return new JMSFailover(distributedDestinationImplArray, distributedDestinationImpl);
    }

    private DistributedDestinationImpl getDestination(boolean bl, FESession fESession, FESession fESession2) {
        DistributedDestinationImpl distributedDestinationImpl = this.isTopic && !this.isPartitionedDistributedTopic ? (bl ? this.pProducerLB.getNext(fESession2) : this.npProducerLB.getNext(fESession2)) : (bl ? (fESession != null && !fESession.isServerAffinityEnabled() ? this.pProducerAllLB.getNext(fESession2) : this.pProducerLB.getNext(fESession2)) : (fESession != null && !fESession.isServerAffinityEnabled() ? this.npProducerAllLB.getNext(fESession2) : this.npProducerLB.getNext(fESession2)));
        return distributedDestinationImpl;
    }

    private String loadBalanceString(int n) {
        switch (n) {
            case 0: {
                return "Round Robin";
            }
            case 1: {
                return "Random";
            }
            case 2: {
                return "Sticky Random";
            }
        }
        return "Unknown Policy";
    }

    public boolean isPartitionedDistributedTopic() {
        return this.isPartitionedDistributedTopic;
    }

    public final class JMSComparator
    implements Comparator {
        public static final int SENDER = 0;
        public static final int PUBLISHER = 1;
        public static final int ORDER = 2;
        final int type;
        final boolean isPersistent;

        public JMSComparator(int n, boolean bl) {
            this.type = n;
            this.isPersistent = bl;
        }

        public int compare(Object object, Object object2) {
            switch (this.type) {
                case 2: {
                    return this.orderCompare(object, object2);
                }
                case 0: {
                    return this.senderCompare(object, object2);
                }
                case 1: {
                    return this.publisherCompare(object, object2);
                }
            }
            return this.senderCompare(object, object2);
        }

        public int orderCompare(Object object, Object object2) {
            try {
                DistributedDestinationImpl distributedDestinationImpl = (DistributedDestinationImpl)object;
                DistributedDestinationImpl distributedDestinationImpl2 = (DistributedDestinationImpl)object2;
                if (distributedDestinationImpl.getOrder() < distributedDestinationImpl2.getOrder()) {
                    return -1;
                }
                return 1;
            }
            catch (Exception exception) {
                return 0;
            }
        }

        public int senderCompare(Object object, Object object2) {
            try {
                DistributedDestinationImpl distributedDestinationImpl = (DistributedDestinationImpl)object;
                DistributedDestinationImpl distributedDestinationImpl2 = (DistributedDestinationImpl)object2;
                if (!this.isPersistent || distributedDestinationImpl.isPersistent() == distributedDestinationImpl2.isPersistent()) {
                    if (distributedDestinationImpl.hasConsumer() == distributedDestinationImpl2.hasConsumer()) {
                        if (distributedDestinationImpl.isLocal() == distributedDestinationImpl2.isLocal()) {
                            if (distributedDestinationImpl.getOrder() < distributedDestinationImpl2.getOrder()) {
                                return -1;
                            }
                            return 1;
                        }
                        if (distributedDestinationImpl2.isLocal()) {
                            return 1;
                        }
                    } else if (distributedDestinationImpl2.hasConsumer()) {
                        return 1;
                    }
                } else if (distributedDestinationImpl2.isPersistent()) {
                    return 1;
                }
                return -1;
            }
            catch (Exception exception) {
                return 0;
            }
        }

        public int publisherCompare(Object object, Object object2) {
            try {
                DistributedDestinationImpl distributedDestinationImpl = (DistributedDestinationImpl)object;
                DistributedDestinationImpl distributedDestinationImpl2 = (DistributedDestinationImpl)object2;
                if (!this.isPersistent || distributedDestinationImpl.isPersistent() == distributedDestinationImpl2.isPersistent()) {
                    if (distributedDestinationImpl.isLocal() == distributedDestinationImpl2.isLocal()) {
                        if (distributedDestinationImpl.getOrder() < distributedDestinationImpl2.getOrder()) {
                            return -1;
                        }
                        return 1;
                    }
                    if (distributedDestinationImpl2.isLocal()) {
                        return 1;
                    }
                } else if (distributedDestinationImpl2.isPersistent()) {
                    return 1;
                }
                return -1;
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }
}

