/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import weblogic.jms.JMSLogger;
import weblogic.jms.common.MessageImpl;
import weblogic.utils.StringUtils;

public final class JMSMessageExpirationHelper {
    public static final void logExpiredMessage(MessageImpl messageImpl, List list, List list2) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer(256);
        StringBuffer stringBuffer2 = new StringBuffer(256);
        boolean bl2 = JMSMessageExpirationHelper.buildLogHeaderString(list, messageImpl, stringBuffer);
        if (bl2 & (bl = JMSMessageExpirationHelper.buildLogPropertyString(list2, messageImpl, stringBuffer2))) {
            JMSLogger.logExpiredMessageHeaderProperty((String)("'" + messageImpl.getJMSMessageID() + "'"), (String)stringBuffer.toString(), (String)stringBuffer2.toString());
        } else if (bl2) {
            JMSLogger.logExpiredMessageHeader((String)("'" + messageImpl.getJMSMessageID() + "'"), (String)stringBuffer.toString());
        } else if (bl) {
            JMSLogger.logExpiredMessageProperty((String)("'" + messageImpl.getJMSMessageID() + "'"), (String)stringBuffer2.toString());
        } else {
            JMSLogger.logExpiredMessageNoHeaderProperty((String)("'" + messageImpl.getJMSMessageID() + "'"));
        }
    }

    public static final void logExpiredSAFMessage(MessageImpl messageImpl, List list, List list2) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer(256);
        StringBuffer stringBuffer2 = new StringBuffer(256);
        boolean bl2 = JMSMessageExpirationHelper.buildLogHeaderString(list, messageImpl, stringBuffer);
        if (bl2 & (bl = JMSMessageExpirationHelper.buildLogPropertyString(list2, messageImpl, stringBuffer2))) {
            JMSLogger.logExpiredSAFMessageHeaderProperty((String)("'" + messageImpl.getJMSMessageID() + "'"), (String)stringBuffer.toString(), (String)stringBuffer2.toString());
        } else if (bl2) {
            JMSLogger.logExpiredSAFMessageHeader((String)("'" + messageImpl.getJMSMessageID() + "'"), (String)stringBuffer.toString());
        } else if (bl) {
            JMSLogger.logExpiredSAFMessageProperty((String)("'" + messageImpl.getJMSMessageID() + "'"), (String)stringBuffer2.toString());
        } else {
            JMSLogger.logExpiredSAFMessageNoHeaderProperty((String)("'" + messageImpl.getJMSMessageID() + "'"));
        }
    }

    public static final boolean buildLogHeaderString(List list, MessageImpl messageImpl, StringBuffer stringBuffer) {
        boolean bl = false;
        List list2 = list;
        if (list2 == null || list2.size() == 0) {
            return bl;
        }
        ListIterator listIterator = list2.listIterator(0);
        String string = new String();
        String string2 = null;
        Object object = null;
        while (listIterator.hasNext()) {
            if (!bl) {
                bl = true;
                stringBuffer.insert(0, "<HeaderFields ");
            }
            try {
                string2 = (String)listIterator.next();
                object = string2.equalsIgnoreCase("JMSDestination") ? messageImpl.getJMSDestination() : (string2.equalsIgnoreCase("JMSReplyTo") ? messageImpl.getJMSReplyTo() : messageImpl.get(string2));
                if (object != null) {
                    if (string2.equals("JMSExpiration")) {
                        object = new Date((Long)object);
                    } else if (string2.equals("JMSTimestamp")) {
                        object = new Date((Long)object);
                    } else if (string2.equals("JMSCorrelationID") || string2.equals("JMSType")) {
                        object = JMSMessageExpirationHelper.truncatedIt(object);
                    } else if (string2.equals("JMSDeliveryTime")) {
                        object = (Long)object > 0L ? new Date((Long)object) : new Date(messageImpl.getJMSTimestamp());
                    }
                    stringBuffer.append(string + string2 + "='" + object + "'");
                } else {
                    stringBuffer.append(string + string2 + "=" + object);
                }
                if (string.length() != 0) continue;
                string = "\n    ";
            }
            catch (Exception exception) {}
        }
        stringBuffer.append(" />");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean buildLogPropertyString(List list, MessageImpl messageImpl, StringBuffer stringBuffer) {
        boolean bl = false;
        List list2 = list;
        if (list2 == null || list2.size() == 0 || !messageImpl.hasProperties()) {
            return bl;
        }
        ListIterator listIterator = list2.listIterator(0);
        String string = new String();
        String string2 = null;
        String string3 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (listIterator.hasNext()) {
            try {
                string2 = (String)listIterator.next();
                if (string2.equalsIgnoreCase("%Properties%")) {
                    Object var13_15;
                    if (!bl) {
                        bl = true;
                    }
                    Iterator iterator = null;
                    boolean bl2 = messageImpl.includeJMSXDeliveryCount(true);
                    try {
                        iterator = messageImpl.getPropertyNameCollection().iterator();
                        var13_15 = null;
                        messageImpl.includeJMSXDeliveryCount(bl2);
                    }
                    catch (Throwable throwable) {
                        var13_15 = null;
                        messageImpl.includeJMSXDeliveryCount(bl2);
                        throw throwable;
                    }
                    {
                    }
                    while (iterator.hasNext()) {
                        String string4 = (String)iterator.next();
                        if (hashMap.get(string4) != null) continue;
                        hashMap.put(string4, string4);
                        string3 = messageImpl.getStringProperty(string4);
                        JMSMessageExpirationHelper.appendTrucatedStringToLogBuffer(string, string4, string3, stringBuffer);
                        if (string.length() != 0) continue;
                        string = "\n    ";
                    }
                    continue;
                }
                if (!messageImpl.propertyExists(string2) || hashMap.get(string2) != null) continue;
                hashMap.put(string2, string2);
                if (!bl) {
                    bl = true;
                }
                string3 = messageImpl.getStringProperty(string2);
                JMSMessageExpirationHelper.appendTrucatedStringToLogBuffer(string, string2, string3, stringBuffer);
                if (string.length() != 0) continue;
                string = "\n    ";
            }
            catch (Exception exception) {}
        }
        stringBuffer.insert(0, "<UserProperties ");
        stringBuffer.append(" />");
        return bl;
    }

    private static final void appendTrucatedStringToLogBuffer(String string, String string2, Object object, StringBuffer stringBuffer) {
        String string3 = object != null ? JMSMessageExpirationHelper.truncatedIt(object) : null;
        if (string3 != null) {
            stringBuffer.append(string + string2 + "='" + string3 + "'");
        } else {
            stringBuffer.append(string + string2 + "=" + string3);
        }
    }

    private static final String truncatedIt(Object object) {
        String string;
        String string2 = string = object instanceof String ? (String)object : object.toString();
        if (string == null) {
            return null;
        }
        if (string.length() > 32) {
            return string.substring(0, 32) + "...";
        }
        return string;
    }

    public static final List convertStringToLinkedList(String string) {
        if (string == null) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)",");
        if ((stringArray == null || stringArray.length == 0) && string.indexOf(",") == -1) {
            stringArray = new String[]{string};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (linkedList.contains(stringArray[i].trim())) continue;
            linkedList.add(stringArray[i].trim());
        }
        return linkedList;
    }

    public static final List extractJMSHeaderAndProperty(String string, StringBuffer stringBuffer) {
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            return null;
        }
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)",");
        if ((stringArray == null || stringArray.length == 0) && string.indexOf(",") == -1) {
            stringArray = new String[]{string};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (MessageImpl.isHeaderField(stringArray[i].trim())) {
                if (bl2 || linkedList.contains(stringArray[i].trim())) continue;
                linkedList.add(stringArray[i].trim());
                continue;
            }
            if (stringArray[i].trim().startsWith("getJMS")) {
                if (MessageImpl.isHeaderField(stringArray[i].trim().substring(3))) {
                    if (bl2 || linkedList.contains(stringArray[i].trim().substring(3))) continue;
                    linkedList.add(stringArray[i].trim().substring(3));
                    continue;
                }
                if (bl) continue;
                stringBuffer.append(stringArray[i].trim() + ", ");
                continue;
            }
            if (stringArray[i].trim().equalsIgnoreCase("%Header%")) {
                if (bl2) continue;
                bl2 = true;
                if (!linkedList.contains("JMSCorrelationID")) {
                    linkedList.add("JMSCorrelationID");
                }
                if (!linkedList.contains("JMSDeliveryMode")) {
                    linkedList.add("JMSDeliveryMode");
                }
                if (!linkedList.contains("JMSDeliveryTime")) {
                    linkedList.add("JMSDeliveryTime");
                }
                if (!linkedList.contains("JMSDestination")) {
                    linkedList.add("JMSDestination");
                }
                if (!linkedList.contains("JMSExpiration")) {
                    linkedList.add("JMSExpiration");
                }
                if (!linkedList.contains("JMSPriority")) {
                    linkedList.add("JMSPriority");
                }
                if (!linkedList.contains("JMSRedelivered")) {
                    linkedList.add("JMSRedelivered");
                }
                if (!linkedList.contains("JMSRedeliveryLimit")) {
                    linkedList.add("JMSRedeliveryLimit");
                }
                if (!linkedList.contains("JMSReplyTo")) {
                    linkedList.add("JMSReplyTo");
                }
                if (!linkedList.contains("JMSTimestamp")) {
                    linkedList.add("JMSTimestamp");
                }
                if (linkedList.contains("JMSType")) continue;
                linkedList.add("JMSType");
                continue;
            }
            if (stringArray[i].trim().equalsIgnoreCase("%Properties%")) {
                if (bl) continue;
                bl = true;
                stringBuffer.append("%Properties%, ");
                continue;
            }
            if (bl) continue;
            stringBuffer.append(stringArray[i].trim() + ", ");
        }
        return linkedList;
    }
}

