/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.Document;
import weblogic.apache.xml.serialize.OutputFormat;
import weblogic.apache.xml.serialize.XMLSerializer;
import weblogic.jms.backend.BEConnectionConsumerImpl;
import weblogic.jms.backend.BEConsumerImpl;
import weblogic.jms.backend.MessageConsumerCreationEvent;
import weblogic.jms.backend.MessageConsumerDestroyEvent;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageEventLogListener;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.XMLHelper;
import weblogic.logging.jms.JMSMessageAddLogRecord;
import weblogic.logging.jms.JMSMessageConsumerCreationLogRecord;
import weblogic.logging.jms.JMSMessageConsumerDestroyLogRecord;
import weblogic.logging.jms.JMSMessageExceededLogRecord;
import weblogic.logging.jms.JMSMessageExpireLogRecord;
import weblogic.logging.jms.JMSMessageForwardLogRecord;
import weblogic.logging.jms.JMSMessageLogRecord;
import weblogic.logging.jms.JMSMessageLogger;
import weblogic.logging.jms.JMSMessageReceiveLogRecord;
import weblogic.logging.jms.JMSMessageRemoveLogRecord;
import weblogic.logging.jms.JMSMessageSendLogRecord;
import weblogic.logging.jms.JMSMessageStoreLogRecord;
import weblogic.logging.jms.JMSSAFMessageLogger;
import weblogic.messaging.kernel.Event;
import weblogic.messaging.kernel.MessageAddEvent;
import weblogic.messaging.kernel.MessageConsumerEvent;
import weblogic.messaging.kernel.MessageEvent;
import weblogic.messaging.kernel.MessageExpirationEvent;
import weblogic.messaging.kernel.MessageReceiveEvent;
import weblogic.messaging.kernel.MessageRedeliveryLimitEvent;
import weblogic.messaging.kernel.MessageRemoveEvent;
import weblogic.messaging.kernel.MessageSendEvent;
import weblogic.utils.StringUtils;

public final class JMSMessageLogHelper {
    private static final String DELIMITER = " ";

    public static final String createLogMessage(MessageImpl messageImpl, List list, List list2) {
        StringBuffer stringBuffer = new StringBuffer(256);
        StringBuffer stringBuffer2 = new StringBuffer(256);
        JMSMessageLogHelper.buildLogHeaderString(list, messageImpl, stringBuffer);
        JMSMessageLogHelper.buildLogPropertyString(list2, messageImpl, stringBuffer2);
        if (stringBuffer.toString() != null && stringBuffer.toString().length() != 0 && stringBuffer2.toString() != null && stringBuffer2.toString().length() != 0) {
            return stringBuffer.toString() + DELIMITER + stringBuffer2.toString();
        }
        return stringBuffer2.toString();
    }

    public static final void buildLogHeaderString(List list, MessageImpl messageImpl, StringBuffer stringBuffer) {
        String string = "";
        List list2 = list;
        if (list2 == null || list2.size() == 0) {
            return;
        }
        ListIterator listIterator = list2.listIterator(0);
        String string2 = null;
        Object object = null;
        while (listIterator.hasNext()) {
            try {
                string2 = (String)listIterator.next();
                if (string2.equalsIgnoreCase("JMSDestination")) continue;
                object = string2.equalsIgnoreCase("JMSReplyTo") ? messageImpl.getJMSReplyTo() : messageImpl.get(string2);
                if (object != null) {
                    if (string2.equals("JMSExpiration")) {
                        object = (Long)object == 0L ? "Never" : new Date((Long)object);
                    } else if (string2.equals("JMSTimestamp")) {
                        object = new Date((Long)object);
                    } else if (string2.equals("JMSCorrelationID") || string2.equals("JMSType")) {
                        object = JMSMessageLogHelper.truncatedIt(object);
                    } else if (string2.equals("JMSDeliveryTime")) {
                        object = (Long)object > 0L ? new Date((Long)object) : new Date(messageImpl.getJMSTimestamp());
                    }
                    stringBuffer.append(string + string2 + "='" + object + "'");
                    string = DELIMITER;
                    continue;
                }
                stringBuffer.append(string + string2 + "=" + object);
                string = DELIMITER;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void buildLogPropertyString(List list, MessageImpl messageImpl, StringBuffer stringBuffer) {
        String string;
        Enumeration enumeration;
        List list2;
        String string2;
        block11: {
            string2 = "";
            list2 = list;
            enumeration = null;
            boolean bl = messageImpl.includeJMSXDeliveryCount(true);
            try {
                try {
                    enumeration = messageImpl.getPropertyNames();
                }
                catch (javax.jms.JMSException jMSException) {
                    string = null;
                    messageImpl.includeJMSXDeliveryCount(bl);
                    break block11;
                }
                string = null;
                messageImpl.includeJMSXDeliveryCount(bl);
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                messageImpl.includeJMSXDeliveryCount(bl);
                throw throwable;
            }
        }
        if (list2 == null || list2.size() == 0 || enumeration == null || !enumeration.hasMoreElements()) {
            return;
        }
        ListIterator listIterator = list2.listIterator(0);
        String string3 = null;
        string = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        block6: while (listIterator.hasNext()) {
            try {
                string3 = (String)listIterator.next();
                if (string3.equalsIgnoreCase("%properties%")) {
                    while (true) {
                        if (!enumeration.hasMoreElements()) continue block6;
                        String string4 = (String)enumeration.nextElement();
                        if (hashMap.get(string4) != null) continue;
                        hashMap.put(string4, string4);
                        string = messageImpl.getStringProperty(string4);
                        JMSMessageLogHelper.appendTrucatedStringToLogBuffer(string2, string4, string, stringBuffer);
                        string2 = DELIMITER;
                    }
                }
                if (!messageImpl.propertyExists(string3) || hashMap.get(string3) != null) continue;
                hashMap.put(string3, string3);
                string = messageImpl.getStringProperty(string3);
                JMSMessageLogHelper.appendTrucatedStringToLogBuffer(string2, string3, string, stringBuffer);
                string2 = DELIMITER;
            }
            catch (Exception exception) {
            }
        }
        return;
    }

    private static final void appendTrucatedStringToLogBuffer(String string, String string2, Object object, StringBuffer stringBuffer) {
        String string3 = object != null ? JMSMessageLogHelper.truncatedIt(object) : null;
        if (string3 != null) {
            stringBuffer.append(string + string2 + "='" + string3 + "'");
        } else {
            stringBuffer.append(string + string2 + "=" + string3);
        }
    }

    private static final String truncatedIt(Object object) {
        String string;
        String string2 = string = object instanceof String ? (String)object : object.toString();
        if (string == null) {
            return null;
        }
        if (string.length() > 32) {
            return string.substring(0, 32) + "...";
        }
        return string;
    }

    public static final List convertStringToLinkedList(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (string == null) {
            return linkedList;
        }
        if ((string = string.trim()).length() == 0) {
            return linkedList;
        }
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)",");
        if ((stringArray == null || stringArray.length == 0) && string.indexOf(",") == -1) {
            stringArray = new String[]{string};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if (linkedList.contains(string2)) continue;
            linkedList.add(string2);
        }
        return linkedList;
    }

    public static final List extractJMSHeaderAndProperty(String string, StringBuffer stringBuffer) {
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string == null) {
            return linkedList;
        }
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)",");
        if ((stringArray == null || stringArray.length == 0) && string.indexOf(",") == -1) {
            stringArray = new String[]{string};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (MessageImpl.isHeaderField(stringArray[i].trim())) {
                if (bl3 || linkedList.contains(stringArray[i].trim())) continue;
                linkedList.add(stringArray[i].trim());
                continue;
            }
            if (stringArray[i].trim().startsWith("getJMS")) {
                if (MessageImpl.isHeaderField(stringArray[i].trim().substring(3))) {
                    if (bl3 || linkedList.contains(stringArray[i].trim().substring(3))) continue;
                    linkedList.add(stringArray[i].trim().substring(3));
                    continue;
                }
                if (bl) continue;
                stringBuffer.append(stringArray[i].trim() + ", ");
                continue;
            }
            if (stringArray[i].trim().equalsIgnoreCase("%Header%")) {
                if (bl3) continue;
                bl3 = true;
                if (!linkedList.contains("JMSCorrelationID")) {
                    linkedList.add("JMSCorrelationID");
                }
                if (!linkedList.contains("JMSDeliveryMode")) {
                    linkedList.add("JMSDeliveryMode");
                }
                if (!linkedList.contains("JMSDeliveryTime")) {
                    linkedList.add("JMSDeliveryTime");
                }
                if (!linkedList.contains("JMSExpiration")) {
                    linkedList.add("JMSExpiration");
                }
                if (!linkedList.contains("JMSPriority")) {
                    linkedList.add("JMSPriority");
                }
                if (!linkedList.contains("JMSRedelivered")) {
                    linkedList.add("JMSRedelivered");
                }
                if (!linkedList.contains("JMSRedeliveryLimit")) {
                    linkedList.add("JMSRedeliveryLimit");
                }
                if (!linkedList.contains("JMSReplyTo")) {
                    linkedList.add("JMSReplyTo");
                }
                if (!linkedList.contains("JMSTimestamp")) {
                    linkedList.add("JMSTimestamp");
                }
                if (linkedList.contains("JMSType")) continue;
                linkedList.add("JMSType");
                continue;
            }
            if (stringArray[i].trim().equalsIgnoreCase("%properties%")) {
                if (bl) continue;
                bl = true;
                stringBuffer.append("%properties%, ");
                continue;
            }
            if (stringArray[i].trim().equalsIgnoreCase("%body%")) {
                if (bl2) continue;
                bl2 = true;
                stringBuffer.append("%body%, ");
                continue;
            }
            if (bl) continue;
            stringBuffer.append(stringArray[i].trim() + ", ");
        }
        return linkedList;
    }

    public static String addSubscriberInfo(BEConsumerImpl bEConsumerImpl) {
        if (bEConsumerImpl instanceof BEConnectionConsumerImpl) {
            return "CC";
        }
        if (bEConsumerImpl.getSession() == null || bEConsumerImpl.getSession().getConnection() == null) {
            return null;
        }
        String string = bEConsumerImpl.getSession().getConnection().getAddress();
        if (string == null) {
            return null;
        }
        int n = string.indexOf("|");
        if (n < 0) {
            return null;
        }
        return "MC:CA(" + string.substring(0, n) + "):OAMI(" + string.substring(n + 1) + ".connection" + ((JMSID)bEConsumerImpl.getSession().getConnection().getId()).getCounter() + ".session" + ((JMSID)bEConsumerImpl.getSession().getId()).getCounter() + ".consumer" + ((JMSID)bEConsumerImpl.getId()).getCounter() + ")";
    }

    public static void logMessageEvent(JMSMessageEventLogListener jMSMessageEventLogListener, Event event) {
        int n;
        Object object;
        JMSMessageLogger jMSMessageLogger = jMSMessageEventLogListener.getJMSMessageLogger();
        JMSMessageLogRecord jMSMessageLogRecord = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (event instanceof MessageConsumerEvent && (object = ((MessageConsumerEvent)event).getUserBlob()) != null && (n = ((String)object).indexOf("#")) != -1) {
            string3 = ((String)object).substring(0, n);
            string2 = ((String)object).substring(n + 1);
        }
        if (jMSMessageEventLogListener != null && jMSMessageEventLogListener instanceof BEConsumerImpl) {
            object = (BEConsumerImpl)jMSMessageEventLogListener;
            if (event instanceof MessageConsumerCreationEvent) {
                string4 = ((MessageConsumerEvent)event).getSelector();
            }
            if (((BEConsumerImpl)object).isDurable()) {
                string = "DS:" + ((BEConsumerImpl)object).getClientID() + "." + ((BEConsumerImpl)object).getSubscriptionName();
            }
            if (event instanceof MessageSendEvent || string == null) {
                string3 = JMSMessageLogHelper.addSubscriberInfo((BEConsumerImpl)object);
            }
        }
        if (string2 == null) {
            string2 = event.getSubjectName();
        }
        if (event instanceof MessageSendEvent) {
            jMSMessageLogRecord = jMSMessageLogger instanceof JMSSAFMessageLogger ? JMSMessageLogHelper.createStoreLogRecord(jMSMessageLogger, jMSMessageEventLogListener, (MessageSendEvent)event, string2, string != null ? string : string3) : JMSMessageLogHelper.createSendLogRecord(jMSMessageLogger, jMSMessageEventLogListener, (MessageSendEvent)event, string2, string != null ? string : string3);
        } else if (event instanceof MessageAddEvent) {
            jMSMessageLogRecord = JMSMessageLogHelper.createAddLogRecord(jMSMessageLogger, jMSMessageEventLogListener, (MessageAddEvent)event, string2, string);
        } else if (event instanceof MessageReceiveEvent) {
            jMSMessageLogRecord = jMSMessageLogger instanceof JMSSAFMessageLogger ? JMSMessageLogHelper.createForwardLogRecord(jMSMessageLogger, jMSMessageEventLogListener, (MessageReceiveEvent)event, string2, string != null ? string + "[" + string3 + "]" : string3) : JMSMessageLogHelper.createReceiveLogRecord(jMSMessageLogger, jMSMessageEventLogListener, (MessageReceiveEvent)event, string2, string != null ? string + "[" + string3 + "]" : string3);
        } else if (event instanceof MessageExpirationEvent) {
            jMSMessageLogRecord = JMSMessageLogHelper.createExpireLogRecord(jMSMessageLogger, jMSMessageEventLogListener, (MessageExpirationEvent)event, string2, string);
        } else if (event instanceof MessageRedeliveryLimitEvent) {
            jMSMessageLogRecord = JMSMessageLogHelper.createRedeliveryLimitLogRecord(jMSMessageLogger, jMSMessageEventLogListener, (MessageRedeliveryLimitEvent)event, string2, string);
        } else if (event instanceof MessageRemoveEvent) {
            jMSMessageLogRecord = JMSMessageLogHelper.createRemoveLogRecord(jMSMessageLogger, jMSMessageEventLogListener, (MessageRemoveEvent)event, string2, string);
        } else if (event instanceof MessageConsumerCreationEvent) {
            jMSMessageLogRecord = JMSMessageLogHelper.createConsumerCreationLogRecord(jMSMessageLogger, jMSMessageEventLogListener, (MessageConsumerCreationEvent)event, string2, string != null ? string + "[" + string3 + "]" : string3, string4);
        } else if (event instanceof MessageConsumerDestroyEvent) {
            jMSMessageLogRecord = JMSMessageLogHelper.createConsumerDestroyLogRecord(jMSMessageLogger, jMSMessageEventLogListener, (MessageConsumerDestroyEvent)event, string2, string != null ? string + "[" + string3 + "]" : string3);
        }
        if (jMSMessageLogRecord != null) {
            jMSMessageLogger.log(jMSMessageLogRecord);
        }
    }

    private static final String createMessageLogMessage(JMSMessageEventLogListener jMSMessageEventLogListener, MessageImpl messageImpl) {
        try {
            return JMSMessageLogHelper.getMessageDocument(messageImpl, jMSMessageEventLogListener.getMessageLoggingJMSHeaders(), jMSMessageEventLogListener.getMessageLoggingUserProperties());
        }
        catch (javax.jms.JMSException jMSException) {
            return null;
        }
    }

    private static final JMSMessageLogRecord createSendLogRecord(JMSMessageLogger jMSMessageLogger, JMSMessageEventLogListener jMSMessageEventLogListener, MessageSendEvent messageSendEvent, String string, String string2) {
        return new JMSMessageSendLogRecord(JMSMessageLogHelper.getMillis(jMSMessageLogger, (Event)messageSendEvent), JMSMessageLogHelper.getNano(jMSMessageLogger, (Event)messageSendEvent), JMSMessageLogHelper.getJMSMessageContent(jMSMessageEventLogListener, (MessageEvent)messageSendEvent), jMSMessageEventLogListener.getListenerName(), ((MessageImpl)messageSendEvent.getMessage()).getJMSMessageID(), ((MessageImpl)messageSendEvent.getMessage()).getJMSCorrelationID(), string, string2, messageSendEvent.getXid());
    }

    private static final JMSMessageLogRecord createStoreLogRecord(JMSMessageLogger jMSMessageLogger, JMSMessageEventLogListener jMSMessageEventLogListener, MessageSendEvent messageSendEvent, String string, String string2) {
        return new JMSMessageStoreLogRecord(JMSMessageLogHelper.getMillis(jMSMessageLogger, (Event)messageSendEvent), JMSMessageLogHelper.getNano(jMSMessageLogger, (Event)messageSendEvent), JMSMessageLogHelper.getJMSMessageContent(jMSMessageEventLogListener, (MessageEvent)messageSendEvent), jMSMessageEventLogListener.getListenerName(), ((MessageImpl)messageSendEvent.getMessage()).getJMSMessageID(), ((MessageImpl)messageSendEvent.getMessage()).getJMSCorrelationID(), string, string2, messageSendEvent.getXid());
    }

    private static final JMSMessageLogRecord createAddLogRecord(JMSMessageLogger jMSMessageLogger, JMSMessageEventLogListener jMSMessageEventLogListener, MessageAddEvent messageAddEvent, String string, String string2) {
        return new JMSMessageAddLogRecord(JMSMessageLogHelper.getMillis(jMSMessageLogger, (Event)messageAddEvent), JMSMessageLogHelper.getNano(jMSMessageLogger, (Event)messageAddEvent), JMSMessageLogHelper.getJMSMessageContent(jMSMessageEventLogListener, (MessageEvent)messageAddEvent), jMSMessageEventLogListener.getListenerName(), ((MessageImpl)messageAddEvent.getMessage()).getJMSMessageID(), ((MessageImpl)messageAddEvent.getMessage()).getJMSCorrelationID(), string, string2, messageAddEvent.getXid());
    }

    private static final JMSMessageLogRecord createReceiveLogRecord(JMSMessageLogger jMSMessageLogger, JMSMessageEventLogListener jMSMessageEventLogListener, MessageReceiveEvent messageReceiveEvent, String string, String string2) {
        return new JMSMessageReceiveLogRecord(JMSMessageLogHelper.getMillis(jMSMessageLogger, (Event)messageReceiveEvent), JMSMessageLogHelper.getNano(jMSMessageLogger, (Event)messageReceiveEvent), JMSMessageLogHelper.getJMSMessageContent(jMSMessageEventLogListener, (MessageEvent)messageReceiveEvent), jMSMessageEventLogListener.getListenerName(), ((MessageImpl)messageReceiveEvent.getMessage()).getJMSMessageID(), ((MessageImpl)messageReceiveEvent.getMessage()).getJMSCorrelationID(), string, string2, messageReceiveEvent.getXid());
    }

    private static final JMSMessageLogRecord createForwardLogRecord(JMSMessageLogger jMSMessageLogger, JMSMessageEventLogListener jMSMessageEventLogListener, MessageReceiveEvent messageReceiveEvent, String string, String string2) {
        return new JMSMessageForwardLogRecord(JMSMessageLogHelper.getMillis(jMSMessageLogger, (Event)messageReceiveEvent), JMSMessageLogHelper.getNano(jMSMessageLogger, (Event)messageReceiveEvent), JMSMessageLogHelper.getJMSMessageContent(jMSMessageEventLogListener, (MessageEvent)messageReceiveEvent), jMSMessageEventLogListener.getListenerName(), ((MessageImpl)messageReceiveEvent.getMessage()).getJMSMessageID(), ((MessageImpl)messageReceiveEvent.getMessage()).getJMSCorrelationID(), string, string2, messageReceiveEvent.getXid());
    }

    private static final JMSMessageLogRecord createExpireLogRecord(JMSMessageLogger jMSMessageLogger, JMSMessageEventLogListener jMSMessageEventLogListener, MessageExpirationEvent messageExpirationEvent, String string, String string2) {
        return new JMSMessageExpireLogRecord(JMSMessageLogHelper.getMillis(jMSMessageLogger, (Event)messageExpirationEvent), JMSMessageLogHelper.getNano(jMSMessageLogger, (Event)messageExpirationEvent), JMSMessageLogHelper.getJMSMessageContent(jMSMessageEventLogListener, (MessageEvent)messageExpirationEvent), jMSMessageEventLogListener.getListenerName(), ((MessageImpl)messageExpirationEvent.getMessage()).getJMSMessageID(), ((MessageImpl)messageExpirationEvent.getMessage()).getJMSCorrelationID(), string, string2, messageExpirationEvent.getXid());
    }

    private static final JMSMessageLogRecord createRemoveLogRecord(JMSMessageLogger jMSMessageLogger, JMSMessageEventLogListener jMSMessageEventLogListener, MessageRemoveEvent messageRemoveEvent, String string, String string2) {
        return new JMSMessageRemoveLogRecord(JMSMessageLogHelper.getMillis(jMSMessageLogger, (Event)messageRemoveEvent), JMSMessageLogHelper.getNano(jMSMessageLogger, (Event)messageRemoveEvent), JMSMessageLogHelper.getJMSMessageContent(jMSMessageEventLogListener, (MessageEvent)messageRemoveEvent), jMSMessageEventLogListener.getListenerName(), ((MessageImpl)messageRemoveEvent.getMessage()).getJMSMessageID(), ((MessageImpl)messageRemoveEvent.getMessage()).getJMSCorrelationID(), string, string2, messageRemoveEvent.getXid());
    }

    private static final JMSMessageLogRecord createRedeliveryLimitLogRecord(JMSMessageLogger jMSMessageLogger, JMSMessageEventLogListener jMSMessageEventLogListener, MessageRedeliveryLimitEvent messageRedeliveryLimitEvent, String string, String string2) {
        return new JMSMessageExceededLogRecord(JMSMessageLogHelper.getMillis(jMSMessageLogger, (Event)messageRedeliveryLimitEvent), JMSMessageLogHelper.getNano(jMSMessageLogger, (Event)messageRedeliveryLimitEvent), JMSMessageLogHelper.getJMSMessageContent(jMSMessageEventLogListener, (MessageEvent)messageRedeliveryLimitEvent), jMSMessageEventLogListener.getListenerName(), ((MessageImpl)messageRedeliveryLimitEvent.getMessage()).getJMSMessageID(), ((MessageImpl)messageRedeliveryLimitEvent.getMessage()).getJMSCorrelationID(), string, string2, messageRedeliveryLimitEvent.getXid());
    }

    private static final JMSMessageLogRecord createConsumerCreationLogRecord(JMSMessageLogger jMSMessageLogger, JMSMessageEventLogListener jMSMessageEventLogListener, MessageConsumerCreationEvent messageConsumerCreationEvent, String string, String string2, String string3) {
        return new JMSMessageConsumerCreationLogRecord(JMSMessageLogHelper.getMillis(jMSMessageLogger, (Event)messageConsumerCreationEvent), JMSMessageLogHelper.getNano(jMSMessageLogger, (Event)messageConsumerCreationEvent), jMSMessageEventLogListener.getListenerName(), string, string2, string3);
    }

    private static final JMSMessageLogRecord createConsumerDestroyLogRecord(JMSMessageLogger jMSMessageLogger, JMSMessageEventLogListener jMSMessageEventLogListener, MessageConsumerDestroyEvent messageConsumerDestroyEvent, String string, String string2) {
        return new JMSMessageConsumerDestroyLogRecord(JMSMessageLogHelper.getMillis(jMSMessageLogger, (Event)messageConsumerDestroyEvent), JMSMessageLogHelper.getNano(jMSMessageLogger, (Event)messageConsumerDestroyEvent), jMSMessageEventLogListener.getListenerName(), string, string2);
    }

    private static boolean isMessageBodyNeeded(List list) {
        if (list == null) {
            return false;
        }
        for (String string : list) {
            if (!"%body%".equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private static String getMessageDocument(MessageImpl messageImpl, List list, List list2) throws javax.jms.JMSException {
        if (!(list != null && list.size() != 0 || list2 != null && list2.size() != 0)) {
            return null;
        }
        Document document = XMLHelper.getDocument(messageImpl, list, list2, JMSMessageLogHelper.isMessageBodyNeeded(list2));
        try {
            StringWriter stringWriter = new StringWriter();
            OutputFormat outputFormat = new OutputFormat(document);
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
            xMLSerializer.serialize(document);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new JMSException("Wrap IOException inside", (Throwable)iOException);
        }
    }

    private static long getMillis(JMSMessageLogger jMSMessageLogger, Event event) {
        if (jMSMessageLogger.doNano()) {
            return jMSMessageLogger.getStartMillisTime() + (event.getNanoseconds() - jMSMessageLogger.getStartNanoTime()) / 1000000L;
        }
        return event.getMilliseconds();
    }

    private static long getNano(JMSMessageLogger jMSMessageLogger, Event event) {
        if (jMSMessageLogger.doNano()) {
            return (event.getNanoseconds() - jMSMessageLogger.getStartNanoTime()) % 1000000L;
        }
        return 0L;
    }

    private static final String getJMSMessageContent(JMSMessageEventLogListener jMSMessageEventLogListener, MessageEvent messageEvent) {
        MessageImpl messageImpl = (MessageImpl)messageEvent.getMessage();
        messageImpl = messageImpl.cloneit();
        messageImpl.setDeliveryCount(messageEvent.getDeliveryCount());
        return JMSMessageLogHelper.createMessageLogMessage(jMSMessageEventLogListener, messageImpl);
    }
}

