/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.transaction.xa.Xid;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.extensions.JMSMessageInfo;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.runtime.OpenDataConverter;

public class JMSMessageOpenDataConverter
implements OpenDataConverter {
    boolean bodyIncluded;

    public JMSMessageOpenDataConverter(boolean bl) {
        this.bodyIncluded = bl;
    }

    public CompositeData createCompositeData(Object object) throws OpenDataException {
        if (object == null) {
            return null;
        }
        if (!(object instanceof MessageElement)) {
            throw new OpenDataException("Unexpected class " + object.getClass().getName());
        }
        MessageElement messageElement = (MessageElement)object;
        MessageImpl messageImpl = (MessageImpl)messageElement.getMessage();
        if (messageImpl == null) {
            throw new OpenDataException("MessageElement " + messageElement + " contained null msg");
        }
        messageImpl = messageImpl.cloneit();
        messageImpl.setDeliveryCount(messageElement.getDeliveryCount());
        messageImpl.setPropertiesWritable(false);
        messageImpl.setBodyWritable(false);
        messageImpl.includeJMSXDeliveryCount(true);
        String string = null;
        Xid xid = messageElement.getXid();
        if (xid != null) {
            string = xid.toString();
        }
        String string2 = null;
        Queue queue = messageElement.getQueue();
        if (queue != null) {
            string2 = queue.getName();
        }
        JMSMessageInfo jMSMessageInfo = new JMSMessageInfo(messageElement.getInternalSequenceNumber(), messageElement.getState(), string, messageElement.getInternalSequenceNumber(), messageElement.getConsumerID(), messageImpl, string2, this.bodyIncluded);
        return jMSMessageInfo.toCompositeData();
    }
}

