/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import javax.jms.Message;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.ProducerSendResponse;
import weblogic.jms.dispatcher.Response;
import weblogic.jms.extensions.AsyncSendResponseInfo;
import weblogic.jms.frontend.FEProducerSendRequest;

public final class JMSProducerSendResponse
extends Response
implements Externalizable,
ProducerSendResponse,
AsyncSendResponseInfo {
    static final long serialVersionUID = -2438555459624785305L;
    private static final int VERSION61 = 1;
    private static final int EXTVERSION = 2;
    private static final int VERSION_MASK = 255;
    private static final int DELIVERY_MODE_MASK = 256;
    private static final int PRIORITY_MASK = 512;
    private static final int TIME_TO_LIVE_MASK = 1024;
    private static final int TIME_TO_DELIVER_MASK = 2048;
    private static final int FLOW_CONTROL_MASK = 4096;
    private static final int REDELIVERY_LIMIT_MASK = 8192;
    private static final int UOO90_MEMBER_MASK = 16384;
    private static final int DIABLOSTYLEMESSAGEID_MASK = 32768;
    private int mask;
    private JMSMessageId messageId;
    private int deliveryMode;
    private int priority;
    private long timeToLive;
    private long timeToDeliver;
    private int redeliveryLimit;
    private long flowControlTime;
    private FEProducerSendRequest request;
    private Serializable uooMember;
    private transient Message message;
    private transient long asyncFlowControlTime;

    public JMSProducerSendResponse(JMSMessageId jMSMessageId) {
        this.messageId = jMSMessageId;
    }

    public void setMessageId(JMSMessageId jMSMessageId) {
        this.messageId = jMSMessageId;
    }

    public JMSMessageId getMessageId() {
        return this.messageId;
    }

    public void setDeliveryMode(int n) {
        this.mask |= 0x100;
        this.deliveryMode = n;
    }

    public int getDeliveryMode() {
        if ((this.mask & 0x100) == 0) {
            return -1;
        }
        return this.deliveryMode;
    }

    public void setPriority(int n) {
        this.mask |= 0x200;
        this.priority = n;
    }

    public int getPriority() {
        if ((this.mask & 0x200) == 0) {
            return -1;
        }
        return this.priority;
    }

    public void setTimeToLive(long l) {
        this.mask |= 0x400;
        this.timeToLive = l;
    }

    public long getTimeToLive() {
        if ((this.mask & 0x400) == 0) {
            return -1L;
        }
        return this.timeToLive;
    }

    public void setTimeToDeliver(long l) {
        this.mask |= 0x800;
        this.timeToDeliver = l;
    }

    public long getTimeToDeliver() {
        if ((this.mask & 0x800) == 0) {
            return -1L;
        }
        return this.timeToDeliver;
    }

    public void setRedeliveryLimit(int n) {
        this.mask |= 0x2000;
        this.redeliveryLimit = n;
    }

    public void set90StyleMessageId() {
        this.mask |= 0x8000;
    }

    public boolean get90StyleMessageId() {
        return (this.mask & 0x8000) != 0;
    }

    public int getRedeliveryLimit() {
        if ((this.mask & 0x2000) == 0) {
            return 0;
        }
        return this.redeliveryLimit;
    }

    public void setNeedsFlowControl(boolean bl) {
        this.mask = bl ? (this.mask |= 0x1000) : (this.mask &= 0xFFFFEFFF);
    }

    public boolean getNeedsFlowControl() {
        return (this.mask & 0x1000) != 0;
    }

    public void setFlowControlTime(long l) {
        this.mask |= 0x1000;
        this.flowControlTime = l;
    }

    public long getFlowControlTime() {
        if ((this.mask & 0x1000) == 0) {
            return -1L;
        }
        return this.flowControlTime;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public long getAsyncFlowControlTime() {
        return this.asyncFlowControlTime;
    }

    public void setAsyncFlowControlTime(long l) {
        this.asyncFlowControlTime = l;
    }

    public void setRequest(FEProducerSendRequest fEProducerSendRequest) {
        this.request = fEProducerSendRequest;
    }

    public boolean isDispatchOneWay() {
        if (this.request == null) {
            return false;
        }
        return this.request.isNoResponse();
    }

    public void setUOOInfo(Serializable serializable) {
        this.uooMember = serializable;
        this.mask = serializable == null ? (this.mask &= 0xFFFFBFFF) : (this.mask |= 0x4000);
    }

    public Serializable getUOOInfo() {
        return this.uooMember;
    }

    private int getVersion(ObjectOutput objectOutput) throws IOException {
        if (objectOutput instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)objectOutput).getPeerInfo();
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_61) < 0) {
                throw new IOException(JMSClientExceptionLogger.logInvalidResponseLoggable((int)1, (int)2, (String)peerInfo.toString()).getMessage());
            }
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_70) < 0) {
                return 1;
            }
        }
        return 2;
    }

    public JMSProducerSendResponse() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput = this.getVersionedStream(objectOutput);
        int n = this.getVersion(objectOutput);
        super.writeExternal(objectOutput);
        this.mask = this.mask & 0xFFFFFF00 | n;
        objectOutput.writeInt(this.mask);
        this.messageId.writeExternal(objectOutput);
        if ((this.mask & 0x100) != 0) {
            objectOutput.writeInt(this.deliveryMode);
        }
        if ((this.mask & 0x200) != 0) {
            objectOutput.writeInt(this.priority);
        }
        if ((this.mask & 0x400) != 0) {
            objectOutput.writeLong(this.timeToLive);
        }
        if ((this.mask & 0x800) != 0) {
            objectOutput.writeLong(this.timeToDeliver);
        }
        if (n == 2) {
            if ((this.mask & 0x2000) != 0) {
                objectOutput.writeInt(this.redeliveryLimit);
            }
            if ((this.mask & 0x1000) != 0) {
                objectOutput.writeLong(this.flowControlTime);
            }
        }
        if ((this.mask & 0x4000) != 0) {
            objectOutput.writeObject(this.uooMember);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.mask = objectInput.readInt();
        int n = this.mask & 0xFF;
        if (n < 1 || n > 2) {
            throw JMSUtilities.versionIOException(n, 1, 2);
        }
        this.messageId = new JMSMessageId();
        this.messageId.readExternal(objectInput);
        if ((this.mask & 0x100) != 0) {
            this.deliveryMode = objectInput.readInt();
        }
        if ((this.mask & 0x200) != 0) {
            this.priority = objectInput.readInt();
        }
        if ((this.mask & 0x400) != 0) {
            this.timeToLive = objectInput.readLong();
        }
        if ((this.mask & 0x800) != 0) {
            this.timeToDeliver = objectInput.readLong();
        }
        if ((this.mask & 0x2000) != 0) {
            this.redeliveryLimit = objectInput.readInt();
        }
        if ((this.mask & 0x1000) != 0) {
            this.flowControlTime = objectInput.readLong();
        }
        if ((this.mask & 0x4000) != 0) {
            this.uooMember = (Serializable)objectInput.readObject();
        }
    }
}

