/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushRequest;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.JMSDispatcher;

public final class JMSPushEntry
implements Externalizable {
    static final long serialVersionUID = -632448292622511345L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int NEXT_MASK = 256;
    private static final int REDELIVERED_MASK = 512;
    private static final int SEQUENCER_ID_MASK = 1024;
    private static final int BACK_END_MASK = 2048;
    private static final int FRONT_END_MASK = 4096;
    private static final int CLIENTRESPONSIBLEFORACKNOWLEDGE = 8192;
    private static final int REDELIVERED_COUNT_FLAG = 16384;
    public static final int PIPELINE_GENERATION_MASK = 0xF00000;
    public static final int NO_PIPELINE_GENERATION = 0;
    public static final int EXPIRED_GENERATION = 0x100000;
    public static final int CLIENT_ACK_GENERATION = 0x200000;
    public static final int LEAST_PIPELINE_GENERATION = 0x400000;
    public static final int FIRST_PIPELINE_GENERATION = 0xF00000;
    private static final int DEBUG_PIPELINE_GENERATION_SHIFT = 20;
    private transient JMSPushEntry next;
    private transient JMSPushEntry nextUnacked;
    private transient JMSPushEntry prevUnacked;
    private transient JMSDispatcher dispatcher;
    private transient long messageSize;
    private JMSID sequencerId;
    private JMSID consumerId;
    private long backEndSequenceNumber;
    private long frontEndSequenceNumber;
    private int pipelineGeneration;
    private int deliveryCount;
    private boolean clientResponsibleForAcknowledge;

    public JMSPushEntry(JMSID jMSID, JMSID jMSID2, long l, long l2, int n, int n2) {
        this.sequencerId = jMSID;
        this.consumerId = jMSID2;
        this.backEndSequenceNumber = l;
        this.frontEndSequenceNumber = l2;
        this.deliveryCount = n;
        this.pipelineGeneration = n2;
    }

    public final JMSID getSequencerId() {
        return this.sequencerId;
    }

    public final JMSID getConsumerId() {
        return this.consumerId;
    }

    public final long getFrontEndSequenceNumber() {
        return this.frontEndSequenceNumber;
    }

    public final void setFrontEndSequenceNumber(long l) {
        this.frontEndSequenceNumber = l;
    }

    public final long getBackEndSequenceNumber() {
        return this.backEndSequenceNumber;
    }

    public final void setBackEndSequenceNumber(long l) {
        this.backEndSequenceNumber = l;
    }

    public int getPipelineGeneration() {
        return this.pipelineGeneration;
    }

    public void setPipelineGeneration(int n) {
        this.pipelineGeneration = n;
    }

    public static int nextRecoverGeneration(int n) {
        if (n < 0x400000) {
            return n;
        }
        if ((n += 0x100000) > 0xF00000) {
            n = 0x400000;
        }
        return n;
    }

    public static int displayRecoverGeneration(int n) {
        return n >> 20;
    }

    public final long getMessageSize() {
        return this.messageSize;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    public final void setMessageSize(long l) {
        this.messageSize = l;
    }

    public final boolean getClientResponsibleForAcknowledge() {
        return this.clientResponsibleForAcknowledge;
    }

    public final void setClientResponsibleForAcknowledge(boolean bl) {
        this.clientResponsibleForAcknowledge = bl;
    }

    public final JMSPushEntry getNext() {
        return this.next;
    }

    public final void setNext(JMSPushEntry jMSPushEntry) {
        this.next = jMSPushEntry;
    }

    public final JMSPushEntry getNextUnacked() {
        return this.nextUnacked;
    }

    public final void setNextUnacked(JMSPushEntry jMSPushEntry) {
        this.nextUnacked = jMSPushEntry;
    }

    public final JMSPushEntry getPrevUnacked() {
        return this.prevUnacked;
    }

    public final void setPrevUnacked(JMSPushEntry jMSPushEntry) {
        this.prevUnacked = jMSPushEntry;
    }

    public final void setDispatcher(JMSDispatcher jMSDispatcher) {
        this.dispatcher = jMSDispatcher;
    }

    public final JMSDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public JMSPushEntry() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.writeExternal(objectOutput, null);
    }

    public void writeExternal(ObjectOutput objectOutput, JMSPushRequest jMSPushRequest) throws IOException {
        ObjectOutput objectOutput2 = objectOutput instanceof MessageImpl.JMSObjectOutputWrapper ? ((MessageImpl.JMSObjectOutputWrapper)objectOutput).getInnerObjectOutput() : objectOutput;
        boolean bl = objectOutput2 instanceof PeerInfoable ? PeerInfo.VERSION_DIABLO.compareTo((Object)((PeerInfoable)objectOutput2).getPeerInfo()) <= 0 : false;
        if (!bl) assert (this.pipelineGeneration == 0);
        int n = 1;
        JMSPushEntry jMSPushEntry = this;
        JMSID jMSID = null;
        if (jMSPushRequest == null) {
            n |= 0x1800;
        } else if (jMSPushRequest.getMethodId() == 15620) {
            n |= 0x1000;
        } else {
            jMSID = (JMSID)jMSPushRequest.getInvocableId();
            n |= 0x800;
        }
        do {
            n &= 0xFF0FB8FF;
            n |= this.pipelineGeneration;
            if (jMSPushEntry.next != null) {
                n |= 0x100;
            }
            if (jMSPushEntry.deliveryCount > 1) {
                n = bl ? (n |= 0x4000) : (n |= 0x200);
            }
            if (jMSPushEntry.getClientResponsibleForAcknowledge()) {
                n |= 0x2000;
            }
            if ((n & 0x800) != 0 && jMSPushEntry.sequencerId != jMSID) {
                n |= 0x400;
                jMSID = this.sequencerId;
            }
            objectOutput.writeInt(n);
            if (MessageImpl.debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
                this.debugWire("JMSPushEntry.write", n, ", atLeastDiabloIOStream=" + bl);
            }
            if ((n & 0x400) != 0) {
                jMSPushEntry.sequencerId.writeExternal(objectOutput);
            }
            if ((n & 0x800) != 0) {
                objectOutput.writeLong(jMSPushEntry.backEndSequenceNumber);
            }
            if ((n & 0x1000) != 0) {
                objectOutput.writeLong(jMSPushEntry.frontEndSequenceNumber);
            }
            jMSPushEntry.consumerId.writeExternal(objectOutput);
            if ((n & 0x4000) == 0) continue;
            objectOutput.writeInt(jMSPushEntry.deliveryCount);
        } while ((jMSPushEntry = jMSPushEntry.next) != null);
    }

    private void debugWire(String string, int n, String string2) {
        JMSDebug.JMSDispatcher.debug(string + " versionInt x" + Integer.toHexString(n).toUpperCase() + string2);
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this.readExternal(objectInput, null);
    }

    JMSPushEntry readExternal(ObjectInput objectInput, JMSPushRequest jMSPushRequest) throws ClassNotFoundException, IOException {
        JMSPushEntry jMSPushEntry;
        JMSPushEntry jMSPushEntry2 = this;
        JMSID jMSID = (JMSID)jMSPushRequest.getInvocableId();
        do {
            int n = objectInput.readInt();
            int n2 = n & 0xFF;
            if (MessageImpl.debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
                this.debugWire("JMSPushEntry.read ", n, ", version=" + n2);
            }
            if (n2 != 1) {
                throw JMSUtilities.versionIOException(n2, 1, 1);
            }
            if ((n & 0x400) == 0) {
                jMSPushEntry2.sequencerId = jMSID;
            } else {
                jMSPushEntry2.sequencerId = new JMSID();
                jMSPushEntry2.sequencerId.readExternal(objectInput);
            }
            if ((n & 0x800) != 0) {
                jMSPushEntry2.backEndSequenceNumber = objectInput.readLong();
            }
            if ((n & 0x1000) != 0) {
                jMSPushEntry2.frontEndSequenceNumber = objectInput.readLong();
            }
            jMSPushEntry2.consumerId = new JMSID();
            jMSPushEntry2.consumerId.readExternal(objectInput);
            jMSPushEntry2.setClientResponsibleForAcknowledge((n & 0x2000) != 0);
            this.pipelineGeneration = n & 0xF00000;
            jMSPushEntry2.deliveryCount = (n & 0x4000) != 0 ? objectInput.readInt() : ((n & 0x200) != 0 ? 2 : 1);
            jMSPushEntry = jMSPushEntry2;
            if ((n & 0x100) == 0) continue;
            jMSPushEntry2.next = new JMSPushEntry();
        } while ((jMSPushEntry2 = jMSPushEntry2.next) != null);
        return jMSPushEntry;
    }
}

