/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.messaging.common.SQLExpression;

public final class JMSSQLExpression
extends SQLExpression {
    public static final long serialVersionUID = 1287505877942351248L;
    private static final int EXTERNAL_VERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int HAS_SELECTOR_FLAG = 256;
    private static final int HAS_ID_FLAG = 512;
    private static final int NO_LOCAL_FLAG = 1024;
    private static final int NOT_FORWARDED_FLAG = 2048;
    private static final int HAS_CLIENT_ID_FLAG = 4096;
    private static final int HAS_CLIENT_ID_POLICY_FLAG = 8192;
    private boolean noLocal;
    private boolean notForwarded;
    private JMSID connectionId;
    private String clientId;
    private int clientIdPolicy = 0;

    public JMSSQLExpression() {
    }

    public JMSSQLExpression(String string, boolean bl, JMSID jMSID, boolean bl2) {
        super(string);
        this.setNoLocal(bl);
        this.setConnectionId(jMSID);
        this.setNotForwarded(bl2);
    }

    public JMSSQLExpression(String string, boolean bl, JMSID jMSID, String string2, int n) {
        super(string);
        this.setNoLocal(bl);
        this.setConnectionId(jMSID);
        this.setNotForwarded(false);
        this.setClientId(string2);
        this.setClientIdPolicy(n);
    }

    public JMSSQLExpression(String string) {
        super(string);
        this.setNoLocal(false);
        this.setConnectionId(null);
        this.setNotForwarded(false);
    }

    public boolean isNull() {
        return this.selector == null && !this.notForwarded && (!this.noLocal || this.connectionId == null);
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean bl) {
        this.noLocal = bl;
    }

    public JMSID getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(JMSID jMSID) {
        this.connectionId = jMSID;
    }

    public void setClientId(String string) {
        this.clientId = string;
    }

    public String getClientId() {
        return this.clientId;
    }

    public int getClientIdPolicy() {
        return this.clientIdPolicy;
    }

    public void setClientIdPolicy(int n) {
        this.clientIdPolicy = n;
    }

    public boolean isNotForwarded() {
        return this.notForwarded;
    }

    public void setNotForwarded(boolean bl) {
        this.notForwarded = bl;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.selector != null) {
            n |= 0x100;
        }
        if (this.connectionId != null) {
            n |= 0x200;
        }
        if (this.clientId != null) {
            n |= 0x1000;
        }
        if (this.clientIdPolicy != 0) {
            n |= 0x2000;
        }
        if (this.noLocal) {
            n |= 0x400;
        }
        if (this.notForwarded) {
            n |= 0x800;
        }
        objectOutput.writeInt(n);
        if (this.selector != null) {
            objectOutput.writeUTF(this.selector);
        }
        if (this.connectionId != null) {
            this.connectionId.writeExternal(objectOutput);
        }
        if (this.clientId != null) {
            objectOutput.writeUTF(this.clientId);
        }
        if ((n & 0x2000) != 0) {
            objectOutput.writeInt(this.clientIdPolicy);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if ((n & 0xFF) != 1) {
            throw new IOException("External version mismatch");
        }
        this.noLocal = (n & 0x400) != 0;
        boolean bl = this.notForwarded = (n & 0x800) != 0;
        if ((n & 0x100) != 0) {
            this.selector = objectInput.readUTF();
        }
        if ((n & 0x200) != 0) {
            this.connectionId = new JMSID();
            this.connectionId.readExternal(objectInput);
        }
        if ((n & 0x1000) != 0) {
            this.clientId = objectInput.readUTF();
        }
        if ((n & 0x2000) != 0) {
            this.clientIdPolicy = objectInput.readInt();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        if (this.selector != null) {
            stringBuffer.append("selector=\"");
            stringBuffer.append(this.selector);
            stringBuffer.append("\" ");
        }
        if (this.connectionId != null) {
            stringBuffer.append("connectionID=\"");
            stringBuffer.append(this.connectionId);
            stringBuffer.append("\" ");
        }
        if (this.clientId != null) {
            stringBuffer.append("clientId=\"");
            stringBuffer.append(this.clientId);
            stringBuffer.append("\" ");
        }
        stringBuffer.append("clientIdPoliy=\"");
        stringBuffer.append(this.clientIdPolicy);
        stringBuffer.append("\" ");
        if (this.noLocal) {
            stringBuffer.append("noLocal=true ");
        }
        if (this.notForwarded) {
            stringBuffer.append("notForwarded=true ");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

