/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSSQLExpression;
import weblogic.jms.common.JMSVariableBinder;
import weblogic.jms.common.MessageImpl;
import weblogic.messaging.common.CompiledSQLExpression;
import weblogic.messaging.common.SQLFilter;
import weblogic.messaging.kernel.Expression;
import weblogic.messaging.kernel.Filter;
import weblogic.messaging.kernel.InvalidExpressionException;
import weblogic.messaging.kernel.Kernel;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.kernel.Sink;
import weblogic.utils.expressions.ExpressionEvaluationException;
import weblogic.utils.expressions.ExpressionParser;
import weblogic.utils.expressions.ExpressionParserException;
import weblogic.utils.expressions.VariableBinder;

public class JMSSQLFilter
extends SQLFilter {
    private final Map indexedSubscribers = new HashMap();
    private final Map filteredForwardedIndexedSubs = new HashMap();
    private final Set<Sink> filteredForwardedSubs = new HashSet<Sink>();
    private final Map<Sink, Expression> filteredForwardedAndMoreSubs = new HashMap<Sink, Expression>();

    public JMSSQLFilter(Kernel kernel) {
        super(kernel, JMSVariableBinder.THE_ONE);
    }

    public Expression createExpression(Object object) throws KernelException {
        try {
            JMSSQLExpression jMSSQLExpression = (JMSSQLExpression)object;
            if (jMSSQLExpression.isNull()) {
                return null;
            }
            return new Exp(this.variableBinder, jMSSQLExpression);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidExpressionException("Wrong class: " + object.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Sink sink, Expression expression) {
        this.lock.lockWrite();
        try {
            if (expression == null) {
                this.subscribers.put(sink, null);
            } else {
                Exp exp = (Exp)expression;
                String string = exp.getSelectorID();
                if (exp.isJMSWLDDForwarded()) {
                    this.filteredForwardedSubs.add(sink);
                } else if (exp.isJMSWLDDForwardedAndMore()) {
                    String string2 = exp.getfilteredForwardedSelectorID();
                    if (string2 != null) {
                        this.addIndexedSubscriber(sink, string2, true);
                    } else {
                        this.filteredForwardedAndMoreSubs.put(sink, expression);
                    }
                } else if (string != null) {
                    this.addIndexedSubscriber(sink, string, false);
                } else {
                    this.subscribers.put(sink, exp);
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.unlockWrite();
            throw throwable;
        }
        this.lock.unlockWrite();
    }

    private void addIndexedSubscriber(Sink sink, String string, boolean bl) {
        assert (this.lock.isLockedForWrite());
        Map map = bl ? this.filteredForwardedIndexedSubs : this.indexedSubscribers;
        Object v = map.get(string);
        if (v == null) {
            map.put(string, sink);
        } else if (v instanceof Set) {
            ((Set)v).add(sink);
        } else {
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.add(v);
            hashSet.add(sink);
            map.put(string, hashSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Sink sink) {
        if (sink == null) {
            return;
        }
        this.lock.lockWrite();
        try {
            if (this.subscribers.remove(sink) == null && !this.filteredForwardedSubs.remove(sink) && this.filteredForwardedAndMoreSubs.remove(sink) == null) {
                this.removeIndexedSubscriber(sink);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlockWrite();
            throw throwable;
        }
        this.lock.unlockWrite();
    }

    private void removeIndexedSubscriber(Sink sink) {
        Object object;
        assert (this.lock.isLockedForWrite());
        Iterator iterator = this.indexedSubscribers.values().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object instanceof Set && ((Set)object).contains(sink)) {
                Set set = (Set)object;
                set.remove(sink);
                if (set.isEmpty()) {
                    iterator.remove();
                }
                return;
            }
            if (!object.equals(sink)) continue;
            iterator.remove();
            return;
        }
        object = this.filteredForwardedIndexedSubs.values().iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (e instanceof Set && ((Set)e).contains(sink)) {
                Set set = (Set)e;
                set.remove(sink);
                if (set.isEmpty()) {
                    object.remove();
                }
                return;
            }
            if (!e.equals(sink)) continue;
            object.remove();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection match(MessageElement messageElement) {
        ArrayList<Object> arrayList;
        ArrayList<Object> arrayList2;
        block19: {
            Iterator<Map.Entry<Object, Object>> iterator;
            MessageImpl messageImpl;
            block18: {
                arrayList2 = new ArrayList<Object>();
                try {
                    messageImpl = (MessageImpl)messageElement.getMessage();
                }
                catch (ClassCastException classCastException) {
                    return null;
                }
                this.lock.lockRead();
                if (!this.filteredForwardedSubs.isEmpty() && !messageImpl.getDDForwarded()) {
                    arrayList2.addAll(this.filteredForwardedSubs);
                }
                if (!this.filteredForwardedAndMoreSubs.isEmpty() && !messageImpl.getDDForwarded()) {
                    for (Map.Entry<Sink, Expression> entry2 : this.filteredForwardedAndMoreSubs.entrySet()) {
                        if (!((CompiledSQLExpression)entry2.getValue()).evaluate(messageElement)) continue;
                        arrayList2.add(entry2.getKey());
                    }
                }
                if (this.filteredForwardedIndexedSubs.isEmpty() || messageImpl.getDDForwarded()) break block18;
                try {
                    iterator = messageImpl.getPropertyNameCollection().iterator();
                    while (iterator.hasNext()) {
                        Object v = this.filteredForwardedIndexedSubs.get(iterator.next());
                        if (v == null) continue;
                        if (v instanceof Set) {
                            arrayList2.addAll((Set)v);
                            continue;
                        }
                        arrayList2.add(v);
                    }
                }
                catch (JMSException jMSException) {
                    Collection collection = null;
                    Object var8_18 = null;
                    this.lock.unlockRead();
                    return collection;
                }
            }
            if (this.indexedSubscribers.isEmpty()) break block19;
            try {
                iterator = messageImpl.getPropertyNameCollection().iterator();
                while (iterator.hasNext()) {
                    Object v = this.indexedSubscribers.get(iterator.next());
                    if (v == null) continue;
                    if (v instanceof Set) {
                        arrayList2.addAll((Set)v);
                        continue;
                    }
                    arrayList2.add(v);
                }
            }
            catch (JMSException jMSException) {
                Collection collection = null;
                Object var8_19 = null;
                this.lock.unlockRead();
                return collection;
            }
        }
        try {
            for (Map.Entry<Object, Object> entry : this.subscribers.entrySet()) {
                CompiledSQLExpression compiledSQLExpression = (CompiledSQLExpression)entry.getValue();
                if (compiledSQLExpression != null && !compiledSQLExpression.evaluate(messageElement)) continue;
                arrayList2.add(entry.getKey());
            }
            arrayList = arrayList2;
            Object var8_20 = null;
        }
        catch (Throwable throwable) {
            Object var8_21 = null;
            this.lock.unlockRead();
            throw throwable;
        }
        this.lock.unlockRead();
        return arrayList;
    }

    private final class Exp
    implements CompiledSQLExpression {
        private weblogic.utils.expressions.Expression wlExp;
        private boolean noLocal;
        private boolean notForwarded;
        private JMSID connectionId;
        private String clientId;
        private int clientIdPolicy = 0;

        Exp(VariableBinder variableBinder, JMSSQLExpression jMSSQLExpression) throws KernelException {
            this.noLocal = jMSSQLExpression.isNoLocal();
            this.notForwarded = jMSSQLExpression.isNotForwarded();
            this.connectionId = jMSSQLExpression.getConnectionId();
            this.clientId = jMSSQLExpression.getClientId();
            this.clientIdPolicy = jMSSQLExpression.getClientIdPolicy();
            String string = jMSSQLExpression.getSelector();
            if (string != null) {
                try {
                    ExpressionParser expressionParser = new ExpressionParser();
                    this.wlExp = expressionParser.parse(string, variableBinder);
                }
                catch (ExpressionParserException expressionParserException) {
                    throw new InvalidExpressionException(string);
                }
            }
        }

        public Filter getFilter() {
            return JMSSQLFilter.this;
        }

        public boolean evaluate(MessageElement messageElement) {
            MessageImpl messageImpl = (MessageImpl)messageElement.getMessage();
            if (this.noLocal) {
                boolean bl;
                boolean bl2 = messageImpl.getConnectionId() != null && this.connectionId != null && messageImpl.getConnectionId().equals(this.connectionId);
                boolean bl3 = bl = this.clientIdPolicy != 0 && messageImpl.getClientId() != null && this.clientId != null && messageImpl.getClientId().equals(this.clientId);
                if (bl2 || bl) {
                    return false;
                }
            }
            if (this.notForwarded && messageImpl.getDDForwarded()) {
                return false;
            }
            if (this.wlExp != null) {
                try {
                    return this.wlExp.evaluate((Object)messageElement);
                }
                catch (ExpressionEvaluationException expressionEvaluationException) {
                    return false;
                }
            }
            return true;
        }

        String getSelectorID() {
            return this.wlExp == null ? null : this.wlExp.getSelectorID();
        }

        String getfilteredForwardedSelectorID() {
            return this.wlExp == null ? null : this.wlExp.getfilteredForwardedSelectorID();
        }

        boolean isJMSWLDDForwarded() {
            if (this.wlExp == null) {
                return false;
            }
            String string = this.wlExp.getStandardForwarderID();
            return string != null && string.equals("JMS_WL_DDForwarded");
        }

        boolean isJMSWLDDForwardedAndMore() {
            if (this.wlExp == null) {
                return false;
            }
            String string = this.wlExp.getComplexForwarderID();
            return string != null && string.equals("JMS_WL_DDForwarded");
        }
    }
}

