/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSSecurityException;
import weblogic.management.ManagementException;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.JMSResource;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.Resource;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public class JMSSecurityHelper {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final AbstractSubject anonymous = SubjectManager.getSubjectManager().getAnonymousSubject();
    private PrincipalAuthenticator pa;
    private AuthorizationManager am;
    private static JMSSecurityHelper securityHelper;
    private static Hashtable destinationMap;

    public JMSSecurityHelper() throws ManagementException {
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Initializing JMS Security Helper");
        }
        String string = "weblogicDEFAULT";
        this.pa = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        this.am = (AuthorizationManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHORIZE);
        if (this.pa == null || this.am == null) {
            throw new RuntimeException("Security Services Unavailable");
        }
    }

    public static synchronized JMSSecurityHelper getSecurityHelper() throws ManagementException {
        if (securityHelper == null) {
            securityHelper = new JMSSecurityHelper();
        }
        return securityHelper;
    }

    public static JMSSecurityHelper getJMSSecurityHelper() {
        return securityHelper;
    }

    public void mapDestinationName(String string, String string2) {
        if (destinationMap == null) {
            destinationMap = new Hashtable();
        }
        destinationMap.put(string, string2);
    }

    public void unmapDestinationName(String string) {
        if (destinationMap == null) {
            return;
        }
        destinationMap.remove(string);
    }

    public PrincipalAuthenticator getPrincipalAuthenticator() {
        return this.pa;
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.am;
    }

    public static boolean authenticate(String string, String string2) {
        try {
            return JMSSecurityHelper.getJMSSecurityHelper().getPrincipalAuthenticator().authenticate((CallbackHandler)new SimpleCallbackHandler(string, string2)) != null;
        }
        catch (LoginException loginException) {
            return false;
        }
    }

    public static void checkPermission(JMSResource jMSResource) throws JMSSecurityException {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        JMSSecurityHelper.checkPermission(jMSResource, authenticatedSubject);
    }

    public static AuthenticatedSubject getCurrentSubject() {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        return authenticatedSubject;
    }

    public static void checkPermission(JMSResource jMSResource, AuthenticatedSubject authenticatedSubject) throws JMSSecurityException {
        if (jMSResource == null) {
            return;
        }
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Creating JMS resource for " + jMSResource.getActionName() + " with " + "  applicationName = " + jMSResource.getApplicationName() + ", moduleName = " + jMSResource.getModule() + " and resource name = " + jMSResource.getResourceName() + " and type = " + jMSResource.getDestinationType());
        }
        if (!JMSSecurityHelper.getJMSSecurityHelper().getAuthorizationManager().isAccessAllowed(authenticatedSubject, (Resource)jMSResource, null)) {
            throw new JMSSecurityException("Access denied to resource: " + jMSResource);
        }
    }

    public static String getSimpleAuthenticatedName() {
        return SubjectUtils.getUsername((Subject)JMSSecurityHelper.getCurrentSubject().getSubject());
    }

    public static AuthenticatedSubject authenticatedSubject(String string, String string2) throws LoginException {
        return JMSSecurityHelper.getJMSSecurityHelper().getPrincipalAuthenticator().authenticate((CallbackHandler)new SimpleCallbackHandler(string, string2));
    }

    public static final Object doAsJNDIOperation(AbstractSubject abstractSubject, PrivilegedExceptionAction privilegedExceptionAction) throws NamingException, JMSException {
        try {
            return abstractSubject.doAs((AbstractSubject)KERNEL_ID, privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof NamingException) {
                throw (NamingException)exception;
            }
            throw new JMSException(exception);
        }
    }

    public static final Object doAs(AbstractSubject abstractSubject, PrivilegedExceptionAction privilegedExceptionAction) throws javax.jms.JMSException {
        try {
            return abstractSubject.doAs((AbstractSubject)KERNEL_ID, privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof javax.jms.JMSException) {
                throw (javax.jms.JMSException)((Object)exception);
            }
            throw new JMSException(exception);
        }
    }

    public static final boolean isServerIdentity(AuthenticatedSubject authenticatedSubject) {
        return SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject) || SecurityServiceManager.isServerIdentity((AuthenticatedSubject)authenticatedSubject);
    }

    public static final AbstractSubject getAnonymousSubject() {
        return anonymous;
    }

    public static void pushSubject(AuthenticatedSubject authenticatedSubject) {
        SubjectManager.getSubjectManager().pushSubject((AbstractSubject)KERNEL_ID, (AbstractSubject)authenticatedSubject);
    }
}

