/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.security.AccessControlException;
import java.security.AccessController;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.j2ee.descriptor.wl.NamedEntityBean;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.IllegalStateException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.dispatcher.DispatcherWrapper;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.dispatcher.Request;
import weblogic.jndi.factories.java.javaURLContextFactory;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.rmi.extensions.RemoteHelper;
import weblogic.rmi.spi.HostID;
import weblogic.security.HMAC;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.utils.StringUtils;

public final class JMSServerUtilities {
    private static final String APPSCOPED_JNDI_PREFIX = "weblogic.applications";
    private static final AuthenticatedSubject kernelID = JMSServerUtilities.getKernelIdentity();

    private static final AuthenticatedSubject getKernelIdentity() {
        try {
            return (AuthenticatedSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }

    public static Context getLocalJNDIContext() {
        try {
            javaURLContextFactory javaURLContextFactory2 = new javaURLContextFactory();
            return (Context)javaURLContextFactory2.getObjectInstance((Object)null, (Name)null, (Context)null, (Hashtable)null);
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    public static void pushLocalJNDIContext(Context context) {
        javaURLContextFactory.pushContext(context);
    }

    public static void popLocalJNDIContext() {
        javaURLContextFactory.popContext();
    }

    public static HostID getHostId(Context context, DestinationImpl destinationImpl) {
        try {
            DispatcherId dispatcherId = destinationImpl.getDispatcherId();
            String string = JMSDispatcherManager.getDispatcherJNDIName(dispatcherId);
            DispatcherWrapper dispatcherWrapper = (DispatcherWrapper)context.lookup(string);
            return RemoteHelper.getHostID((Object)dispatcherWrapper.getRemoteDispatcher());
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    public static String getAppscopedGlobalJNDIName(String string, String string2, NamedEntityBean namedEntityBean) {
        if (string == null || string2 == null || namedEntityBean == null) {
            return null;
        }
        return new String(APPSCOPED_JNDI_PREFIX + string + "." + string2 + "#" + namedEntityBean.getName());
    }

    public static ConnectionFactory getXAConnectionFactory() {
        return JMSService.getJMSService().getDefaultConnectionFactory("DefaultXAConnectionFactory").getJMSConnectionFactory();
    }

    public static ConnectionFactory getXAConnectionFactory0() {
        return JMSService.getJMSService().getDefaultConnectionFactory("DefaultXAConnectionFactory0").getJMSConnectionFactory();
    }

    public static ConnectionFactory getXAConnectionFactory1() {
        return JMSService.getJMSService().getDefaultConnectionFactory("DefaultXAConnectionFactory1").getJMSConnectionFactory();
    }

    public static ConnectionFactory getXAConnectionFactory2() {
        return JMSService.getJMSService().getDefaultConnectionFactory("DefaultXAConnectionFactory2").getJMSConnectionFactory();
    }

    public static ConnectionFactory getConnectionFactory() {
        return JMSService.getJMSService().getDefaultConnectionFactory("DefaultConnectionFactory").getJMSConnectionFactory();
    }

    public static BEDestinationImpl findBEDestinationByJNDIName(String string) {
        BackEnd[] backEndArray = JMSService.getJMSService().getBEDeployer().getBackEnds();
        for (int i = 0; i < backEndArray.length; ++i) {
            BEDestinationImpl[] bEDestinationImplArray = backEndArray[i].getBEDestinations();
            for (int j = 0; j < bEDestinationImplArray.length; ++j) {
                if (bEDestinationImplArray[j] != null && string.equals(bEDestinationImplArray[j].getJNDIName())) {
                    return bEDestinationImplArray[j];
                }
                if (bEDestinationImplArray[j] == null || !string.equals(bEDestinationImplArray[j].getLocalJNDIName())) continue;
                return bEDestinationImplArray[j];
            }
        }
        for (BackEnd backEnd : backEndArray) {
            BEDestinationImpl[] bEDestinationImplArray;
            for (BEDestinationImpl bEDestinationImpl : bEDestinationImplArray = backEnd.getBEDestinations()) {
                int n;
                String string2 = bEDestinationImpl.getJNDIName();
                int n2 = n = string2 != null ? string2.lastIndexOf(64) : -1;
                if (n == -1 || !string.equals(string2.substring(n + 1))) continue;
                return bEDestinationImpl;
            }
        }
        return null;
    }

    public static String transformJNDIName(String string) {
        block5: {
            try {
                if (JMSDebug.JMSConfig.isDebugEnabled()) {
                    JMSDebug.JMSConfig.debug("In JMSServerUtilities.transformJNDIName with jndiName: " + string);
                }
                String string2 = JMSServerUtilities.getCurrentApplicationContext().getApplicationId();
                if (JMSDebug.JMSConfig.isDebugEnabled()) {
                    JMSDebug.JMSConfig.debug("In JMSServerUtilities.transformJNDIName. Found app name: " + string2);
                }
                string = JMSServerUtilities.transformJNDIName(string, string2);
                if (JMSDebug.JMSConfig.isDebugEnabled()) {
                    JMSDebug.JMSConfig.debug("In JMSServerUtilities.transformJNDIName. Calculated final jndiName: " + string);
                }
            }
            catch (IllegalStateException illegalStateException) {
                if (!JMSDebug.JMSConfig.isDebugEnabled()) break block5;
                JMSDebug.JMSConfig.debug("In JMSServerUtilities.transformJNDIName. Didn't get app name due to exception: " + illegalStateException.toString());
            }
        }
        return string;
    }

    public static String transformJNDIName(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("${APPNAME}") != -1) {
            return StringUtils.replaceGlobal((String)string, (String)"${APPNAME}", (String)string2);
        }
        return string;
    }

    public static ApplicationContext getCurrentApplicationContext() throws IllegalStateException {
        ApplicationContextInternal applicationContextInternal = ApplicationAccess.getApplicationAccess().getCurrentApplicationContext();
        if (applicationContextInternal == null) {
            throw new IllegalStateException("Attempt to access current application context from a component which has no application context");
        }
        return applicationContextInternal;
    }

    public static boolean verifySignature(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return HMAC.verify((byte[])byArray, (byte[])byArray2, (byte[])byArray3, (byte[])SerializedSystemIni.getSalt());
    }

    public static byte[] digest(byte[] byArray, byte[] byArray2) {
        return HMAC.digest((byte[])byArray, (byte[])byArray2, (byte[])SerializedSystemIni.getSalt());
    }

    public static byte[] generateSecret(String string) {
        byte[] byArray = SerializedSystemIni.getEncryptedSecretKey();
        byte[] byArray2 = string.getBytes();
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void anonDispatchNoReply(Request request, JMSDispatcher jMSDispatcher) throws JMSException {
        AuthenticatedSubject authenticatedSubject = null;
        try {
            AuthenticatedSubject authenticatedSubject2;
            if (!jMSDispatcher.isLocal() && (SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)(authenticatedSubject2 = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelID))) || SecurityServiceManager.isServerIdentity((AuthenticatedSubject)authenticatedSubject2))) {
                authenticatedSubject = SubjectUtils.getAnonymousSubject();
            }
            if (authenticatedSubject != null) {
                SubjectManager.getSubjectManager().pushSubject((AbstractSubject)kernelID, authenticatedSubject);
            }
            jMSDispatcher.dispatchNoReply(request);
            Object var5_4 = null;
            if (authenticatedSubject == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (authenticatedSubject == null) throw throwable;
            SubjectManager.getSubjectManager().popSubject((AbstractSubject)kernelID);
            throw throwable;
        }
        SubjectManager.getSubjectManager().popSubject((AbstractSubject)kernelID);
    }
}

