/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.util.HashMap;
import javax.jms.JMSException;
import weblogic.jms.extensions.WLMessage;
import weblogic.messaging.Message;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.runtime.MessageInfo;
import weblogic.utils.expressions.Expression;
import weblogic.utils.expressions.ExpressionEvaluationException;
import weblogic.utils.expressions.Variable;
import weblogic.utils.expressions.VariableBinder;

public final class JMSVariableBinder
implements VariableBinder {
    public static final JMSVariableBinder THE_ONE = new JMSVariableBinder();
    private static final HashMap VARIABLES = new HashMap();

    public Variable getVariable(String string) {
        Variable variable = (Variable)VARIABLES.get(string);
        if (variable != null) {
            return variable;
        }
        return new JMSPropertiesVariable(string);
    }

    protected static WLMessage msg(Object object) {
        return (WLMessage)JMSVariableBinder.element(object).getMessage();
    }

    protected static Message kmsg(Object object) {
        return JMSVariableBinder.element(object).getMessage();
    }

    protected static MessageElement element(Object object) {
        return (MessageElement)object;
    }

    protected static ExpressionEvaluationException wrapException(JMSException jMSException) throws ExpressionEvaluationException {
        ExpressionEvaluationException expressionEvaluationException = new ExpressionEvaluationException("Failed to bind variable");
        expressionEvaluationException.initCause((Throwable)jMSException);
        throw expressionEvaluationException;
    }

    static {
        VARIABLES.put("JMSDeliveryMode", new JMSDeliveryModeVariable());
        VARIABLES.put("JMSMessageID", new JMSMessageIDVariable());
        VARIABLES.put("JMSMessageId", new JMSMessageIDVariable());
        VARIABLES.put("JMSTimestamp", new JMSTimestampVariable());
        VARIABLES.put("JMSCorrelationID", new JMSCorrelationIDVariable());
        VARIABLES.put("JMSType", new JMSTypeVariable());
        VARIABLES.put("JMSPriority", new JMSPriorityVariable());
        VARIABLES.put("JMSExpiration", new JMSExpirationVariable());
        VARIABLES.put("JMSRedelivered", new JMSRedeliveredVariable());
        VARIABLES.put("JMSDeliveryTime", new JMSDeliveryTimeVariable());
        VARIABLES.put("JMS_BEA_DeliveryTime", new JMSDeliveryTimeVariable());
        VARIABLES.put("JMSRedeliveryLimit", new JMSRedeliveryLimitVariable());
        VARIABLES.put("JMS_BEA_RedeliveryLimit", new JMSRedeliveryLimitVariable());
        VARIABLES.put("JMS_BEA_Size", new JMS_BEA_SizeVariable());
        VARIABLES.put("JMS_BEA_UnitOfOrder", new JMS_BEA_UnitOfOrderVariable());
        VARIABLES.put("JMSXUserID", new JMSXUserIDVariable());
        VARIABLES.put("JMSXDeliveryCount", new JMSXDeliveryCountVariable());
        VARIABLES.put("JMS_BEA_State", new JMSBEAStateVariable());
        VARIABLES.put("JMS_WL_DDForwarded", new JMS_WL_DDForwardedVariable());
    }

    private static class JMS_WL_DDForwardedVariable
    implements Variable {
        private JMS_WL_DDForwardedVariable() {
        }

        public Object get(Object object) {
            return new Boolean(((WLMessage)JMSVariableBinder.element(object).getMessage()).getDDForwarded());
        }

        public Expression.Type getType() {
            return Expression.Type.BOOLEAN;
        }
    }

    private static class JMSBEAStateVariable
    implements Variable {
        private JMSBEAStateVariable() {
        }

        public Object get(Object object) {
            return MessageInfo.getStateString(JMSVariableBinder.element(object).getState());
        }

        public Expression.Type getType() {
            return Expression.Type.STRING;
        }
    }

    private static class JMSXDeliveryCountVariable
    implements Variable {
        private JMSXDeliveryCountVariable() {
        }

        public Object get(Object object) {
            return new Integer(JMSVariableBinder.element(object).getDeliveryCount());
        }

        public Expression.Type getType() {
            return Expression.Type.NUMERIC;
        }
    }

    private static class JMSXUserIDVariable
    implements Variable {
        private JMSXUserIDVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return JMSVariableBinder.msg(object).getStringProperty("JMSXUserID");
            }
            catch (JMSException jMSException) {
                throw JMSVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.STRING;
        }
    }

    private static class JMS_BEA_UnitOfOrderVariable
    implements Variable {
        private JMS_BEA_UnitOfOrderVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return JMSVariableBinder.msg(object).getStringProperty("JMS_BEA_UnitOfOrder");
            }
            catch (JMSException jMSException) {
                throw JMSVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.STRING;
        }
    }

    private static class JMS_BEA_SizeVariable
    implements Variable {
        private JMS_BEA_SizeVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            return new Long(JMSVariableBinder.kmsg(object).size());
        }

        public Expression.Type getType() {
            return Expression.Type.NUMERIC;
        }
    }

    private static class JMSRedeliveryLimitVariable
    implements Variable {
        private JMSRedeliveryLimitVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return new Integer(JMSVariableBinder.msg(object).getJMSRedeliveryLimit());
            }
            catch (JMSException jMSException) {
                throw JMSVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.NUMERIC;
        }
    }

    private static class JMSDeliveryTimeVariable
    implements Variable {
        private JMSDeliveryTimeVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return new Long(JMSVariableBinder.msg(object).getJMSDeliveryTime());
            }
            catch (JMSException jMSException) {
                throw JMSVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.NUMERIC;
        }
    }

    private static class JMSRedeliveredVariable
    implements Variable {
        private JMSRedeliveredVariable() {
        }

        public Object get(Object object) {
            return JMSVariableBinder.element(object).getDeliveryCount() > 1;
        }

        public Expression.Type getType() {
            return Expression.Type.BOOLEAN;
        }
    }

    private static class JMSExpirationVariable
    implements Variable {
        private JMSExpirationVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return new Long(JMSVariableBinder.msg(object).getJMSExpiration());
            }
            catch (JMSException jMSException) {
                throw JMSVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.NUMERIC;
        }
    }

    private static class JMSPriorityVariable
    implements Variable {
        private JMSPriorityVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return new Integer(JMSVariableBinder.msg(object).getJMSPriority());
            }
            catch (JMSException jMSException) {
                throw JMSVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.NUMERIC;
        }
    }

    private static class JMSTypeVariable
    implements Variable {
        private JMSTypeVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return JMSVariableBinder.msg(object).getJMSType();
            }
            catch (JMSException jMSException) {
                throw JMSVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.STRING;
        }
    }

    private static class JMSCorrelationIDVariable
    implements Variable {
        private JMSCorrelationIDVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return JMSVariableBinder.msg(object).getJMSCorrelationID();
            }
            catch (JMSException jMSException) {
                throw JMSVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.STRING;
        }
    }

    private static class JMSTimestampVariable
    implements Variable {
        private JMSTimestampVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return new Long(JMSVariableBinder.msg(object).getJMSTimestamp());
            }
            catch (JMSException jMSException) {
                throw JMSVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.NUMERIC;
        }
    }

    private static class JMSMessageIDVariable
    implements Variable {
        private JMSMessageIDVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return JMSVariableBinder.msg(object).getJMSMessageID();
            }
            catch (JMSException jMSException) {
                throw JMSVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.STRING;
        }
    }

    private static class JMSDeliveryModeVariable
    implements Variable {
        private JMSDeliveryModeVariable() {
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return JMSVariableBinder.msg(object).getJMSDeliveryMode() == 2 ? "PERSISTENT" : "NON_PERSISTENT";
            }
            catch (JMSException jMSException) {
                throw JMSVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.STRING;
        }
    }

    private static class JMSPropertiesVariable
    implements Variable {
        private final String key;

        private JMSPropertiesVariable(String string) {
            this.key = string;
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return JMSVariableBinder.msg(object).getObjectProperty(this.key);
            }
            catch (JMSException jMSException) {
                throw JMSVariableBinder.wrapException(jMSException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.ANY;
        }
    }
}

