/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;

public final class LeaderBindFailedRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 1241072754999225509L;
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private static final int VERSION_MASK = 255;
    private String jndiName;
    private JMSID leaderID;
    private long sequenceNumber = -1L;

    public LeaderBindFailedRequest(String string, JMSID jMSID, long l) {
        super(null, 16661);
        this.jndiName = string;
        this.leaderID = jMSID;
        this.sequenceNumber = l;
    }

    public int remoteSignature() {
        return 64;
    }

    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public final String getJNDIName() {
        return this.jndiName;
    }

    public final long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public final JMSID getLeaderID() {
        return this.leaderID;
    }

    public String toString() {
        return new String("LeaderBindFailedRequest(" + this.jndiName + ")");
    }

    public LeaderBindFailedRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        PeerInfo peerInfo;
        int n = 2;
        if (objectOutput instanceof PeerInfoable && (peerInfo = ((PeerInfoable)objectOutput).getPeerInfo()).getMajor() < 9) {
            n = 1;
        }
        int n2 = n;
        objectOutput.writeInt(n2);
        super.writeExternal(objectOutput);
        objectOutput.writeUTF(this.jndiName);
        if (n >= 2) {
            this.leaderID.writeExternal(objectOutput);
            objectOutput.writeLong(this.sequenceNumber);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 < 1 || n2 > 2) {
            throw JMSUtilities.versionIOException(n2, 1, 2);
        }
        super.readExternal(objectInput);
        this.jndiName = objectInput.readUTF();
        if (n2 >= 2) {
            this.leaderID = new JMSID();
            this.leaderID.readExternal(objectInput);
            this.sequenceNumber = objectInput.readLong();
        }
    }
}

