/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.LeaderBindResponse;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;

public final class LeaderBindRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -5214437563807672399L;
    private static final byte EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private String serverName;
    private String jndiName;

    public LeaderBindRequest(String string, String string2) {
        super(null, 16405);
        this.serverName = string;
        this.jndiName = string2;
    }

    public final String getServerName() {
        return this.serverName;
    }

    public int remoteSignature() {
        return 34;
    }

    public Response createResponse() {
        return new LeaderBindResponse();
    }

    public final String getJNDIName() {
        return this.jndiName;
    }

    public String toString() {
        return "LeaderBindRequest(" + this.serverName + ":" + this.jndiName + ")";
    }

    public LeaderBindRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        objectOutput.writeUTF(this.serverName);
        objectOutput.writeUTF(this.jndiName);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.serverName = objectInput.readUTF();
        this.jndiName = objectInput.readUTF();
    }
}

