/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Response;

public final class LeaderBindResponse
extends Response
implements Externalizable,
Comparable {
    static final long serialVersionUID = -2408521791630650078L;
    private static final byte EXTVERSION1 = 1;
    private static final byte EXTVERSION2 = 2;
    private static final int VERSION_MASK = 255;
    private static final int GO_AHEAD_AND_BIND = 256;
    private static final int HAS_REASON = 512;
    private boolean goAheadAndBind;
    private JMSID leaderJMSID;
    private long leaderSequenceNumber;
    private String reasonForRejection;

    public LeaderBindResponse(boolean bl, JMSID jMSID, long l, String string) {
        this.goAheadAndBind = bl;
        this.leaderJMSID = jMSID;
        this.leaderSequenceNumber = l;
        this.reasonForRejection = string;
    }

    public LeaderBindResponse(boolean bl, JMSID jMSID, long l) {
        this(bl, jMSID, l, null);
    }

    public JMSID getLeaderJMSID() {
        return this.leaderJMSID;
    }

    public long getLeaderSequenceNumber() {
        return this.leaderSequenceNumber;
    }

    public boolean doBind() {
        return this.goAheadAndBind;
    }

    public String getReasonForRejection() {
        if (!this.goAheadAndBind && this.reasonForRejection == null) {
            return "Unknown reason for rejection";
        }
        return this.reasonForRejection;
    }

    public int compareTo(Object object) {
        LeaderBindResponse leaderBindResponse = (LeaderBindResponse)object;
        int n = leaderBindResponse.leaderJMSID.compareTo(this.leaderJMSID);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        if (leaderBindResponse.leaderSequenceNumber < this.leaderSequenceNumber) {
            return -1;
        }
        if (leaderBindResponse.leaderSequenceNumber > this.leaderSequenceNumber) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        LeaderBindResponse leaderBindResponse = (LeaderBindResponse)object;
        if (!leaderBindResponse.leaderJMSID.equals(this.leaderJMSID)) {
            return false;
        }
        return leaderBindResponse.leaderSequenceNumber == this.leaderSequenceNumber;
    }

    public String toString() {
        return new String("LeaderBindResponse(" + this.goAheadAndBind + ":" + this.leaderJMSID.toString() + ":" + this.leaderSequenceNumber + ")");
    }

    public int hashCode() {
        return this.leaderJMSID.hashCode() ^ (int)(this.leaderSequenceNumber & 0xFFFFFFFFFFFFFFFFL);
    }

    public LeaderBindResponse() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        PeerInfo peerInfo;
        int n = 2;
        if (objectOutput instanceof PeerInfoable && (peerInfo = ((PeerInfoable)objectOutput).getPeerInfo()).getMajor() < 9) {
            n = 1;
        }
        int n2 = n;
        if (this.goAheadAndBind) {
            n2 |= 0x100;
        }
        if (this.reasonForRejection != null) {
            n2 |= 0x200;
        }
        objectOutput.writeInt(n2);
        super.writeExternal(objectOutput);
        this.leaderJMSID.writeExternal(objectOutput);
        objectOutput.writeLong(this.leaderSequenceNumber);
        if (n >= 2 && this.reasonForRejection != null) {
            objectOutput.writeUTF(this.reasonForRejection);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 < 1 || n2 > 2) {
            throw JMSUtilities.versionIOException(n2, 1, 2);
        }
        this.goAheadAndBind = (n & 0x100) != 0;
        super.readExternal(objectInput);
        this.leaderJMSID = new JMSID();
        this.leaderJMSID.readExternal(objectInput);
        this.leaderSequenceNumber = objectInput.readLong();
        if (n2 >= 2 && (n & 0x200) != 0) {
            this.reasonForRejection = objectInput.readUTF();
        }
    }
}

