/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.cluster.ClusterMembersChangeEvent;
import weblogic.cluster.ClusterMembersChangeListener;
import weblogic.cluster.ClusterService;
import weblogic.cluster.ClusterServices;
import weblogic.jms.JMSService;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.LeaderBindFailedRequest;
import weblogic.jms.common.LeaderBindRequest;
import weblogic.jms.common.LeaderBindResponse;
import weblogic.jms.dispatcher.Invocable;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;

public final class LeaderManager
implements Invocable,
ClusterMembersChangeListener {
    private static final LeaderManager leaderManager = new LeaderManager();
    private JMSID requestStatsSourceId;
    private long sequenceNumber;
    private final HashMap hashByName = new HashMap();

    private LeaderManager() {
        ClusterServices clusterServices = ClusterService.getServices();
        if (clusterServices != null) {
            clusterServices.addClusterMembersListener(this);
        }
    }

    public JMSID getJMSID() {
        return null;
    }

    public ID getId() {
        return this.getJMSID();
    }

    public InvocableMonitor getInvocableMonitor() {
        return null;
    }

    private void setRequestStatsSourceId(JMSID jMSID) {
        this.requestStatsSourceId = jMSID;
    }

    private JMSID getRequestStatsSourceId() {
        return this.requestStatsSourceId;
    }

    public int invoke(Request request) throws Throwable {
        switch (request.getMethodId()) {
            case 16405: {
                return this.leaderBindSingular((LeaderBindRequest)request);
            }
            case 16661: {
                LeaderBindFailedRequest leaderBindFailedRequest = (LeaderBindFailedRequest)request;
                this.aggregatableDidBind(leaderBindFailedRequest.getJNDIName(), leaderBindFailedRequest.getLeaderID(), leaderBindFailedRequest.getSequenceNumber());
                break;
            }
        }
        return Integer.MAX_VALUE;
    }

    private synchronized long getNextSequenceNumber() {
        return this.sequenceNumber++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int leaderBindSingular(LeaderBindRequest leaderBindRequest) {
        long l;
        String string = leaderBindRequest.getJNDIName();
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("LeaderManager.leaderBindSingular(" + leaderBindRequest + ")");
        }
        if (this.requestStatsSourceId == null) {
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("LeaderManager.leaderBindSingular(Not Granted 10)");
            }
            leaderBindRequest.setResult(new LeaderBindResponse(false, this.requestStatsSourceId, this.getNextSequenceNumber(), "The statistics source id is null"));
            leaderBindRequest.setState(Integer.MAX_VALUE);
            return Integer.MAX_VALUE;
        }
        if (string == null) {
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("LeaderManager.leaderBindSingular(Not Granted 30)");
            }
            leaderBindRequest.setResult(new LeaderBindResponse(false, this.requestStatsSourceId, this.getNextSequenceNumber(), "The requested JNDI name was null"));
            leaderBindRequest.setState(Integer.MAX_VALUE);
            return Integer.MAX_VALUE;
        }
        HashMap hashMap = this.hashByName;
        synchronized (hashMap) {
            try {
                Object object = JMSService.getContext().lookup(string);
                if (JMSDebug.JMSCommon.isDebugEnabled()) {
                    JMSDebug.JMSCommon.debug("LeaderManager.leaderBindSingular(Not Granted 40)");
                }
                leaderBindRequest.setResult(new LeaderBindResponse(false, this.requestStatsSourceId, this.getNextSequenceNumber(), "The JNDI name " + string + " was found, and was bound to an object of type " + object.getClass().getName() + " : " + object));
                leaderBindRequest.setState(Integer.MAX_VALUE);
                return Integer.MAX_VALUE;
            }
            catch (NamingException namingException) {
                if (!(namingException instanceof NameNotFoundException)) {
                    if (JMSDebug.JMSCommon.isDebugEnabled()) {
                        JMSDebug.JMSCommon.debug("LeaderManager.leaderBindSingular(Not Granted 50)");
                    }
                    leaderBindRequest.setResult(new LeaderBindResponse(false, this.requestStatsSourceId, this.getNextSequenceNumber(), "An unknown naming exception occured looking up " + string + ".  The error was " + namingException));
                    leaderBindRequest.setState(Integer.MAX_VALUE);
                    return Integer.MAX_VALUE;
                }
                String string2 = leaderBindRequest.getServerName();
                String string3 = string.replace('/', '.');
                if (this.hashByName.get(string3) != null) {
                    if (JMSDebug.JMSCommon.isDebugEnabled()) {
                        JMSDebug.JMSCommon.debug("LeaderManager.leaderBindSingular(Not Granted 60)");
                    }
                    leaderBindRequest.setResult(new LeaderBindResponse(false, this.requestStatsSourceId, this.getNextSequenceNumber(), "The name " + string3 + " has been previously reserved by server " + string2));
                    leaderBindRequest.setState(Integer.MAX_VALUE);
                    return Integer.MAX_VALUE;
                }
                l = this.getNextSequenceNumber();
                this.hashByName.put(string3, new SerAndSeq(string2, l));
                if (JMSDebug.JMSCommon.isDebugEnabled()) {
                    JMSDebug.JMSCommon.debug("LeaderManager.leaderBindSingular name put in pending list=" + string3);
                }
            }
        }
        leaderBindRequest.setResult(new LeaderBindResponse(true, this.requestStatsSourceId, l));
        leaderBindRequest.setState(Integer.MAX_VALUE);
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("LeaderManager.leaderBindSingular(Granted " + string + " to " + leaderBindRequest.getServerName() + ")");
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregatableDidBind(String string, JMSID jMSID, long l) {
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("LeaderManager.aggregatableDidBind(" + string + ":" + jMSID + ":" + l + ")");
        }
        if (string == null || jMSID == null || this.requestStatsSourceId == null) {
            return;
        }
        if (!jMSID.equals(this.requestStatsSourceId)) {
            return;
        }
        SerAndSeq serAndSeq = null;
        HashMap hashMap = this.hashByName;
        synchronized (hashMap) {
            serAndSeq = (SerAndSeq)this.hashByName.get(string);
            if (serAndSeq != null && (l < 0L || l == serAndSeq.getSequenceNumber())) {
                this.hashByName.remove(string);
            }
        }
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("LeaderManager.aggregatableDidBind(removed " + string + " with value " + serAndSeq + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clusterMembersChanged(ClusterMembersChangeEvent clusterMembersChangeEvent) {
        if (clusterMembersChangeEvent.getAction() != 1) {
            return;
        }
        String string = clusterMembersChangeEvent.getClusterMemberInfo().serverName();
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("LeaderManager.clusterMembersChanged(" + string + ") is being removed");
        }
        HashMap hashMap = this.hashByName;
        synchronized (hashMap) {
            Iterator iterator = this.hashByName.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SerAndSeq serAndSeq = (SerAndSeq)entry.getValue();
                String string2 = serAndSeq.getServerName();
                if (!string.equals(string2)) continue;
                iterator.remove();
            }
        }
    }

    public static synchronized LeaderManager getLeaderManager() {
        return leaderManager;
    }

    public static synchronized LeaderManager getLeaderManager(JMSID jMSID) {
        if (leaderManager.getRequestStatsSourceId() == null) {
            leaderManager.setRequestStatsSourceId(jMSID);
        }
        return leaderManager;
    }

    private static class SerAndSeq {
        private String serverName;
        private long sequenceNumber;

        private SerAndSeq(String string, long l) {
            this.serverName = string;
            this.sequenceNumber = l;
        }

        private String getServerName() {
            return this.serverName;
        }

        private long getSequenceNumber() {
            return this.sequenceNumber;
        }

        public String toString() {
            return "SerAndSeq(" + this.serverName + "/" + this.sequenceNumber + ")";
        }
    }
}

