/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Closeable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.MapMessage;
import javax.jms.Message;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageFormatException;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;
import weblogic.jms.common.TypeConverter;

public final class MapMessageImpl
extends MessageImpl
implements MapMessage,
Externalizable {
    private static final byte EXTVERSION = 1;
    private static final byte EXTVERSION2 = 2;
    private static final byte VERSIONMASK = 127;
    static final long serialVersionUID = -3363325517439700010L;
    private HashMap hashMap;
    private PayloadStream payload;
    private PeerInfo peerInfo;

    public MapMessageImpl() {
        this.peerInfo = PeerInfo.getPeerInfo();
    }

    public MapMessageImpl(MapMessage mapMessage) throws javax.jms.JMSException {
        this(mapMessage, null, null);
    }

    public MapMessageImpl(MapMessage mapMessage, Destination destination, Destination destination2) throws javax.jms.JMSException {
        super((Message)mapMessage, destination, destination2);
        Enumeration enumeration = mapMessage.getMapNames();
        if (enumeration.hasMoreElements()) {
            this.hashMap = new HashMap();
            do {
                String string = (String)enumeration.nextElement();
                this.hashMap.put(string, mapMessage.getObject(string));
            } while (enumeration.hasMoreElements());
        }
        this.peerInfo = PeerInfo.getPeerInfo();
    }

    public byte getType() {
        return 3;
    }

    public boolean getBoolean(String string) throws javax.jms.JMSException {
        return TypeConverter.toBoolean(this.getObject(string));
    }

    public byte getByte(String string) throws javax.jms.JMSException {
        return TypeConverter.toByte(this.getObject(string));
    }

    public byte[] getBytes(String string) throws javax.jms.JMSException {
        return TypeConverter.toByteArray(this.getObject(string));
    }

    public char getChar(String string) throws javax.jms.JMSException {
        return TypeConverter.toChar(this.getObject(string));
    }

    public double getDouble(String string) throws javax.jms.JMSException {
        return TypeConverter.toDouble(this.getObject(string));
    }

    public float getFloat(String string) throws javax.jms.JMSException {
        return TypeConverter.toFloat(this.getObject(string));
    }

    public short getShort(String string) throws javax.jms.JMSException {
        return TypeConverter.toShort(this.getObject(string));
    }

    public int getInt(String string) throws javax.jms.JMSException {
        return TypeConverter.toInt(this.getObject(string));
    }

    public long getLong(String string) throws javax.jms.JMSException {
        return TypeConverter.toLong(this.getObject(string));
    }

    public String getString(String string) throws javax.jms.JMSException {
        return TypeConverter.toString(this.getObject(string));
    }

    public Object getObject(String string) throws javax.jms.JMSException {
        return this.getHashMap().get(string);
    }

    public Enumeration getMapNames() throws javax.jms.JMSException {
        return Collections.enumeration(this.getHashMap().keySet());
    }

    public void setBoolean(String string, boolean bl) throws javax.jms.JMSException {
        this.setObjectInternal(string, new Boolean(bl));
    }

    public void setByte(String string, byte by) throws javax.jms.JMSException {
        this.setObjectInternal(string, new Byte(by));
    }

    public void setBytes(String string, byte[] byArray) throws javax.jms.JMSException {
        this.setObjectInternal(string, byArray);
    }

    public void setBytes(String string, byte[] byArray, int n, int n2) throws javax.jms.JMSException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.setObjectInternal(string, byArray2);
    }

    public void setChar(String string, char c) throws javax.jms.JMSException {
        this.setObjectInternal(string, new Character(c));
    }

    public void setDouble(String string, double d) throws javax.jms.JMSException {
        this.setObjectInternal(string, new Double(d));
    }

    public void setFloat(String string, float f) throws javax.jms.JMSException {
        this.setObjectInternal(string, new Float(f));
    }

    public void setInt(String string, int n) throws javax.jms.JMSException {
        this.setObjectInternal(string, new Integer(n));
    }

    public void setLong(String string, long l) throws javax.jms.JMSException {
        this.setObjectInternal(string, new Long(l));
    }

    public void setObject(String string, Object object) throws javax.jms.JMSException {
        if (!(object instanceof Number || object instanceof String || object instanceof Boolean || object instanceof byte[] || object instanceof Character || object == null)) {
            throw new MessageFormatException(JMSClientExceptionLogger.logInvalidDataTypeLoggable((String)object.getClass().getName()).getMessage());
        }
        this.setObjectInternal(string, object);
    }

    public void setShort(String string, short s) throws javax.jms.JMSException {
        this.setObjectInternal(string, new Short(s));
    }

    public void setString(String string, String string2) throws javax.jms.JMSException {
        this.setObjectInternal(string, string2);
    }

    private void setObjectInternal(String string, Object object) throws javax.jms.JMSException {
        this.writeMode();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(JMSClientExceptionLogger.logIllegalNameLoggable((String)string).getMessage());
        }
        this.getHashMap().put(string, object);
    }

    public boolean itemExists(String string) throws javax.jms.JMSException {
        return this.getHashMap().containsKey(string);
    }

    public void nullBody() {
        this.payload = null;
        this.hashMap = null;
    }

    public String toString() {
        return "MapMessage[" + this.getJMSMessageID() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        PayloadStream payloadStream;
        ObjectOutput objectOutput2;
        super.writeExternal(objectOutput);
        int n = Integer.MAX_VALUE;
        if (objectOutput instanceof MessageImpl.JMSObjectOutputWrapper) {
            n = ((MessageImpl.JMSObjectOutputWrapper)objectOutput).getCompressionThreshold();
            objectOutput2 = ((MessageImpl.JMSObjectOutputWrapper)objectOutput).getInnerObjectOutput();
        } else {
            objectOutput2 = objectOutput;
        }
        PeerInfo peerInfo = objectOutput2 instanceof PeerInfoable ? ((PeerInfoable)objectOutput2).getPeerInfo() : PeerInfo.getPeerInfo();
        if (!this.isCompressed()) {
            MapMessageImpl mapMessageImpl = this;
            synchronized (mapMessageImpl) {
                payloadStream = this.getMapPayload(peerInfo);
                if (this.payload == null) {
                    this.payload = payloadStream;
                    this.peerInfo = peerInfo;
                    this.hashMap = null;
                }
            }
        } else {
            payloadStream = null;
        }
        int n2 = this.getVersion(objectOutput2) >= 30 ? (int)((byte)(2 | (this.shouldCompress(objectOutput2, n) ? -128 : 0))) : 1;
        objectOutput2.writeByte(n2);
        if (this.isCompressed()) {
            if (n2 == 1) {
                this.decompress().writeLengthAndData(objectOutput2);
            } else {
                this.flushCompressedMessageBody(objectOutput2);
            }
        } else if ((n2 & 0xFFFFFF80) != 0) {
            this.writeExternalCompressPayload(objectOutput2, payloadStream);
        } else {
            payloadStream.writeLengthAndData(objectOutput2);
        }
    }

    public final void decompressMessageBody() throws javax.jms.JMSException {
        if (!this.isCompressed()) {
            return;
        }
        try {
            try {
                this.payload = (PayloadStream)this.decompress();
            }
            catch (IOException iOException) {
                throw new JMSException(JMSClientExceptionLogger.logErrorDecompressMessageBodyLoggable().getMessage(), (Throwable)iOException);
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.cleanupCompressedMessageBody();
            throw throwable;
        }
        this.cleanupCompressedMessageBody();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        PeerInfo peerInfo;
        super.readExternal(objectInput);
        byte by = objectInput.readByte();
        byte by2 = (byte)(by & 0x7F);
        if (by2 < 1 || by2 > 2) {
            throw JMSUtilities.versionIOException(by2, 1, 2);
        }
        this.peerInfo = PeerInfo.getPeerInfo();
        if (objectInput instanceof PeerInfoable && (peerInfo = ((PeerInfoable)objectInput).getPeerInfo()) != null && peerInfo.compareTo((Object)this.peerInfo) < 0) {
            this.peerInfo = peerInfo;
        }
        if ((by & 0xFFFFFF80) != 0) {
            this.readExternalCompressedMessageBody(objectInput);
        } else {
            this.payload = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)objectInput));
        }
    }

    public MessageImpl copy() throws javax.jms.JMSException {
        MapMessageImpl mapMessageImpl = new MapMessageImpl();
        this.copy(mapMessageImpl);
        try {
            mapMessageImpl.peerInfo = PeerInfo.getPeerInfo();
            PayloadStream payloadStream = this.getMapPayload(mapMessageImpl.peerInfo);
            mapMessageImpl.payload = payloadStream.copyPayloadWithoutSharedStream();
        }
        catch (IOException iOException) {
            throw new JMSException(JMSClientExceptionLogger.logCopyErrorLoggable().getMessage(), (Throwable)iOException);
        }
        mapMessageImpl.setBodyWritable(false);
        mapMessageImpl.setPropertiesWritable(false);
        return mapMessageImpl;
    }

    public long getPayloadSize() {
        if (this.isCompressed()) {
            return this.getCompressedMessageBodySize();
        }
        if (this.bodySize != -1L) {
            return this.bodySize;
        }
        this.bodySize = this.payload == null ? 0L : (long)this.payload.getLength();
        return this.bodySize;
    }

    private HashMap getHashMap() throws javax.jms.JMSException {
        if (this.hashMap != null) {
            return this.hashMap;
        }
        this.decompressMessageBody();
        if (this.payload == null) {
            this.hashMap = new HashMap();
        } else {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(this.payload.getInputStream());
                this.hashMap = JMSUtilities.readBigStringBasicMap(objectInputStream);
            }
            catch (IOException iOException) {
                throw new JMSException(JMSClientExceptionLogger.logDeserializationErrorLoggable().getMessage(), (Throwable)iOException);
            }
        }
        this.payload = null;
        return this.hashMap;
    }

    private PayloadStream getMapPayload(PeerInfo peerInfo) throws IOException {
        Closeable closeable;
        HashMap hashMap = this.hashMap;
        if (this.payload != null) {
            if (this.peerInfo != null && this.peerInfo.equals((Object)peerInfo)) {
                return this.payload;
            }
            closeable = new ObjectInputStream(this.payload.getInputStream());
            hashMap = JMSUtilities.readBigStringBasicMap((ObjectInput)((Object)closeable));
        } else if (hashMap == null) {
            hashMap = new HashMap();
        }
        closeable = PayloadFactoryImpl.createOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)closeable);
        JMSUtilities.writeBigStringBasicMap(objectOutputStream, hashMap, peerInfo, true);
        objectOutputStream.flush();
        return (PayloadStream)((BufferOutputStream)closeable).moveToPayload();
    }
}

