/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.jms.Message;
import org.w3c.dom.Document;
import weblogic.common.WLObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.client.JMSSession;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.BytesMessageImpl;
import weblogic.jms.common.Destination;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.HdrMessageImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSOutputStream;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.JMSWorkContextHelper;
import weblogic.jms.common.MapMessageImpl;
import weblogic.jms.common.MessageFormatException;
import weblogic.jms.common.MessageNotReadableException;
import weblogic.jms.common.MessageNotWriteableException;
import weblogic.jms.common.MessageReference;
import weblogic.jms.common.ObjectMessageImpl;
import weblogic.jms.common.Payload;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;
import weblogic.jms.common.PrimitiveObjectMap;
import weblogic.jms.common.PutBackable;
import weblogic.jms.common.StreamMessageImpl;
import weblogic.jms.common.TextMessageImpl;
import weblogic.jms.common.TypeConverter;
import weblogic.jms.common.XMLMessageImpl;
import weblogic.jms.extensions.WLMessage;
import weblogic.messaging.MessageID;
import weblogic.messaging.common.MessagingUtilities;
import weblogic.utils.expressions.ExpressionMap;

public abstract class MessageImpl
implements Message,
weblogic.messaging.Message,
WLMessage,
ExpressionMap,
Cloneable,
Externalizable {
    static final long serialVersionUID = 7571220996297716034L;
    static final byte EXTVERSION1 = 1;
    static final byte EXTVERSION2 = 10;
    static final byte EXTVERSION3 = 20;
    static final byte EXTVERSION4 = 30;
    static final byte EXTVERSION5 = 40;
    public static final String USER_ID_PROPERTY_NAME = "JMSXUserID";
    public static final String UNIT_OF_ORDER_PROPERTY_NAME = "JMS_BEA_UnitOfOrder";
    public static final String SAF_SEQUENCE_NAME = "JMS_BEA_SAF_SEQUENCE_NAME";
    public static final String SAF_SEQUENCE_NUMBER = "JMS_BEA_SAF_SEQUENCE";
    public static final String DELIVERY_TIME_PROPERTY_NAME = "JMS_BEA_DeliveryTime";
    public static final String REDELIVERY_LIMIT_PROPERTY_NAME = "JMS_BEA_RedeliveryLimit";
    public static final String DELIVERY_COUNT_PROPERTY_NAME = "JMSXDeliveryCount";
    public static final String SIZE_PROPERTY_NAME = "JMS_BEA_Size";
    public static final String STATE_PROPERTY_NAME = "JMS_BEA_State";
    public static final String XID_PROPERTY_NAME = "JMS_BEA_Xid";
    public static final String INTERNAL_SEQUENCE_NUMBER_PROPERTY_NAME = "JMS_BEA_SequenceNumber";
    public static final String DD_FORWARDED_PROPERTY_NAME = "JMS_WL_DDForwarded";
    private static final boolean mydebug = false;
    private int deliveryMode = 1;
    private transient int adjustedDeliveryMode = 1;
    private int deliveryCount = 0;
    private long expiration;
    private long deliveryTime;
    private int redeliveryLimit = -1;
    private byte priority;
    private int userdatalen = -1;
    transient long bodySize = -1L;
    private boolean clientResponsibleForAcknowledge = false;
    private transient long sequenceNumber;
    private transient boolean bodyWritable = true;
    private transient boolean propertiesWritable = true;
    private boolean serializeDestination = true;
    private boolean ddforwarded;
    private String correlationId;
    private DestinationImpl destination;
    private DestinationImpl replyTo;
    private String type;
    private PrimitiveObjectMap properties;
    static final byte NULLMESSAGEIMPL = 0;
    static final byte BYTESMESSAGEIMPL = 1;
    static final byte HDRMESSAGEIMPL = 2;
    static final byte MAPMESSAGEIMPL = 3;
    static final byte OBJECTMESSAGEIMPL = 4;
    static final byte STREAMMESSAGEIMPL = 5;
    static final byte TEXTMESSAGEIMPL = 6;
    static final byte XMLMESSAGEIMPL = 7;
    static final byte COMPRESSION = -128;
    protected static final int SUBFLAG_TOKENIZE = 1;
    protected static final int SUBFLAG_UTF8 = 2;
    protected static final int SUBFLAG_OBJECT = 4;
    protected static final int SUBFLAG_STRING = 128;
    private boolean hasBeenCompressed;
    private Externalizable bexaXid;
    private JMSMessageId messageId;
    private JMSID connectionId;
    private String messageIdString;
    private String userId;
    private String clientId;
    private transient JMSSession session;
    private String unitOfOrderName;
    private String safSequenceName;
    private long safSequenceNumber;
    private transient boolean keepSAFSequenceNameAndNumber;
    private Object workContext;
    private transient MessageReference mRef;
    private boolean userIDRequested = false;
    private transient boolean deliveryCountIncluded;
    private boolean pre90Message = false;
    private PayloadStream payloadCompressed;
    private boolean compressed;
    protected int originalLength;
    private boolean clean;
    protected transient boolean payloadCopyOnWrite;
    private boolean safNeedReorder;
    private boolean jmsClientForward = false;
    private int totalForwardsCount;
    private static final int _PRIORITYMASK = 15;
    private static final int _PRIORITYSHIFT = 0;
    private static final int _RESERVEDEXTENSION2 = 16;
    private static final int _DDFORWARDED = 128;
    private static final int _HASREDELIVERYLIMIT = 256;
    private static final int _ISPERSISTENT = 512;
    private static final int _HASCORRID = 1024;
    private static final int _HASDESTINATION = 2048;
    private static final int _HASREPLYTO = 4096;
    private static final int _ISREDELIVERED = 8192;
    private static final int _HASTYPE = 16384;
    private static final int _HASEXPIRATION = 32768;
    private static final int _HASPROPERTIES = 65536;
    private static final int _HASXID = 131072;
    private static final int _HASMESSAGEID = 262144;
    private static final int _HASUSERDATALEN = 524288;
    private static final int _HASDELIVERYTIME = 0x100000;
    private static final int _SERIALIZEDEST = 0x200000;
    private static final int _CLIENTRESPONSIBLEFORACKNOWLEDGE = 0x400000;
    private static final int _RESERVEDEXTENSION1 = 0x800000;
    private static final int _VERSIONMASK = -16777216;
    private static final int _VERSIONSHIFT = 24;
    private static final int _DESTINATIONMASK = 7;
    private static final int _REPLYTODESTINATIONMASK = 56;
    private static final int _REPLYTODESTINATIONSHIFT = 3;
    private static final int _JMSCLIENTFORWARD = 1;
    private static final int _WORKCONTEXT = 2;
    private static final int _OLDMESSAGE = 4;
    private static final int _REQUESTUSERID = 16;
    private static final int _UNITOFORDER = 32;
    private static final int _HASSAFSEQUENCE = 64;
    private static final int _HASSAFSEQUENCENUMBER = 128;
    private static final int _HASUSERID = 256;
    private static final int _SAFNEEDREORDER = 512;
    private static final int _HASCLIENTID = 1024;
    protected static final int _CONTROL_MESSAGE_MASK = 0xFF0000;
    public static final int _CONTROL_SEQUENCE_RELEASE_FANOUT = 65536;
    public static final int _CONTROL_SEQUENCE_RELEASE = 131072;
    public static final int _CONTROL_SEQUENCE_RESERVE = 196608;
    private static final int GZIP_COMPRESSION = 0;
    static boolean debugWire = true;

    public final boolean hasBeenCompressed() {
        return this.hasBeenCompressed;
    }

    public MessageImpl() {
    }

    public final void setOldMessage(boolean bl) {
        this.pre90Message = bl;
    }

    public final boolean isOldMessage() {
        return this.pre90Message;
    }

    public final void incForwardsCount() {
        ++this.totalForwardsCount;
    }

    public final void resetForwardsCount() {
        this.totalForwardsCount = 0;
    }

    public final void setForward(boolean bl) {
        this.jmsClientForward = bl;
    }

    public final void setSAFNeedReorder(boolean bl) {
        this.safNeedReorder = bl;
    }

    public final boolean isSAFNeedReorder() {
        return this.safNeedReorder;
    }

    public final boolean isForwarded() {
        return this.totalForwardsCount > 0;
    }

    public final boolean isForwardable() {
        return this.jmsClientForward;
    }

    public final int getForwardsCount() {
        return this.totalForwardsCount;
    }

    public abstract byte getType();

    public int getControlOpcode() {
        return 0;
    }

    public void setControlOpcode(int n) throws IOException {
        throw new IOException("opcode not allocated");
    }

    public static MessageImpl createMessageImpl(byte by) throws IOException {
        switch (by) {
            case 1: {
                return new BytesMessageImpl();
            }
            case 2: {
                return new HdrMessageImpl();
            }
            case 3: {
                return new MapMessageImpl();
            }
            case 4: {
                return new ObjectMessageImpl();
            }
            case 5: {
                return new StreamMessageImpl();
            }
            case 6: {
                return new TextMessageImpl();
            }
            case 7: {
                return new XMLMessageImpl();
            }
        }
        throw new IOException(JMSClientExceptionLogger.logUnknownMessageTypeLoggable((byte)by).getMessage());
    }

    public MessageImpl(Message message) throws javax.jms.JMSException {
        this(message, null, null);
    }

    public MessageImpl(Message message, javax.jms.Destination destination, javax.jms.Destination destination2) throws javax.jms.JMSException {
        this();
        this.initializeFromMessage(message, destination, destination2);
    }

    public void initializeFromMessage(Message message) throws javax.jms.JMSException {
        this.initializeFromMessage(message, null, null);
    }

    public void initializeFromMessage(Message message, javax.jms.Destination destination, javax.jms.Destination destination2) throws javax.jms.JMSException {
        this.setJMSCorrelationID(message.getJMSCorrelationID());
        this.setJMSType(message.getJMSType());
        if (destination2 == null) {
            this.setJMSReplyTo(message.getJMSReplyTo());
        } else {
            this.setJMSReplyTo(destination2);
        }
        this.userdatalen = 0;
        if (this.correlationId != null) {
            this.userdatalen = this.correlationId.length();
        }
        if (this.type != null) {
            this.userdatalen += this.type.length();
        }
        if (destination == null) {
            this.setJMSDestination(message.getJMSDestination());
        } else {
            this.setJMSDestination(destination);
        }
        if (message.getJMSRedelivered()) {
            this.setDeliveryCount(2);
        }
        this.setJMSExpiration(message.getJMSExpiration());
        if (message instanceof WLMessage) {
            this.setJMSPriority(message.getJMSPriority());
            this.setJMSDeliveryMode(message.getJMSDeliveryMode());
            this.setJMSDeliveryTime(((WLMessage)message).getJMSDeliveryTime());
            this.setJMSRedeliveryLimit(((WLMessage)message).getJMSRedeliveryLimit());
        }
        Enumeration enumeration = message.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = message.getObjectProperty(string);
            this.userdatalen += 4 + (string.length() << 2);
            this.userdatalen += MessagingUtilities.calcObjectSize(object);
            this.setObjectProperty(string, object);
        }
    }

    private void copyToMessageReference() {
        if (this.mRef == null) {
            return;
        }
        try {
            MessageImpl messageImpl = this.copy();
            this.mRef.setMessage(messageImpl);
        }
        catch (javax.jms.JMSException jMSException) {
            JMSClientExceptionLogger.logStackTrace((Throwable)jMSException);
        }
        this.mRef = null;
    }

    public final String getJMSMessageID() {
        if (this.messageIdString == null && this.messageId != null) {
            this.messageIdString = this.pre90Message ? (this.deliveryMode == 1 ? "ID:N" : "ID:P") + this.messageId : "ID:" + this.messageId;
        }
        return this.messageIdString;
    }

    public final void setJMSMessageID(String string) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.messageIdString = string;
        this.jmsClientForward = false;
    }

    public final long getJMSTimestamp() {
        if (this.messageId != null) {
            return this.messageId.getTimestamp();
        }
        return 0L;
    }

    public final void setJMSTimestamp(long l) {
    }

    public final byte[] getJMSCorrelationIDAsBytes() throws javax.jms.JMSException {
        if (this.correlationId == null) {
            return null;
        }
        byte[] byArray = new byte[this.correlationId.length()];
        try {
            byArray = this.correlationId.getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray;
    }

    public final void setJMSCorrelationIDAsBytes(byte[] byArray) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        try {
            if (byArray == null) {
                this.setJMSCorrelationID(null);
            } else {
                this.setJMSCorrelationID(new String(byArray, "UTF-16BE"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public final void setJMSCorrelationID(String string) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.jmsClientForward = false;
        this.correlationId = string;
    }

    public final String getJMSCorrelationID() {
        return this.correlationId;
    }

    public final javax.jms.Destination getJMSReplyTo() {
        return this.replyTo;
    }

    public final void setJMSReplyTo(javax.jms.Destination destination) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.replyTo = destination == null || destination instanceof DestinationImpl ? (DestinationImpl)destination : null;
    }

    public final javax.jms.Destination getJMSDestination() {
        return this.destination;
    }

    public final DestinationImpl getDestination() {
        return this.destination;
    }

    public final void setJMSDestination(javax.jms.Destination destination) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.destination = destination == null || destination instanceof DestinationImpl ? (DestinationImpl)destination : null;
    }

    public final void setJMSDestinationImpl(DestinationImpl destinationImpl) {
        this.destination = destinationImpl;
    }

    public final int getJMSDeliveryMode() {
        return this.deliveryMode;
    }

    public final void setJMSDeliveryMode(int n) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        if (n != 2 && n != 1) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidDeliveryMode2Loggable((int)n).getMessage());
        }
        this.deliveryMode = n;
        this.adjustedDeliveryMode = this.deliveryMode;
    }

    public final int getAdjustedDeliveryMode() {
        return this.adjustedDeliveryMode;
    }

    public final void setAdjustedDeliveryMode(int n) {
        this.adjustedDeliveryMode = n;
    }

    public final boolean getJMSRedelivered() {
        return this.deliveryCount > 1;
    }

    public void setDeliveryCount(int n) {
        this.deliveryCount = n;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    public final void setJMSRedelivered(boolean bl) throws javax.jms.JMSException {
        if (bl == this.getJMSRedelivered()) {
            return;
        }
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        if (bl) {
            this.setDeliveryCount(2);
        } else {
            this.setDeliveryCount(0);
        }
        assert (bl == this.getJMSRedelivered());
    }

    public final void incrementDeliveryCount() {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.setDeliveryCount(++this.deliveryCount);
    }

    public final void setClientResponsibleForAcknowledge(boolean bl) {
        this.clientResponsibleForAcknowledge = bl;
    }

    public final boolean getClientResponsibleForAcknowledge() {
        return this.clientResponsibleForAcknowledge;
    }

    public final String getJMSType() {
        return this.type;
    }

    public final void setJMSType(String string) throws javax.jms.JMSException {
        this.jmsClientForward = false;
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.type = string;
    }

    public final long getJMSExpiration() {
        return this.expiration;
    }

    public final void setJMSExpiration(long l) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.expiration = l;
    }

    public final void _setJMSExpiration(long l) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.expiration = l;
    }

    public final void setJMSDeliveryTime(long l) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.deliveryTime = l;
    }

    public final void setDeliveryTime(long l) {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.deliveryTime = l;
    }

    public final long getJMSDeliveryTime() throws javax.jms.JMSException {
        return this.deliveryTime;
    }

    public final long getDeliveryTime() {
        return this.deliveryTime;
    }

    public final void setJMSRedeliveryLimit(int n) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        if (n < -1) {
            throw new JMSException(JMSClientExceptionLogger.logInvalidRedeliveryLimit2Loggable().getMessage());
        }
        this.redeliveryLimit = n;
    }

    public final void _setJMSRedeliveryLimit(int n) {
        this.redeliveryLimit = n;
    }

    public final int getJMSRedeliveryLimit() throws javax.jms.JMSException {
        return this.redeliveryLimit;
    }

    public final int _getJMSRedeliveryLimit() {
        return this.redeliveryLimit;
    }

    public final int getJMSPriority() {
        return this.priority;
    }

    public final void setJMSPriority(int n) throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        if (n >= 0 && n <= 9) {
            this.priority = (byte)n;
        } else if (n == -1) {
            this.priority = (byte)4;
        } else {
            throw new JMSException(JMSClientExceptionLogger.logInvalidPriority2Loggable((int)n).getMessage());
        }
    }

    public final void setMessageReference(MessageReference messageReference) {
        this.mRef = messageReference;
    }

    public final void clearProperties() {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.jmsClientForward = false;
        this.propertiesWritable = true;
        this.deliveryCountIncluded = false;
        this.properties = null;
    }

    private boolean isUnitOfOrderSet() {
        return this.unitOfOrderName != null;
    }

    private boolean isUserIDSet() {
        return this.userId != null;
    }

    private boolean isSAFSequenceNameSet() {
        return this.safSequenceName != null;
    }

    private boolean isSAFSequenceNumberSet() {
        return this.safSequenceNumber != 0L;
    }

    private boolean isDeliveryTimeSet() {
        return this.deliveryTime != 0L;
    }

    private boolean isRedeliveryLimitSet() {
        return this.redeliveryLimit != -1;
    }

    boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public final boolean propertyExists(String string) throws javax.jms.JMSException {
        if (string.equals(UNIT_OF_ORDER_PROPERTY_NAME)) {
            return this.isUnitOfOrderSet();
        }
        if (string.equals(USER_ID_PROPERTY_NAME)) {
            return this.isUserIDSet();
        }
        if (string.equals(SAF_SEQUENCE_NAME)) {
            return this.isSAFSequenceNameSet();
        }
        if (string.equals(SAF_SEQUENCE_NUMBER)) {
            return this.isSAFSequenceNumberSet();
        }
        if (string.equals(DELIVERY_TIME_PROPERTY_NAME)) {
            return this.isDeliveryTimeSet();
        }
        if (string.equals(REDELIVERY_LIMIT_PROPERTY_NAME)) {
            return this.isRedeliveryLimitSet();
        }
        if (string.equals(DELIVERY_COUNT_PROPERTY_NAME)) {
            return true;
        }
        return this.properties != null && this.properties.containsKey(string);
    }

    public final boolean getBooleanProperty(String string) throws javax.jms.JMSException {
        return TypeConverter.toBoolean(this.getObjectProperty(string));
    }

    public final byte getByteProperty(String string) throws javax.jms.JMSException {
        return TypeConverter.toByte(this.getObjectProperty(string));
    }

    public final short getShortProperty(String string) throws javax.jms.JMSException {
        return TypeConverter.toShort(this.getObjectProperty(string));
    }

    public final int getIntProperty(String string) throws javax.jms.JMSException {
        return TypeConverter.toInt(this.getObjectProperty(string));
    }

    public final long getLongProperty(String string) throws javax.jms.JMSException {
        return TypeConverter.toLong(this.getObjectProperty(string));
    }

    public final float getFloatProperty(String string) throws javax.jms.JMSException {
        return TypeConverter.toFloat(this.getObjectProperty(string));
    }

    public final double getDoubleProperty(String string) throws javax.jms.JMSException {
        return TypeConverter.toDouble(this.getObjectProperty(string));
    }

    public final String getStringProperty(String string) throws javax.jms.JMSException {
        Object object = this.getObjectProperty(string);
        if (object != null && object instanceof byte[]) {
            try {
                byte[] byArray = (byte[])object;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                return (String)objectInputStream.readObject();
            }
            catch (Exception exception) {
                throw new JMSException(JMSClientExceptionLogger.logInvalidStringPropertyLoggable());
            }
        }
        return TypeConverter.toString(this.getObjectProperty(string));
    }

    public final Object getObjectProperty(String string) throws javax.jms.JMSException {
        if (string.equals(UNIT_OF_ORDER_PROPERTY_NAME)) {
            return this.unitOfOrderName;
        }
        if (string.equals(SAF_SEQUENCE_NAME)) {
            return this.safSequenceName;
        }
        if (string.equals(SAF_SEQUENCE_NUMBER)) {
            return new Long(this.safSequenceNumber);
        }
        if (string.equals(DELIVERY_TIME_PROPERTY_NAME)) {
            return new Long(this.deliveryTime);
        }
        if (string.equals(REDELIVERY_LIMIT_PROPERTY_NAME)) {
            return new Integer(this.redeliveryLimit);
        }
        if (string.equals(DELIVERY_COUNT_PROPERTY_NAME)) {
            return new Integer(this.deliveryCount);
        }
        if (string.equals(USER_ID_PROPERTY_NAME)) {
            return this.userId;
        }
        if (this.properties != null) {
            return this.properties.get(string);
        }
        return null;
    }

    public final Collection getPropertyNameCollection() throws javax.jms.JMSException {
        ArrayList<String> arrayList = this.properties == null ? new ArrayList<String>() : new ArrayList(this.properties.keySet());
        if (this.isUnitOfOrderSet()) {
            arrayList.add(UNIT_OF_ORDER_PROPERTY_NAME);
        }
        if (this.isSAFSequenceNameSet()) {
            arrayList.add(SAF_SEQUENCE_NAME);
        }
        if (this.isSAFSequenceNumberSet()) {
            arrayList.add(SAF_SEQUENCE_NUMBER);
        }
        if (this.isDeliveryTimeSet()) {
            arrayList.add(DELIVERY_TIME_PROPERTY_NAME);
        }
        if (this.isRedeliveryLimitSet()) {
            arrayList.add(REDELIVERY_LIMIT_PROPERTY_NAME);
        }
        if (this.isUserIDSet()) {
            arrayList.add(USER_ID_PROPERTY_NAME);
        }
        if (this.deliveryCount > 0 && !this.propertiesWritable || this.deliveryCountIncluded) {
            arrayList.add(DELIVERY_COUNT_PROPERTY_NAME);
        }
        return arrayList;
    }

    private PrimitiveObjectMap getInteropProperties() throws IOException {
        PrimitiveObjectMap primitiveObjectMap = new PrimitiveObjectMap();
        try {
            for (String string : this.getPropertyNameCollection()) {
                primitiveObjectMap.put(string, this.getObjectProperty(string));
            }
        }
        catch (javax.jms.JMSException jMSException) {
            IOException iOException = new IOException(jMSException.toString());
            iOException.initCause(jMSException);
            throw iOException;
        }
        return primitiveObjectMap;
    }

    public void removeProperty(String string) {
        try {
            this.properties.remove(string);
        }
        catch (javax.jms.JMSException jMSException) {
            // empty catch block
        }
    }

    private void readInteropProperties(ObjectInput objectInput, int n) throws IOException {
        this.properties = new PrimitiveObjectMap(objectInput, n);
        try {
            this.properties.remove(DELIVERY_COUNT_PROPERTY_NAME);
            this.properties.remove(DELIVERY_TIME_PROPERTY_NAME);
            this.properties.remove(REDELIVERY_LIMIT_PROPERTY_NAME);
            this.properties.remove(SAF_SEQUENCE_NAME);
            this.properties.remove(SAF_SEQUENCE_NUMBER);
            this.properties.remove(UNIT_OF_ORDER_PROPERTY_NAME);
            this.properties.remove(USER_ID_PROPERTY_NAME);
            if (this.properties.isEmpty()) {
                this.properties = null;
            }
        }
        catch (javax.jms.JMSException jMSException) {
            IOException iOException = new IOException(jMSException.toString());
            iOException.initCause(jMSException);
            throw iOException;
        }
    }

    public final Enumeration getPropertyNames() throws javax.jms.JMSException {
        return Collections.enumeration(this.getPropertyNameCollection());
    }

    public final void setBooleanProperty(String string, boolean bl) throws javax.jms.JMSException {
        this.setObjectProperty(string, bl);
    }

    public final void setByteProperty(String string, byte by) throws javax.jms.JMSException {
        this.setObjectProperty(string, new Byte(by));
    }

    public final void setShortProperty(String string, short s) throws javax.jms.JMSException {
        this.setObjectProperty(string, new Short(s));
    }

    public final void setIntProperty(String string, int n) throws javax.jms.JMSException {
        this.setObjectProperty(string, new Integer(n));
    }

    public final void setLongProperty(String string, long l) throws javax.jms.JMSException {
        this.setObjectProperty(string, new Long(l));
    }

    public final void setFloatProperty(String string, float f) throws javax.jms.JMSException {
        this.setObjectProperty(string, new Float(f));
    }

    public final void setDoubleProperty(String string, double d) throws javax.jms.JMSException {
        this.setObjectProperty(string, new Double(d));
    }

    public final void setStringProperty(String string, String string2) throws javax.jms.JMSException {
        this.setObjectProperty(string, string2);
    }

    private String illegalPropertyName(String string) {
        return JMSClientExceptionLogger.logInvalidPropertyName2Loggable((String)string).getMessage();
    }

    public final void setObjectProperty(String string, Object object) throws javax.jms.JMSException {
        int n;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(this.illegalPropertyName(string));
        }
        if (MessageImpl.isHeaderField(string)) {
            throw new MessageFormatException(this.illegalPropertyName(string));
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            throw new MessageFormatException(this.illegalPropertyName(string));
        }
        for (n = 1; n < string.length(); ++n) {
            if (Character.isJavaIdentifierPart(string.charAt(n))) continue;
            throw new MessageFormatException(this.illegalPropertyName(string));
        }
        if (!this.propertiesWritable) {
            throw new MessageNotWriteableException(JMSClientExceptionLogger.logWriteInReadModeLoggable().getMessage());
        }
        if (object instanceof Number || object instanceof String || object instanceof Boolean || object == null) {
            if (string.equals(UNIT_OF_ORDER_PROPERTY_NAME)) {
                this.unitOfOrderName = TypeConverter.toString(object);
                return;
            }
            if (string.equals(SAF_SEQUENCE_NAME)) {
                this.safSequenceName = TypeConverter.toString(object);
                this.keepSAFSequenceNameAndNumber = true;
                return;
            }
            if (string.equals(SAF_SEQUENCE_NUMBER)) {
                this.safSequenceNumber = TypeConverter.toLong(object);
                this.keepSAFSequenceNameAndNumber = true;
                return;
            }
            if (string.equals(DELIVERY_TIME_PROPERTY_NAME)) {
                this.deliveryTime = TypeConverter.toLong(object);
                return;
            }
            if (string.equals(REDELIVERY_LIMIT_PROPERTY_NAME)) {
                n = TypeConverter.toInt(object);
                if (n < -1) {
                    throw new JMSException(JMSClientExceptionLogger.logInvalidRedeliveryLimit2Loggable());
                }
                this.redeliveryLimit = n;
                return;
            }
            if (string.equals(DELIVERY_COUNT_PROPERTY_NAME)) {
                this.deliveryCount = TypeConverter.toInt(object);
                return;
            }
            if (string.equals(USER_ID_PROPERTY_NAME)) {
                this.userId = TypeConverter.toString(object);
                return;
            }
            if (this.properties == null) {
                this.properties = new PrimitiveObjectMap();
            }
        } else {
            throw new MessageFormatException(JMSClientExceptionLogger.logInvalidPropertyValueLoggable((String)object.toString()).getMessage());
        }
        this.properties.put(string, object);
    }

    public final void acknowledge() throws javax.jms.JMSException {
        if (this.session != null) {
            this.session.acknowledge(this);
            this.session = null;
        }
    }

    public final void clearBody() throws javax.jms.JMSException {
        if (this.mRef != null) {
            this.copyToMessageReference();
        }
        this.jmsClientForward = false;
        this.bodyWritable = true;
        this.bodySize = -1L;
        this.nullBody();
        this.cleanupCompressedMessageBody();
    }

    public abstract void nullBody();

    public final void setId(JMSMessageId jMSMessageId) {
        this.messageId = jMSMessageId;
        this.messageIdString = null;
    }

    public final JMSMessageId getId() {
        return this.messageId;
    }

    public final JMSMessageId getMessageId() {
        return this.getId();
    }

    public final void setSession(JMSSession jMSSession) {
        this.session = jMSSession;
    }

    public final void setConnectionId(JMSID jMSID) {
        this.connectionId = jMSID;
    }

    public final JMSID getConnectionId() {
        return this.connectionId;
    }

    public final void setClientId(String string) {
        this.clientId = string;
    }

    public final String getClientId() {
        return this.clientId;
    }

    public final long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public final void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public final Object get(String string) {
        try {
            if (string.startsWith("JMS")) {
                if (string.equals("JMSCorrelationID")) {
                    return this.getJMSCorrelationID();
                }
                if (string.equals("JMSDeliveryMode")) {
                    if (this.getJMSDeliveryMode() == 2) {
                        return "PERSISTENT";
                    }
                    return "NON_PERSISTENT";
                }
                if (string.equals("JMSDeliveryTime")) {
                    return new Long(this.getDeliveryTime());
                }
                if (string.equals("JMSExpiration")) {
                    return new Long(this.getJMSExpiration());
                }
                if (string.equals("JMSMessageID")) {
                    return this.getJMSMessageID();
                }
                if (string.equals("JMSPriority")) {
                    return new Integer(this.getJMSPriority());
                }
                if (string.equals("JMSRedelivered")) {
                    return this.getJMSRedelivered();
                }
                if (string.equals("JMSRedeliveryLimit")) {
                    return new Integer(this.getJMSRedeliveryLimit());
                }
                if (string.equals("JMSTimestamp")) {
                    return new Long(this.getJMSTimestamp());
                }
                if (string.equals("JMSType")) {
                    return this.getJMSType();
                }
                if (string.equals(SIZE_PROPERTY_NAME)) {
                    return new Long(this.size());
                }
            }
            return this.getObjectProperty(string);
        }
        catch (javax.jms.JMSException jMSException) {
            return null;
        }
    }

    public Object parse() throws Exception {
        return null;
    }

    public final synchronized MessageImpl cloneit() {
        try {
            return (MessageImpl)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract MessageImpl copy() throws javax.jms.JMSException;

    final void copy(MessageImpl messageImpl) throws javax.jms.JMSException {
        boolean bl = false;
        messageImpl.destination = this.destination;
        messageImpl.replyTo = this.replyTo;
        messageImpl.deliveryMode = this.deliveryMode;
        messageImpl.correlationId = this.correlationId;
        messageImpl.deliveryCount = this.deliveryCount;
        messageImpl.type = this.type;
        messageImpl.deliveryTime = this.deliveryTime;
        messageImpl.redeliveryLimit = this.redeliveryLimit;
        messageImpl.expiration = this.expiration;
        messageImpl.priority = this.priority;
        messageImpl.jmsClientForward = this.jmsClientForward;
        messageImpl.totalForwardsCount = this.totalForwardsCount;
        messageImpl.safNeedReorder = this.safNeedReorder;
        messageImpl.compressed = this.compressed;
        if (messageImpl.compressed) {
            messageImpl.originalLength = this.originalLength;
            messageImpl.payloadCompressed = this.payloadCompressed.copyPayloadWithoutSharedStream();
        }
        messageImpl.clientResponsibleForAcknowledge = this.clientResponsibleForAcknowledge;
        if (this.userdatalen == -1) {
            bl = true;
            messageImpl.userdatalen = 0;
            if (messageImpl.correlationId != null) {
                messageImpl.userdatalen = messageImpl.correlationId.length();
            }
            if (messageImpl.type != null) {
                messageImpl.userdatalen += messageImpl.type.length();
            }
        } else {
            messageImpl.userdatalen = this.userdatalen;
        }
        messageImpl.connectionId = this.connectionId;
        messageImpl.clientId = this.clientId;
        messageImpl.messageId = this.messageId;
        if (this.properties != null) {
            messageImpl.properties = new PrimitiveObjectMap(this.properties);
            if (bl) {
                messageImpl.userdatalen += messageImpl.properties.getSizeInBytes();
            }
        }
        messageImpl.bodyWritable = this.bodyWritable;
        messageImpl.propertiesWritable = this.propertiesWritable;
        messageImpl.serializeDestination = this.serializeDestination;
        messageImpl.ddforwarded = this.ddforwarded;
        messageImpl.unitOfOrderName = this.unitOfOrderName;
        messageImpl.safSequenceName = this.safSequenceName;
        messageImpl.safSequenceNumber = this.safSequenceNumber;
        messageImpl.userId = this.userId;
        messageImpl.workContext = this.workContext;
        messageImpl.setOldMessage(this.isOldMessage());
    }

    protected int getVersion(Object object) throws IOException {
        if (object instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)object).getPeerInfo();
            int n = peerInfo.getMajor();
            if (debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSDebug.JMSDispatcher.debug("MessageImpl PeerInfo " + peerInfo);
            }
            if (n < 6) {
                throw new IOException(JMSClientExceptionLogger.logIncompatibleVersion9Loggable((byte)1, (byte)10, (byte)20, (byte)30, (String)peerInfo.toString()).getMessage());
            }
            switch (n) {
                case 7: 
                case 8: {
                    return 20;
                }
                case 6: {
                    return 10;
                }
            }
            if (peerInfo.getMajor() == 9 || peerInfo.getMajor() > 9 && peerInfo.compareTo((Object)PeerInfo.VERSION_1033) < 0) {
                return 30;
            }
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_1033) >= 0) {
                return 40;
            }
        }
        if (debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("MessageImpl write NOT! PeerInfoable");
        }
        return 40;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        boolean bl;
        DestinationImpl destinationImpl;
        int n2;
        DestinationImpl destinationImpl2;
        String string;
        ObjectOutput objectOutput2 = objectOutput instanceof JMSObjectOutputWrapper ? ((JMSObjectOutputWrapper)objectOutput).getInnerObjectOutput() : objectOutput;
        int n3 = 0;
        int n4 = this.getVersion(objectOutput2);
        n3 |= n4 << 24;
        if (this.deliveryMode == 2) {
            n3 |= 0x200;
        }
        if ((string = this.correlationId) != null) {
            n3 |= 0x400;
        }
        if (this.serializeDestination) {
            n3 |= 0x200000;
        }
        if (this.ddforwarded) {
            n3 |= 0x80;
        }
        if ((destinationImpl2 = this.destination) != null) {
            if (this.serializeDestination) {
                n3 |= 0x800;
            } else if (!(objectOutput2 instanceof WLObjectOutput || objectOutput2 instanceof JMSOutputStream && (((JMSOutputStream)((Object)objectOutput2)).isJMSMulticastOutputStream() || ((JMSOutputStream)((Object)objectOutput2)).isBypassOutputStream()))) {
                n3 |= 0x800;
            }
        }
        int n5 = 0;
        if (n4 >= 20 && (n3 & 0x800) != 0 && (n5 |= Destination.getDestinationType(destinationImpl2, 0)) != 0) {
            n3 |= 0x800000;
        }
        if (n4 >= 30) {
            n2 = this.getControlOpcode();
            if (this.jmsClientForward) {
                n2 |= 1;
            }
            if (this.workContext != null) {
                n2 |= 2;
            }
            if (this.userIDRequested) {
                n2 |= 0x10;
            }
            if (this.isUnitOfOrderSet()) {
                n2 |= 0x20;
            }
            if (this.isSAFSequenceNameSet()) {
                n2 |= 0x40;
            }
            if (this.isSAFSequenceNumberSet()) {
                n2 |= 0x80;
            }
            if (this.isUserIDSet()) {
                n2 |= 0x100;
            }
            if (this.safNeedReorder) {
                n2 |= 0x200;
            }
            if (this.pre90Message) {
                n2 |= 4;
            }
            if (n4 >= 40 && this.clientId != null) {
                n2 |= 0x400;
            }
            if (n2 != 0) {
                n3 |= 0x10;
            }
        } else {
            n2 = 0;
        }
        if ((destinationImpl = this.replyTo) != null) {
            n3 |= 0x1000;
        }
        if (n4 >= 20 && destinationImpl != null && ((n5 |= Destination.getDestinationType(destinationImpl, 3)) & 0x38) != 0) {
            n3 |= 0x800000;
        }
        if (this.getJMSRedelivered()) {
            n3 |= 0x2000;
        }
        if (this.type != null) {
            n3 |= 0x4000;
        }
        if (this.deliveryTime != 0L) {
            n3 |= 0x100000;
        }
        if (n4 >= 20 && this.redeliveryLimit != -1) {
            n3 |= 0x100;
        }
        if (this.expiration != 0L) {
            n3 |= 0x8000;
        }
        n3 |= this.priority << 0;
        boolean bl2 = bl = n4 < 30 || this.hasProperties();
        if (bl) {
            n3 |= 0x10000;
        }
        if (this.messageId != null) {
            n3 |= 0x40000;
        }
        if (this.bexaXid != null) {
            n3 |= 0x20000;
        }
        if ((n3 & 0x14400) != 0 || (n2 & 0x20) != 0) {
            n3 |= 0x80000;
        }
        if (this.clientResponsibleForAcknowledge) {
            n3 |= 0x400000;
        }
        this.writeFlags(n3, objectOutput2);
        if (string != null) {
            objectOutput2.writeUTF(string);
            n = string.length();
        } else {
            n = 0;
        }
        if (n4 >= 20 && (n3 & 0x800000) != 0) {
            objectOutput2.writeByte(n5);
        }
        if ((n3 & 0x800) != 0) {
            destinationImpl2.writeExternal(objectOutput2);
        }
        if (destinationImpl != null) {
            destinationImpl.writeExternal(objectOutput2);
        }
        if (n4 >= 30 && n2 != 0) {
            objectOutput2.writeInt(n2);
            if (this.jmsClientForward) {
                objectOutput2.writeInt(this.totalForwardsCount);
            }
        }
        if (this.type != null) {
            objectOutput2.writeUTF(this.type);
            n += this.type.length();
        }
        if (this.isDeliveryTimeSet()) {
            objectOutput2.writeLong(this.deliveryTime);
        }
        if (n4 >= 20 && this.isRedeliveryLimitSet()) {
            objectOutput2.writeInt(this.redeliveryLimit);
        }
        if (this.expiration != 0L) {
            objectOutput2.writeLong(this.expiration);
        }
        if (n4 >= 30) {
            objectOutput2.writeInt(this.deliveryCount);
        }
        if (bl) {
            if (n4 >= 30) {
                this.properties.writeToStream((DataOutput)objectOutput2, n4);
            } else {
                PeerInfo peerInfo = objectOutput2 instanceof PeerInfoable ? ((PeerInfoable)objectOutput2).getPeerInfo() : PeerInfo.getPeerInfo();
                this.getInteropProperties().writeToStream((DataOutput)objectOutput2, peerInfo);
            }
        }
        if (this.messageId != null) {
            this.messageId.writeExternal(objectOutput2);
        }
        if (n4 >= 30) {
            if (this.isUnitOfOrderSet()) {
                objectOutput2.writeUTF(this.unitOfOrderName);
            }
            if (this.isUserIDSet()) {
                objectOutput2.writeUTF(this.userId);
                n += this.userId.length();
            }
            if (this.isSAFSequenceNameSet()) {
                objectOutput2.writeUTF(this.safSequenceName);
            }
            if (this.isSAFSequenceNumberSet()) {
                objectOutput2.writeLong(this.safSequenceNumber);
            }
            if (this.workContext != null) {
                JMSWorkContextHelper.writeWorkContext(this.workContext, objectOutput2);
            }
        }
        if (this.bexaXid != null) {
            objectOutput2.writeObject(this.bexaXid);
        }
        if ((n3 & 0x80000) != 0) {
            objectOutput2.writeInt(n);
        }
        this.userdatalen = n;
        if ((n2 & 0x400) != 0) {
            objectOutput2.writeUTF(this.clientId);
        }
    }

    private void writeFlags(int n, ObjectOutput objectOutput) throws IOException {
        if (debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("MessageImpl.write versionInt 0x" + Integer.toHexString(n).toUpperCase());
        }
        objectOutput.writeInt(n);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        int n2;
        int n3 = objectInput.readInt();
        byte by = (byte)((n3 & 0xFF000000) >>> 24 & 0xFF);
        if (debugWire && JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("MessageImpl.read  versionInt 0x" + Integer.toHexString(n3).toUpperCase());
        }
        if (by < 30) {
            this.pre90Message = true;
            if (by == 1) {
                if (!(objectInput instanceof PutBackable)) {
                    throw new IOException(JMSClientExceptionLogger.logUnknownStreamTypeLoggable().getMessage());
                }
                ((PutBackable)((Object)objectInput)).unput();
                ((PutBackable)((Object)objectInput)).unput();
                ((PutBackable)((Object)objectInput)).unput();
                this.readExternalVersion1(objectInput);
                return;
            }
            if (by == 10) {
                this.readExternalVersion2(objectInput, n3);
                return;
            }
        }
        if (by > 40) {
            throw JMSUtilities.versionIOException(by, 1, 40);
        }
        this.deliveryMode = (n3 & 0x200) != 0 ? 2 : 1;
        this.adjustedDeliveryMode = this.deliveryMode;
        if ((n3 & 0x400) != 0) {
            this.correlationId = objectInput.readUTF();
        }
        if ((n3 & 0x800000) != 0) {
            n2 = objectInput.readByte();
            if ((n3 & 0x800) != 0) {
                n = n2 & 7;
                this.destination = Destination.createDestination((byte)n, objectInput);
            }
            if ((n3 & 0x1000) != 0) {
                n = (byte)((n2 & 0x38) >>> 3);
                this.replyTo = Destination.createDestination((byte)n, objectInput);
            }
        }
        n2 = 0;
        if ((n3 & 0x10) != 0) {
            n2 = objectInput.readInt();
            this.pre90Message = (n2 & 4) != 0;
            this.userIDRequested = (n2 & 0x10) != 0;
            this.jmsClientForward = (n2 & 1) != 0;
            this.safNeedReorder = (n2 & 0x200) != 0;
            n = 0xFF0000 & n2;
            if (n != 0) {
                this.setControlOpcode(n);
            }
            if ((n2 & 1) != 0) {
                this.totalForwardsCount = objectInput.readInt();
            }
        }
        if ((n3 & 0x4000) != 0) {
            this.type = objectInput.readUTF();
        }
        if ((n3 & 0x100000) != 0) {
            this.deliveryTime = objectInput.readLong();
        }
        if ((n3 & 0x100) != 0) {
            this.redeliveryLimit = objectInput.readInt();
        }
        if ((n3 & 0x8000) != 0) {
            this.expiration = objectInput.readLong();
        }
        if (by >= 30) {
            this.deliveryCount = objectInput.readInt();
        }
        this.priority = (byte)((n3 & 0xF) >>> 0 & 0xFF);
        if ((n3 & 0x10000) != 0) {
            if (by >= 30) {
                this.properties = new PrimitiveObjectMap(objectInput, by);
            } else {
                this.readInteropProperties(objectInput, by);
            }
        }
        if ((n3 & 0x40000) != 0) {
            this.messageId = new JMSMessageId();
            this.messageId.readExternal(objectInput);
        }
        if ((n2 & 0x20) != 0) {
            this.unitOfOrderName = objectInput.readUTF().intern();
        }
        if ((n2 & 0x100) != 0) {
            this.userId = objectInput.readUTF().intern();
        }
        if ((n2 & 0x40) != 0) {
            this.safSequenceName = objectInput.readUTF().intern();
        }
        if ((n2 & 0x80) != 0) {
            this.safSequenceNumber = objectInput.readLong();
        }
        if ((n2 & 2) != 0) {
            this.workContext = JMSWorkContextHelper.readWorkContext(objectInput);
        }
        if ((n3 & 0x20000) != 0) {
            this.bexaXid = (Externalizable)objectInput.readObject();
        }
        this.userdatalen = (n3 & 0x80000) != 0 ? objectInput.readInt() : 0;
        this.clientResponsibleForAcknowledge = (n3 & 0x400000) != 0;
        this.bodyWritable = false;
        this.propertiesWritable = false;
        this.serializeDestination = (n3 & 0x200000) != 0;
        boolean bl = this.ddforwarded = (n3 & 0x80) != 0;
        if ((n2 & 0x400) != 0) {
            this.clientId = objectInput.readUTF();
        }
    }

    private void readExternalVersion2(ObjectInput objectInput, int n) throws IOException, ClassNotFoundException {
        boolean bl;
        this.deliveryMode = (n & 0x200) != 0 ? 2 : 1;
        this.adjustedDeliveryMode = this.deliveryMode;
        if ((n & 0x400) != 0) {
            this.correlationId = objectInput.readUTF();
        }
        if ((n & 0x800) != 0) {
            this.destination = new DestinationImpl();
            this.destination.readExternal(objectInput);
        }
        if ((n & 0x1000) != 0) {
            this.replyTo = new DestinationImpl();
            this.replyTo.readExternal(objectInput);
        }
        boolean bl2 = bl = (n & 0x2000) != 0;
        if (bl) {
            this.setDeliveryCount(2);
        } else {
            this.setDeliveryCount(1);
        }
        if ((n & 0x4000) != 0) {
            this.type = objectInput.readUTF();
        }
        if ((n & 0x100000) != 0) {
            this.deliveryTime = objectInput.readLong();
        }
        if ((n & 0x8000) != 0) {
            this.expiration = objectInput.readLong();
        }
        this.priority = (byte)((n & 0xF) >>> 0 & 0xFF);
        if ((n & 0x10000) != 0) {
            this.readInteropProperties(objectInput, 10);
        }
        if ((n & 0x40000) != 0) {
            this.messageId = new JMSMessageId();
            this.messageId.readExternal(objectInput);
        }
        if ((n & 0x20000) != 0) {
            this.bexaXid = (Externalizable)objectInput.readObject();
        }
        this.userdatalen = (n & 0x80000) != 0 ? objectInput.readInt() : 0;
        this.bodyWritable = false;
        this.propertiesWritable = false;
        this.serializeDestination = (n & 0x200000) != 0;
    }

    private void readExternalVersion1(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        boolean bl;
        this.adjustedDeliveryMode = this.deliveryMode = (int)objectInput.readByte();
        if (this.deliveryMode != 2) {
            throw new IOException(JMSClientExceptionLogger.logCorruptedStreamLoggable().getMessage());
        }
        this.correlationId = objectInput.readBoolean() ? objectInput.readUTF() : null;
        objectInput.readLong();
        if (objectInput.readBoolean()) {
            this.destination = new DestinationImpl();
            this.destination.readExternal(objectInput);
        }
        if (objectInput.readBoolean()) {
            this.replyTo = new DestinationImpl();
            this.replyTo.readExternal(objectInput);
        }
        if (bl = objectInput.readBoolean()) {
            this.setDeliveryCount(2);
        } else {
            this.setDeliveryCount(1);
        }
        this.type = objectInput.readBoolean() ? objectInput.readUTF() : null;
        this.expiration = objectInput.readLong();
        this.priority = objectInput.readByte();
        if (objectInput.readBoolean()) {
            this.readInteropProperties(objectInput, 1);
        }
        if (objectInput.readBoolean()) {
            this.messageId = new JMSMessageId();
            this.messageId.readExternal(objectInput);
        }
        if (this.messageId == null && this.expiration != 0L) {
            throw new IOException(JMSClientExceptionLogger.logVersionErrorLoggable().getMessage());
        }
        if (objectInput.readBoolean()) {
            this.bexaXid = (Externalizable)objectInput.readObject();
        }
        this.userdatalen = objectInput.readInt();
        this.connectionId = new JMSID();
        this.clientResponsibleForAcknowledge = false;
        this.connectionId.readExternal(objectInput);
        this.bodyWritable = false;
        this.propertiesWritable = false;
    }

    public static boolean isHeaderField(String string) {
        return string.startsWith("JMS") && (string.equals("JMSCorrelationID") || string.equals("JMSDeliveryMode") || string.equals("JMSDestination") || string.equals("JMSExpiration") || string.equals("JMSPriority") || string.equals("JMSRedelivered") || string.equals("JMSReplyTo") || string.equals("JMSTimestamp") || string.equals("JMSType"));
    }

    public void reset() throws javax.jms.JMSException {
    }

    public final void setBodyWritable() {
        this.setBodyWritable(true);
        this.jmsClientForward = false;
    }

    public final void setBodyWritable(boolean bl) {
        this.bodyWritable = bl;
    }

    public final void setPropertiesWritable(boolean bl) {
        this.propertiesWritable = bl;
    }

    final void readMode() throws javax.jms.JMSException {
        if (this.bodyWritable) {
            throw new MessageNotReadableException(JMSClientExceptionLogger.logReadInWriteModeLoggable().getMessage());
        }
    }

    public void setJMSXUserID(String string) {
        this.userId = string;
    }

    public boolean isJMSXUserIDRequested() {
        return this.userIDRequested;
    }

    public void requestJMSXUserID(boolean bl) {
        this.userIDRequested = bl;
    }

    public boolean includeJMSXDeliveryCount(boolean bl) {
        boolean bl2 = this.deliveryCountIncluded;
        this.deliveryCountIncluded = bl;
        return bl2;
    }

    final void writeMode() throws javax.jms.JMSException {
        if (!this.bodyWritable) {
            throw new MessageNotWriteableException(JMSClientExceptionLogger.logWriteInReadMode2Loggable().getMessage());
        }
    }

    public final Externalizable getBEXAXid() {
        return this.bexaXid;
    }

    public final void setBEXAXid(Externalizable externalizable) {
        this.bexaXid = externalizable;
    }

    public abstract long getPayloadSize();

    public final int getUserPropertySize() {
        return this.userdatalen;
    }

    public final void resetUserPropertySize() {
        this.userdatalen = -1;
        this.bodySize = -1;
    }

    public final void setSerializeDestination(boolean bl) {
        this.serializeDestination = bl;
    }

    public final void setDDForwarded(boolean bl) {
        this.ddforwarded = bl;
    }

    public final boolean getDDForwarded() {
        return this.ddforwarded;
    }

    public final void setUnitOfOrderName(String string) {
        this.unitOfOrderName = string;
    }

    public final String getUnitOfOrder() {
        return this.unitOfOrderName;
    }

    public final boolean getKeepSAFSequenceNameAndNumber() {
        return this.keepSAFSequenceNameAndNumber;
    }

    public final void setSAFSequenceName(String string) {
        this.safSequenceName = string;
        this.keepSAFSequenceNameAndNumber = true;
    }

    public final String getSAFSequenceName() {
        return this.safSequenceName;
    }

    public void setSAFSeqNumber(long l) {
        this.safSequenceNumber = l;
        this.keepSAFSequenceNameAndNumber = true;
    }

    public long getSAFSeqNumber() {
        return this.safSequenceNumber;
    }

    public final String getGroup() {
        return this.unitOfOrderName;
    }

    public final void setWorkContext(Object object) {
        this.workContext = object;
    }

    public final Object getWorkContext() {
        return this.workContext;
    }

    public MessageID getMessageID() {
        return this.messageId;
    }

    public long getExpirationTime() {
        return this.getJMSExpiration();
    }

    public int getRedeliveryLimit() {
        return this._getJMSRedeliveryLimit();
    }

    public long size() {
        return this.getPayloadSize() + (long)this.getUserPropertySize();
    }

    public weblogic.messaging.Message duplicate() {
        return this.cloneit();
    }

    public Document getJMSMessageDocument() throws javax.jms.JMSException {
        try {
            Class<?> clazz = Class.forName("weblogic.jms.common.XMLHelper");
            Method method = clazz.getMethod("getDocument", WLMessage.class);
            return (Document)method.invoke(null, this);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof javax.jms.JMSException) {
                throw (javax.jms.JMSException)throwable;
            }
            throw new AssertionError((Object)throwable);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public final boolean isCompressed() {
        return this.compressed;
    }

    protected final boolean shouldCompress(ObjectOutput objectOutput, int n) throws IOException {
        if (this.compressed) {
            return true;
        }
        if (this.getVersion(objectOutput) < 30) {
            return false;
        }
        long l = this.getPayloadSize();
        return l > (long)n;
    }

    protected void cleanupCompressedMessageBody() {
        if (this.clean) {
            return;
        }
        this.originalLength = 0;
        this.payloadCompressed = null;
        this.compressed = false;
        this.clean = true;
    }

    protected void readExternalCompressedMessageBody(ObjectInput objectInput) throws IOException {
        byte by = objectInput.readByte();
        if (by != 0) {
            throw new IOException(JMSClientExceptionLogger.logErrorCompressionTagLoggable((int)by).getMessage());
        }
        this.compressed = true;
        this.originalLength = objectInput.readInt();
        this.payloadCompressed = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)objectInput));
    }

    public int getCompressedMessageBodySize() {
        return this.payloadCompressed.getLength();
    }

    public int getOriginalMessageBodySize() {
        return this.originalLength;
    }

    protected void flushCompressedMessageBody(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(0);
        objectOutput.writeInt(this.originalLength);
        this.payloadCompressed.writeLengthAndData(objectOutput);
    }

    public abstract void decompressMessageBody() throws javax.jms.JMSException;

    protected Payload decompress() throws IOException {
        this.hasBeenCompressed = true;
        GZIPInputStream gZIPInputStream = new GZIPInputStream((InputStream)this.payloadCompressed.getInputStream(), this.payloadCompressed.getLength());
        return PayloadFactoryImpl.copyPayloadFromStream(gZIPInputStream, this.originalLength);
    }

    protected final void writeExternalCompressPayload(ObjectOutput objectOutput, Payload payload) throws IOException {
        BufferOutputStream bufferOutputStream = PayloadFactoryImpl.createOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(bufferOutputStream);
        payload.writeTo(gZIPOutputStream);
        gZIPOutputStream.finish();
        bufferOutputStream.flush();
        objectOutput.writeByte(0);
        objectOutput.writeInt(payload.getLength());
        bufferOutputStream.writeLengthAndData(objectOutput);
    }

    public static final JMSObjectOutputWrapper createJMSObjectOutputWrapper(ObjectOutput objectOutput, int n, boolean bl) {
        assert (objectOutput instanceof PeerInfoable);
        return new JMSObjectOutputWrapper(objectOutput, n, bl);
    }

    public static int getPosition(ObjectOutput objectOutput) {
        try {
            Class<?> clazz = Class.forName("weblogic.protocol.AsyncOutgoingMessage");
            Method method = clazz.getMethod("getLength", new Class[0]);
            return (Integer)method.invoke((Object)objectOutput, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return -1;
    }

    public static final class JMSObjectOutputWrapper
    implements ObjectOutput,
    PeerInfoable {
        private final ObjectOutput out;
        private int compressionThreshold = Integer.MAX_VALUE;
        private boolean readStringAsObject = false;

        private JMSObjectOutputWrapper(ObjectOutput objectOutput, int n, boolean bl) {
            this.out = objectOutput;
            this.compressionThreshold = n;
            this.readStringAsObject = bl;
        }

        private JMSObjectOutputWrapper(ObjectOutput objectOutput, int n) {
            this.out = objectOutput;
            this.compressionThreshold = n;
        }

        public PeerInfo getPeerInfo() {
            return ((PeerInfoable)this.out).getPeerInfo();
        }

        final ObjectOutput getInnerObjectOutput() {
            return this.out;
        }

        final boolean getReadStringAsObject() {
            return this.readStringAsObject;
        }

        final int getCompressionThreshold() {
            return this.compressionThreshold;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void writeObject(Object object) throws IOException {
        }

        public void writeDouble(double d) throws IOException {
        }

        public void writeFloat(float f) throws IOException {
        }

        public void writeByte(int n) throws IOException {
        }

        public void writeChar(int n) throws IOException {
        }

        public void writeInt(int n) throws IOException {
        }

        public void writeShort(int n) throws IOException {
        }

        public void writeLong(long l) throws IOException {
        }

        public void writeBoolean(boolean bl) throws IOException {
        }

        public void write(int n) throws IOException {
        }

        public void write(byte[] byArray) throws IOException {
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
        }

        public void writeBytes(String string) throws IOException {
        }

        public void writeChars(String string) throws IOException {
        }

        public void writeUTF(String string) throws IOException {
        }
    }
}

