/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.jms.common.JMSDiagnosticImageSource;
import weblogic.jms.common.MessageImpl;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;

public final class MessageStatistics {
    private long messagesPendingCount;
    private long messagesSentCount;
    private long messagesReceivedCount;
    private long bytesPendingCount;
    private long bytesSentCount;
    private long bytesReceivedCount;

    public final synchronized long getMessagesPendingCount() {
        return this.messagesPendingCount;
    }

    public final synchronized long getMessagesReceivedCount() {
        return this.messagesReceivedCount;
    }

    public final synchronized long getMessagesSentCount() {
        return this.messagesSentCount;
    }

    public final synchronized long getBytesPendingCount() {
        return this.bytesPendingCount;
    }

    public final synchronized long getBytesReceivedCount() {
        return this.bytesReceivedCount;
    }

    public final synchronized long getBytesSentCount() {
        return this.bytesSentCount;
    }

    public final synchronized void incrementPendingCount(long l) {
        ++this.messagesPendingCount;
        this.bytesPendingCount += l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementPendingCount(MessageImpl messageImpl) {
        long l = messageImpl.getPayloadSize() + (long)messageImpl.getUserPropertySize();
        MessageStatistics messageStatistics = this;
        synchronized (messageStatistics) {
            ++this.messagesPendingCount;
            this.bytesPendingCount += l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrementPendingCount(long l) {
        MessageStatistics messageStatistics = this;
        synchronized (messageStatistics) {
            --this.messagesPendingCount;
            this.bytesPendingCount -= l;
        }
    }

    public final synchronized void incrementReceivedCount(long l) {
        ++this.messagesReceivedCount;
        this.bytesReceivedCount += l;
    }

    public final synchronized void incrementReceivedCount(MessageImpl messageImpl) {
        ++this.messagesReceivedCount;
        this.bytesReceivedCount += messageImpl.getPayloadSize();
        this.bytesReceivedCount += (long)messageImpl.getUserPropertySize();
    }

    public final synchronized void incrementSentCount(long l) {
        ++this.messagesSentCount;
        this.bytesSentCount += l;
    }

    public final synchronized void incrementSentCount(MessageImpl messageImpl) {
        ++this.messagesSentCount;
        this.bytesSentCount += messageImpl.getPayloadSize();
        this.bytesSentCount += (long)messageImpl.getUserPropertySize();
    }

    public void dump(JMSDiagnosticImageSource jMSDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        jMSDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("Statistics");
        xMLStreamWriter.writeAttribute("messagesPendingCount", String.valueOf(this.messagesPendingCount));
        xMLStreamWriter.writeAttribute("messagesSentCount", String.valueOf(this.messagesSentCount));
        xMLStreamWriter.writeAttribute("messagesReceivedCount", String.valueOf(this.messagesReceivedCount));
        xMLStreamWriter.writeAttribute("bytesPendingCount", String.valueOf(this.bytesPendingCount));
        xMLStreamWriter.writeAttribute("bytesSentCount", String.valueOf(this.bytesSentCount));
        xMLStreamWriter.writeAttribute("bytesReceivedCount", String.valueOf(this.bytesReceivedCount));
        xMLStreamWriter.writeEndElement();
    }
}

