/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import weblogic.jms.backend.BEConsumerImpl;
import weblogic.jms.common.Destination;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DurableSubscription;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.Subscription;

public final class NonDurableSubscription
implements Subscription {
    private String clientId;
    private DestinationImpl destinationImpl;
    private String selector;
    private boolean noLocal;
    private String subscriptionQueueName;
    private int clientIdPolicy;
    private int subscriptionSharingPolicy;
    private int numSubscribers;
    private int subscribersTotalCount;
    private int subscribersHighCount;

    public synchronized int getSubscribersTotalCount() {
        return this.subscribersTotalCount;
    }

    public synchronized int getSubscribersHighCount() {
        return this.subscribersHighCount;
    }

    public NonDurableSubscription(String string, DestinationImpl destinationImpl, String string2, boolean bl, int n, int n2) {
        this(string, destinationImpl, string2, bl, n, n2, null);
    }

    public NonDurableSubscription(String string, DestinationImpl destinationImpl, String string2, boolean bl, int n, int n2, String string3) {
        this.clientId = string;
        this.destinationImpl = destinationImpl;
        if (string2 != null && string2.trim().length() > 0) {
            this.selector = string2;
        }
        this.noLocal = bl;
        this.clientIdPolicy = n;
        this.subscriptionSharingPolicy = n2;
        this.subscriptionQueueName = string3;
    }

    public synchronized void addSubscriber(BEConsumerImpl bEConsumerImpl) {
        ++this.numSubscribers;
        ++this.subscribersTotalCount;
        if (this.numSubscribers > this.subscribersHighCount) {
            this.subscribersHighCount = this.numSubscribers;
        }
    }

    public synchronized void removeSubscriber(JMSID jMSID) {
        --this.numSubscribers;
    }

    public synchronized int getSubscribersCount() {
        return this.numSubscribers;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public String getSelector() {
        return this.selector;
    }

    public DestinationImpl getDestinationImpl() {
        return this.destinationImpl;
    }

    public int getSubscriptionSharingPolicy() {
        return this.subscriptionSharingPolicy;
    }

    public String getSubscriptionQueueName() {
        return this.subscriptionQueueName;
    }

    public boolean equals(Object object) {
        if (!(object instanceof NonDurableSubscription)) {
            return false;
        }
        NonDurableSubscription nonDurableSubscription = (NonDurableSubscription)object;
        if (!DurableSubscription.noLocalAndSelectorMatch(this, nonDurableSubscription.noLocal, nonDurableSubscription.selector) || this.destinationImpl == null && nonDurableSubscription.destinationImpl != null || this.destinationImpl != null && nonDurableSubscription.destinationImpl == null || !this.clientId.equals(nonDurableSubscription.clientId) || this.clientIdPolicy != nonDurableSubscription.clientIdPolicy) {
            return false;
        }
        return Destination.equalsForDS(this.destinationImpl, nonDurableSubscription.destinationImpl);
    }

    public int hashCode() {
        int n = this.clientId.hashCode();
        if (this.selector != null) {
            n = n * 31 + this.selector.hashCode();
        }
        if (this.noLocal) {
            n = n * 31 + 1;
        }
        n = n * 31 + this.clientIdPolicy;
        n = n * 31 + this.destinationImpl.getName().hashCode();
        return n;
    }

    public String toString() {
        return "NonDurableSubscription((" + this.clientId + ") " + ":" + this.clientIdPolicy + this.destinationImpl + ":" + this.selector + ":" + this.noLocal + ":" + this.subscriptionSharingPolicy + ")";
    }
}

