/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import weblogic.jms.common.BufferInputStream;
import weblogic.jms.common.BufferInputStreamChunked;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;
import weblogic.jms.common.PayloadText;
import weblogic.utils.io.ByteBufferObjectOutputStream;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedDataInputStream;
import weblogic.utils.io.ChunkedDataOutputStream;

class PayloadChunkBase
implements PayloadText,
PayloadStream {
    private static int DOUBLE_CHUNK_SIZE = Chunk.CHUNK_SIZE + Chunk.CHUNK_SIZE;
    protected final Chunk chunk;

    PayloadChunkBase(Chunk chunk) {
        this.chunk = chunk;
    }

    public BufferInputStream getInputStream() throws IOException {
        Chunk chunk = this.chunk.getSharedBeforeTailCopy(null);
        ChunkedDataInputStream chunkedDataInputStream = new ChunkedDataInputStream(chunk, 0);
        return new BufferInputStreamChunked(null, chunkedDataInputStream);
    }

    public int getLength() {
        return Chunk.size((Chunk)this.chunk);
    }

    public String readUTF8() throws IOException {
        int n = this.getLength();
        byte[] byArray = new byte[4];
        int n2 = 0;
        byArray[n2++] = (byte)(n >>> 24);
        byArray[n2++] = (byte)(n >>> 16);
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2++] = (byte)(n >>> 0);
        Chunk chunk = Chunk.createSharedChunk((byte[])byArray, (int)4);
        chunk.next = this.chunk.getSharedBeforeTailCopy(null);
        ChunkedDataInputStream chunkedDataInputStream = new ChunkedDataInputStream(chunk, 0);
        chunkedDataInputStream.mark(0);
        return chunkedDataInputStream.readUTF8();
    }

    public PayloadText copyPayloadWithoutSharedText() throws JMSException {
        return new PayloadChunkBase(PayloadChunkBase.copyWithoutSharedData(this.chunk));
    }

    public PayloadStream copyPayloadWithoutSharedStream() throws JMSException {
        return new PayloadChunkBase(PayloadChunkBase.copyWithoutSharedData(this.chunk));
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        Chunk chunk = this.chunk;
        while (chunk != null) {
            if (chunk.end > 0) {
                outputStream.write(chunk.buf, 0, chunk.end);
            }
            chunk = chunk.next;
        }
    }

    public void writeLengthAndData(DataOutput dataOutput) throws IOException {
        PayloadChunkBase.internalWriteLengthAndData(dataOutput, this.chunk);
    }

    static Chunk copyWithoutSharedData(Chunk chunk) throws JMSException {
        int n;
        Chunk chunk2;
        int n2 = 0;
        Chunk chunk3 = chunk;
        while (chunk3 != null) {
            n2 += chunk3.end;
            chunk3 = chunk3.next;
        }
        chunk3 = new ChunkedDataInputStream(chunk, 0);
        chunk3.mark(0);
        int n3 = n2 % Chunk.CHUNK_SIZE;
        int n4 = Math.min(n2, Chunk.CHUNK_SIZE * 2 + n3);
        if (n4 == 0) {
            n4 = Chunk.CHUNK_SIZE;
        }
        try {
            chunk2 = Chunk.createOneSharedChunk((InputStream)chunk3, (int)n4);
            if ((n2 -= n4) == 0) {
                return chunk2;
            }
            chunk2.next = Chunk.getChunk();
            n = Chunk.chunk((Chunk)chunk2.next, (InputStream)chunk3, (int)n2);
        }
        catch (IOException iOException) {
            throw new JMSException(iOException);
        }
        if (n != n2) {
            Chunk.releaseChunks((Chunk)chunk2);
            throw new JMSException(new EOFException("Short by " + (n2 - n)));
        }
        int n5 = 0;
        Chunk chunk4 = chunk2;
        while (chunk4 != null) {
            if (chunk4.buf.length == Chunk.CHUNK_SIZE) {
                ++n5;
            }
            chunk4 = chunk4.next;
        }
        if (PayloadFactoryImpl.REPLACE_STOLEN_CHUNKS && (n5 >>= PayloadFactoryImpl.SHIFT_REPLACEMENT_STOLEN_CHUNK_COUNT) > 0) {
            Chunk.replaceStolenChunks((int)n5);
        }
        return chunk2;
    }

    static void internalWriteLengthAndData(DataOutput dataOutput, Chunk chunk) throws IOException {
        int n = 0;
        Chunk chunk2 = chunk;
        while (chunk2 != null) {
            n += chunk2.end;
            chunk2 = chunk2.next;
        }
        if (n > PayloadFactoryImpl.CHUNK_LINK_THRESHOLD) {
            chunk = chunk.getSharedBeforeTailCopy(null);
            if (dataOutput instanceof ChunkedDataOutputStream) {
                chunk2 = Chunk.tail((Chunk)chunk);
                if (chunk2.isReadOnlySharedBuf()) {
                    chunk2.next = Chunk.getChunk();
                }
                ((ChunkedDataOutputStream)dataOutput).writeChunks(chunk);
                return;
            }
            if (dataOutput instanceof ByteBufferObjectOutputStream) {
                PayloadChunkBase.writeLengthLinkByteBuffers((ByteBufferObjectOutputStream)dataOutput, chunk);
                return;
            }
        }
        dataOutput.writeInt(n);
        while (chunk != null) {
            if (chunk.end != 0) {
                dataOutput.write(chunk.buf, 0, chunk.end);
            }
            chunk = chunk.next;
        }
    }

    private static void writeLengthLinkByteBuffers(ByteBufferObjectOutputStream byteBufferObjectOutputStream, Chunk chunk) throws IOException {
        int n = 0;
        int n2 = 0;
        Chunk chunk2 = chunk;
        while (chunk2 != null) {
            if (chunk2.end > 0) {
                n += chunk2.end;
                ++n2;
            }
            chunk2 = chunk2.next;
        }
        byteBufferObjectOutputStream.writeInt(n);
        if (n == 0) {
            return;
        }
        chunk2 = new ByteBuffer[n2];
        n2 = 0;
        Chunk chunk3 = chunk;
        while (chunk3 != null) {
            if (chunk3.end > 0) {
                ByteBuffer byteBuffer = chunk3.wrapAsReadOnlyByteBuffer();
                byteBuffer.position(chunk3.end);
                chunk2[n2++] = byteBuffer;
            }
            chunk3 = chunk3.next;
        }
        byteBufferObjectOutputStream.addReadOnlyBuffers((ByteBuffer[])chunk2);
    }

    static final Chunk linkAndCopyChunksWithoutWastedMemory(ChunkedDataInputStream chunkedDataInputStream, int n) throws IOException {
        Chunk chunk;
        Chunk chunk2 = chunkedDataInputStream.getChunks();
        int n2 = chunkedDataInputStream.getChunkPos();
        if (n2 != 0) {
            int n3 = chunk2.end - n2;
            n -= n3;
            chunk = PayloadChunkBase.nCustomChunks(chunkedDataInputStream, n3);
        } else {
            chunk = null;
        }
        Chunk chunk3 = chunk;
        chunk2 = chunkedDataInputStream.getChunks();
        n2 = chunkedDataInputStream.getChunkPos();
        while (n > 0) {
            Chunk chunk4;
            Chunk chunk5;
            if (chunk2.end == n2) {
                chunk2 = chunk2.next;
                n2 = 0;
                continue;
            }
            assert (n2 == 0);
            if (n >= chunk2.end && chunk2.end == chunk2.buf.length) {
                chunk4 = chunk5 = chunk2.createOneSharedChunk();
                n -= chunk5.end;
                chunkedDataInputStream.skip((long)chunk5.end);
            } else {
                int n4 = Math.min(n, chunk2.end);
                n -= n4;
                chunk5 = PayloadChunkBase.nCustomChunks(chunkedDataInputStream, n4);
                chunk4 = Chunk.tail((Chunk)chunk5);
            }
            if (chunk == null) {
                chunk = chunk5;
            } else {
                chunk3.next = chunk5;
            }
            chunk3 = chunk4;
            chunk2 = chunkedDataInputStream.getChunks();
            n2 = chunkedDataInputStream.getChunkPos();
        }
        if (chunk == null) {
            chunk = Chunk.createOneSharedChunk((InputStream)chunkedDataInputStream, (int)0);
        }
        return chunk;
    }

    private static Chunk nCustomChunks(ChunkedDataInputStream chunkedDataInputStream, int n) throws IOException {
        if (n == 0) {
            return null;
        }
        int n2 = n % Chunk.CHUNK_SIZE;
        int n3 = Math.min(n, Chunk.CHUNK_SIZE + n2);
        Chunk chunk = Chunk.createOneSharedChunk((InputStream)chunkedDataInputStream, (int)n3);
        if ((n -= n3) > 0) {
            chunk.next = Chunk.getChunk();
            int n4 = Chunk.chunk((Chunk)chunk.next, (InputStream)chunkedDataInputStream, (int)n);
            if (n4 != n) {
                throw new EOFException();
            }
        }
        return chunk;
    }
}

