/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import weblogic.jms.common.BufferInputStreamChunked;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.BufferOutputStreamChunked;
import weblogic.jms.common.Payload;
import weblogic.jms.common.PayloadChunkBase;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedDataInputStream;

public class PayloadFactoryImpl {
    static boolean REPLACE_STOLEN_CHUNKS;
    static int SHIFT_REPLACEMENT_STOLEN_CHUNK_COUNT;
    static int CHUNK_LINK_THRESHOLD;

    static BufferOutputStream createOutputStream() {
        return new BufferOutputStreamChunked(null);
    }

    public static Payload createPayload(InputStream inputStream) throws IOException {
        int n = ((DataInput)((Object)inputStream)).readInt();
        if (n > CHUNK_LINK_THRESHOLD) {
            if (inputStream instanceof ChunkedDataInputStream) {
                ChunkedDataInputStream chunkedDataInputStream = (ChunkedDataInputStream)inputStream;
                return new PayloadChunkBase(PayloadChunkBase.linkAndCopyChunksWithoutWastedMemory(chunkedDataInputStream, n));
            }
            if (inputStream instanceof BufferInputStreamChunked) {
                ChunkedDataInputStream chunkedDataInputStream = ((BufferInputStreamChunked)inputStream).getInternalCDIS();
                return new PayloadChunkBase(PayloadChunkBase.linkAndCopyChunksWithoutWastedMemory(chunkedDataInputStream, n));
            }
        }
        return PayloadFactoryImpl.copyPayloadFromStream(inputStream, n);
    }

    static final Payload copyPayloadFromStream(InputStream inputStream, int n) throws IOException {
        Chunk chunk;
        int n2 = Math.min(n, Chunk.CHUNK_SIZE * 2);
        n -= n2;
        Chunk chunk2 = chunk = Chunk.createOneSharedChunk((InputStream)inputStream, (int)n2);
        while (n > 0) {
            n2 = Math.min(n, Chunk.CHUNK_SIZE);
            n -= n2;
            chunk2 = chunk2.next = Chunk.createOneSharedChunk((InputStream)inputStream, (int)n2);
        }
        return new PayloadChunkBase(chunk);
    }

    static final Payload convertObjectToPayload(Object object) throws IOException {
        BufferOutputStream bufferOutputStream = PayloadFactoryImpl.createOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferOutputStream);
        objectOutputStream.writeObject(object);
        bufferOutputStream.flush();
        return bufferOutputStream.moveToPayload();
    }

    static {
        String string;
        Integer n;
        REPLACE_STOLEN_CHUNKS = true;
        SHIFT_REPLACEMENT_STOLEN_CHUNK_COUNT = 0;
        CHUNK_LINK_THRESHOLD = Chunk.CHUNK_SIZE * 9;
        try {
            int n2;
            String string2 = "weblogic.jms.CHUNK_LINK_THRESHOLD";
            n = Integer.getInteger(string2);
            if (n != null && CHUNK_LINK_THRESHOLD != (n2 = n.intValue())) {
                CHUNK_LINK_THRESHOLD = n2;
                string = string2 + "=" + CHUNK_LINK_THRESHOLD;
                System.out.println(string);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            String string3 = System.getProperty("weblogic.jms.addChunkPool");
            if (string3 != null && "noPool".equals(string3)) {
                string = "PayloadFactoryImpl weblogic.jms.addChunkPool";
                REPLACE_STOLEN_CHUNKS = false;
                string = string + " do NOT proactively refill chunk pool!!";
                System.out.println(string);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            int n3;
            n = Integer.getInteger("weblogic.jms.ReplaceChunkPoolShift");
            if (n != null && SHIFT_REPLACEMENT_STOLEN_CHUNK_COUNT != (n3 = n.intValue())) {
                SHIFT_REPLACEMENT_STOLEN_CHUNK_COUNT = n3;
                string = "PayloadFactoryImpl weblogic.jms.ReplaceChunkPoolShift";
                string = string + "= " + SHIFT_REPLACEMENT_STOLEN_CHUNK_COUNT + " value";
                System.out.println(string);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

