/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.VersionInfoFactory;
import weblogic.jms.common.BufferOutputStream;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.PayloadFactoryImpl;
import weblogic.jms.common.PayloadStream;

final class PrimitiveObjectMap {
    private HashMap map;
    PayloadStream payload;
    private static PeerInfo LATEST_PEER_INFO = VersionInfoFactory.getPeerInfo();

    PrimitiveObjectMap() {
    }

    PrimitiveObjectMap(DataInput dataInput, int n) throws IOException {
        if (n >= 30) {
            this.payload = (PayloadStream)PayloadFactoryImpl.createPayload((InputStream)((Object)dataInput));
        } else {
            this.map = JMSUtilities.readBasicMap(dataInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrimitiveObjectMap(PrimitiveObjectMap primitiveObjectMap) throws javax.jms.JMSException {
        PrimitiveObjectMap primitiveObjectMap2 = primitiveObjectMap;
        synchronized (primitiveObjectMap2) {
            try {
                primitiveObjectMap.ensurePayload();
            }
            catch (IOException iOException) {
                throw new JMSException(iOException);
            }
            this.payload = primitiveObjectMap.payload.copyPayloadWithoutSharedStream();
        }
    }

    public Set entrySet() throws javax.jms.JMSException {
        this.ensureMap();
        return this.map.entrySet();
    }

    public Set keySet() throws javax.jms.JMSException {
        this.ensureMap();
        return this.map.keySet();
    }

    public Object put(Object object, Object object2) throws javax.jms.JMSException {
        this.ensureMap();
        this.invalidatePayload();
        return this.map.put(object, object2);
    }

    public Object get(Object object) throws javax.jms.JMSException {
        this.ensureMap();
        return this.map.get(object);
    }

    public Object remove(Object object) throws javax.jms.JMSException {
        this.ensureMap();
        Object v = this.map.remove(object);
        if (v != null) {
            this.invalidatePayload();
        }
        return v;
    }

    public boolean containsKey(Object object) throws javax.jms.JMSException {
        this.ensureMap();
        return this.map.containsKey(object);
    }

    public boolean isEmpty() {
        if (this.map != null) {
            return this.map.isEmpty();
        }
        return this.payload == null;
    }

    public int getSizeInBytes() throws javax.jms.JMSException {
        try {
            this.ensurePayload();
        }
        catch (IOException iOException) {
            throw new JMSException(iOException);
        }
        return this.payload.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToStream(DataOutput dataOutput, int n) throws IOException {
        if (n >= 30) {
            PrimitiveObjectMap primitiveObjectMap = this;
            synchronized (primitiveObjectMap) {
                this.ensurePayload();
                this.payload.writeLengthAndData(dataOutput);
            }
        } else {
            this.writeToStream(dataOutput, LATEST_PEER_INFO);
        }
    }

    void writeToStream(DataOutput dataOutput, PeerInfo peerInfo) throws IOException {
        try {
            this.ensureMap();
        }
        catch (javax.jms.JMSException jMSException) {
            IOException iOException = new IOException(jMSException.toString());
            iOException.initCause(jMSException);
            throw iOException;
        }
        JMSUtilities.writeBasicMap(dataOutput, this.map, peerInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidatePayload() {
        PrimitiveObjectMap primitiveObjectMap = this;
        synchronized (primitiveObjectMap) {
            this.payload = null;
        }
    }

    private synchronized void ensureMap() throws javax.jms.JMSException {
        if (this.map == null) {
            if (this.payload != null) {
                try {
                    this.map = JMSUtilities.readBasicMap(this.payload.getInputStream());
                }
                catch (IOException iOException) {
                    throw new JMSException(iOException);
                }
            } else {
                this.map = new HashMap();
            }
        }
    }

    private synchronized void ensurePayload() throws IOException {
        if (this.payload == null) {
            BufferOutputStream bufferOutputStream = PayloadFactoryImpl.createOutputStream();
            JMSUtilities.writeBasicMap(bufferOutputStream, this.map, LATEST_PEER_INFO);
            bufferOutputStream.close();
            this.payload = (PayloadStream)bufferOutputStream.moveToPayload();
        }
    }
}

