/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import weblogic.jms.common.DDTxLoadBalancingOptimizer;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.LoadBalancer;

public final class RRLoadBalancer
implements LoadBalancer {
    private DistributedDestinationImpl[] dests = null;
    private int current;
    private int pass;
    private int min;
    private int max;
    private int size;
    private int count;

    public RRLoadBalancer() {
    }

    public RRLoadBalancer(DistributedDestinationImpl[] distributedDestinationImplArray) {
        if (distributedDestinationImplArray == null || distributedDestinationImplArray.length == 0 || distributedDestinationImplArray[0] == null) {
            this.dests = null;
            return;
        }
        this.refresh(distributedDestinationImplArray);
        this.current = 0;
        this.pass = 0;
        this.count = -1;
    }

    public void refresh(DistributedDestinationImpl[] distributedDestinationImplArray) {
        int n;
        if (distributedDestinationImplArray == null || distributedDestinationImplArray.length == 0 || distributedDestinationImplArray[0] == null) {
            this.dests = null;
            return;
        }
        this.min = distributedDestinationImplArray[0].getWeight();
        this.max = distributedDestinationImplArray[0].getWeight();
        for (n = 1; n < distributedDestinationImplArray.length && distributedDestinationImplArray[n] != null; ++n) {
            int n2 = distributedDestinationImplArray[n].getWeight();
            if (n2 < this.min) {
                this.min = n2;
                continue;
            }
            if (n2 <= this.max) continue;
            this.max = n2;
        }
        if (this.dests != null && this.size > n) {
            while (this.current < n && this.current >= 0 && this.dests[this.current] != distributedDestinationImplArray[this.current]) {
                --this.current;
            }
        }
        this.size = n;
        this.dests = distributedDestinationImplArray;
    }

    public DistributedDestinationImpl getNext(DDTxLoadBalancingOptimizer dDTxLoadBalancingOptimizer) {
        if (this.dests == null) {
            return null;
        }
        if (++this.current >= this.size) {
            this.current = 0;
        }
        if (++this.count >= this.size) {
            this.count = 0;
            if (++this.pass >= this.max) {
                this.pass = 0;
            }
        }
        while (this.pass >= this.min && this.dests[this.current].getWeight() <= this.pass) {
            if (++this.current >= this.size) {
                this.current = 0;
            }
            if (++this.count < this.size) continue;
            this.count = 0;
            if (++this.pass < this.max) continue;
            this.pass = 0;
        }
        int n = this.current;
        if (dDTxLoadBalancingOptimizer != null && !this.dests[n].isLocal() && !dDTxLoadBalancingOptimizer.visited(this.dests[n])) {
            int n2;
            for (n2 = 0; n2 < this.size && !dDTxLoadBalancingOptimizer.visited(this.dests[n]); ++n2) {
                if (++n < this.size) continue;
                n = 0;
            }
            if (n2 >= this.size) {
                dDTxLoadBalancingOptimizer.addVisitedDispatcher(this.dests[n]);
            }
        }
        return this.dests[n];
    }

    public DistributedDestinationImpl getNext(int n) {
        return this.dests[n];
    }
}

