/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.util.Random;
import weblogic.jms.common.DDTxLoadBalancingOptimizer;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.LoadBalancer;

public final class RandomLoadBalancer
implements LoadBalancer {
    private DistributedDestinationImpl[] dests = null;
    private int size;
    private int unit;
    private int[] upper;
    private int[] lower;
    private int[] rate;
    private Random random;

    public RandomLoadBalancer() {
    }

    public RandomLoadBalancer(DistributedDestinationImpl[] distributedDestinationImplArray) {
        this.refresh(distributedDestinationImplArray);
    }

    public void refresh(DistributedDestinationImpl[] distributedDestinationImplArray) {
        int n;
        if (distributedDestinationImplArray == null || distributedDestinationImplArray.length == 0 || distributedDestinationImplArray[0] == null) {
            this.dests = null;
            return;
        }
        this.dests = distributedDestinationImplArray;
        this.random = new Random();
        for (n = 0; n < distributedDestinationImplArray.length && distributedDestinationImplArray[n] != null; ++n) {
        }
        this.size = n;
        int[] nArray = new int[this.size];
        this.upper = new int[this.size];
        this.lower = new int[this.size];
        this.rate = new int[this.size];
        this.unit = 0;
        for (n = 0; n < this.size; ++n) {
            nArray[n] = distributedDestinationImplArray[n].getWeight();
            this.unit += nArray[n];
            nArray[n] = nArray[n] * this.size;
        }
        for (n = 0; n < this.size; ++n) {
            int n2 = Integer.MAX_VALUE;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < this.size; ++i) {
                if (nArray[i] > 0 && nArray[i] < n2) {
                    n2 = nArray[i];
                    n3 = i;
                }
                if (nArray[i] <= n4) continue;
                n4 = nArray[i];
                n5 = i;
            }
            this.upper[n] = n3;
            this.lower[n] = n5;
            this.rate[n] = n2 >= this.unit ? this.unit : n2;
            nArray[n3] = 0;
            int n6 = n5;
            nArray[n6] = nArray[n6] - (this.unit - n2);
        }
    }

    public DistributedDestinationImpl getNext(DDTxLoadBalancingOptimizer dDTxLoadBalancingOptimizer) {
        if (this.dests == null) {
            return null;
        }
        int n = this.random.nextInt(this.size);
        int n2 = this.random.nextInt(this.unit);
        DistributedDestinationImpl distributedDestinationImpl = n2 < this.rate[n] ? this.dests[this.upper[n]] : this.dests[this.lower[n]];
        if (dDTxLoadBalancingOptimizer != null && !distributedDestinationImpl.isLocal() && !dDTxLoadBalancingOptimizer.visited(distributedDestinationImpl)) {
            int n3;
            for (n3 = 0; n3 < this.size && !dDTxLoadBalancingOptimizer.visited(this.dests[n]); ++n3) {
                if (++n < this.size) continue;
                n = 0;
            }
            if (n3 < this.size) {
                distributedDestinationImpl = this.dests[n];
            } else {
                dDTxLoadBalancingOptimizer.addVisitedDispatcher(distributedDestinationImpl);
            }
        }
        return distributedDestinationImpl;
    }

    public DistributedDestinationImpl getNext(int n) {
        return this.dests[n];
    }
}

