/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import weblogic.utils.encoders.BASE64Decoder;
import weblogic.utils.encoders.BASE64Encoder;

public class SecHelper {
    private static final int SALT_SIZE = 8;
    private static final int OLD_ITERATIONS = 13;
    private static final int ITERATIONS = 1024;
    private static final int AES_KEY_SIZE = 128;
    private static final String OLD_BLOCK_CIPHER_ALGORITHM = "PBEWithMD5AndDES";
    private static final String BLOCK_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String SECRET_KEY_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final String ALGORITHM_TOKEN = "{Algorithm}";
    private static final String SALT_TOKEN = "{Salt}";
    private static final String IV_TOKEN = "{IV}";
    private static final String DATA_TOKEN = "{Data}";

    public static String encryptString(char[] cArray, String string) throws GeneralSecurityException {
        if (string == null) {
            return null;
        }
        return SecHelper.encryptPassword(cArray, string.toCharArray());
    }

    private static byte[] charsToBytes(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = cArray.length * 2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < cArray.length; ++i) {
            int n2 = cArray[i] & 0xFFFF;
            byArray[i * 2] = (byte)((n2 & 0xFF00) >> 8);
            byArray[i * 2 + 1] = (byte)(n2 & 0xFF);
        }
        return byArray;
    }

    private static char[] bytesToChars(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length % 2 != 0) {
            throw new AssertionError((Object)("Invalid number of bytes: " + byArray.length));
        }
        int n = byArray.length / 2;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(byArray[i * 2] << 8 | byArray[i * 2 + 1]);
        }
        return cArray;
    }

    private static SecretKey generateSecretKey(char[] cArray, byte[] byArray) throws GeneralSecurityException {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, byArray, 1024, 128);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(SECRET_KEY_ALGORITHM);
        SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), "AES");
        return secretKeySpec;
    }

    public static String encryptPassword(char[] cArray, char[] cArray2) throws GeneralSecurityException {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[8];
        secureRandom.nextBytes(byArray);
        SecretKey secretKey = SecHelper.generateSecretKey(cArray, byArray);
        Cipher cipher = Cipher.getInstance(BLOCK_CIPHER_ALGORITHM);
        cipher.init(1, secretKey);
        AlgorithmParameters algorithmParameters = cipher.getParameters();
        byte[] byArray2 = algorithmParameters.getParameterSpec(IvParameterSpec.class).getIV();
        byte[] byArray3 = cipher.doFinal(SecHelper.charsToBytes(cArray2));
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string = bASE64Encoder.encodeBuffer(byArray);
        String string2 = bASE64Encoder.encodeBuffer(byArray2);
        String string3 = bASE64Encoder.encodeBuffer(byArray3);
        return "{Algorithm}AES/CBC/PKCS5Padding{Salt}" + string + IV_TOKEN + string2 + DATA_TOKEN + string3;
    }

    public static char[] decryptString(char[] cArray, String string) throws GeneralSecurityException, IOException {
        int n = string.indexOf(ALGORITHM_TOKEN);
        int n2 = n + ALGORITHM_TOKEN.length();
        int n3 = string.indexOf(SALT_TOKEN);
        int n4 = n3 + SALT_TOKEN.length();
        int n5 = string.indexOf(DATA_TOKEN);
        int n6 = n5 + DATA_TOKEN.length();
        if (n < 0) {
            throw new GeneralSecurityException("Algorithm cannot be found");
        }
        String string2 = string.substring(n2, n3);
        if (!BLOCK_CIPHER_ALGORITHM.equals(string2) && !OLD_BLOCK_CIPHER_ALGORITHM.equals(string2)) {
            throw new GeneralSecurityException("algorithm " + string2 + " is not supported");
        }
        if (n3 < 0) {
            throw new GeneralSecurityException("Salt cannot be found");
        }
        if (n5 < 0) {
            throw new GeneralSecurityException("Encrypted data cannot be found");
        }
        SecretKey secretKey = null;
        AlgorithmParameterSpec algorithmParameterSpec = null;
        byte[] byArray = null;
        if (BLOCK_CIPHER_ALGORITHM.equals(string2)) {
            int n7 = string.indexOf(IV_TOKEN);
            int n8 = n7 + IV_TOKEN.length();
            if (n7 < 0) {
                throw new GeneralSecurityException("Initialzation vector cannot be found for " + string2);
            }
            String string3 = string.substring(n4, n7);
            String string4 = string.substring(n8, n5);
            String string5 = string.substring(n6);
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byte[] byArray2 = bASE64Decoder.decodeBuffer(string3);
            byte[] byArray3 = bASE64Decoder.decodeBuffer(string4);
            byArray = bASE64Decoder.decodeBuffer(string5);
            secretKey = SecHelper.generateSecretKey(cArray, byArray2);
            algorithmParameterSpec = new IvParameterSpec(byArray3);
        } else {
            String string6 = string.substring(n4, n5);
            String string7 = string.substring(n6);
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byte[] byArray4 = bASE64Decoder.decodeBuffer(string6);
            byArray = bASE64Decoder.decodeBuffer(string7);
            algorithmParameterSpec = new PBEParameterSpec(byArray4, 13);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string2);
            secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        }
        Cipher cipher = Cipher.getInstance(string2);
        cipher.init(2, (Key)secretKey, algorithmParameterSpec);
        try {
            byte[] byArray5 = cipher.doFinal(byArray);
            return SecHelper.bytesToChars(byArray5);
        }
        catch (Exception exception) {
            throw new GeneralSecurityException("Error occured during decryption");
        }
    }
}

