/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.util.concurrent.ConcurrentHashMap;
import weblogic.jms.JMSService;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSSecurityException;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.common.TimedSecurityParticipant;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.JMSResource;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;

public final class SecurityChecker
implements TimerListener {
    private JMSService jmsService;
    private ConcurrentHashMap<TimedSecurityParticipant, JMSResource> checkMe;

    public SecurityChecker(JMSService jMSService) {
        this.jmsService = jMSService;
        this.checkMe = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWithChecker(JMSResource jMSResource, TimedSecurityParticipant timedSecurityParticipant) {
        ConcurrentHashMap<TimedSecurityParticipant, JMSResource> concurrentHashMap = this.checkMe;
        synchronized (concurrentHashMap) {
            if (this.checkMe.size() <= 0) {
                this.jmsService.fireUpSecurityChecks();
            }
        }
        this.checkMe.put(timedSecurityParticipant, jMSResource);
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("Registered " + JMSSecurityHelper.getSimpleAuthenticatedName() + " for security checks on " + jMSResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        for (TimedSecurityParticipant timedSecurityParticipant : this.checkMe.keySet()) {
            if (timedSecurityParticipant.isClosed()) {
                if (JMSDebug.JMSCommon.isDebugEnabled()) {
                    JMSDebug.JMSCommon.debug("Removing closed participant " + timedSecurityParticipant);
                }
                this.checkMe.remove(timedSecurityParticipant);
                continue;
            }
            JMSResource jMSResource = this.checkMe.get(timedSecurityParticipant);
            try {
                JMSSecurityHelper.checkPermission(jMSResource, timedSecurityParticipant.getSubject());
            }
            catch (JMSSecurityException jMSSecurityException) {
                if (JMSDebug.JMSCommon.isDebugEnabled()) {
                    JMSDebug.JMSCommon.debug("Security lapsed for " + jMSResource + SubjectUtils.getUsername((AuthenticatedSubject)timedSecurityParticipant.getSubject()));
                }
                timedSecurityParticipant.securityLapsed();
            }
        }
        ConcurrentHashMap<TimedSecurityParticipant, JMSResource> concurrentHashMap = this.checkMe;
        synchronized (concurrentHashMap) {
            if (this.checkMe.size() <= 0) {
                this.jmsService.stopSecurityChecks();
                return;
            }
        }
    }
}

