/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import weblogic.jms.JMSService;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.JMSPushRequest;
import weblogic.jms.common.PushTarget;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;

public final class Sequencer
implements Invocable {
    private final PushTarget pushTarget;
    private final JMSDispatcher dispatcher;
    private final JMSID sequencerId;
    private final InvocableMonitor invocableMonitor;
    private long expectedSequenceNumber = 1L;
    private boolean running;
    private JMSPushRequest firstRequest;
    private JMSPushRequest lastRequest;

    public Sequencer(PushTarget pushTarget, JMSDispatcher jMSDispatcher) {
        this.pushTarget = pushTarget;
        this.dispatcher = jMSDispatcher;
        this.sequencerId = JMSService.getJMSService().getNextId();
        this.invocableMonitor = JMSService.getJMSService().getInvocableMonitor();
    }

    public Sequencer(PushTarget pushTarget) {
        this.pushTarget = pushTarget;
        this.dispatcher = null;
        this.sequencerId = null;
        this.invocableMonitor = null;
    }

    public JMSDispatcher getDispatcher() {
        return this.dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeExpectedSequenceNumberCanHaveRemainder(long l) {
        Sequencer sequencer = this;
        synchronized (sequencer) {
            if (this.expectedSequenceNumber >= l) {
                return;
            }
            this.expectedSequenceNumber = l;
            this.expungeBeforeSequenceNumber();
            if (this.running) {
                return;
            }
            this.running = true;
        }
        this.deliverMessages();
    }

    private void expungeBeforeSequenceNumber() {
        assert (Thread.holdsLock(this));
        while (this.firstRequest != null) {
            if (this.firstRequest.getBackEndSequenceNumber() >= this.expectedSequenceNumber) {
                return;
            }
            JMSPushRequest jMSPushRequest = this.firstRequest;
            this.firstRequest = (JMSPushRequest)jMSPushRequest.getNext();
            jMSPushRequest.setNext(null);
        }
        if (this.firstRequest == null) {
            this.lastRequest = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushMessage(JMSPushRequest jMSPushRequest) {
        Sequencer sequencer = this;
        synchronized (sequencer) {
            for (JMSPushRequest jMSPushRequest2 = jMSPushRequest; jMSPushRequest2 != null; jMSPushRequest2 = (JMSPushRequest)jMSPushRequest2.getNext()) {
                JMSPushRequest jMSPushRequest3;
                JMSPushEntry jMSPushEntry;
                JMSPushEntry jMSPushEntry2 = jMSPushRequest2.getFirstPushEntry().getNext();
                while (jMSPushEntry2 != null) {
                    jMSPushEntry = jMSPushEntry2;
                    jMSPushEntry2 = jMSPushEntry.getNext();
                    jMSPushEntry.setNext(null);
                    jMSPushRequest3 = new JMSPushRequest(13, this.pushTarget.getJMSID(), jMSPushRequest2.getMessage(), jMSPushEntry);
                    this.sequenceRequest(jMSPushRequest3);
                }
                jMSPushEntry = jMSPushRequest2.getFirstPushEntry();
                jMSPushEntry.setNext(null);
                jMSPushRequest2.setLastPushEntry(jMSPushEntry);
                jMSPushRequest2.setInvocableId(this.pushTarget.getJMSID());
                jMSPushRequest3 = jMSPushRequest2;
                jMSPushRequest3.setNext(null);
                this.sequenceRequest(jMSPushRequest3);
            }
            if (this.running) {
                return;
            }
            this.running = true;
        }
        this.deliverMessages();
    }

    private void sequenceRequest(JMSPushRequest jMSPushRequest) {
        JMSPushRequest jMSPushRequest2;
        assert (Thread.holdsLock(this));
        assert (jMSPushRequest.getNext() == null);
        assert (jMSPushRequest.getFirstPushEntry().getNext() == null);
        long l = jMSPushRequest.getBackEndSequenceNumber();
        if (l < this.expectedSequenceNumber) {
            return;
        }
        if (this.firstRequest == null) {
            this.firstRequest = this.lastRequest = jMSPushRequest;
            return;
        }
        if (this.lastRequest != null && l > this.lastRequest.getBackEndSequenceNumber()) {
            this.lastRequest.setNext(jMSPushRequest);
            this.lastRequest = jMSPushRequest;
            return;
        }
        Request request = null;
        for (jMSPushRequest2 = this.firstRequest; jMSPushRequest2 != null && l >= jMSPushRequest2.getBackEndSequenceNumber(); jMSPushRequest2 = (JMSPushRequest)jMSPushRequest2.getNext()) {
            request = jMSPushRequest2;
        }
        if (jMSPushRequest2 != null) {
            if (jMSPushRequest2.getBackEndSequenceNumber() == l) {
                return;
            }
            jMSPushRequest.setNext(jMSPushRequest2);
            if (request != null) {
                request.setNext(jMSPushRequest);
            } else {
                this.firstRequest = jMSPushRequest;
            }
        } else {
            request.setNext(jMSPushRequest);
            this.lastRequest = jMSPushRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverMessages() {
        JMSPushRequest jMSPushRequest = null;
        while (true) {
            Sequencer sequencer = this;
            synchronized (sequencer) {
                jMSPushRequest = this.firstRequest;
                Request request = null;
                while (this.firstRequest != null && this.firstRequest.getBackEndSequenceNumber() == this.expectedSequenceNumber) {
                    this.firstRequest.getFirstPushEntry().setDispatcher(this.dispatcher);
                    ++this.expectedSequenceNumber;
                    request = this.firstRequest;
                    this.firstRequest = (JMSPushRequest)this.firstRequest.getNext();
                }
                if (request == null) {
                    this.running = false;
                    return;
                }
                if (this.firstRequest == null) {
                    this.lastRequest = null;
                } else {
                    request.setNext(null);
                }
            }
            this.pushTarget.pushMessage(jMSPushRequest);
        }
    }

    public JMSID getJMSID() {
        return this.sequencerId;
    }

    public ID getId() {
        return this.getJMSID();
    }

    public InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    public int invoke(Request request) throws javax.jms.JMSException {
        switch (request.getMethodId()) {
            case 15629: {
                this.pushMessage((JMSPushRequest)request);
                return Integer.MAX_VALUE;
            }
        }
        throw new JMSException("No such method " + request.getMethodId());
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        if (this.firstRequest != null) {
            stringBuffer.append(" first=");
            stringBuffer.append(this.firstRequest.getBackEndSequenceNumber());
        }
        if (this.lastRequest != null) {
            stringBuffer.append(" last=");
            stringBuffer.append(this.lastRequest.getBackEndSequenceNumber());
        }
        int n = 0;
        for (JMSPushRequest jMSPushRequest = this.firstRequest; jMSPushRequest != null; jMSPushRequest = (JMSPushRequest)jMSPushRequest.getNext()) {
            stringBuffer.append(' ');
            stringBuffer.append(jMSPushRequest.getBackEndSequenceNumber());
            stringBuffer.append(' ');
            ++n;
        }
        stringBuffer.append(" pending=");
        stringBuffer.append(n);
        stringBuffer.append(" expected=");
        stringBuffer.append(this.expectedSequenceNumber);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

