/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.util.LinkedList;
import weblogic.jms.common.JMSDebug;
import weblogic.work.WorkManagerFactory;

public class SerialScheduler
implements Runnable {
    private boolean running = false;
    private boolean drain = false;
    private LinkedList schedList = new LinkedList();
    private Throwable firstThrowable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n = 0;
        while (true) {
            Runnable runnable = null;
            LinkedList linkedList = this.schedList;
            synchronized (linkedList) {
                if (!this.drain && n == 100) {
                    if (WorkManagerFactory.getInstance().getDefault().scheduleIfBusy((Runnable)this)) {
                        return;
                    }
                    n = 0;
                }
                if (this.schedList.size() != 0) {
                    runnable = (Runnable)this.schedList.removeFirst();
                }
                if (runnable == null) {
                    this.running = false;
                    this.drain = false;
                    this.schedList.notifyAll();
                    return;
                }
            }
            try {
                if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                    JMSDebug.JMSBackEnd.debug("Calling out to " + runnable);
                }
                runnable.run();
                if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                    JMSDebug.JMSBackEnd.debug("Back from " + runnable);
                }
            }
            catch (Throwable throwable) {
                if (this.firstThrowable == null) {
                    this.firstThrowable = throwable;
                }
                throwable.printStackTrace();
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Runnable runnable) {
        LinkedList linkedList = this.schedList;
        synchronized (linkedList) {
            this.schedList.add(runnable);
            if (!this.running) {
                this.running = true;
                WorkManagerFactory.getInstance().getDefault().schedule((Runnable)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        LinkedList linkedList = this.schedList;
        synchronized (linkedList) {
            if (this.schedList.size() == 0) {
                return;
            }
            this.drain = true;
            if (!this.running) {
                this.running = true;
                WorkManagerFactory.getInstance().getDefault().schedule((Runnable)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable waitForComplete() {
        LinkedList linkedList = this.schedList;
        synchronized (linkedList) {
            while (this.schedList.size() > 0 || this.running) {
                try {
                    this.schedList.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
            Throwable throwable = this.firstThrowable;
            this.firstThrowable = null;
            return throwable;
        }
    }
}

