/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.IOException;
import java.rmi.Remote;
import javax.naming.NamingException;
import weblogic.jms.common.CDSListListener;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.common.CrossDomainSecurityUtil;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.dispatcher.DispatcherAdapter;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherProxy;
import weblogic.messaging.dispatcher.DispatcherRemote;
import weblogic.messaging.dispatcher.DispatcherWrapperState;
import weblogic.messaging.dispatcher.Request;
import weblogic.rmi.extensions.RemoteHelper;
import weblogic.rmi.extensions.server.RemoteDomainSecurityHelper;
import weblogic.rmi.spi.EndPoint;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public final class ServerCrossDomainSecurityUtil
implements CrossDomainSecurityUtil {
    private final AbstractSubject anonymous = SubjectManager.getSubjectManager().getAnonymousSubject();

    public AbstractSubject getSubjectFromListener(CDSListListener cDSListListener) throws NamingException, IOException {
        AbstractSubject abstractSubject = null;
        try {
            abstractSubject = cDSListListener.getForeignSubject();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (abstractSubject == null) {
            abstractSubject = cDSListListener.getSubject();
        }
        String string = cDSListListener.getProviderURL();
        if (JMSDebug.JMSCrossDomainSecurity.isDebugEnabled()) {
            JMSDebug.JMSCrossDomainSecurity.debug("getSubjectFromListener() listener's url = " + string + " listener's subject = " + abstractSubject + " isLocal  = " + cDSListListener.isLocal());
        }
        if (cDSListListener.isLocal() || string == null || string.trim().length() == 0) {
            if (abstractSubject == null) {
                abstractSubject = CrossDomainSecurityManager.getCurrentSubject();
            }
            if (JMSDebug.JMSCrossDomainSecurity.isDebugEnabled()) {
                JMSDebug.JMSCrossDomainSecurity.debug("getSubjectFromListener() final subject = " + abstractSubject);
            }
            return abstractSubject;
        }
        if (abstractSubject != null && this.isKernelIdentity((AbstractSubject)((AuthenticatedSubject)abstractSubject)) && this.isRemoteDomain(cDSListListener.getProviderURL())) {
            abstractSubject = this.getRemoteSubjectFromCM(cDSListListener.getProviderURL());
        }
        if (abstractSubject == null || this.isKernelIdentity((AbstractSubject)((AuthenticatedSubject)abstractSubject))) {
            abstractSubject = this.anonymous;
        }
        if (JMSDebug.JMSCrossDomainSecurity.isDebugEnabled()) {
            JMSDebug.JMSCrossDomainSecurity.debug("Final subject for URL " + string + " is " + abstractSubject);
        }
        return abstractSubject;
    }

    public AbstractSubject getRemoteSubject(String string, AbstractSubject abstractSubject) {
        AbstractSubject abstractSubject2 = null;
        try {
            abstractSubject2 = this.getRemoteSubjectFromCM(string);
            if (abstractSubject2 != null) {
                return abstractSubject2;
            }
            if (CrossDomainSecurityManager.getCrossDomainSecurityUtil().isRemoteDomain(string)) {
                return this.anonymous;
            }
        }
        catch (IOException iOException) {
            return this.anonymous;
        }
        catch (NamingException namingException) {
            return this.anonymous;
        }
        abstractSubject2 = abstractSubject != null ? abstractSubject : CrossDomainSecurityManager.getCurrentSubject();
        if (abstractSubject2 == null || this.isKernelIdentity((AbstractSubject)((AuthenticatedSubject)abstractSubject2))) {
            abstractSubject2 = this.anonymous;
        }
        return abstractSubject2;
    }

    private AbstractSubject getRemoteSubjectFromCM(String string) throws IOException, NamingException {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        return RemoteDomainSecurityHelper.getSubject(string);
    }

    public AbstractSubject getRemoteSubject(JMSDispatcher jMSDispatcher) throws JMSException {
        return this.getRemoteSubject(jMSDispatcher, CrossDomainSecurityManager.getCurrentSubject(), false);
    }

    public AbstractSubject getRemoteSubject(JMSDispatcher jMSDispatcher, AbstractSubject abstractSubject, boolean bl) throws JMSException {
        AbstractSubject abstractSubject2 = CrossDomainSecurityManager.getCurrentSubject();
        if (JMSDebug.JMSCrossDomainSecurity.isDebugEnabled()) {
            JMSDebug.JMSCrossDomainSecurity.debug("getRemoteSubject from dispatcher: isLocal = " + jMSDispatcher.isLocal() + " currentSubject = " + abstractSubject2 + " suggestedSubject = " + abstractSubject + " dispatcher " + jMSDispatcher + " suggestedSubjectGoodForRemoteDomain = " + bl);
        }
        if (jMSDispatcher.isLocal()) {
            if (abstractSubject != null) {
                return abstractSubject;
            }
            return abstractSubject2;
        }
        Dispatcher dispatcher = ((DispatcherAdapter)jMSDispatcher).getDelegate();
        Remote remote = RemoteHelper.getRemote((Object)dispatcher);
        if (JMSDebug.JMSCrossDomainSecurity.isDebugEnabled()) {
            JMSDebug.JMSCrossDomainSecurity.debug("Remote = " + remote);
        }
        if (remote == null || !(remote instanceof DispatcherProxy) && !(dispatcher instanceof DispatcherWrapperState)) {
            if (abstractSubject != null) {
                return abstractSubject;
            }
            return abstractSubject2;
        }
        AbstractSubject abstractSubject3 = null;
        if (remote instanceof DispatcherProxy) {
            if (abstractSubject != null && (bl || !RemoteDomainSecurityHelper.isRemoteDomain((EndPoint)((DispatcherProxy)remote).getRJVM()))) {
                abstractSubject3 = abstractSubject;
            }
            if (abstractSubject3 == null || this.isKernelIdentity((AbstractSubject)((AuthenticatedSubject)abstractSubject3))) {
                try {
                    abstractSubject3 = RemoteDomainSecurityHelper.getSubject((EndPoint)((DispatcherProxy)remote).getRJVM());
                }
                catch (IOException iOException) {
                    throw new JMSException(iOException);
                }
            }
        } else {
            abstractSubject3 = abstractSubject;
        }
        if (abstractSubject3 == null || this.isKernelIdentity((AbstractSubject)((AuthenticatedSubject)abstractSubject3))) {
            abstractSubject3 = this.anonymous;
        }
        if (JMSDebug.JMSCrossDomainSecurity.isDebugEnabled()) {
            JMSDebug.JMSCrossDomainSecurity.debug("final subject = " + abstractSubject3);
        }
        return abstractSubject3;
    }

    private void checkRole(DispatcherProxy dispatcherProxy, Request request) throws JMSException {
        int n;
        if (JMSDebug.JMSCrossDomainSecurity.isDebugEnabled() && ((n = request.getMethodId()) == 18455 || n == 18711 || n == 18967 || n == 4 || n == 15616)) {
            String string = null;
            switch (request.getMethodId()) {
                case 18455: {
                    string = "DDMembershipRequest:";
                    break;
                }
                case 18711: {
                    string = "DDMembershipPushRequest:";
                    break;
                }
                case 18967: {
                    string = "DDMembershipCancalRequest:";
                    break;
                }
                case 15616: {
                    string = "JMSPushMessageRequest:";
                    break;
                }
                case 4: {
                    string = "JMSSessionRequest:";
                }
            }
            if (JMSDebug.JMSCrossDomainSecurity.isDebugEnabled()) {
                JMSDebug.JMSCrossDomainSecurity.debug("Processing " + string + " dispatcherProxy = " + dispatcherProxy + " isCollocatd = " + request.isCollocated());
            }
        }
        AbstractSubject abstractSubject = CrossDomainSecurityManager.getCurrentSubject();
        int n2 = RemoteDomainSecurityHelper.acceptRemoteDomainCall(dispatcherProxy.getRJVM().getHostID(), (AuthenticatedSubject)abstractSubject);
        if (JMSDebug.JMSCrossDomainSecurity.isDebugEnabled() && JMSDebug.JMSCrossDomainSecurity.isDebugEnabled()) {
            JMSDebug.JMSCrossDomainSecurity.debug("Verifying subject = " + abstractSubject + " acceptRemoteDomainCall()= " + n2);
        }
        if (n2 == 1) {
            throw new JMSException("User <" + abstractSubject + "> does not have " + "permission for cross-domain communication");
        }
    }

    public void checkRole(JMSDispatcher jMSDispatcher, Request request) throws JMSException {
        DispatcherProxy dispatcherProxy = this.getDispatcherProxy(jMSDispatcher);
        if (dispatcherProxy == null) {
            return;
        }
        this.checkRole(dispatcherProxy, request);
    }

    public void checkRole(DispatcherRemote dispatcherRemote, Request request) throws JMSException {
        if (request.isCollocated() || !(dispatcherRemote instanceof DispatcherProxy)) {
            return;
        }
        this.checkRole((DispatcherProxy)dispatcherRemote, request);
    }

    public boolean isRemoteDomain(String string) throws IOException {
        return RemoteDomainSecurityHelper.isRemoteDomain(string);
    }

    public boolean isRemoteDomain(JMSDispatcher jMSDispatcher) throws IOException {
        DispatcherProxy dispatcherProxy = this.getDispatcherProxy(jMSDispatcher);
        if (dispatcherProxy == null) {
            return false;
        }
        return RemoteDomainSecurityHelper.isRemoteDomain((EndPoint)dispatcherProxy.getRJVM());
    }

    private DispatcherProxy getDispatcherProxy(JMSDispatcher jMSDispatcher) {
        if (jMSDispatcher.isLocal()) {
            return null;
        }
        Dispatcher dispatcher = ((DispatcherAdapter)jMSDispatcher).getDelegate();
        Remote remote = RemoteHelper.getRemote((Object)dispatcher);
        if (!(remote instanceof DispatcherProxy)) {
            return null;
        }
        return (DispatcherProxy)remote;
    }

    public boolean isKernelIdentity(AbstractSubject abstractSubject) {
        if (!(abstractSubject instanceof AuthenticatedSubject)) {
            return false;
        }
        return SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)((AuthenticatedSubject)abstractSubject)) || SecurityServiceManager.isServerIdentity((AuthenticatedSubject)((AuthenticatedSubject)abstractSubject));
    }

    public boolean ifRemoteSubjectExists(String string) {
        AuthenticatedSubject authenticatedSubject = null;
        try {
            if (string != null && string.trim().length() > 0) {
                authenticatedSubject = RemoteDomainSecurityHelper.getSubject(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return authenticatedSubject != null;
    }
}

