/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.LeaderManager;
import weblogic.jms.common.SingularAggregatableManager;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jndi.Aggregatable;
import weblogic.jndi.internal.NamingNode;

public abstract class SingularAggregatable
implements Aggregatable,
Externalizable {
    static final long serialVersionUID = 3833976158056390134L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int HASLEADERJMSID = 256;
    private transient JMSDispatcher leaderDispatcher;
    private transient String jndiName;
    private transient int aggregatableCount = 0;
    private JMSID leaderJMSID;
    private long leaderSequenceNumber;

    public abstract void hadConflict(boolean var1);

    public final void setJNDIName(String string) {
        this.jndiName = string;
    }

    public final String getJNDIName() {
        return this.jndiName;
    }

    public final JMSDispatcher getLeaderDispatcher() {
        return this.leaderDispatcher;
    }

    public final void setLeaderDispatcher(JMSDispatcher jMSDispatcher) {
        this.leaderDispatcher = jMSDispatcher;
    }

    public final void setLeaderJMSID(JMSID jMSID) {
        this.leaderJMSID = jMSID;
    }

    public final JMSID getLeaderJMSID() {
        return this.leaderJMSID;
    }

    public final void setLeaderSequenceNumber(long l) {
        this.leaderSequenceNumber = l;
    }

    public final long getLeaderSequenceNumber() {
        return this.leaderSequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasAggregatable() {
        SingularAggregatable singularAggregatable = this;
        synchronized (singularAggregatable) {
            return this.aggregatableCount > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBind(NamingNode namingNode, String string, Aggregatable aggregatable) {
        String string2 = null;
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("SingularAggregatable.onBind(" + string2 + ":" + this.aggregatableCount + ")");
        }
        try {
            string2 = namingNode.getNameInNamespace(string);
        }
        catch (NamingException namingException) {
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("SingularAggregatble.onBind failed with naming excption: " + namingException);
            }
            return;
        }
        catch (RemoteException remoteException) {
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("SingularAggregatble.onBind failed with remote excption: " + remoteException);
            }
            return;
        }
        SingularAggregatable singularAggregatable = aggregatable == null ? this : (SingularAggregatable)aggregatable;
        SingularAggregatableManager singularAggregatableManager = SingularAggregatableManager.findOrCreate();
        singularAggregatableManager.aggregatableDidBind(string2, singularAggregatable);
        SingularAggregatable singularAggregatable2 = this;
        synchronized (singularAggregatable2) {
            ++this.aggregatableCount;
        }
    }

    public final void onRebind(NamingNode namingNode, String string, Aggregatable aggregatable) {
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            try {
                JMSDebug.JMSCommon.debug("SingularAggregatable:onRebind(" + namingNode.getNameInNamespace(string) + ":" + this.aggregatableCount + ")");
            }
            catch (NamingException namingException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onUnbind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            if (--this.aggregatableCount <= 0) {
                this.aggregatableCount = 0;
                bl = true;
            }
        }
        object = null;
        try {
            object = namingNode.getNameInNamespace(string);
        }
        catch (NamingException namingException) {
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("SingularAggregatble.onUnBind failed with naming excption: " + namingException);
            }
            return bl;
        }
        catch (RemoteException remoteException) {
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("SingularAggregatble.onUnBind failed with remote excption: " + remoteException);
            }
            return bl;
        }
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("SingularAggregatable:onUnbind(" + (String)object + ":" + this.aggregatableCount + ")");
        }
        SingularAggregatable singularAggregatable = aggregatable == null ? this : (SingularAggregatable)aggregatable;
        LeaderManager leaderManager = LeaderManager.getLeaderManager();
        leaderManager.aggregatableDidBind((String)object, singularAggregatable.getLeaderJMSID(), singularAggregatable.getLeaderSequenceNumber());
        SingularAggregatable singularAggregatable2 = this;
        synchronized (singularAggregatable2) {
            if (--this.aggregatableCount <= 0) {
                this.aggregatableCount = 0;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "SingularAggregatable(" + this.leaderJMSID + ":" + this.leaderSequenceNumber + ")";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.leaderJMSID != null) {
            n |= 0x100;
        }
        objectOutput.writeInt(n);
        if (this.leaderJMSID != null) {
            this.leaderJMSID.writeExternal(objectOutput);
        }
        objectOutput.writeLong(this.leaderSequenceNumber);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        if ((n & 0x100) != 0) {
            this.leaderJMSID = new JMSID();
            this.leaderJMSID.readExternal(objectInput);
        }
        this.leaderSequenceNumber = objectInput.readLong();
    }
}

