/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Collection;
import java.util.Hashtable;
import javax.naming.NamingException;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterService;
import weblogic.jms.JMSService;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.common.LeaderBindFailedRequest;
import weblogic.jms.common.LeaderBindRequest;
import weblogic.jms.common.LeaderBindResponse;
import weblogic.jms.common.SingularAggregatable;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.management.provider.ManagementService;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.Request;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.work.WorkManagerFactory;

public final class SingularAggregatableManager {
    private static SingularAggregatableManager singularAggregatableManager;
    private static final AuthenticatedSubject kernelId;
    private final Hashtable pendingRequests;
    private final Hashtable boundAggregatables = new Hashtable();
    private final String serverName;

    public static synchronized SingularAggregatableManager findOrCreate() {
        if (singularAggregatableManager != null) {
            return singularAggregatableManager;
        }
        singularAggregatableManager = new SingularAggregatableManager();
        return singularAggregatableManager;
    }

    private SingularAggregatableManager() {
        this.pendingRequests = new Hashtable();
        this.serverName = ManagementService.getRuntimeAccess(kernelId).getServerName();
    }

    private static JMSDispatcher findLeader() {
        JMSDispatcher jMSDispatcher;
        ClusterService clusterService = ClusterService.getClusterService();
        ClusterMemberInfo clusterMemberInfo3 = clusterService.getLocalMember();
        if (clusterMemberInfo3 == null) {
            jMSDispatcher = JMSDispatcherManager.getLocalDispatcher();
        } else {
            String string = clusterMemberInfo3.serverName();
            Collection collection = clusterService.getRemoteMembers();
            ClusterMemberInfo clusterMemberInfo2 = clusterMemberInfo3;
            if (collection != null) {
                for (ClusterMemberInfo clusterMemberInfo3 : collection) {
                    String string2 = clusterMemberInfo3.serverName();
                    if (string.compareTo(string2) >= 0) continue;
                    clusterMemberInfo2 = clusterMemberInfo3;
                }
            }
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("SingularAggregatableManager.findLeader Leader is " + clusterMemberInfo2.serverName());
            }
            DispatcherId dispatcherId = new DispatcherId(clusterMemberInfo2.serverName(), clusterMemberInfo2.identity().getPersistentIdentity().toString());
            try {
                jMSDispatcher = JMSDispatcherManager.dispatcherFindOrCreate(dispatcherId);
            }
            catch (DispatcherException dispatcherException) {
                if (JMSDebug.JMSCommon.isDebugEnabled()) {
                    JMSDebug.JMSCommon.debug("Exception:", (Throwable)dispatcherException);
                }
                jMSDispatcher = JMSDispatcherManager.getLocalDispatcher();
            }
        }
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("SingularAggregatableManager.findLeader(" + jMSDispatcher + ")");
        }
        return jMSDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void singularBindStart(String string, SingularAggregatable singularAggregatable, weblogic.jms.dispatcher.Request request) throws JMSException {
        block12: {
            LeaderBindRequest leaderBindRequest;
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("SingularAggregatableManager.singularBindStart(" + string + ":" + singularAggregatable + ")");
            }
            if (string == null || singularAggregatable == null) {
                throw new JMSException("Invalid arguments to SingularAggregatable.bind");
            }
            singularAggregatable.setJNDIName(string);
            JMSDispatcher jMSDispatcher = SingularAggregatableManager.findLeader();
            if (jMSDispatcher == null) {
                throw new JMSException("Could not get the leader, impossible to bind");
            }
            singularAggregatable.setLeaderDispatcher(jMSDispatcher);
            Hashtable hashtable = this.pendingRequests;
            synchronized (hashtable) {
                leaderBindRequest = new LeaderBindRequest(this.serverName, string);
            }
            try {
                if (request != null) {
                    request.rememberChild(leaderBindRequest);
                    request.dispatchAsync(jMSDispatcher, (Request)leaderBindRequest);
                    break block12;
                }
                jMSDispatcher.dispatchAsync(leaderBindRequest);
                hashtable = this.pendingRequests;
                synchronized (hashtable) {
                    this.pendingRequests.put(string, leaderBindRequest);
                }
            }
            catch (DispatcherException dispatcherException) {
                throw new JMSException("Could not dispatch request to leader", (Throwable)dispatcherException);
            }
        }
    }

    private static void sendFailedToBind(SingularAggregatable singularAggregatable, LeaderBindResponse leaderBindResponse) {
        block5: {
            LeaderBindFailedRequest leaderBindFailedRequest = new LeaderBindFailedRequest(singularAggregatable.getJNDIName(), singularAggregatable.getLeaderJMSID(), singularAggregatable.getLeaderSequenceNumber());
            JMSDispatcher jMSDispatcher = singularAggregatable.getLeaderDispatcher();
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("SingularAggregatableManager.sendFailedToBind(" + singularAggregatable + ":" + leaderBindResponse + ")");
            }
            if (jMSDispatcher == null) {
                if (JMSDebug.JMSCommon.isDebugEnabled()) {
                    JMSDebug.JMSCommon.debug("SingularAggregatableManager.sendFailedToBind failed because leaderDispatcher is null");
                }
                return;
            }
            try {
                JMSServerUtilities.anonDispatchNoReply(leaderBindFailedRequest, jMSDispatcher);
            }
            catch (javax.jms.JMSException jMSException) {
                if (!JMSDebug.JMSCommon.isDebugEnabled()) break block5;
                JMSDebug.JMSCommon.debug("SingularAggregatableManager.singularBindFinish(failed to dispatch" + (Object)((Object)jMSException) + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String singularBindFinish(SingularAggregatable singularAggregatable, weblogic.jms.dispatcher.Request request) throws JMSException {
        LeaderBindResponse leaderBindResponse;
        Serializable serializable;
        Hashtable hashtable;
        Externalizable externalizable;
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("SingularAggregatableManager.singularBindFinish(" + singularAggregatable + ")");
        }
        if (singularAggregatable == null) {
            throw new JMSException("Invalid input parameters");
        }
        String string = singularAggregatable.getJNDIName();
        try {
            if (request != null && request.getChild() != null) {
                externalizable = request.useChildResult(LeaderBindResponse.class);
            } else {
                hashtable = this.pendingRequests;
                synchronized (hashtable) {
                    serializable = (LeaderBindRequest)this.pendingRequests.remove(string);
                }
                if (serializable == null) {
                    throw new JMSException("Cannot find the request to complete");
                }
                externalizable = serializable.getResult();
            }
            if (externalizable == null) {
                throw new AssertionError((Object)"In singularBindFinish the response is null");
            }
            leaderBindResponse = (LeaderBindResponse)externalizable;
        }
        catch (javax.jms.JMSException jMSException) {
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("Exception:", (Throwable)jMSException);
            }
            throw new JMSException("Unexpected response from leader", (Throwable)jMSException);
        }
        if (!leaderBindResponse.doBind()) {
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("SingularAggregatableManager.singularBindFinish leader denied request");
            }
            return leaderBindResponse.getReasonForRejection();
        }
        singularAggregatable.setLeaderJMSID(leaderBindResponse.getLeaderJMSID());
        singularAggregatable.setLeaderSequenceNumber(leaderBindResponse.getLeaderSequenceNumber());
        serializable = this.boundAggregatables;
        synchronized (serializable) {
            externalizable = this.boundAggregatables.put(string, singularAggregatable);
            if (externalizable != null) {
                this.boundAggregatables.put(string, externalizable);
            }
        }
        if (externalizable != null) {
            SingularAggregatableManager.sendFailedToBind(singularAggregatable, leaderBindResponse);
            throw new JMSException("Attempt to bind to a name we have already bound: (" + leaderBindResponse + "/" + singularAggregatable + "/" + externalizable + ")");
        }
        try {
            PrivilegedActionUtilities.bindAsSU(JMSService.getContext(), string, singularAggregatable, kernelId);
        }
        catch (NamingException namingException) {
            hashtable = this.boundAggregatables;
            synchronized (hashtable) {
                this.boundAggregatables.remove(string);
            }
            SingularAggregatableManager.sendFailedToBind(singularAggregatable, leaderBindResponse);
            throw new JMSException("Failed to bind name " + string, (Throwable)namingException);
        }
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("SingularAggregatableManager.singularBindFinish bound (" + singularAggregatable + ")");
        }
        return null;
    }

    public String singularBind(String string, SingularAggregatable singularAggregatable) throws JMSException {
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("SingularAggregatableManager.singularBind()");
        }
        this.singularBindStart(string, singularAggregatable, null);
        String string2 = this.singularBindFinish(singularAggregatable, null);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void singularUnbind(String string) throws JMSException {
        SingularAggregatable singularAggregatable;
        Serializable serializable;
        block8: {
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("SingularAggregatableManager.singularUnbind(" + string + ")");
            }
            if (string == null) {
                throw new JMSException("Invalid paramter to singularUnbind");
            }
            serializable = this.boundAggregatables;
            synchronized (serializable) {
                singularAggregatable = (SingularAggregatable)this.boundAggregatables.remove(string);
                if (singularAggregatable == null) {
                    return;
                }
            }
            try {
                PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(), string, kernelId);
            }
            catch (NamingException namingException) {
                if (!JMSDebug.JMSCommon.isDebugEnabled()) break block8;
                JMSDebug.JMSCommon.debug("SingularAggregatableManager.singularUnbind got a naming exception unbinding " + string + ";  The exception is: " + namingException);
            }
        }
        serializable = new LeaderBindResponse(true, singularAggregatable.getLeaderJMSID(), singularAggregatable.getLeaderSequenceNumber());
        SingularAggregatableManager.sendFailedToBind(singularAggregatable, (LeaderBindResponse)serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregatableDidBind(String string, SingularAggregatable singularAggregatable) {
        SingularAggregatable singularAggregatable2;
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("SingularAggregatableManager.aggregatableDidBind(" + string + ":" + singularAggregatable + ")");
        }
        if (string == null || singularAggregatable == null) {
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("SingularAggregatableManager.aggregatableDidBind failed due to bad input parameters");
            }
            return;
        }
        Hashtable hashtable = this.boundAggregatables;
        synchronized (hashtable) {
            singularAggregatable2 = (SingularAggregatable)this.boundAggregatables.get(string);
            if (singularAggregatable2 == null) {
                return;
            }
        }
        JMSID jMSID = singularAggregatable2.getLeaderJMSID();
        if (jMSID == null) {
            return;
        }
        JMSID jMSID2 = singularAggregatable.getLeaderJMSID();
        if (jMSID2 == null) {
            return;
        }
        int n = jMSID.compareTo(jMSID2);
        if (n == 0 && singularAggregatable2.getLeaderSequenceNumber() == singularAggregatable.getLeaderSequenceNumber()) {
            return;
        }
        if (n == 0) {
            n = singularAggregatable2.getLeaderSequenceNumber() <= singularAggregatable.getLeaderSequenceNumber() ? -1 : 1;
        }
        boolean bl = n > 0;
        singularAggregatable2.hadConflict(bl);
        if (!bl) {
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new SingularUnbindOnConflictThread(string));
        }
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private class SingularUnbindOnConflictThread
    implements Runnable {
        String jndiName;

        private SingularUnbindOnConflictThread(String string) {
            this.jndiName = string;
        }

        public void run() {
            try {
                SingularAggregatableManager.this.singularUnbind(this.jndiName);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }
}

