/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import weblogic.jms.JMSClientExceptionLogger;
import weblogic.jms.common.MessageFormatException;

final class TypeConverter {
    TypeConverter() {
    }

    public static boolean toBoolean(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw new MessageFormatException(JMSClientExceptionLogger.logConvertBooleanLoggable((String)object.toString()).getMessage());
    }

    public static byte toByte(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            throw new NumberFormatException(JMSClientExceptionLogger.logNullByteLoggable().getMessage());
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof String) {
            return Byte.parseByte((String)object);
        }
        throw new MessageFormatException(JMSClientExceptionLogger.logConvertByteLoggable((String)object.toString()).getMessage());
    }

    public static short toShort(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            throw new NumberFormatException(JMSClientExceptionLogger.logNullShortLoggable().getMessage());
        }
        if (object instanceof Byte || object instanceof Short) {
            return ((Number)object).shortValue();
        }
        if (object instanceof String) {
            return Short.parseShort((String)object);
        }
        throw new MessageFormatException(JMSClientExceptionLogger.logConvertShortLoggable((String)object.toString()).getMessage());
    }

    public static char toChar(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            throw new NullPointerException(JMSClientExceptionLogger.logNullCharLoggable().getMessage());
        }
        try {
            Character c = (Character)object;
            return c.charValue();
        }
        catch (ClassCastException classCastException) {
            try {
                String string = (String)object;
                if (string.length() == 1) {
                    return string.charAt(0);
                }
            }
            catch (ClassCastException classCastException2) {
                // empty catch block
            }
            throw new MessageFormatException(JMSClientExceptionLogger.logConvertCharLoggable((String)object.toString()).getMessage());
        }
    }

    public static int toInt(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            throw new NumberFormatException(JMSClientExceptionLogger.logNullIntLoggable().getMessage());
        }
        if (object instanceof Integer || object instanceof Short || object instanceof Byte) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        throw new MessageFormatException(JMSClientExceptionLogger.logConvertIntLoggable((String)object.toString()).getMessage());
    }

    public static long toLong(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            throw new NumberFormatException(JMSClientExceptionLogger.logNullLongLoggable().getMessage());
        }
        if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            return Long.parseLong((String)object);
        }
        throw new MessageFormatException(JMSClientExceptionLogger.logConvertLongLoggable((String)object.toString()).getMessage());
    }

    public static float toFloat(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            throw new NullPointerException(JMSClientExceptionLogger.logNullFloatLoggable().getMessage());
        }
        if (object instanceof Float) {
            return ((Number)object).floatValue();
        }
        if (object instanceof String) {
            return Float.valueOf((String)object).floatValue();
        }
        throw new MessageFormatException(JMSClientExceptionLogger.logConvertFloatLoggable((String)object.toString()).getMessage());
    }

    public static double toDouble(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            throw new NullPointerException(JMSClientExceptionLogger.logNullDoubleLoggable().getMessage());
        }
        if (object instanceof Double || object instanceof Float) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.valueOf((String)object);
        }
        throw new MessageFormatException(JMSClientExceptionLogger.logConvertDoubleLoggable((String)object.toString()).getMessage());
    }

    public static String toString(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            throw new MessageFormatException(JMSClientExceptionLogger.logConvertByteArrayLoggable().getMessage());
        }
        return object == null ? null : object.toString();
    }

    public static byte[] toByteArray(Object object) throws javax.jms.MessageFormatException {
        if (object == null) {
            return null;
        }
        try {
            return (byte[])object;
        }
        catch (ClassCastException classCastException) {
            throw new MessageFormatException(JMSClientExceptionLogger.logConvertToByteArrayLoggable((String)object.toString()).getMessage());
        }
    }
}

