/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.dd.DDMember;
import weblogic.jms.extensions.JMSOrderException;
import weblogic.jms.frontend.FEDDHandler;

public final class UOOHelper {
    public static boolean cacheUpToDate(FEDDHandler fEDDHandler, String string, boolean bl, MessageImpl messageImpl) {
        DDMember dDMember = fEDDHandler.findDDMemberByMemberName(string);
        if (dDMember == null) {
            return false;
        }
        if (!dDMember.hasConsumers() && bl) {
            return false;
        }
        if (dDMember.isProductionPaused() || dDMember.isInsertionPaused()) {
            return false;
        }
        return dDMember.isPersistent() || messageImpl.getAdjustedDeliveryMode() != 2;
    }

    public static boolean hasConsumers(FEDDHandler fEDDHandler, String string) {
        DDMember dDMember = fEDDHandler.findDDMemberByMemberName(string);
        return dDMember.hasConsumers();
    }

    public static DistributedDestinationImpl getHashBasedDestination(FEDDHandler fEDDHandler, String string) throws JMSException {
        DDMember dDMember;
        DDHandler dDHandler = fEDDHandler.getDDHandler();
        if (dDHandler == null) {
            throw new JMSOrderException("no ddHandler for " + fEDDHandler.getName());
        }
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = dDHandler.getNumberOfMembers()) == 0) {
                throw new JMSOrderException("no known configured members for " + dDHandler.getName());
            }
            int n3 = string.hashCode() % n2;
            if (n3 < 0) {
                n3 = -n3;
            }
            dDMember = dDHandler.getMemberByIndex(n3);
            ++n;
            if (dDMember != null) break;
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                throw new AssertionError((Object)interruptedException);
            }
            if (n >= 20) {
                throw new JMSOrderException("could not get " + n3 + " from " + dDMember.getName() + " that has size " + n2);
            }
            ++n;
        }
        if (dDMember.isUp()) {
            return dDMember.getDDImpl();
        }
        throw new JMSOrderException("hashed member of " + dDHandler.getName() + " is " + dDMember.getName() + " which is not available");
    }
}

