/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DestinationImplObserver;
import weblogic.jndi.Aggregatable;
import weblogic.jndi.OpaqueReference;
import weblogic.jndi.internal.NamingNode;

public class WrappedDestinationImpl
implements OpaqueReference,
Externalizable,
Aggregatable {
    private static DestinationImplObserver observer;
    private DestinationImpl destinationImpl;

    public WrappedDestinationImpl() {
    }

    public WrappedDestinationImpl(DestinationImpl destinationImpl) {
        this.destinationImpl = destinationImpl;
    }

    public Object getReferent(Name name, Context context) throws NamingException {
        if (this.destinationImpl == null) {
            throw new NameNotFoundException("Name not found");
        }
        return this.destinationImpl;
    }

    public String toString() {
        if (this.destinationImpl == null) {
            return null;
        }
        return this.destinationImpl.toString();
    }

    public void onBind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        DestinationImpl destinationImpl = aggregatable == null ? this.destinationImpl : ((WrappedDestinationImpl)aggregatable).destinationImpl;
        if (observer != null) {
            observer.newDestination(this.getBoundName(namingNode, string), destinationImpl);
        }
    }

    public void onRebind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        throw new NameAlreadyBoundException("Name already bound");
    }

    public boolean onUnbind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        if (observer != null) {
            observer.removeDestination(this.getBoundName(namingNode, string), this.destinationImpl);
        }
        return true;
    }

    private String getBoundName(NamingNode namingNode, String string) {
        String string2 = null;
        try {
            String string3 = namingNode.getNameInNamespace();
            string2 = string3 == null || string3.length() == 0 ? string : string3 + '.' + string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public static void setObserver(DestinationImplObserver destinationImplObserver) {
        observer = destinationImplObserver;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.destinationImpl = new DestinationImpl();
        this.destinationImpl.readExternal(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.destinationImpl.writeExternal(objectOutput);
    }
}

