/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.common;

import com.bea.wls.jms.message.BooleanType;
import com.bea.wls.jms.message.ByteType;
import com.bea.wls.jms.message.BytesType;
import com.bea.wls.jms.message.CharType;
import com.bea.wls.jms.message.DestinationType;
import com.bea.wls.jms.message.DoubleType;
import com.bea.wls.jms.message.FloatType;
import com.bea.wls.jms.message.IntType;
import com.bea.wls.jms.message.LongType;
import com.bea.wls.jms.message.MapBodyType;
import com.bea.wls.jms.message.PropertyType;
import com.bea.wls.jms.message.ShortType;
import com.bea.wls.jms.message.StreamBodyType;
import com.bea.wls.jms.message.StringType;
import com.bea.wls.jms.message.WLJMSMessageDocument;
import com.bea.xml.SchemaType;
import com.bea.xml.XmlCursor;
import com.bea.xml.XmlException;
import com.bea.xml.XmlObject;
import com.bea.xml.XmlOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.jms.common.BytesMessageImpl;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.HdrMessageImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.MapMessageImpl;
import weblogic.jms.common.MessageEOFException;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.ObjectMessageImpl;
import weblogic.jms.common.StreamMessageImpl;
import weblogic.jms.common.TextMessageImpl;
import weblogic.jms.common.XMLMessageImpl;
import weblogic.jms.extensions.WLMessage;
import weblogic.xml.jaxp.WebLogicDocumentBuilderFactory;

public class XMLHelper {
    public static Document getDocument(WLMessage wLMessage) throws javax.jms.JMSException {
        return XMLHelper.getDocument(wLMessage, null, null, true);
    }

    public static String getXMLText(WLMessage wLMessage, boolean bl) throws javax.jms.JMSException {
        WLJMSMessageDocument wLJMSMessageDocument = XMLHelper.getWLJMSMessageDocument(wLMessage, null, null, bl);
        if (wLJMSMessageDocument == null) {
            return null;
        }
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setSavePrettyPrint();
        return wLJMSMessageDocument.xmlText(xmlOptions);
    }

    public static String getXMLText(WLMessage wLMessage) throws javax.jms.JMSException {
        return XMLHelper.getXMLText(wLMessage, true);
    }

    static Document getDocument(WLMessage wLMessage, List list, List list2, boolean bl) throws javax.jms.JMSException {
        WLJMSMessageDocument wLJMSMessageDocument = XMLHelper.getWLJMSMessageDocument(wLMessage, list, list2, bl);
        if (wLJMSMessageDocument == null) {
            return null;
        }
        return (Document)wLJMSMessageDocument.newDomNode();
    }

    public static WLMessage createMessage(Document document) throws javax.jms.JMSException, IOException, ClassNotFoundException {
        Object var1_1 = null;
        try {
            WLJMSMessageDocument wLJMSMessageDocument = WLJMSMessageDocument.Factory.parse(document.getDocumentElement());
            return XMLHelper.createMessage(wLJMSMessageDocument);
        }
        catch (XmlException xmlException) {
            throw new JMSException(xmlException);
        }
    }

    public static WLMessage createMessage(String string) throws javax.jms.JMSException, IOException, ClassNotFoundException {
        try {
            WLJMSMessageDocument wLJMSMessageDocument = WLJMSMessageDocument.Factory.parse(string);
            return XMLHelper.createMessage(wLJMSMessageDocument);
        }
        catch (XmlException xmlException) {
            throw new JMSException(xmlException);
        }
    }

    private static WLMessage createMessage(WLJMSMessageDocument wLJMSMessageDocument) throws javax.jms.JMSException, IOException, ClassNotFoundException {
        WLJMSMessageDocument.WLJMSMessage wLJMSMessage = wLJMSMessageDocument.getWLJMSMessage();
        WLJMSMessageDocument.WLJMSMessage.Header header = wLJMSMessage.getHeader();
        WLJMSMessageDocument.WLJMSMessage.Body body = wLJMSMessage.getBody();
        MessageImpl messageImpl = null;
        if (body == null) {
            messageImpl = new HdrMessageImpl();
            XMLHelper.processHeader(header, messageImpl);
        } else if (body.isSetText()) {
            messageImpl = new TextMessageImpl();
            XMLHelper.processHeader(header, messageImpl);
            XMLHelper.processTextBody(body, (TextMessageImpl)messageImpl);
        } else if (body.isSetObject()) {
            messageImpl = new ObjectMessageImpl();
            XMLHelper.processHeader(header, messageImpl);
            XMLHelper.processObjectBody(body, (ObjectMessageImpl)messageImpl);
        } else if (body.isSetBytes()) {
            messageImpl = new BytesMessageImpl();
            XMLHelper.processHeader(header, messageImpl);
            XMLHelper.processBytesBody(body, (BytesMessageImpl)messageImpl);
        } else if (body.isSetStream()) {
            messageImpl = new StreamMessageImpl();
            XMLHelper.processHeader(header, messageImpl);
            XMLHelper.processStreamBody(body, (StreamMessageImpl)messageImpl);
        } else if (body.isSetMap()) {
            messageImpl = new MapMessageImpl();
            XMLHelper.processHeader(header, messageImpl);
            XMLHelper.processMapBody(body, (MapMessageImpl)messageImpl);
        } else if (body.isSetXML()) {
            messageImpl = new XMLMessageImpl();
            XMLHelper.processHeader(header, messageImpl);
            XMLHelper.processXMLBody(body, (XMLMessageImpl)messageImpl);
        } else {
            messageImpl = new HdrMessageImpl();
            XMLHelper.processHeader(header, messageImpl);
        }
        return messageImpl;
    }

    public static Document parse(String string) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder;
        WebLogicDocumentBuilderFactory webLogicDocumentBuilderFactory;
        try {
            webLogicDocumentBuilderFactory = new WebLogicDocumentBuilderFactory();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("XML Factory Configuration Error: " + factoryConfigurationError.getMessage());
            }
            throw factoryConfigurationError;
        }
        try {
            ((DocumentBuilderFactory)webLogicDocumentBuilderFactory).setNamespaceAware(true);
            documentBuilder = ((DocumentBuilderFactory)webLogicDocumentBuilderFactory).newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("Can not create XML Document Builder: " + parserConfigurationException.getMessage());
            }
            throw parserConfigurationException;
        }
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(new StringReader(string));
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("XMLMessageImpl.parse(): message :");
            JMSDebug.JMSCommon.debug(string);
        }
        Document document = null;
        try {
            document = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("Input message is not a well-formed XML message: " + sAXException.getMessage());
            }
            throw sAXException;
        }
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("Parsed DOM document is -" + document + "-");
        }
        return document;
    }

    private static WLJMSMessageDocument getWLJMSMessageDocument(WLMessage wLMessage, List list, List list2, boolean bl) throws javax.jms.JMSException {
        MessageImpl messageImpl = (MessageImpl)wLMessage;
        WLJMSMessageDocument wLJMSMessageDocument = WLJMSMessageDocument.Factory.newInstance();
        WLJMSMessageDocument.WLJMSMessage wLJMSMessage = wLJMSMessageDocument.addNewWLJMSMessage();
        XMLHelper.createHeader(wLJMSMessage, messageImpl, list, list2);
        if (bl) {
            WLJMSMessageDocument.WLJMSMessage.Body body = wLJMSMessage.addNewBody();
            switch (messageImpl.getType()) {
                case 1: {
                    XMLHelper.createBytesBody(body, (BytesMessageImpl)messageImpl);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    XMLHelper.createMapBody(body, (MapMessageImpl)messageImpl);
                    break;
                }
                case 4: {
                    XMLHelper.createObjectBody(body, (ObjectMessageImpl)messageImpl);
                    break;
                }
                case 5: {
                    XMLHelper.createStreamBody(body, (StreamMessageImpl)messageImpl);
                    break;
                }
                case 6: {
                    XMLHelper.createTextBody(body, (TextMessageImpl)messageImpl);
                    break;
                }
                case 7: {
                    try {
                        XMLHelper.createXMLBody(body, (XMLMessageImpl)messageImpl);
                        break;
                    }
                    catch (XmlException xmlException) {
                        throw new JMSException(xmlException);
                    }
                }
            }
        }
        return wLJMSMessageDocument;
    }

    private static JMSMessageId getMessageId(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<.>");
        if (!stringTokenizer.hasMoreElements()) {
            return null;
        }
        String string2 = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreElements()) {
            return null;
        }
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        return new JMSMessageId(Integer.parseInt(string3), Long.parseLong(string4), Integer.parseInt(string5));
    }

    private static void processHeader(WLJMSMessageDocument.WLJMSMessage.Header header, WLMessage wLMessage) throws javax.jms.JMSException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        Object object;
        Object object2;
        if (header.isSetJMSMessageID()) {
            object2 = (MessageImpl)wLMessage;
            object = header.getJMSMessageID();
            if (((String)object).contains("ID:N") || ((String)object).contains("ID:P")) {
                object2.setOldMessage(true);
            }
            object2.setId(XMLHelper.getMessageId((String)object));
        }
        if (header.isSetJMSCorrelationID()) {
            wLMessage.setJMSCorrelationID(header.getJMSCorrelationID());
        }
        if (header.isSetJMSDeliveryMode()) {
            object2 = header.getJMSDeliveryMode();
            wLMessage.setJMSDeliveryMode(object2.intValue() == 1 ? 2 : 1);
        }
        if (header.isSetJMSDestination()) {
            object2 = header.getJMSDestination();
            object = object2.getDestination();
            string5 = object.getName();
            string4 = object.getServerName();
            string3 = object.getServerURL();
            string2 = object.getApplicationName();
            string = object.getModuleName();
            wLMessage.setJMSDestination(new DestinationImpl(0, string4, string5, string2, string));
        }
        if (header.isSetJMSExpiration()) {
            wLMessage.setJMSExpiration(header.getJMSExpiration());
        }
        if (header.isSetJMSPriority()) {
            wLMessage.setJMSPriority(header.getJMSPriority());
        }
        if (header.isSetJMSRedelivered()) {
            wLMessage.setJMSRedelivered(header.getJMSRedelivered());
        }
        if (header.isSetJMSTimestamp()) {
            wLMessage.setJMSTimestamp(header.getJMSTimestamp());
        }
        if (header.isSetJMSReplyTo()) {
            object2 = header.getJMSReplyTo();
            object = object2.getDestination();
            string5 = object.getName();
            string4 = object.getServerName();
            string3 = object.getServerURL();
            string2 = object.getApplicationName();
            string = object.getModuleName();
            wLMessage.setJMSReplyTo(new DestinationImpl(0, string4, string5, string2, string));
        }
        if (header.isSetJMSType()) {
            wLMessage.setJMSType(header.getJMSType());
        }
        if (header.isSetProperties()) {
            XMLHelper.processHeaderProperties(header, wLMessage);
        }
        ((MessageImpl)wLMessage).includeJMSXDeliveryCount(true);
    }

    private static Element getBodyTypeElement(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        return (Element)node2.getNextSibling();
    }

    private static void processXMLBody(WLJMSMessageDocument.WLJMSMessage.Body body, XMLMessageImpl xMLMessageImpl) throws javax.jms.JMSException {
        WLJMSMessageDocument.WLJMSMessage.Body.XML xML = body.getXML();
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setUseDefaultNamespace();
        XmlCursor xmlCursor = xML.newCursor();
        boolean bl = xmlCursor.toFirstChild();
        String string = xmlCursor.xmlText(xmlOptions);
        xMLMessageImpl.setText(string);
    }

    private static void processMapBody(WLJMSMessageDocument.WLJMSMessage.Body body, MapMessageImpl mapMessageImpl) throws javax.jms.JMSException {
        MapBodyType mapBodyType = body.getMap();
        MapBodyType.NameValue[] nameValueArray = mapBodyType.getNameValueArray();
        if (nameValueArray == null) {
            return;
        }
        for (int i = 0; i < nameValueArray.length; ++i) {
            MapBodyType.NameValue nameValue = nameValueArray[i];
            String string = nameValue.getName();
            if (nameValue.isSetBoolean()) {
                mapMessageImpl.setBoolean(string, nameValue.getBoolean());
                continue;
            }
            if (nameValue.isSetByte()) {
                mapMessageImpl.setByte(string, nameValue.getByte());
                continue;
            }
            if (nameValue.isSetBytes()) {
                mapMessageImpl.setBytes(string, nameValue.getBytes());
                continue;
            }
            if (nameValue.isSetChar()) {
                mapMessageImpl.setChar(string, nameValue.getChar().charAt(0));
                continue;
            }
            if (nameValue.isSetDouble()) {
                mapMessageImpl.setDouble(string, nameValue.getDouble());
                continue;
            }
            if (nameValue.isSetFloat()) {
                mapMessageImpl.setFloat(string, nameValue.getFloat());
                continue;
            }
            if (nameValue.isSetInt()) {
                mapMessageImpl.setInt(string, nameValue.getInt().intValue());
                continue;
            }
            if (nameValue.isSetLong()) {
                mapMessageImpl.setLong(string, nameValue.getLong());
                continue;
            }
            if (nameValue.isSetShort()) {
                mapMessageImpl.setShort(string, nameValue.getShort());
                continue;
            }
            if (nameValue.isSetString()) {
                mapMessageImpl.setString(string, nameValue.getString());
                continue;
            }
            mapMessageImpl.setObject(string, null);
        }
    }

    private static void processStreamBody(WLJMSMessageDocument.WLJMSMessage.Body body, StreamMessageImpl streamMessageImpl) throws javax.jms.JMSException {
        StreamBodyType streamBodyType = body.getStream();
        XmlCursor xmlCursor = streamBodyType.newCursor();
        while (xmlCursor.hasNextToken()) {
            XmlCursor.TokenType tokenType = xmlCursor.toNextToken();
            if (!tokenType.isStart()) continue;
            XmlObject xmlObject = xmlCursor.getObject();
            SchemaType schemaType = xmlObject.schemaType();
            if (schemaType.equals(BooleanType.type)) {
                streamMessageImpl.writeBoolean(((BooleanType)xmlObject).getBooleanValue());
                continue;
            }
            if (schemaType.equals(ByteType.type)) {
                streamMessageImpl.writeByte(((ByteType)xmlObject).getByteValue());
                continue;
            }
            if (schemaType.equals(BytesType.type)) {
                streamMessageImpl.writeBytes(((BytesType)xmlObject).getByteArrayValue());
                continue;
            }
            if (schemaType.equals(CharType.type)) {
                streamMessageImpl.writeChar(((CharType)xmlObject).getStringValue().charAt(0));
                continue;
            }
            if (schemaType.equals(DoubleType.type)) {
                streamMessageImpl.writeDouble(((DoubleType)xmlObject).getDoubleValue());
                continue;
            }
            if (schemaType.equals(FloatType.type)) {
                streamMessageImpl.writeFloat(((FloatType)xmlObject).getFloatValue());
                continue;
            }
            if (schemaType.equals(IntType.type)) {
                streamMessageImpl.writeInt(((IntType)xmlObject).getBigDecimalValue().intValue());
                continue;
            }
            if (schemaType.equals(LongType.type)) {
                streamMessageImpl.writeLong(((LongType)xmlObject).getLongValue());
                continue;
            }
            if (schemaType.equals(ShortType.type)) {
                streamMessageImpl.writeShort(((ShortType)xmlObject).getShortValue());
                continue;
            }
            if (schemaType.equals(StringType.type)) {
                streamMessageImpl.writeString(((StringType)xmlObject).getStringValue());
                continue;
            }
            throw new javax.jms.JMSException("Invalid stream body type " + schemaType);
        }
    }

    private static void processBytesBody(WLJMSMessageDocument.WLJMSMessage.Body body, BytesMessageImpl bytesMessageImpl) throws javax.jms.JMSException {
        byte[] byArray = body.getBytes();
        if (byArray != null) {
            bytesMessageImpl.writeBytes(byArray);
        }
    }

    private static void processObjectBody(WLJMSMessageDocument.WLJMSMessage.Body body, ObjectMessageImpl objectMessageImpl) throws javax.jms.JMSException, IOException, ClassNotFoundException {
        byte[] byArray = body.getObject();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectMessageImpl objectMessageImpl2 = objectMessageImpl;
        objectMessageImpl2.getClass();
        ObjectMessageImpl.ObjectInputStream2 objectInputStream2 = new ObjectMessageImpl.ObjectInputStream2(objectMessageImpl2, byteArrayInputStream);
        objectMessageImpl.setObject((Serializable)objectInputStream2.readObject());
    }

    private static void processTextBody(WLJMSMessageDocument.WLJMSMessage.Body body, TextMessageImpl textMessageImpl) throws javax.jms.JMSException {
        textMessageImpl.setText(body.getText());
    }

    private static void processHeaderProperties(WLJMSMessageDocument.WLJMSMessage.Header header, WLMessage wLMessage) throws javax.jms.JMSException {
        PropertyType propertyType = header.getProperties();
        PropertyType.Property[] propertyArray = propertyType.getPropertyArray();
        if (propertyArray == null) {
            return;
        }
        for (int i = 0; i < propertyArray.length; ++i) {
            PropertyType.Property property = propertyArray[i];
            String string = property.getName();
            if (property.isSetString()) {
                wLMessage.setStringProperty(string, property.getString());
                continue;
            }
            if (property.isSetLong()) {
                wLMessage.setLongProperty(string, property.getLong());
                continue;
            }
            if (property.isSetShort()) {
                wLMessage.setShortProperty(string, property.getShort());
                continue;
            }
            if (property.isSetInt()) {
                wLMessage.setIntProperty(string, property.getInt().intValue());
                continue;
            }
            if (property.isSetFloat()) {
                wLMessage.setFloatProperty(string, property.getFloat());
                continue;
            }
            if (property.isSetDouble()) {
                wLMessage.setDoubleProperty(string, property.getDouble());
                continue;
            }
            if (property.isSetByte()) {
                wLMessage.setByteProperty(string, property.getByte());
                continue;
            }
            if (property.isSetBoolean()) {
                wLMessage.setBooleanProperty(string, property.getBoolean());
                continue;
            }
            wLMessage.setObjectProperty(string, null);
        }
    }

    private static void createHeader(WLJMSMessageDocument.WLJMSMessage wLJMSMessage, MessageImpl messageImpl, List list, List list2) throws javax.jms.JMSException {
        DestinationType.Destination destination;
        DestinationType destinationType;
        Object object;
        WLJMSMessageDocument.WLJMSMessage.Header header = wLJMSMessage.addNewHeader();
        if ((list == null || list.contains("JMSMessageID")) && (object = messageImpl.getJMSMessageID()) != null) {
            header.setJMSMessageID((String)object);
        }
        if ((list == null || list.contains("JMSCorrelationID")) && (object = messageImpl.getJMSCorrelationID()) != null) {
            header.setJMSCorrelationID((String)object);
        }
        if ((list == null || list.contains("JMSType")) && (object = messageImpl.getJMSType()) != null) {
            header.setJMSType((String)object);
        }
        if (list == null || list.contains("JMSDeliveryMode")) {
            header.setJMSDeliveryMode(messageImpl.getJMSDeliveryMode() == 2 ? WLJMSMessageDocument.WLJMSMessage.Header.JMSDeliveryMode.PERSISTENT : WLJMSMessageDocument.WLJMSMessage.Header.JMSDeliveryMode.NON_PERSISTENT);
        }
        if ((list == null || list.contains("JMSDestination")) && (object = messageImpl.getDestination()) != null) {
            destinationType = header.addNewJMSDestination();
            destination = destinationType.addNewDestination();
            destination.setName(((DestinationImpl)object).getDestinationName());
            destination.setServerName(((DestinationImpl)object).getServerName());
            destination.setApplicationName(((DestinationImpl)object).getApplicationName());
            destination.setModuleName(((DestinationImpl)object).getModuleName());
        }
        if (list == null || list.contains("JMSExpiration")) {
            header.setJMSExpiration(messageImpl.getJMSExpiration());
        }
        if (list == null || list.contains("JMSPriority")) {
            header.setJMSPriority(messageImpl.getJMSPriority());
        }
        if (list == null || list.contains("JMSRedelivered")) {
            header.setJMSRedelivered(messageImpl.getJMSRedelivered());
        }
        if (list == null || list.contains("JMSTimestamp")) {
            header.setJMSTimestamp(messageImpl.getJMSTimestamp());
        }
        if ((list == null || list.contains("JMSReplyTo")) && (object = (DestinationImpl)messageImpl.getJMSReplyTo()) != null) {
            destinationType = header.addNewJMSReplyTo();
            destination = destinationType.addNewDestination();
            destination.setName(((DestinationImpl)object).getDestinationName());
            destination.setServerName(((DestinationImpl)object).getServerName());
            destination.setApplicationName(((DestinationImpl)object).getApplicationName());
            destination.setModuleName(((DestinationImpl)object).getModuleName());
        }
        XMLHelper.createHeaderProperties(header, messageImpl, list2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createHeaderProperties(WLJMSMessageDocument.WLJMSMessage.Header header, MessageImpl messageImpl, List list) throws javax.jms.JMSException {
        String string;
        Enumeration enumeration = null;
        boolean bl = messageImpl.includeJMSXDeliveryCount(true);
        try {
            enumeration = messageImpl.getPropertyNames();
            string = null;
            messageImpl.includeJMSXDeliveryCount(bl);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            messageImpl.includeJMSXDeliveryCount(bl);
            throw throwable;
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return;
        }
        PropertyType propertyType = header.addNewProperties();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (list != null && !list.contains("%properties%") && !list.contains(string)) continue;
            PropertyType.Property property = propertyType.addNewProperty();
            property.setName(string);
            Object object = messageImpl.getObjectProperty(string);
            if (object instanceof String) {
                property.setString((String)object);
                continue;
            }
            if (object instanceof Long) {
                property.setLong((Long)object);
                continue;
            }
            if (object instanceof Short) {
                property.setShort((Short)object);
                continue;
            }
            if (object instanceof Integer) {
                property.setInt(BigInteger.valueOf(((Integer)object).longValue()));
                continue;
            }
            if (object instanceof Float) {
                property.setFloat(((Float)object).floatValue());
                continue;
            }
            if (object instanceof Double) {
                property.setDouble((Double)object);
                continue;
            }
            if (object instanceof Byte) {
                property.setByte((Byte)object);
                continue;
            }
            if (!(object instanceof Boolean)) continue;
            property.setBoolean((Boolean)object);
        }
    }

    private static void createTextBody(WLJMSMessageDocument.WLJMSMessage.Body body, TextMessageImpl textMessageImpl) throws javax.jms.JMSException {
        body.setText(textMessageImpl.getText());
    }

    private static void createStreamBody(WLJMSMessageDocument.WLJMSMessage.Body body, StreamMessageImpl streamMessageImpl) throws javax.jms.JMSException {
        block13: {
            Object object;
            StreamBodyType streamBodyType = body.addNewStream();
            StreamMessageImpl streamMessageImpl2 = (StreamMessageImpl)streamMessageImpl.copy();
            while (true) {
                try {
                    object = streamMessageImpl2.readObject();
                }
                catch (MessageEOFException messageEOFException) {
                    break block13;
                }
                if (object == null) continue;
                if (object instanceof byte[]) {
                    streamBodyType.addBytes((byte[])object);
                    continue;
                }
                if (object instanceof Number) {
                    if (object instanceof Byte) {
                        streamBodyType.addByte((Byte)object);
                        continue;
                    }
                    if (object instanceof Short) {
                        streamBodyType.addShort((Short)object);
                        continue;
                    }
                    if (object instanceof Integer) {
                        streamBodyType.addInt(BigInteger.valueOf(((Integer)object).longValue()));
                        continue;
                    }
                    if (object instanceof Long) {
                        streamBodyType.addLong((Long)object);
                        continue;
                    }
                    if (object instanceof Float) {
                        streamBodyType.addFloat(((Float)object).floatValue());
                        continue;
                    }
                    if (object instanceof Double) {
                        streamBodyType.addDouble((Double)object);
                        continue;
                    }
                    throw new javax.jms.JMSException("Invalid Stream value type " + object.getClass().getName());
                }
                if (object instanceof Boolean) {
                    streamBodyType.addBoolean((Boolean)object);
                    continue;
                }
                if (object instanceof String) {
                    streamBodyType.addString((String)object);
                    continue;
                }
                if (!(object instanceof Character)) break;
                streamBodyType.addChar(object.toString());
            }
            throw new javax.jms.JMSException("Invalid Stream value type " + object.getClass().getName());
        }
    }

    private static void createBytesBody(WLJMSMessageDocument.WLJMSMessage.Body body, BytesMessageImpl bytesMessageImpl) throws javax.jms.JMSException {
        BytesMessageImpl bytesMessageImpl2 = (BytesMessageImpl)bytesMessageImpl.copy();
        bytesMessageImpl2.decompressMessageBody();
        byte[] byArray = bytesMessageImpl2.getBodyBytes();
        body.setBytes(byArray);
    }

    private static void createMapBody(WLJMSMessageDocument.WLJMSMessage.Body body, MapMessageImpl mapMessageImpl) throws javax.jms.JMSException {
        MapBodyType mapBodyType = body.addNewMap();
        Enumeration enumeration = mapMessageImpl.getMapNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            MapBodyType.NameValue nameValue = mapBodyType.addNewNameValue();
            nameValue.setName(string);
            Object object = mapMessageImpl.getObject(string);
            if (object == null) continue;
            if (object instanceof byte[]) {
                nameValue.setBytes((byte[])object);
                continue;
            }
            if (object instanceof Number) {
                if (object instanceof Byte) {
                    nameValue.setByte((Byte)object);
                    continue;
                }
                if (object instanceof Short) {
                    nameValue.setShort((Short)object);
                    continue;
                }
                if (object instanceof Integer) {
                    nameValue.setInt(BigInteger.valueOf(((Integer)object).longValue()));
                    continue;
                }
                if (object instanceof Long) {
                    nameValue.setLong((Long)object);
                    continue;
                }
                if (object instanceof Float) {
                    nameValue.setFloat(((Float)object).floatValue());
                    continue;
                }
                if (object instanceof Double) {
                    nameValue.setDouble((Double)object);
                    continue;
                }
                throw new javax.jms.JMSException("Invalid Map value type " + object.getClass().getName());
            }
            if (object instanceof Boolean) {
                nameValue.setBoolean((Boolean)object);
                continue;
            }
            if (object instanceof String) {
                nameValue.setString((String)object);
                continue;
            }
            if (object instanceof Character) {
                nameValue.setChar(((Character)object).toString());
                continue;
            }
            throw new javax.jms.JMSException("Invalid Map value type " + object.getClass().getName());
        }
    }

    private static void createObjectBody(WLJMSMessageDocument.WLJMSMessage.Body body, ObjectMessageImpl objectMessageImpl) throws javax.jms.JMSException {
        objectMessageImpl.decompressMessageBody();
        body.setObject(objectMessageImpl.getBodyBytes());
    }

    private static void createXMLBody(WLJMSMessageDocument.WLJMSMessage.Body body, XMLMessageImpl xMLMessageImpl) throws XmlException, javax.jms.JMSException {
        WLJMSMessageDocument.WLJMSMessage.Body.XML xML = body.addNewXML();
        xML.set(XmlObject.Factory.parse((Node)xMLMessageImpl.getDocument()));
    }
}

