/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BEUOOQueueState;
import weblogic.jms.backend.QueueForwardingManager;
import weblogic.jms.backend.TopicForwardingManager;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.dd.DDConfig;
import weblogic.jms.dd.DDManager;
import weblogic.jms.dd.DDMember;
import weblogic.jms.dd.DDScheduler;
import weblogic.jms.dd.DDStatusListener;
import weblogic.jms.dd.DDStatusSharer;
import weblogic.jms.dd.MemberStatusListener;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.frontend.FEDDHandler;
import weblogic.messaging.dispatcher.DispatcherId;

public final class DDHandler
implements MemberStatusListener,
Runnable {
    public static final int NO_EVENT = 0;
    public static final int MEMBERSHIP_CHANGE = 1;
    public static final int MEMBER_STATUS_CHANGE = 2;
    public static final int DD_PARAM_CHANGE = 4;
    public static final int ACTIVATE = 8;
    public static final int DEACTIVATE = 16;
    public static final int ANY_CHANGE = 255;
    private List listeners = new LinkedList();
    private static List generalListeners;
    private static Object generalLock;
    private HashMap members = new HashMap();
    private List memberList = new ArrayList();
    private FEDDHandler feDDHandler;
    private DDConfig ddConfig = null;
    private DistributedDestinationImpl ddImpl = null;
    private int events = 0;
    private String name = null;
    private String safExportPolicy = null;
    private String unitOfOrderRouting = null;
    private String jndiName = null;
    private int loadBalancingPolicyAsInt;
    private String applicationName = null;
    private String EARModuleName = null;
    private String referenceName = null;
    private int queueForwardDelay;
    private boolean resetDeliveryCount = true;
    private boolean active = false;
    private boolean local = false;
    private boolean isQueue;
    private boolean setupForwarding;
    private boolean isUOWDestination = false;
    private boolean remoteUpdatePending = false;
    private int forwardingPolicy = 1;
    private boolean defaultUnitOfOrder = false;

    public DDHandler() {
    }

    public DDHandler(DDConfig dDConfig, boolean bl) {
        this.name = dDConfig.getName();
        this.ddConfig = dDConfig;
        this.isQueue = dDConfig.getType() == 0;
        this.safExportPolicy = dDConfig.getSAFExportPolicy();
        this.unitOfOrderRouting = dDConfig.getUnitOfOrderRouting();
        this.jndiName = dDConfig.getJNDIName();
        this.loadBalancingPolicyAsInt = dDConfig.getLoadBalancingPolicyAsInt();
        this.applicationName = dDConfig.getApplicationName();
        this.EARModuleName = dDConfig.getEARModuleName();
        this.referenceName = dDConfig.getReferenceName();
        this.queueForwardDelay = dDConfig.getForwardDelay();
        this.resetDeliveryCount = dDConfig.getResetDeliveryCountOnForward();
        this.setupForwarding = bl;
        this.local = true;
        this.defaultUnitOfOrder = dDConfig.isDefaultUnitOfOrder();
    }

    public int getForwardingPolicy() {
        return this.forwardingPolicy;
    }

    public void setForwardingPolicy(int n) {
        if (n != 1 && n != 0) {
            throw new RuntimeException("Invalid forwarding policy value (" + n + ") found. Valid forwarding policies are" + " the constants from DDConstants(DDConstants.FORWARDING_POLICY_PARTITIONED(value=" + 0 + ") or DDConstants.FORWARDING_POLICY_REPLICATED" + "(value=" + 1 + ")");
        }
        this.forwardingPolicy = n;
    }

    public void activate() {
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("activating " + this.name);
        }
        this.feDDHandler = new FEDDHandler(this);
        new DDStatusSharer(this);
        this.active = true;
        this.addEvent(8);
    }

    public synchronized void deactivate() {
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Deactivating " + this.name);
        }
        this.updateMembers(new LinkedList());
        this.addEvent(16);
        DDManager.deactivate(this);
        this.active = false;
        this.feDDHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateMembers(List list) {
        if (list == null) {
            return;
        }
        int n = 0;
        HashMap hashMap = this.members;
        synchronized (hashMap) {
            try {
                Object object;
                ListIterator listIterator = this.memberCloneIterator();
                while (listIterator.hasNext()) {
                    object = (DDMember)listIterator.next();
                    if (list.contains(((DDMember)object).getName())) continue;
                    n |= this.removeMemberWithoutEvent(((DDMember)object).getName());
                }
                listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    object = (String)listIterator.next();
                    n |= this.addMemberWithoutEvent((String)object);
                }
                Object var7_6 = null;
                if (n != 0) {
                    this.addEvent(n);
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (n != 0) {
                    this.addEvent(n);
                }
                throw throwable;
            }
        }
    }

    public void update(DDHandler dDHandler) {
        if (this.local && !dDHandler.local) {
            this.remoteUpdatePending = true;
        }
        if (dDHandler.local) {
            this.local = true;
            this.ddConfig = dDHandler.ddConfig;
        }
        this.setSAFExportPolicy(dDHandler.safExportPolicy);
        this.setUnitOfOrderRouting(dDHandler.unitOfOrderRouting);
        this.setDefaultUnitOfOrder(dDHandler.defaultUnitOfOrder);
        this.setJNDIName(dDHandler.jndiName);
        this.setLoadBalancingPolicyAsInt(dDHandler.loadBalancingPolicyAsInt);
        this.setForwardingPolicy(dDHandler.forwardingPolicy);
        this.setForwardDelay(dDHandler.queueForwardDelay);
        this.setResetDeliveryCountOnForward(dDHandler.resetDeliveryCount);
        this.setApplicationName(dDHandler.applicationName);
        this.setEARModuleName(dDHandler.EARModuleName);
        this.setReferenceName(dDHandler.referenceName);
        this.setupForwarding |= dDHandler.setupForwarding;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isQueue() {
        return this.isQueue;
    }

    public void setIsQueue(boolean bl) {
        this.isQueue = bl;
    }

    public void setEARModuleName(String string) {
        this.EARModuleName = string;
    }

    public void setReferenceName(String string) {
        this.referenceName = string;
    }

    public FEDDHandler getFEDDHandler() {
        return this.feDDHandler;
    }

    public String getEARModuleName() {
        return this.EARModuleName;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberStatusListener(String string, MemberStatusListener memberStatusListener) {
        DDMember dDMember = null;
        HashMap hashMap = this.members;
        synchronized (hashMap) {
            dDMember = (DDMember)this.members.get(string);
        }
        assert (dDMember != null);
        dDMember.addStatusListener(memberStatusListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGeneralStatusListener(DDStatusListener dDStatusListener, int n) {
        Object object = generalLock;
        synchronized (object) {
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("Adding general listener: " + dDStatusListener + ", listening for " + n + " on everything");
            }
            LinkedList linkedList = new LinkedList();
            if (generalListeners != null) {
                ListIterator listIterator = generalListeners.listIterator();
                while (listIterator.hasNext()) {
                    linkedList.add(listIterator.next());
                }
            }
            linkedList.add(new ListenerObject(dDStatusListener, n));
            generalListeners = linkedList;
        }
    }

    public synchronized void addStatusListener(DDStatusListener dDStatusListener, int n) {
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Adding listener: " + dDStatusListener + ", listening for " + n + " on " + this.name + ", this is " + this);
        }
        this.listeners.add(new ListenerObject(dDStatusListener, n));
    }

    public synchronized void removeStatusListener(DDStatusListener dDStatusListener) {
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Removing listener: " + dDStatusListener + " for " + this.name + ", this is " + this);
        }
        ListIterator listIterator = this.listeners.listIterator();
        while (listIterator.hasNext()) {
            ListenerObject listenerObject = (ListenerObject)listIterator.next();
            if (listenerObject.listener != dDStatusListener) continue;
            listIterator.remove();
        }
    }

    public void run() {
        this.callListeners();
    }

    private static String append(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string + "|" + string2;
    }

    private static String eventsPrint(int n) {
        String string = null;
        if ((n & 1) != 0) {
            string = DDHandler.append(string, "MEMBERSHIP_CHANGE");
        }
        if ((n & 2) != 0) {
            string = DDHandler.append(string, "MEMBER_STATUS_CHANGE");
        }
        if ((n & 4) != 0) {
            string = DDHandler.append(string, "DD_PARAM_CHANGE");
        }
        if ((n & 8) != 0) {
            string = DDHandler.append(string, "ACTIVATE");
        }
        if ((n & 0x10) != 0) {
            string = DDHandler.append(string, "DEACTIVATE");
        }
        return string;
    }

    private void callListener(ListenerObject listenerObject, int n) {
        DDStatusListener dDStatusListener = listenerObject.listener;
        if ((listenerObject.toWhat & n) != 0) {
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("Calling out to " + dDStatusListener);
            }
            try {
                dDStatusListener.statusChangeNotification(this, n);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("Back from " + dDStatusListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callListeners() {
        LinkedList linkedList;
        int n;
        ListIterator listIterator = this;
        synchronized (listIterator) {
            if (this.events == 0) {
                return;
            }
            n = this.events;
            this.events = 0;
            linkedList = new LinkedList(this.listeners);
        }
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Events is " + DDHandler.eventsPrint(n) + " for " + this.name + ", this is " + this);
        }
        listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            this.callListener((ListenerObject)listIterator.next(), n);
        }
        if (generalListeners != null) {
            listIterator = generalListeners.listIterator();
            while (listIterator.hasNext()) {
                this.callListener((ListenerObject)listIterator.next(), n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addEvent(int n) {
        if (!this.active) {
            return;
        }
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Adding event to " + this.name + ": " + DDHandler.eventsPrint(n));
        }
        DDHandler dDHandler = this;
        synchronized (dDHandler) {
            this.events |= n;
        }
        DDScheduler.schedule(this);
    }

    public void memberStatusChange(DDMember dDMember, int n) {
        this.addEvent(2);
    }

    private boolean equal(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public String getSAFExportPolicy() {
        return this.safExportPolicy;
    }

    public void setSAFExportPolicy(String string) {
        if (!this.equal(string, this.safExportPolicy)) {
            this.safExportPolicy = string;
            this.addEvent(4);
        }
    }

    public boolean isUOWDestination() {
        return this.isUOWDestination;
    }

    public void setIsUOWDestination(boolean bl) {
        if (bl != this.isUOWDestination) {
            this.isUOWDestination = bl;
            this.addEvent(4);
        }
    }

    public String getUnitOfOrderRouting() {
        return this.unitOfOrderRouting;
    }

    public void setUnitOfOrderRouting(String string) {
        if (!this.equal(this.unitOfOrderRouting, string)) {
            this.unitOfOrderRouting = string;
            this.addEvent(4);
        }
    }

    public boolean isDefaultUnitOfOrder() {
        return this.defaultUnitOfOrder;
    }

    public void setDefaultUnitOfOrder(boolean bl) {
        if (this.defaultUnitOfOrder != bl) {
            this.defaultUnitOfOrder = bl;
            this.addEvent(4);
        }
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String string) {
        if (!this.equal(this.jndiName, string)) {
            this.jndiName = string;
            this.addEvent(4);
        }
    }

    public int getLoadBalancingPolicyAsInt() {
        return this.loadBalancingPolicyAsInt;
    }

    public void setLoadBalancingPolicyAsInt(int n) {
        if (this.loadBalancingPolicyAsInt != n) {
            this.loadBalancingPolicyAsInt = n;
            this.addEvent(4);
        }
    }

    public int getForwardDelay() {
        return this.queueForwardDelay;
    }

    public void setForwardDelay(int n) {
        if (this.queueForwardDelay != n) {
            this.queueForwardDelay = n;
            this.addEvent(4);
        }
    }

    public boolean getResetDeliveryCountOnForward() {
        return this.resetDeliveryCount;
    }

    public void setResetDeliveryCountOnForward(boolean bl) {
        if (this.resetDeliveryCount != bl) {
            this.resetDeliveryCount = bl;
            this.addEvent(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberUpdate(DDMember dDMember) {
        DDMember dDMember2 = null;
        HashMap hashMap = this.members;
        synchronized (hashMap) {
            dDMember2 = (DDMember)this.members.get(dDMember.getName());
        }
        if (dDMember2 == null) {
            return;
        }
        dDMember2.update(dDMember);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMembers(String[] stringArray, BEDestinationImpl[] bEDestinationImplArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int n = 0;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                n |= this.addMemberWithoutEvent(stringArray[i], bEDestinationImplArray[i]);
            }
            Object var6_5 = null;
            if (n != 0) {
                this.addEvent(n);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (n != 0) {
                this.addEvent(n);
            }
            throw throwable;
        }
    }

    private int addMemberWithoutEvent(String string) {
        if (JMSService.getJMSService() == null || JMSService.getJMSService().getBEDeployer() == null) {
            return 0;
        }
        return this.addMemberWithoutEvent(string, JMSService.getJMSService().getBEDeployer().findBEDestination(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addMemberWithoutEvent(String string, BEDestinationImpl bEDestinationImpl) {
        DDMember dDMember = this.findMemberByName(string);
        if (dDMember != null) {
            if (this.local && bEDestinationImpl != null) {
                this.setDestination(dDMember, bEDestinationImpl);
                return 2;
            }
            return 0;
        }
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Adding member " + string + " to " + this.name);
        }
        if ((dDMember = DDManager.removeDeferredMember(string)) == null) {
            dDMember = new DDMember(string);
        }
        HashMap hashMap = this.members;
        synchronized (hashMap) {
            this.members.put(string, dDMember);
            this.memberList.add(dDMember);
        }
        DDManager.addDDHandlerMember(string, this);
        if (this.local && bEDestinationImpl != null) {
            this.setDestination(dDMember, bEDestinationImpl);
        }
        dDMember.setDDHandler(this);
        dDMember.addStatusListener(this);
        return 1;
    }

    public void addMember(String string) {
        if (JMSService.getJMSService() != null && JMSService.getJMSService().getBEDeployer() != null) {
            this.addMember(string, JMSService.getJMSService().getBEDeployer().findBEDestination(string));
        }
    }

    public void addMember(String string, BEDestinationImpl bEDestinationImpl) {
        int n = this.addMemberWithoutEvent(string, bEDestinationImpl);
        if (n != 0) {
            this.addEvent(n);
        }
    }

    public void setMemberWeight(String string, int n) {
        DDMember dDMember = this.findMemberByName(string);
        dDMember.setWeight(n);
    }

    private void setDestination(DDMember dDMember, BEDestinationImpl bEDestinationImpl) {
        if (dDMember.getDestination() != null) {
            return;
        }
        dDMember.setDestination(bEDestinationImpl);
        this.setIsUOWDestination(dDMember.isUOWDestination());
        if (this.setupForwarding) {
            if (this.isQueue) {
                new QueueForwardingManager(this, dDMember);
            } else if (this.forwardingPolicy == 1) {
                new TopicForwardingManager(this, dDMember, bEDestinationImpl);
            } else {
                dDMember.setIsForwardingUp(true);
            }
        } else {
            dDMember.setIsForwardingUp(true);
        }
        if (this.isQueue && "PathService".equals(this.getUnitOfOrderRouting())) {
            bEDestinationImpl.setExtension(new BEUOOQueueState(bEDestinationImpl, this));
        }
    }

    public void removeMember(String string) {
        this.addEvent(this.removeMemberWithoutEvent(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeMemberWithoutEvent(String string) {
        DDManager.removeDDHandlerMember(string);
        HashMap hashMap = this.members;
        synchronized (hashMap) {
            DDMember dDMember = (DDMember)this.members.remove(string);
            if (dDMember != null) {
                if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                    JMSDebug.JMSDistTopic.debug("Removing member " + string + " from " + this.name);
                }
                this.memberList.remove(dDMember);
                dDMember.removeStatusListener(this);
                dDMember.notAMember();
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedDestinationImpl getDDImpl() {
        Object object;
        if (this.ddImpl != null) {
            return this.ddImpl;
        }
        String string = null;
        JMSServerId jMSServerId = null;
        JMSID jMSID = null;
        Object object2 = this.members;
        synchronized (object2) {
            if (!this.members.isEmpty() && (object = (DDMember)this.members.values().iterator().next()) != null) {
                string = ((DDMember)object).getName();
                jMSServerId = ((DDMember)object).getBackEndId();
                jMSID = ((DDMember)object).getDestinationId();
            }
        }
        object2 = JMSDispatcherManager.getLocalDispatcher();
        assert (object2 != null);
        object = object2.getId();
        this.ddImpl = new DistributedDestinationImpl(this.isQueue ? 1 : 2, "", this.name, this.getApplicationName(), this.getEARModuleName(), this.getLoadBalancingPolicyAsInt(), this.getForwardingPolicy(), string, this.jndiName, jMSServerId, jMSID, (DispatcherId)object, false, "", this.safExportPolicy, false);
        return this.ddImpl;
    }

    public DistributedDestinationImpl getDDIByMemberName(String string) {
        DDMember dDMember = this.findMemberByName(string);
        assert (dDMember != null);
        return dDMember.getDDImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DDMember findMemberByName(String string) {
        HashMap hashMap = this.members;
        synchronized (hashMap) {
            return (DDMember)this.members.get(string);
        }
    }

    public String debugKeys() {
        Set set = ((HashMap)this.members.clone()).keySet();
        if (set == null) {
            return "DDHandler keys are null";
        }
        Iterator iterator = ((HashMap)this.members.clone()).values().iterator();
        String string = "\nvalues:";
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                DDMember dDMember = (DDMember)iterator.next();
                string = string + "\n(" + dDMember + ")";
            }
        } else {
            string = "\n no values";
        }
        return set.toString() + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean memberHasSecurityMode(int n) {
        HashMap hashMap = this.members;
        synchronized (hashMap) {
            for (DDMember dDMember : this.members.values()) {
                if (dDMember.getRemoteSecurityMode() != n) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List memberCloneList() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashMap hashMap = this.members;
        synchronized (hashMap) {
            for (DDMember dDMember : this.members.values()) {
                try {
                    linkedList.add(dDMember.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new AssertionError((Object)"I can't clone a member");
                }
            }
        }
        return linkedList;
    }

    public Iterator memberCloneIterator() {
        return this.memberCloneList().listIterator();
    }

    public String toString() {
        return "DDHandler: " + this.name + ", hash: " + this.hashCode() + ", dd: " + this.ddImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfMembers() {
        HashMap hashMap = this.members;
        synchronized (hashMap) {
            return this.members.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DDMember getMemberByIndex(int n) {
        HashMap hashMap = this.members;
        synchronized (hashMap) {
            return (DDMember)this.memberList.get(n);
        }
    }

    public void newDestination(BEDestinationImpl bEDestinationImpl) {
        if (!this.local) {
            return;
        }
        DDMember dDMember = this.findMemberByName(bEDestinationImpl.getName());
        if (dDMember == null) {
            return;
        }
        this.setDestination(dDMember, bEDestinationImpl);
    }

    public boolean isRemoteUpdatePending() {
        return this.remoteUpdatePending;
    }

    public void setRemoteUpdatePending(boolean bl) {
        this.remoteUpdatePending = bl;
    }

    static {
        generalLock = new Object();
    }

    private static class ListenerObject {
        int toWhat;
        DDStatusListener listener;

        ListenerObject(DDStatusListener dDStatusListener, int n) {
            this.toWhat = n;
            this.listener = dDStatusListener;
        }
    }
}

