/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dd;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.NewDestinationListener;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.dd.DDMember;
import weblogic.jms.dd.MemberStatusListener;
import weblogic.jms.frontend.FEDDHandler;

public final class DDManager
implements NewDestinationListener {
    private static HashMap deferredMemberTable = new HashMap();
    private static HashMap member2DDHandler = new HashMap();
    private static Hashtable name2DDHandler = new Hashtable();

    private DDManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DDHandler activateOrUpdate(DDHandler dDHandler) {
        Hashtable hashtable = name2DDHandler;
        synchronized (hashtable) {
            DDHandler dDHandler2 = (DDHandler)name2DDHandler.get(dDHandler.getName());
            if (dDHandler2 != null) {
                dDHandler2.update(dDHandler);
                return dDHandler2;
            }
            name2DDHandler.put(dDHandler.getName(), dDHandler);
            dDHandler.activate();
        }
        return dDHandler;
    }

    public static void remoteUpdate(DDHandler dDHandler, List list) {
        DDHandler dDHandler2 = DDManager.activateOrUpdate(dDHandler);
        if (!dDHandler2.isLocal()) {
            dDHandler2.updateMembers(list);
        } else if (dDHandler2.isRemoteUpdatePending()) {
            dDHandler2.updateMembers(list);
            dDHandler2.setRemoteUpdatePending(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remoteDeactivate(String string) {
        Hashtable hashtable = name2DDHandler;
        synchronized (hashtable) {
            DDHandler dDHandler = (DDHandler)name2DDHandler.get(string);
            if (dDHandler == null) {
                return;
            }
            if (dDHandler.isLocal()) {
                return;
            }
            dDHandler.deactivate();
        }
    }

    public static void deactivate(DDHandler dDHandler) {
        name2DDHandler.remove(dDHandler.getName());
    }

    private static void deferMember(DDMember dDMember) {
        deferredMemberTable.put(dDMember.getName(), dDMember);
    }

    public static DDMember removeDeferredMember(String string) {
        return (DDMember)deferredMemberTable.remove(string);
    }

    public static void memberUpdate(DDMember dDMember) {
        DDHandler dDHandler = DDManager.findDDHandlerByMemberName(dDMember.getName());
        if (dDHandler == null) {
            DDManager.deferMember(dDMember);
        } else {
            dDHandler.memberUpdate(dDMember);
        }
    }

    public static void addMemberStatusListener(String string, MemberStatusListener memberStatusListener) {
        DDHandler dDHandler = DDManager.findDDHandlerByMemberName(string);
        assert (dDHandler != null);
        dDHandler.addMemberStatusListener(string, memberStatusListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DDHandler findDDHandlerByMemberName(String string) {
        HashMap hashMap = member2DDHandler;
        synchronized (hashMap) {
            return (DDHandler)member2DDHandler.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDDHandlerMember(String string, DDHandler dDHandler) {
        HashMap hashMap = member2DDHandler;
        synchronized (hashMap) {
            member2DDHandler.put(string, dDHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DDHandler removeDDHandlerMember(String string) {
        HashMap hashMap = member2DDHandler;
        synchronized (hashMap) {
            return (DDHandler)member2DDHandler.remove(string);
        }
    }

    public static boolean isMember(String string, String string2) {
        DDHandler dDHandler = DDManager.findDDHandlerByMemberName(string2);
        if (dDHandler == null) {
            return false;
        }
        return dDHandler.getName().equals(string);
    }

    public static boolean isDD(String string) {
        return DDManager.findDDHandlerByDDName(string) != null;
    }

    public static DDHandler findDDHandlerByDDName(String string) {
        return (DDHandler)name2DDHandler.get(string);
    }

    public static FEDDHandler findFEDDHandlerByDDName(String string) {
        DDHandler dDHandler = DDManager.findDDHandlerByDDName(string);
        if (dDHandler == null) {
            return null;
        }
        return dDHandler.getFEDDHandler();
    }

    public static DistributedDestinationImpl findDDImplByDDName(String string) {
        DDHandler dDHandler = DDManager.findDDHandlerByDDName(string);
        if (dDHandler == null) {
            return null;
        }
        return dDHandler.getDDImpl();
    }

    public static boolean handlerHasSecurityModeByMemberName(String string, int n) {
        DDHandler dDHandler = DDManager.findDDHandlerByMemberName(string);
        if (dDHandler == null) {
            return false;
        }
        return dDHandler.memberHasSecurityMode(n);
    }

    public static DistributedDestinationImpl findDDImplByMemberName(String string) {
        DDHandler dDHandler = DDManager.findDDHandlerByMemberName(string);
        if (dDHandler == null) {
            return null;
        }
        return dDHandler.getDDIByMemberName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String debugKeys() {
        Set set;
        String string = "\n values are ";
        HashMap hashMap = member2DDHandler;
        synchronized (hashMap) {
            set = ((HashMap)member2DDHandler.clone()).keySet();
            Iterator iterator = ((HashMap)member2DDHandler.clone()).values().iterator();
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    DDHandler dDHandler = (DDHandler)iterator.next();
                    string = string + "\n(" + dDHandler + " keys: " + dDHandler.debugKeys() + ")";
                }
            } else {
                string = "\n no values";
            }
        }
        if (set == null) {
            return "DDManager keys are null";
        }
        return "DDManager Member Name keys are: " + set.toString() + string;
    }

    public static DDMember findDDMemberByMemberName(String string) {
        DDHandler dDHandler = DDManager.findDDHandlerByMemberName(string);
        if (dDHandler == null) {
            return null;
        }
        return dDHandler.findMemberByName(string);
    }

    public static Iterator getAllDDHandlers() {
        return name2DDHandler.values().iterator();
    }

    public void newDestination(BEDestinationImpl bEDestinationImpl) {
        DDHandler dDHandler = DDManager.findDDHandlerByMemberName(bEDestinationImpl.getName());
        if (dDHandler != null) {
            dDHandler.newDestination(bEDestinationImpl);
        }
    }

    static {
        BEDestinationImpl.addNewDestinationListener(new DDManager());
    }
}

