/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dd;

import java.security.AccessController;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.dd.DDMemberStatusSharer;
import weblogic.jms.dd.DDScheduler;
import weblogic.jms.dd.MemberStatusListener;
import weblogic.jms.module.JMSDeploymentHelper;
import weblogic.jms.server.DestinationStatus;
import weblogic.jms.server.DestinationStatusListener;
import weblogic.management.provider.ManagementService;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class DDMember
implements DestinationStatusListener,
DestinationStatus,
Cloneable,
Runnable {
    static final long serialVersionUID = -7244423966789145785L;
    private String name;
    private boolean isProductionPaused;
    private boolean isInsertionPaused;
    private boolean isConsumptionPaused;
    private boolean hasConsumers;
    private boolean isUp = false;
    private boolean isForwardingUp = false;
    private boolean isDestinationUp = false;
    private boolean isLocal = false;
    private boolean isPersistent;
    private int weight = 1;
    private BEDestinationImpl destination = null;
    private List statusListeners;
    private DistributedDestinationImpl ddImpl = null;
    private boolean ddImplOutOfDate = true;
    private String jmsServerName;
    private String persistentStoreName;
    private String wlsServerName;
    private String migratableTargetName;
    private String domainName = null;
    private JMSServerId backEndId;
    private JMSID destinationId;
    private DispatcherId dispatcherId;
    private short events = 0;
    public static final short HAS_CONSUMERS_CHANGE = 1;
    public static final short INSERTION_PAUSED_CHANGE = 2;
    public static final short PRODUCTION_PAUSED_CHANGE = 4;
    public static final short CONSUMPTION_PAUSED_CHANGE = 8;
    public static final short UP_CHANGE = 16;
    public static final short WEIGHT_CHANGE = 32;
    private String globalJNDIName = null;
    private String localJNDIName = null;
    private DDHandler ddHandler = null;
    public static final int SECURITY_MODE_REMOTE_SIGNED = 11;
    public static final int SECURITY_MODE_REMOTE_UNSIGNED = 12;
    public static final int SECURITY_MODE_REMOTE_SIGNEDFULL = 13;
    public static final int SECURITY_MODE_REMOTE_KERNELID = 14;
    public static final int SECURITY_MODE_LOCAL_KERNELID = 15;
    public static final int SECURITY_MODE_UNKNOWN = 16;
    private int remoteSecurityMode = 16;
    private static final int SECURITY_MODE_FOR_WIRE = DDMember.getSecurityModeForWire();

    public DDMember(String string) {
        this.name = string;
        this.isInsertionPaused = false;
        this.isConsumptionPaused = false;
        this.isProductionPaused = false;
        this.hasConsumers = false;
        this.isPersistent = false;
        this.jmsServerName = null;
        this.wlsServerName = null;
        this.migratableTargetName = null;
        this.domainName = null;
        this.backEndId = null;
        this.destinationId = null;
        this.dispatcherId = null;
        this.remoteSecurityMode = 16;
    }

    public boolean equals(Object object) {
        return object instanceof DDMember && this.name.equals(((DDMember)object).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private void determineMigratableTargetName() {
        BackEnd backEnd = this.destination.getBackEnd();
        if (backEnd == null) {
            return;
        }
        this.migratableTargetName = JMSDeploymentHelper.getMigratableTargetName(backEnd.getName());
    }

    private void determinePersistentStoreName() {
        if (this.destination == null) {
            return;
        }
        BackEnd backEnd = this.destination.getBackEnd();
        if (backEnd == null) {
            return;
        }
        if (backEnd.getPersistentStore() != null) {
            this.persistentStoreName = backEnd.getPersistentStore().getName();
        }
    }

    public synchronized void setDestination(BEDestinationImpl bEDestinationImpl) {
        if (this.destination != null) {
            return;
        }
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("I have not seen this destination before: " + bEDestinationImpl.getName());
        }
        this.destination = bEDestinationImpl;
        this.isLocal = true;
        this.remoteSecurityMode = SECURITY_MODE_FOR_WIRE;
        this.setIsInsertionPaused(bEDestinationImpl.isInsertionPaused());
        this.setIsConsumptionPaused(bEDestinationImpl.isConsumptionPaused());
        this.setIsProductionPaused(bEDestinationImpl.isProductionPaused());
        this.setHasConsumers(bEDestinationImpl.hasConsumers());
        this.isPersistent = bEDestinationImpl.isPersistent();
        this.globalJNDIName = bEDestinationImpl.getJNDIName();
        this.localJNDIName = bEDestinationImpl.getLocalJNDIName();
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        this.wlsServerName = ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getName();
        this.jmsServerName = bEDestinationImpl.getDestinationImpl().getServerName();
        this.determinePersistentStoreName();
        this.determineMigratableTargetName();
        this.domainName = JMSDeploymentHelper.getDomainName();
        this.backEndId = bEDestinationImpl.getDestinationImpl().getBackEndId();
        this.destinationId = bEDestinationImpl.getDestinationImpl().getId();
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("destinationId is now " + this.destinationId);
        }
        this.dispatcherId = bEDestinationImpl.getDestinationImpl().getDispatcherId();
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("dispatcherId is now " + this.dispatcherId);
        }
        bEDestinationImpl.addStatusListener(this);
        this.isDestinationUp = false;
        this.isUp = false;
        this.isForwardingUp = false;
        this.setIsDestinationUp(bEDestinationImpl.isUp());
        new DDMemberStatusSharer(this);
    }

    public DDMember() {
    }

    public void notAMember() {
        if (this.destination != null) {
            this.destination.removeStatusListener(this);
        }
        this.setIsUp(false);
        this.ddHandler = null;
    }

    public void update(DDMember dDMember) {
        if (this.isLocal) {
            return;
        }
        this.name = dDMember.name;
        this.setIsInsertionPaused(dDMember.isInsertionPaused);
        this.setIsConsumptionPaused(dDMember.isConsumptionPaused);
        this.setIsProductionPaused(dDMember.isProductionPaused);
        this.setHasConsumers(dDMember.hasConsumers);
        this.isPersistent = dDMember.isPersistent;
        this.wlsServerName = dDMember.wlsServerName;
        this.jmsServerName = dDMember.jmsServerName;
        this.persistentStoreName = dDMember.persistentStoreName;
        this.migratableTargetName = dDMember.migratableTargetName;
        this.domainName = dDMember.domainName;
        this.globalJNDIName = dDMember.globalJNDIName;
        this.localJNDIName = dDMember.localJNDIName;
        this.backEndId = dDMember.backEndId;
        this.destinationId = dDMember.destinationId;
        this.dispatcherId = dDMember.dispatcherId;
        this.remoteSecurityMode = dDMember.remoteSecurityMode;
        this.setIsUp(dDMember.isUp);
    }

    public synchronized void addStatusListener(MemberStatusListener memberStatusListener) {
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Adding listener: " + memberStatusListener + " on " + this.name + ", this is " + this);
        }
        if (this.statusListeners == null) {
            this.statusListeners = new LinkedList();
        }
        this.statusListeners.add(memberStatusListener);
        if (this.events != 0) {
            DDScheduler.schedule(this);
        }
    }

    public synchronized void removeStatusListener(MemberStatusListener memberStatusListener) {
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Removing listener: " + memberStatusListener + " on " + this.name + ", this is " + this);
        }
        if (this.statusListeners != null) {
            this.statusListeners.remove(memberStatusListener);
            if (this.statusListeners.isEmpty()) {
                this.statusListeners = null;
            }
        }
    }

    boolean isUOWDestination() {
        if (this.destination == null) {
            return true;
        }
        return this.destination.isUOWDestination();
    }

    public void onProductionPauseChange(DestinationStatus destinationStatus) {
        this.setIsProductionPaused(destinationStatus.isProductionPaused());
    }

    public void onConsumptionPauseChange(DestinationStatus destinationStatus) {
        this.setIsConsumptionPaused(destinationStatus.isConsumptionPaused());
    }

    public void onInsertionPauseChange(DestinationStatus destinationStatus) {
        this.setIsInsertionPaused(destinationStatus.isInsertionPaused());
    }

    public void onHasConsumersStatusChange(DestinationStatus destinationStatus) {
        this.setHasConsumers(destinationStatus.hasConsumers());
    }

    public void onUpStatusChange(DestinationStatus destinationStatus) {
        this.setIsDestinationUp(destinationStatus.isUp());
    }

    public void run() {
        this.callListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callListeners() {
        DDMember dDMember;
        LinkedList linkedList;
        short s;
        Object object = this;
        synchronized (object) {
            if (this.events == 0) {
                return;
            }
            s = this.events;
            this.events = 0;
            if (this.statusListeners == null) {
                return;
            }
            linkedList = new LinkedList(this.statusListeners);
            try {
                dDMember = (DDMember)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)("Clone is supported, no matter what the followoing says: " + cloneNotSupportedException));
            }
        }
        object = linkedList.listIterator();
        while (object.hasNext()) {
            MemberStatusListener memberStatusListener = (MemberStatusListener)object.next();
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("Calling out to " + memberStatusListener + " events is " + DDMember.eventsPrint(s));
            }
            memberStatusListener.memberStatusChange(dDMember, s);
            if (!JMSDebug.JMSDistTopic.isDebugEnabled()) continue;
            JMSDebug.JMSDistTopic.debug("Back from " + memberStatusListener + " events is " + DDMember.eventsPrint(s));
        }
    }

    private static String append(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string + "|" + string2;
    }

    private static String eventsPrint(int n) {
        String string = null;
        if ((n & 1) != 0) {
            string = DDMember.append(string, "HAS_CONSUMERS_CHANGE");
        }
        if ((n & 2) != 0) {
            string = DDMember.append(string, "INSERTION_PAUSED_CHANGE");
        }
        if ((n & 4) != 0) {
            string = DDMember.append(string, "PRODUCTION_PAUSED_CHANGE");
        }
        if ((n & 8) != 0) {
            string = DDMember.append(string, "CONSUMPTION_PAUSED_CHANGE");
        }
        if ((n & 0x10) != 0) {
            string = DDMember.append(string, "UP_CHANGE");
        }
        if ((n & 0x20) != 0) {
            string = DDMember.append(string, "WEIGHT_CHANGE");
        }
        return string;
    }

    private synchronized void addEvent(short s) {
        this.events = (short)(this.events | s);
        if (this.statusListeners == null) {
            return;
        }
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Got an event: " + DDMember.eventsPrint(s) + " on " + this.name);
        }
        DDScheduler.schedule(this);
    }

    public void setHasConsumers(boolean bl) {
        if (bl == this.hasConsumers) {
            return;
        }
        if (this.statusListeners != null && JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Got a HAS_CONSUMERS_CHANGE on " + this.name + ", it is now " + bl);
        }
        this.ddImplOutOfDate = true;
        this.hasConsumers = bl;
        this.addEvent((short)1);
    }

    public void setIsPersistent(boolean bl) {
        this.isPersistent = bl;
    }

    public void setIsInsertionPaused(boolean bl) {
        if (bl == this.isInsertionPaused) {
            return;
        }
        this.ddImplOutOfDate = true;
        this.isInsertionPaused = bl;
        this.addEvent((short)2);
    }

    public void setIsProductionPaused(boolean bl) {
        if (bl == this.isProductionPaused) {
            return;
        }
        this.ddImplOutOfDate = true;
        this.isProductionPaused = bl;
        this.addEvent((short)4);
    }

    public void setIsConsumptionPaused(boolean bl) {
        if (bl == this.isConsumptionPaused) {
            return;
        }
        this.ddImplOutOfDate = true;
        this.isConsumptionPaused = bl;
        this.addEvent((short)8);
    }

    public void setIsUp(boolean bl) {
        if (bl == this.isUp) {
            return;
        }
        if (this.statusListeners != null && JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Got an UP_CHANGE on " + this.name + ", it is now " + bl);
        }
        this.ddImplOutOfDate = true;
        this.isUp = bl;
        this.addEvent((short)16);
    }

    public boolean isDestinationUp() {
        return this.isDestinationUp;
    }

    private synchronized void setIsDestinationUp(boolean bl) {
        if (bl == this.isDestinationUp) {
            return;
        }
        if (this.statusListeners != null && JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Got a DESTINATION_UP_CHANGE on " + this.name + ", it is now " + bl);
        }
        if (!bl) {
            if (this.destination != null) {
                this.destination.removeStatusListener(this);
                this.destination = null;
            }
            this.isLocal = false;
        }
        this.ddImplOutOfDate = true;
        this.isDestinationUp = bl;
        this.setIsUp(this.isForwardingUp && bl);
    }

    public void setIsForwardingUp(boolean bl) {
        if (bl == this.isForwardingUp) {
            return;
        }
        if (this.statusListeners != null && JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Got a FORWARDING_UP_CHANGE on " + this.name + ", it is now " + bl);
        }
        this.isForwardingUp = bl;
        this.setIsUp(bl && this.isDestinationUp);
    }

    public void setWeight(int n) {
        if (n == this.weight) {
            return;
        }
        this.ddImplOutOfDate = true;
        this.weight = n;
        this.addEvent((short)32);
    }

    public BEDestinationImpl getDestination() {
        return this.destination;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    void setRemoteSecurityMode(int n) {
        switch (n) {
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.remoteSecurityMode = n;
                return;
            }
        }
        throw new AssertionError();
    }

    public int getRemoteSecurityMode() {
        return this.remoteSecurityMode;
    }

    public DispatcherId getDispatcherId() {
        return this.dispatcherId;
    }

    public void setDispatcherId(DispatcherId dispatcherId) {
        this.dispatcherId = dispatcherId;
    }

    public JMSID getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(JMSID jMSID) {
        this.destinationId = jMSID;
    }

    public JMSServerId getBackEndId() {
        return this.backEndId;
    }

    public void setBackEndId(JMSServerId jMSServerId) {
        this.backEndId = jMSServerId;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String string) {
        this.domainName = string;
    }

    public String getMigratableTargetName() {
        return this.migratableTargetName;
    }

    public void setMigratableTargetName(String string) {
        this.migratableTargetName = string;
    }

    public String getWLSServerName() {
        return this.wlsServerName;
    }

    public void setWLSServerName(String string) {
        this.wlsServerName = string;
    }

    public String getJMSServerName() {
        return this.jmsServerName;
    }

    public void setJMSServerName(String string) {
        this.jmsServerName = string;
    }

    public String getPersistentStoreName() {
        this.determinePersistentStoreName();
        return this.persistentStoreName;
    }

    public void setPersistentStoreName(String string) {
        this.persistentStoreName = string;
    }

    public String getGlobalJNDIName() {
        return this.globalJNDIName;
    }

    public void setGlobalJNDIName(String string) {
        this.globalJNDIName = string;
    }

    public String getLocalJNDIName() {
        return this.localJNDIName;
    }

    public void setLocalJNDIName(String string) {
        this.localJNDIName = string;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isInsertionPaused() {
        return this.isInsertionPaused;
    }

    public boolean isConsumptionPaused() {
        return this.isConsumptionPaused;
    }

    public boolean isProductionPaused() {
        return this.isProductionPaused;
    }

    public boolean hasConsumers() {
        return this.hasConsumers;
    }

    public boolean isUp() {
        return this.isUp;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setDDHandler(DDHandler dDHandler) {
        this.ddHandler = dDHandler;
        this.getDDImpl();
    }

    public DistributedDestinationImpl getDDImpl() {
        if (this.ddImplOutOfDate && this.ddHandler != null) {
            this.ddImpl = new DistributedDestinationImpl(this.ddHandler.isQueue() ? 1 : 2, this.jmsServerName, this.ddHandler.getName(), this.ddHandler.getApplicationName(), this.ddHandler.getEARModuleName(), this.ddHandler.getLoadBalancingPolicyAsInt(), this.ddHandler.getForwardingPolicy(), this.getName(), this.ddHandler.getJNDIName(), this.backEndId, this.destinationId, this.dispatcherId, this.isPersistent(), this.persistentStoreName, this.ddHandler.getSAFExportPolicy(), this.isLocal);
            this.ddImpl.setNonSystemSubscriberConsumers(this.hasConsumers ? 1 : 0);
            this.ddImpl.setIsProductionPaused(this.isProductionPaused());
            this.ddImpl.setIsConsumptionPaused(this.isConsumptionPaused());
            this.ddImpl.setIsInsertionPaused(this.isInsertionPaused());
            this.ddImpl.setWeight(this.weight);
            this.ddImplOutOfDate = false;
        }
        return this.ddImpl;
    }

    public Object clone() throws CloneNotSupportedException {
        return (DDMember)super.clone();
    }

    public String toString() {
        return "DDMember: " + this.name + ", hash: " + this.hashCode() + ", dispId: " + this.dispatcherId + ", backEndId: " + this.backEndId + ", destinationId: " + this.destinationId + ", remoteSecurityMode: " + this.remoteSecurityMode;
    }

    private static int getSecurityModeForWire() {
        String string = "weblogic.jms.DDMemberPolicy";
        String string2 = System.getProperty(string, "");
        if ((string2 = string2.toLowerCase(Locale.ENGLISH).trim()).equals("default")) {
            return 11;
        }
        if (string2.equals("perf")) {
            return 12;
        }
        if (string2.equals("full")) {
            return 13;
        }
        if (string2.equals("kid")) {
            return 14;
        }
        if (string2.length() > 0) {
            new Exception("Unexpected value for " + string).printStackTrace();
        }
        return 11;
    }
}

