/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dd;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.security.AccessController;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSService;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.dd.DDManager;
import weblogic.jms.dd.DDMember;
import weblogic.jms.dd.MemberStatusListener;
import weblogic.jndi.Aggregatable;
import weblogic.jndi.internal.NamingNode;
import weblogic.management.provider.ManagementService;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class DDMemberStatusSharer
implements MemberStatusListener,
Aggregatable,
Externalizable {
    static final long serialVersionUID = 3562221018441394798L;
    private DDMember member;
    private static final int VERSION_SHIFT = 3;
    private static final int VERSION_MASK = 7;
    private static final int EXTVERSION = 1;
    private static final int EXTVERSION_DANTE = 2;
    private static final int EXTVERSION_CORDELL = 3;
    private static final int IS_PRODUCTION_PAUSED = 8;
    private static final int IS_CONSUMPTION_PAUSED = 16;
    private static final int IS_INSERTION_PAUSED = 32;
    private static final int IS_UP = 64;
    private static final int HAS_CONSUMERS = 128;
    private static final int IS_PERSISTENT = 256;
    private static final int HAS_GLOBAL_JNDI_NAME = 512;
    private static final int HAS_LOCAL_JNDI_NAME = 1024;
    private static final int HAS_MIGRATABLE_TARGET_NAME = 2048;
    private static final int HAS_DOMAIN_NAME = 4096;
    private static final int SECURITY_MASK = 24576;
    private static final int WANTS_UNSIGNED = 8192;
    private static final int WANTS_SIGNED = 16384;
    private static final int WANTS_SIGNEDFULL = 24576;
    private static final int WANTS_KERNELID = 0;
    private static final int HAS_MORE_FLAGS = 32768;
    private static final int HAS_STORE_NAME = 1;
    private boolean init = false;
    private String internalDistributedJNDIName;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public DDMemberStatusSharer(DDMember dDMember) {
        this.member = dDMember;
        dDMember.addStatusListener(this);
    }

    public DDMemberStatusSharer() {
    }

    private void init() {
        String string = ManagementService.getRuntimeAccess(kernelId).getServer().getName();
        this.internalDistributedJNDIName = "weblogic.jms.internal.ddmember." + this.member.getName() + "." + string;
        this.init = true;
    }

    public void doBind() {
        if (!this.member.isLocal()) {
            return;
        }
        if (!this.init) {
            this.init();
        }
        try {
            PrivilegedActionUtilities.rebindAsSU(JMSService.getContext(true), this.internalDistributedJNDIName, this, kernelId);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void doUnbind() {
        if (!this.init) {
            this.init();
        }
        try {
            PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(true), this.internalDistributedJNDIName, this, kernelId);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void memberStatusChange(DDMember dDMember, int n) {
        if (!dDMember.isDestinationUp()) {
            if ((n & 0x10) != 0) {
                dDMember.removeStatusListener(this);
                this.doUnbind();
            }
        } else {
            this.doBind();
        }
    }

    public void onBind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        if (aggregatable == null) {
            aggregatable = this;
        }
        DDManager.memberUpdate(((DDMemberStatusSharer)aggregatable).member);
    }

    public void onRebind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        this.onBind(namingNode, string, aggregatable);
    }

    private boolean checkForReplacement(NamingNode namingNode, String string) {
        try {
            NamingEnumeration namingEnumeration = namingNode.listBindings("", null);
            while (namingEnumeration.hasMoreElements()) {
                NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                if (nameClassPair.getName().equals(string)) continue;
                DDManager.memberUpdate(((DDMemberStatusSharer)namingNode.lookupLink((String)nameClassPair.getName(), null)).member);
            }
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onUnbind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        DDMember dDMember;
        if (this.checkForReplacement(namingNode, string)) {
            return true;
        }
        DDHandler dDHandler = DDManager.findDDHandlerByMemberName(this.member.getName());
        if (dDHandler != null && (dDMember = dDHandler.findMemberByName(this.member.getName())) != null) {
            DDMember dDMember2 = dDMember;
            synchronized (dDMember2) {
                dDMember.setIsUp(false);
                dDMember.setHasConsumers(false);
            }
        }
        return true;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        short s;
        int n = this.getVersion(objectOutput);
        short s2 = (short)n;
        if (this.member.isProductionPaused()) {
            s2 = (short)(s2 | 8);
        }
        if (this.member.isConsumptionPaused()) {
            s2 = (short)(s2 | 0x10);
        }
        if (this.member.isInsertionPaused()) {
            s2 = (short)(s2 | 0x20);
        }
        if (this.member.isUp()) {
            s2 = (short)(s2 | 0x40);
        }
        if (this.member.hasConsumers()) {
            s2 = (short)(s2 | 0x80);
        }
        if (this.member.isPersistent()) {
            s2 = (short)(s2 | 0x100);
        }
        if (this.member.getMigratableTargetName() != null) {
            s2 = (short)(s2 | 0x800);
        }
        if (n > 1 && this.member.getDomainName() != null) {
            s2 = (short)(s2 | 0x1000);
        }
        if (this.member.getGlobalJNDIName() != null) {
            s2 = (short)(s2 | 0x200);
        }
        if (this.member.getLocalJNDIName() != null) {
            s2 = (short)(s2 | 0x400);
        }
        switch (this.member.getRemoteSecurityMode()) {
            case 11: {
                s2 = (short)(s2 | 0x4000);
                break;
            }
            case 13: {
                s2 = (short)(s2 | 0x6000);
                break;
            }
            case 12: {
                s2 = (short)(s2 | 0x2000);
                break;
            }
            case 14: {
                s2 = (short)(s2 | 0);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (n >= 3) {
            s = 0;
            if (this.member.getPersistentStoreName() != null && this.member.getPersistentStoreName().length() != 0) {
                s = (short)(s | 1);
            }
            if (s != 0) {
                s2 = (short)(s2 | 0x8000);
            }
        } else {
            s = 0;
        }
        objectOutput.writeShort(s2);
        objectOutput.writeInt(this.member.getWeight());
        objectOutput.writeUTF(this.member.getName());
        objectOutput.writeUTF(this.member.getWLSServerName());
        objectOutput.writeUTF(this.member.getJMSServerName());
        if ((s2 & 0x800) != 0) {
            objectOutput.writeUTF(this.member.getMigratableTargetName());
        }
        if ((s2 & 0x1000) != 0) {
            objectOutput.writeUTF(this.member.getDomainName());
        }
        if ((s2 & 0x200) != 0) {
            objectOutput.writeUTF(this.member.getGlobalJNDIName());
        }
        if ((s2 & 0x400) != 0) {
            objectOutput.writeUTF(this.member.getLocalJNDIName());
        }
        this.member.getBackEndId().writeExternal(objectOutput);
        this.member.getDestinationId().writeExternal(objectOutput);
        this.member.getDispatcherId().writeExternal(objectOutput);
        if (n >= 3) {
            if ((s2 & 0x8000) != 0) {
                objectOutput.writeShort(s);
            }
            if ((s & 1) != 0) {
                objectOutput.writeUTF(this.member.getPersistentStoreName());
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        short s = objectInput.readShort();
        int n = s & 7;
        if (n != 1 && n != 2 && n != 3) {
            throw JMSUtilities.versionIOException(n, 1, 3);
        }
        this.member = new DDMember();
        this.member.setIsProductionPaused((s & 8) != 0);
        this.member.setIsConsumptionPaused((s & 0x10) != 0);
        this.member.setIsInsertionPaused((s & 0x20) != 0);
        this.member.setHasConsumers((s & 0x80) != 0);
        this.member.setIsPersistent((s & 0x100) != 0);
        int n2 = 0;
        switch (s & 0x6000) {
            case 16384: {
                n2 = 11;
                break;
            }
            case 24576: {
                n2 = 13;
                break;
            }
            case 0: {
                n2 = 14;
                break;
            }
            case 8192: {
                n2 = 12;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.member.setRemoteSecurityMode(n2);
        this.member.setWeight(objectInput.readInt());
        this.member.setName(objectInput.readUTF());
        this.member.setWLSServerName(objectInput.readUTF());
        this.member.setJMSServerName(objectInput.readUTF());
        if ((s & 0x800) != 0) {
            this.member.setMigratableTargetName(objectInput.readUTF());
        }
        if ((s & 0x1000) != 0) {
            this.member.setDomainName(objectInput.readUTF());
        }
        if ((s & 0x200) != 0) {
            this.member.setGlobalJNDIName(objectInput.readUTF());
        }
        if ((s & 0x400) != 0) {
            this.member.setLocalJNDIName(objectInput.readUTF());
        }
        JMSServerId jMSServerId = new JMSServerId();
        jMSServerId.readExternal(objectInput);
        this.member.setBackEndId(jMSServerId);
        JMSID jMSID = new JMSID();
        jMSID.readExternal(objectInput);
        this.member.setDestinationId(jMSID);
        DispatcherId dispatcherId = new DispatcherId();
        dispatcherId.readExternal(objectInput);
        this.member.setDispatcherId(dispatcherId);
        short s2 = 0;
        if ((s & 0x8000) != 0) {
            s2 = objectInput.readShort();
        }
        if ((s2 & 1) != 0) {
            this.member.setPersistentStoreName(objectInput.readUTF());
        }
        this.member.setIsUp((s & 0x40) != 0);
    }

    public boolean equals(Object object) {
        return object instanceof DDMemberStatusSharer && ((DDMemberStatusSharer)object).member.getName().equals(this.member.getName());
    }

    public int hashCode() {
        return this.member.getName().hashCode();
    }

    public String toString() {
        return "DDMemberStatusSharer: " + this.member.getName() + ", hash: " + this.hashCode();
    }

    private int getVersion(Object object) throws IOException {
        if (object instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)object).getPeerInfo();
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_DIABLO) < 0) {
                throw JMSUtilities.versionIOException(0, 1, 3);
            }
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_920) <= 0) {
                return 1;
            }
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_1030) <= 0) {
                return 2;
            }
        }
        return 3;
    }
}

