/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dd;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.naming.NamingException;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.JMSService;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.dd.DDManager;
import weblogic.jms.dd.DDMember;
import weblogic.jms.dd.DDStatusListener;
import weblogic.jndi.Aggregatable;
import weblogic.jndi.internal.NamingNode;
import weblogic.management.provider.ManagementService;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class DDStatusSharer
implements DDStatusListener,
Aggregatable,
Externalizable {
    static final long serialVersionUID = -3705735684883464847L;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private DDHandler ddHandler;
    private static int VERSION_FARALON_PS1 = 1;
    private static int EXTVERSION = 2;
    private static final int VERSION_SHIFT = 3;
    private static final int VERSION_MASK = 7;
    private static final int NO_APPLICATION_NAME = 8;
    private static final int NO_MODULE_NAME = 16;
    private static final int IS_ROUTING_PATHSERVICE = 32;
    private static final int NO_SAF_EXPORT_POLICY = 64;
    private static final int IS_ROUTING_HASH = 128;
    private static final int NO_JNDI_NAME = 256;
    private static final int IS_QUEUE = 512;
    private static final int IS_UOW_DESTINATION = 1024;
    private static final int HAS_REFERENCE_NAME = 2048;
    private static final int RESET_DELIVERY_COUNT = 4096;
    private List remoteMemberList;
    private boolean everHadMembers = false;
    private String serverName;

    public DDStatusSharer() {
    }

    public DDStatusSharer(DDHandler dDHandler) {
        this.ddHandler = dDHandler;
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        this.serverName = ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getName();
        if (dDHandler.getNumberOfMembers() != 0) {
            this.everHadMembers = true;
        }
        dDHandler.addStatusListener(this, 29);
    }

    public void statusChangeNotification(DDHandler dDHandler, int n) {
        if (!dDHandler.isLocal()) {
            return;
        }
        if (!this.everHadMembers) {
            if (dDHandler.getNumberOfMembers() == 0) {
                return;
            }
            this.everHadMembers = true;
        }
        String string = "weblogic.jms.internal.dd." + this.serverName + "." + dDHandler.getName();
        try {
            if (!dDHandler.isActive()) {
                PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(true), string, kernelId);
            } else {
                PrivilegedActionUtilities.rebindAsSU(JMSService.getContext(true), string, this, kernelId);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void onBind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        DDStatusSharer dDStatusSharer = aggregatable == null ? this : (DDStatusSharer)aggregatable;
        DDManager.remoteUpdate(dDStatusSharer.ddHandler, dDStatusSharer.remoteMemberList);
    }

    public void onRebind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        this.onBind(namingNode, string, aggregatable);
    }

    public boolean onUnbind(NamingNode namingNode, String string, Aggregatable aggregatable) throws NamingException {
        DDManager.remoteDeactivate(this.ddHandler.getName());
        return true;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        boolean bl;
        this.ddHandler = new DDHandler();
        int n = objectInput.readInt();
        int n2 = n & 7;
        if (n2 == EXTVERSION) {
            bl = true;
        } else {
            if (n2 != VERSION_FARALON_PS1) {
                throw JMSUtilities.versionIOException(n2, EXTVERSION, VERSION_FARALON_PS1);
            }
            bl = false;
        }
        this.ddHandler.setIsQueue((n & 0x200) != 0);
        this.ddHandler.setIsUOWDestination((n & 0x400) != 0);
        this.ddHandler.setName(objectInput.readUTF());
        if ((n & 8) == 0) {
            this.ddHandler.setApplicationName(objectInput.readUTF());
        }
        if ((n & 0x10) == 0) {
            this.ddHandler.setEARModuleName(objectInput.readUTF());
        }
        if ((n & 0x40) == 0) {
            this.ddHandler.setSAFExportPolicy(objectInput.readUTF());
        }
        if ((n & 0x80) != 0) {
            this.ddHandler.setUnitOfOrderRouting("Hash".intern());
        } else if ((n & 0x20) != 0) {
            this.ddHandler.setUnitOfOrderRouting("PathService".intern());
        }
        if ((n & 0x100) == 0) {
            this.ddHandler.setJNDIName(objectInput.readUTF());
        }
        this.ddHandler.setLoadBalancingPolicyAsInt(objectInput.readInt());
        this.ddHandler.setForwardDelay(objectInput.readInt());
        int n3 = objectInput.readInt();
        this.remoteMemberList = new LinkedList();
        for (int i = 0; i < n3; ++i) {
            String string = objectInput.readUTF();
            this.remoteMemberList.add(string);
        }
        if ((n & 0x800) != 0) {
            this.ddHandler.setReferenceName(objectInput.readUTF());
        }
        this.ddHandler.setResetDeliveryCountOnForward((n & 0x1000) != 0);
        if (bl) {
            this.ddHandler.setForwardingPolicy(objectInput.readInt());
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Object object;
        ListIterator listIterator;
        boolean bl;
        int n;
        if (objectOutput instanceof PeerInfoable && ((PeerInfoable)objectOutput).getPeerInfo().compareTo((Object)PeerInfo.VERSION_1033) < 0) {
            n = VERSION_FARALON_PS1;
            bl = false;
        } else {
            n = EXTVERSION;
            bl = true;
        }
        String string = this.ddHandler.getUnitOfOrderRouting();
        if (string != null) {
            if (string.equals("Hash")) {
                n |= 0x80;
            } else if (string.equals("PathService")) {
                n |= 0x20;
            }
        }
        if (this.ddHandler.getApplicationName() == null) {
            n |= 8;
        }
        if (this.ddHandler.getEARModuleName() == null) {
            n |= 0x10;
        }
        if (this.ddHandler.getSAFExportPolicy() == null) {
            n |= 0x40;
        }
        if (this.ddHandler.getJNDIName() == null) {
            n |= 0x100;
        }
        if (this.ddHandler.isQueue()) {
            n |= 0x200;
        }
        if (this.ddHandler.isUOWDestination()) {
            n |= 0x400;
        }
        if (this.ddHandler.getReferenceName() != null) {
            n |= 0x800;
        }
        if (this.ddHandler.getResetDeliveryCountOnForward()) {
            n |= 0x1000;
        }
        objectOutput.writeInt(n);
        objectOutput.writeUTF(this.ddHandler.getName());
        if ((n & 8) == 0) {
            objectOutput.writeUTF(this.ddHandler.getApplicationName());
        }
        if ((n & 0x10) == 0) {
            objectOutput.writeUTF(this.ddHandler.getEARModuleName());
        }
        if ((n & 0x40) == 0) {
            objectOutput.writeUTF(this.ddHandler.getSAFExportPolicy());
        }
        if ((n & 0x100) == 0) {
            objectOutput.writeUTF(this.ddHandler.getJNDIName());
        }
        objectOutput.writeInt(this.ddHandler.getLoadBalancingPolicyAsInt());
        objectOutput.writeInt(this.ddHandler.getForwardDelay());
        if (this.ddHandler.isActive()) {
            listIterator = this.ddHandler.memberCloneIterator();
            this.remoteMemberList = new LinkedList();
            while (listIterator.hasNext()) {
                object = (DDMember)listIterator.next();
                this.remoteMemberList.add(((DDMember)object).getName());
            }
        }
        objectOutput.writeInt(this.remoteMemberList.size());
        listIterator = this.remoteMemberList.listIterator();
        while (listIterator.hasNext()) {
            object = (String)listIterator.next();
            objectOutput.writeUTF((String)object);
        }
        if (this.ddHandler.isActive()) {
            this.remoteMemberList = null;
        }
        if ((n & 0x800) != 0) {
            objectOutput.writeUTF(this.ddHandler.getReferenceName());
        }
        if (bl) {
            objectOutput.writeInt(this.ddHandler.getForwardingPolicy());
        }
    }

    public boolean equals(Object object) {
        if (object instanceof DDStatusSharer) {
            return ((DDStatusSharer)object).ddHandler.getName().equals(this.ddHandler.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.ddHandler.getName().hashCode();
    }

    public String toString() {
        return "DDStatusSharer: " + this.ddHandler.getName() + ", hash: " + this.hashCode();
    }
}

