/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.application.ApplicationContext;
import weblogic.application.ModuleException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.DestinationBean;
import weblogic.j2ee.descriptor.wl.DistributedDestinationBean;
import weblogic.j2ee.descriptor.wl.DistributedDestinationMemberBean;
import weblogic.j2ee.descriptor.wl.DistributedQueueBean;
import weblogic.j2ee.descriptor.wl.DistributedTopicBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.jms.JMSExceptionLogger;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.dd.DDConfig;
import weblogic.jms.dd.DDConstants;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.dd.DDManager;
import weblogic.jms.dd.DDScheduler;
import weblogic.jms.extensions.JMSModuleHelper;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.JMSDeploymentHelper;
import weblogic.jms.module.JMSModuleManagedEntity;
import weblogic.management.ManagementException;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSConstants;
import weblogic.management.utils.BeanListenerCustomizer;
import weblogic.management.utils.GenericBeanListener;

public final class DistributedDestination
implements JMSModuleManagedEntity,
BeanListenerCustomizer,
DDConfig,
DDConstants {
    private static final String PHYS_DEST_NAME = "PhysicalDestinationName";
    private int type;
    private HashMap memberName2Listener = new HashMap();
    private HashMap memberName2InteropListener = new HashMap();
    private ArrayList addedMemberNameList;
    private ArrayList removedMemberInformation;
    private String name;
    private String jndiName;
    private String unitOfOrderRouting;
    private boolean isDefaultUnitOfOrder;
    private String loadBalancingPolicy;
    private String forwardingPolicy;
    private int queueForwardDelay;
    private boolean resetDeliveryCount = true;
    private BasicDeploymentMBean deployableApplication;
    private JMSBean module;
    private DistributedDestinationBean specificBean;
    private String EARModuleName;
    private String moduleName;
    private ApplicationContext appCtx;
    private String safExportPolicy;
    private GenericBeanListener distributedDestinationBeanListener;
    private String ddGroupTargetName = null;
    private DDHandler ddHandler;
    private static HashMap groupBeanSignatures = new HashMap();
    private boolean isInterop;

    public DistributedDestination(String string, JMSBean jMSBean, DistributedDestinationBean distributedDestinationBean, BasicDeploymentMBean basicDeploymentMBean, String string2, String string3, ApplicationContext applicationContext) {
        this.name = string;
        this.module = jMSBean;
        this.specificBean = distributedDestinationBean;
        this.deployableApplication = basicDeploymentMBean;
        this.EARModuleName = string2;
        this.moduleName = string3;
        this.appCtx = applicationContext;
        this.isInterop = this.moduleName.equals("interop-jms");
        this.type = this.specificBean instanceof DistributedQueueBean ? 0 : 1;
        this.ddHandler = new DDHandler(this, true);
    }

    private BasicDeploymentMBean findApplication() {
        if (this.deployableApplication != null) {
            return this.deployableApplication;
        }
        this.deployableApplication = JMSModuleHelper.findJMSSystemResource(this.moduleName);
        if (this.deployableApplication != null) {
            return this.deployableApplication;
        }
        this.deployableApplication = JMSBeanHelper.getJMSInteropModule();
        return this.deployableApplication;
    }

    private void initializeWithBean() throws ModuleException {
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Initializing distributed destination with Bean " + this.specificBean.getName());
        }
        try {
            this.initializeBeanUpdateListeners();
        }
        catch (JMSException jMSException) {
            throw new ModuleException(jMSException.getMessage(), (Throwable)((Object)jMSException));
        }
    }

    public String getApplicationName() {
        if (this.appCtx != null) {
            return this.appCtx.getApplicationId();
        }
        return null;
    }

    private void prepareMembers() throws ModuleException {
        DistributedDestinationMemberBean[] distributedDestinationMemberBeanArray = null;
        if (this.type == 0) {
            distributedDestinationMemberBeanArray = ((DistributedQueueBean)this.specificBean).getDistributedQueueMembers();
        } else if (this.type == 1) {
            distributedDestinationMemberBeanArray = ((DistributedTopicBean)this.specificBean).getDistributedTopicMembers();
        }
        if (distributedDestinationMemberBeanArray != null) {
            if (JMSDebug.JMSConfig.isDebugEnabled()) {
                JMSDebug.JMSConfig.debug("DistributedDestination -- " + distributedDestinationMemberBeanArray.length + " members are found in " + this.name);
            }
            for (int i = 0; i < distributedDestinationMemberBeanArray.length; ++i) {
                if (JMSDebug.JMSConfig.isDebugEnabled()) {
                    JMSDebug.JMSConfig.debug("Preparing distributed destination member " + distributedDestinationMemberBeanArray[i].getName());
                }
                this.prepareMember(distributedDestinationMemberBeanArray[i], false);
            }
        }
    }

    private synchronized void prepareMember(DistributedDestinationMemberBean distributedDestinationMemberBean, boolean bl) throws ModuleException {
        String string = JMSDeploymentHelper.getMemberName(this.moduleName, distributedDestinationMemberBean);
        if (this.isInterop && !distributedDestinationMemberBean.isSet(PHYS_DEST_NAME)) {
            if (bl) {
                return;
            }
            string = null;
        }
        if (string == null) {
            JMSLogger.logJMSDDNullMember((String)this.name, (String)distributedDestinationMemberBean.getName());
            return;
        }
    }

    private List fullMemberNames() {
        DistributedDestinationMemberBean[] distributedDestinationMemberBeanArray = this.getMemberBeans();
        ArrayList<String> arrayList = new ArrayList<String>(distributedDestinationMemberBeanArray.length);
        for (int i = 0; i < distributedDestinationMemberBeanArray.length; ++i) {
            DistributedDestinationMemberBean distributedDestinationMemberBean = distributedDestinationMemberBeanArray[i];
            String string = JMSDeploymentHelper.getMemberName(this.moduleName, distributedDestinationMemberBean);
            arrayList.add(string);
        }
        return arrayList;
    }

    private void activateMembers() {
        if (this.ddHandler != null) {
            this.ddHandler.updateMembers(this.fullMemberNames());
        }
        DistributedDestinationMemberBean[] distributedDestinationMemberBeanArray = this.getMemberBeans();
        for (int i = 0; i < distributedDestinationMemberBeanArray.length; ++i) {
            DistributedDestinationMemberBean distributedDestinationMemberBean = distributedDestinationMemberBeanArray[i];
            if (JMSDebug.JMSConfig.isDebugEnabled()) {
                JMSDebug.JMSConfig.debug("Activating distributed destination member " + distributedDestinationMemberBean.getName());
            }
            this.activateMember(distributedDestinationMemberBean);
        }
    }

    private synchronized void activateMember(DistributedDestinationMemberBean distributedDestinationMemberBean) {
        Object object;
        String string = JMSDeploymentHelper.getMemberName(this.moduleName, distributedDestinationMemberBean);
        if (this.isInterop) {
            if (this.memberName2InteropListener.get(distributedDestinationMemberBean.getName()) == null) {
                object = new InteropMemberHandler(distributedDestinationMemberBean);
                this.memberName2InteropListener.put(distributedDestinationMemberBean.getName(), object);
            }
            if (!distributedDestinationMemberBean.isSet(PHYS_DEST_NAME)) {
                return;
            }
        }
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("new member " + string + " added.");
        }
        if (this.ddHandler != null) {
            object = this.ddHandler.findMemberByName(string);
            GenericBeanListener genericBeanListener = new GenericBeanListener((DescriptorBean)distributedDestinationMemberBean, object, groupBeanSignatures);
            this.memberName2Listener.put(string, genericBeanListener);
            this.ddHandler.setMemberWeight(string, distributedDestinationMemberBean.getWeight());
        }
    }

    private void deactivateMembers() {
        DistributedDestinationMemberBean[] distributedDestinationMemberBeanArray = this.getMemberBeans();
        for (int i = 0; i < distributedDestinationMemberBeanArray.length; ++i) {
            this.deactivateMember(distributedDestinationMemberBeanArray[i]);
        }
    }

    private void deactivateMember(DistributedDestinationMemberBean distributedDestinationMemberBean) {
        GenericBeanListener genericBeanListener;
        InteropMemberHandler interopMemberHandler;
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Deactivating distributed destination member " + distributedDestinationMemberBean.getName());
        }
        if ((interopMemberHandler = (InteropMemberHandler)this.memberName2InteropListener.get(distributedDestinationMemberBean.getName())) != null) {
            interopMemberHandler.close();
        }
        if ((genericBeanListener = (GenericBeanListener)this.memberName2Listener.get(distributedDestinationMemberBean.getName())) != null) {
            genericBeanListener.close();
        }
    }

    private void unprepareMembers() {
        DistributedDestinationMemberBean[] distributedDestinationMemberBeanArray = this.getMemberBeans();
        for (int i = 0; i < distributedDestinationMemberBeanArray.length; ++i) {
            DistributedDestinationMemberBean distributedDestinationMemberBean = distributedDestinationMemberBeanArray[i];
            if (JMSDebug.JMSConfig.isDebugEnabled()) {
                JMSDebug.JMSConfig.debug("Unpreparing distributed destination member " + distributedDestinationMemberBean.getName());
            }
            this.unprepareMember(distributedDestinationMemberBean, false);
        }
    }

    private void unprepareMember(DistributedDestinationMemberBean distributedDestinationMemberBean, boolean bl) {
        String string = distributedDestinationMemberBean.getName();
        GenericBeanListener genericBeanListener = (GenericBeanListener)this.memberName2Listener.remove(string);
        if (genericBeanListener != null) {
            genericBeanListener.close();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getEARModuleName() {
        return this.EARModuleName;
    }

    public String getReferenceName() {
        return null;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public ApplicationContext getApplicationContext() {
        return this.appCtx;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String string) throws IllegalArgumentException {
        this.jndiName = JMSServerUtilities.transformJNDIName(string);
        if (this.ddHandler != null) {
            this.ddHandler.setJNDIName(string);
        }
    }

    public static int translateLoadBalancingPolicy(String string) {
        int n = 0;
        if (string != null) {
            if (string.equals("Round-Robin")) {
                n = 0;
            } else if (string.equals("Random")) {
                n = 1;
            }
        }
        return n;
    }

    public int getLoadBalancingPolicyAsInt() {
        return DistributedDestination.translateLoadBalancingPolicy(this.loadBalancingPolicy);
    }

    public String getLoadBalancingPolicy() {
        return this.loadBalancingPolicy;
    }

    public void setLoadBalancingPolicy(String string) {
        this.loadBalancingPolicy = string;
        if (this.ddHandler != null) {
            this.ddHandler.setLoadBalancingPolicyAsInt(DistributedDestination.translateLoadBalancingPolicy(string));
        }
    }

    public static int translateForwardingPolicy(String string) {
        int n = 1;
        if (string != null) {
            if (string.equals(JMSConstants.FORWARDING_POLICY_REPLICATED)) {
                n = 1;
            } else if (string.equals(JMSConstants.FORWARDING_POLICY_PARTITIONED)) {
                n = 0;
            } else {
                throw new IllegalArgumentException("Unrecognized forwarding policy " + string + ". Allowed valid values=" + JMSConstants.FORWARDING_POLICY_REPLICATED + "," + JMSConstants.FORWARDING_POLICY_PARTITIONED);
            }
        }
        return n;
    }

    public int getForwardingPolicyAsInt() {
        return DistributedDestination.translateForwardingPolicy(this.forwardingPolicy);
    }

    public String getForwardingPolicy() {
        return this.forwardingPolicy;
    }

    public void setForwardingPolicy(String string) {
        this.forwardingPolicy = string;
        if (this.ddHandler != null) {
            this.ddHandler.setForwardingPolicy(DistributedDestination.translateForwardingPolicy(string));
        }
    }

    public int getForwardDelay() {
        return this.queueForwardDelay;
    }

    public void setForwardDelay(int n) {
        this.queueForwardDelay = n;
        if (this.ddHandler != null) {
            this.ddHandler.setForwardDelay(n);
        }
    }

    public boolean getResetDeliveryCountOnForward() {
        return this.resetDeliveryCount;
    }

    public void setResetDeliveryCountOnForward(boolean bl) {
        this.resetDeliveryCount = bl;
        if (this.ddHandler != null) {
            this.ddHandler.setResetDeliveryCountOnForward(bl);
        }
    }

    public int getType() {
        return this.type;
    }

    public DistributedDestinationMemberBean getMemberBean(String string) {
        if (this.specificBean == null) {
            return null;
        }
        if (this.type == 0) {
            DistributedQueueBean distributedQueueBean = (DistributedQueueBean)this.specificBean;
            return distributedQueueBean.lookupDistributedQueueMember(string);
        }
        DistributedTopicBean distributedTopicBean = (DistributedTopicBean)this.specificBean;
        return distributedTopicBean.lookupDistributedTopicMember(string);
    }

    public DistributedDestinationMemberBean[] getMemberBeans() {
        if (this.specificBean == null) {
            return new DistributedDestinationMemberBean[0];
        }
        if (this.type == 0) {
            DistributedQueueBean distributedQueueBean = (DistributedQueueBean)this.specificBean;
            return distributedQueueBean.getDistributedQueueMembers();
        }
        DistributedTopicBean distributedTopicBean = (DistributedTopicBean)this.specificBean;
        return distributedTopicBean.getDistributedTopicMembers();
    }

    private String getMemberJndiName(DistributedDestinationMemberBean distributedDestinationMemberBean) {
        String string = distributedDestinationMemberBean.getPhysicalDestinationName();
        DestinationBean destinationBean = JMSBeanHelper.findDestinationBean(string, this.module);
        if (destinationBean == null) {
            return null;
        }
        return destinationBean.getJNDIName();
    }

    private String getMemberLocalJndiName(DistributedDestinationMemberBean distributedDestinationMemberBean) {
        String string = distributedDestinationMemberBean.getPhysicalDestinationName();
        DestinationBean destinationBean = JMSBeanHelper.findDestinationBean(string, this.module);
        if (destinationBean == null) {
            return null;
        }
        return destinationBean.getLocalJNDIName();
    }

    public String toString() {
        return "DistributedDestination(name = " + this.name + "; jndiName = " + this.jndiName + ")";
    }

    private final void internalValJndiName(String string, boolean bl) throws BeanUpdateRejectedException {
        if ((string = JMSServerUtilities.transformJNDIName(string)) == null) {
            return;
        }
        if (this.ddHandler.isActive() && this.jndiName != null && this.jndiName.equals(string)) {
            return;
        }
        Context context = JMSService.getContext(!bl);
        Object object = null;
        for (int i = 0; i < 40; ++i) {
            try {
                object = context.lookup(string);
            }
            catch (NameNotFoundException nameNotFoundException) {
                return;
            }
            catch (NamingException namingException) {
                throw new BeanUpdateRejectedException(namingException.getMessage(), (Throwable)namingException);
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        throw new BeanUpdateRejectedException("The proposed " + (bl ? "Local" : "") + " JNDI name " + string + " for destination " + this.name + " is already bound by another object of type " + (object == null ? "null" : object.getClass().getName()));
    }

    private final void valJNDIName(String string) throws BeanUpdateRejectedException {
        this.internalValJndiName(string, false);
    }

    public void prepare() throws ModuleException {
        this.initializeWithBean();
        try {
            this.valJNDIName(this.jndiName);
        }
        catch (BeanUpdateRejectedException beanUpdateRejectedException) {
            throw new ModuleException(beanUpdateRejectedException.getMessage(), beanUpdateRejectedException.getCause());
        }
        if (this.type == 0) {
            this.queueForwardDelay = ((DistributedQueueBean)this.specificBean).getForwardDelay();
            this.setResetDeliveryCountOnForward(((DistributedQueueBean)this.specificBean).getResetDeliveryCountOnForward());
            if (JMSDebug.JMSConfig.isDebugEnabled()) {
                JMSDebug.JMSConfig.debug("DistributedDestination.prepare()  queueForwardDelay " + this.queueForwardDelay + " resetDeliveryCount " + this.resetDeliveryCount);
            }
        }
        this.prepareMembers();
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Sucessfully prepared distributed destination: " + this.name);
        }
    }

    public void activate(JMSBean jMSBean) throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Activating distributed destination: " + this.name);
        }
        if (jMSBean != null) {
            this.module = jMSBean;
            this.specificBean = this.specificBean instanceof DistributedQueueBean ? this.module.lookupDistributedQueue(this.getEntityName()) : this.module.lookupDistributedTopic(this.getEntityName());
            this.closeBeanUpdateListeners();
        }
        this.openBeanUpdateListeners();
        if (this.ddHandler != null) {
            this.ddHandler = DDManager.activateOrUpdate(this.ddHandler);
        }
        this.activateMembers();
        JMSLogger.logDDDeployed((String)this.name);
        DDScheduler.drain();
        Throwable throwable = DDScheduler.waitForComplete();
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            if (throwable == null) {
                JMSDebug.JMSModule.debug("Sucessfully activated distributed destination: " + this.name);
            } else {
                JMSDebug.JMSModule.debug("failed to activate distributed destination: " + this.name, throwable);
            }
        }
        if (throwable != null) {
            if (throwable instanceof ModuleException) {
                throw (ModuleException)((Object)throwable);
            }
            throw new ModuleException(throwable);
        }
    }

    public void deactivate() {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Start deactivate distributed destination: " + this.name);
        }
        this.closeBeanUpdateListeners();
        this.deactivateMembers();
        if (this.ddHandler != null) {
            this.ddHandler.deactivate();
        } else if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("ddHandler is null for " + this.name);
        }
        DDScheduler.drain();
        Throwable throwable = DDScheduler.waitForComplete();
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            if (throwable == null) {
                JMSDebug.JMSModule.debug("Sucessfully deactivated distributed destination: " + this.name);
            } else {
                JMSDebug.JMSModule.debug("failed to deactivate distributed destination: " + this.name, throwable);
            }
        } else if (throwable != null) {
            JMSDebug.JMSModule.debug("ddHandler is null for " + this.name);
            throwable.printStackTrace();
        }
        this.ddHandler = null;
    }

    public void unprepare() {
        this.unprepareMembers();
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Sucessfully unprepared distributed destination: " + this.name);
        }
    }

    public void remove() {
    }

    public void destroy() {
    }

    public String getEntityName() {
        return this.specificBean.getName();
    }

    public void prepareChangeOfTargets(List list, DomainMBean domainMBean) {
    }

    public void activateChangeOfTargets() {
    }

    public void rollbackChangeOfTargets() {
    }

    public String getUnitOfOrderRouting() {
        return this.unitOfOrderRouting;
    }

    public void setUnitOfOrderRouting(String string) {
        this.unitOfOrderRouting = string.intern();
        if (this.ddHandler != null) {
            this.ddHandler.setUnitOfOrderRouting(this.unitOfOrderRouting);
        }
    }

    public boolean isDefaultUnitOfOrder() {
        return this.isDefaultUnitOfOrder;
    }

    public void setDefaultUnitOfOrder(boolean bl) {
        this.isDefaultUnitOfOrder = bl;
        if (this.ddHandler != null) {
            this.ddHandler.setDefaultUnitOfOrder(this.isDefaultUnitOfOrder);
        }
    }

    private void addMemberBean(DistributedDestinationMemberBean distributedDestinationMemberBean) throws BeanUpdateRejectedException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Preparing distributed destination member for add " + distributedDestinationMemberBean.getName());
        }
        try {
            this.prepareMember(distributedDestinationMemberBean, true);
        }
        catch (ModuleException moduleException) {
            throw new BeanUpdateRejectedException(JMSExceptionLogger.logCannotDynamicallyAddDDMemberLoggable((String)this.name, (String)distributedDestinationMemberBean.getName()).getMessage(), (Throwable)((Object)moduleException));
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Member " + distributedDestinationMemberBean.getName() + " is prepared for add ");
        }
    }

    private void removeMemberBean(DistributedDestinationMemberBean distributedDestinationMemberBean) {
        String string;
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Deactivating distributed destination member for removal" + distributedDestinationMemberBean.getName());
        }
        if ((string = JMSDeploymentHelper.getMemberName(this.moduleName, distributedDestinationMemberBean)) != null) {
            this.deactivateMember(distributedDestinationMemberBean);
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Member " + distributedDestinationMemberBean.getName() + " is deactivated for removal ");
        }
    }

    private void finishAddDistributedDestinationMember(String string, DistributedDestinationMemberBean distributedDestinationMemberBean, boolean bl) {
        if (string == null) {
            return;
        }
        if (bl) {
            if (this.ddHandler != null) {
                this.ddHandler.updateMembers(this.fullMemberNames());
            }
            this.activateMember(distributedDestinationMemberBean);
        } else {
            this.deactivateMember(distributedDestinationMemberBean);
        }
    }

    private void finishRemoveDistributedDestinationMember(String string, DistributedDestinationMemberBean distributedDestinationMemberBean, boolean bl) throws BeanUpdateRejectedException {
        if (string == null) {
            return;
        }
        if (bl) {
            if (this.ddHandler != null) {
                this.ddHandler.updateMembers(this.fullMemberNames());
            }
            this.unprepareMember(distributedDestinationMemberBean, true);
        } else {
            try {
                this.prepareMember(distributedDestinationMemberBean, true);
            }
            catch (ModuleException moduleException) {
                throw new BeanUpdateRejectedException(JMSExceptionLogger.logCannotDynamicallyRemoveDDMemberLoggable((String)this.name, (String)string).getMessage(), (Throwable)((Object)moduleException));
            }
        }
    }

    public void startAddDistributedQueueMembers(DistributedDestinationMemberBean distributedDestinationMemberBean) throws BeanUpdateRejectedException {
        if (distributedDestinationMemberBean == null) {
            return;
        }
        this.addMemberBean(distributedDestinationMemberBean);
    }

    public void finishAddDistributedQueueMembers(DistributedDestinationMemberBean distributedDestinationMemberBean, boolean bl) {
        this.finishAddDistributedDestinationMember(distributedDestinationMemberBean.getPhysicalDestinationName(), distributedDestinationMemberBean, bl);
    }

    public void startAddDistributedTopicMembers(DistributedDestinationMemberBean distributedDestinationMemberBean) throws BeanUpdateRejectedException {
        if (distributedDestinationMemberBean == null) {
            return;
        }
        this.addMemberBean(distributedDestinationMemberBean);
    }

    public void finishAddDistributedTopicMembers(DistributedDestinationMemberBean distributedDestinationMemberBean, boolean bl) {
        this.finishAddDistributedDestinationMember(distributedDestinationMemberBean.getPhysicalDestinationName(), distributedDestinationMemberBean, bl);
    }

    public void startRemoveDistributedQueueMembers(DistributedDestinationMemberBean distributedDestinationMemberBean) {
        if (distributedDestinationMemberBean == null) {
            return;
        }
        this.removeMemberBean(distributedDestinationMemberBean);
    }

    public void finishRemoveDistributedQueueMembers(DistributedDestinationMemberBean distributedDestinationMemberBean, boolean bl) throws BeanUpdateRejectedException {
        String string = JMSDeploymentHelper.getMemberName(this.moduleName, distributedDestinationMemberBean);
        this.finishRemoveDistributedDestinationMember(string, distributedDestinationMemberBean, bl);
    }

    public void startRemoveDistributedTopicMembers(DistributedDestinationMemberBean distributedDestinationMemberBean) {
        if (distributedDestinationMemberBean == null) {
            return;
        }
        this.removeMemberBean(distributedDestinationMemberBean);
    }

    public void finishRemoveDistributedTopicMembers(DistributedDestinationMemberBean distributedDestinationMemberBean, boolean bl) throws BeanUpdateRejectedException {
        String string = JMSDeploymentHelper.getMemberName(this.moduleName, distributedDestinationMemberBean);
        this.finishRemoveDistributedDestinationMember(string, distributedDestinationMemberBean, bl);
    }

    private void initializeBeanUpdateListeners() throws JMSException {
        DescriptorBean descriptorBean = (DescriptorBean)this.specificBean;
        this.distributedDestinationBeanListener = this.type == 0 ? new GenericBeanListener(descriptorBean, this, JMSBeanHelper.distributedQueueBeanSignatures, JMSBeanHelper.distributedQueueAdditionSignatures, false) : new GenericBeanListener(descriptorBean, this, JMSBeanHelper.distributedTopicBeanSignatures, JMSBeanHelper.distributedTopicAdditionSignatures, false);
        try {
            this.distributedDestinationBeanListener.initialize();
        }
        catch (ManagementException managementException) {
            throw new JMSException(managementException);
        }
        this.distributedDestinationBeanListener.setCustomizer(this);
    }

    private void openBeanUpdateListeners() {
        DescriptorBean descriptorBean = (DescriptorBean)this.specificBean;
        if (this.distributedDestinationBeanListener != null) {
            this.distributedDestinationBeanListener.open();
        } else {
            this.distributedDestinationBeanListener = this.type == 0 ? new GenericBeanListener(descriptorBean, (Object)this, (Map)JMSBeanHelper.distributedQueueBeanSignatures, JMSBeanHelper.distributedQueueAdditionSignatures) : new GenericBeanListener(descriptorBean, (Object)this, (Map)JMSBeanHelper.distributedTopicBeanSignatures, JMSBeanHelper.distributedTopicAdditionSignatures);
            this.distributedDestinationBeanListener.setCustomizer(this);
        }
    }

    private void closeBeanUpdateListeners() {
        if (this.distributedDestinationBeanListener != null) {
            this.distributedDestinationBeanListener.close();
            this.distributedDestinationBeanListener = null;
        }
    }

    public void activateFinished() {
    }

    public DistributedDestinationMemberBean lookupDistributedQueueMember(String string) {
        return null;
    }

    public DistributedDestinationMemberBean lookupDistributedTopicMember(String string) {
        return null;
    }

    public String getSAFExportPolicy() {
        return this.safExportPolicy;
    }

    public void setSAFExportPolicy(String string) {
        this.safExportPolicy = string == null ? "All" : string;
        if (this.ddHandler != null) {
            this.ddHandler.setSAFExportPolicy(this.safExportPolicy);
        }
    }

    static {
        groupBeanSignatures.put("Weight", Integer.TYPE);
    }

    private class InteropMemberHandler
    implements BeanUpdateListener {
        DistributedDestinationMemberBean memberBean;
        boolean physicalDestinationNameSet;

        InteropMemberHandler(DistributedDestinationMemberBean distributedDestinationMemberBean) {
            this.memberBean = distributedDestinationMemberBean;
            this.physicalDestinationNameSet = this.memberBean.isSet(DistributedDestination.PHYS_DEST_NAME);
            ((DescriptorBean)this.memberBean).addBeanUpdateListener((BeanUpdateListener)this);
        }

        private void close() {
            ((DescriptorBean)this.memberBean).removeBeanUpdateListener((BeanUpdateListener)this);
        }

        public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
            DistributedDestinationMemberBean distributedDestinationMemberBean = (DistributedDestinationMemberBean)beanUpdateEvent.getProposedBean();
            BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
            for (int i = 0; i < propertyUpdateArray.length; ++i) {
                BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
                String string = propertyUpdate.getPropertyName();
                if (!DistributedDestination.PHYS_DEST_NAME.equals(string)) continue;
                if (this.physicalDestinationNameSet) {
                    throw new BeanUpdateRejectedException("An attempt was made to change the physical destination from " + this.memberBean.getPhysicalDestinationName() + " to " + distributedDestinationMemberBean.getPhysicalDestinationName() + ".  This is not allowed.  The physical" + " destination may only be changed from an unset state to a particular physical destination");
                }
                DistributedDestination.this.addMemberBean(distributedDestinationMemberBean);
            }
        }

        public void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
            BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
            for (int i = 0; i < propertyUpdateArray.length; ++i) {
                BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
                String string = propertyUpdate.getPropertyName();
                if (!DistributedDestination.PHYS_DEST_NAME.equals(string)) continue;
                this.physicalDestinationNameSet = true;
                DistributedDestination.this.finishAddDistributedDestinationMember(this.memberBean.getPhysicalDestinationName(), this.memberBean, true);
            }
        }

        public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
            DistributedDestinationMemberBean distributedDestinationMemberBean = (DistributedDestinationMemberBean)beanUpdateEvent.getProposedBean();
            BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
            for (int i = 0; i < propertyUpdateArray.length; ++i) {
                BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
                String string = propertyUpdate.getPropertyName();
                if (!DistributedDestination.PHYS_DEST_NAME.equals(string)) continue;
                DistributedDestination.this.finishAddDistributedDestinationMember(distributedDestinationMemberBean.getPhysicalDestinationName(), distributedDestinationMemberBean, false);
            }
        }
    }
}

