/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dd;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.application.ApplicationContext;
import weblogic.application.ModuleException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.DistributedDestinationMemberBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.UniformDistributedDestinationBean;
import weblogic.j2ee.descriptor.wl.UniformDistributedQueueBean;
import weblogic.j2ee.descriptor.wl.UniformDistributedTopicBean;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.backend.udd.SyntheticDQBean;
import weblogic.jms.backend.udd.SyntheticDTBean;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.dd.DDConfig;
import weblogic.jms.dd.DDConstants;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.dd.DDManager;
import weblogic.jms.dd.DDScheduler;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.JMSDeploymentHelper;
import weblogic.jms.module.JMSModuleManagedEntity;
import weblogic.management.ManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSConstants;
import weblogic.management.utils.BeanListenerCustomizer;
import weblogic.management.utils.GenericBeanListener;

public class UniformDistributedDestination
implements JMSModuleManagedEntity,
BeanListenerCustomizer,
DDConfig,
DDConstants {
    private static final String PHYS_DEST_NAME = "PhysicalDestinationName";
    private String forwardingPolicy;
    private int type;
    private GenericBeanListener uddBeanListener;
    private UniformDistributedDestinationBean specificBean;
    private String name;
    private JMSBean module;
    private DDHandler ddHandler;
    private String jndiName;
    private ApplicationContext appCtx;
    private String safExportPolicy;
    private String EARModuleName;
    private String moduleName;
    private String unitOfOrderRouting;
    private boolean isDefaultUnitOfOrder;
    private String loadBalancingPolicy;
    private int queueForwardDelay;
    private boolean resetDeliveryCount = true;

    public UniformDistributedDestination(String string, JMSBean jMSBean, UniformDistributedDestinationBean uniformDistributedDestinationBean, String string2, String string3, ApplicationContext applicationContext) {
        this.name = string;
        this.module = jMSBean;
        this.specificBean = uniformDistributedDestinationBean;
        this.EARModuleName = string2;
        this.moduleName = string3;
        this.appCtx = applicationContext;
        this.type = this.specificBean instanceof UniformDistributedQueueBean ? 0 : 1;
        this.ddHandler = new DDHandler(this, true);
    }

    private void initializeBeanUpdateListeners() throws JMSException {
        DescriptorBean descriptorBean = (DescriptorBean)this.specificBean;
        this.uddBeanListener = this.type == 0 ? new GenericBeanListener(descriptorBean, (Object)this, (Map)JMSBeanHelper.uniformDistributedQueueBeanSignatures, false) : new GenericBeanListener(descriptorBean, (Object)this, (Map)JMSBeanHelper.uniformDistributedTopicBeanSignatures, false);
        try {
            this.uddBeanListener.initialize();
        }
        catch (ManagementException managementException) {
            throw new JMSException(managementException);
        }
        this.uddBeanListener.setCustomizer(this);
    }

    public void activate(JMSBean jMSBean) throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Activating uniform distributed destination: " + this.name);
        }
        if (jMSBean != null) {
            this.module = jMSBean;
            this.specificBean = this.specificBean instanceof UniformDistributedQueueBean ? this.module.lookupUniformDistributedQueue(this.getEntityName()) : this.module.lookupUniformDistributedTopic(this.getEntityName());
            this.closeBeanUpdateListeners();
        }
        this.openBeanUpdateListeners();
        if (this.ddHandler != null) {
            this.ddHandler = DDManager.activateOrUpdate(this.ddHandler);
        }
        this.activateMembers();
        JMSLogger.logDDDeployed((String)this.name);
        DDScheduler.drain();
        Throwable throwable = DDScheduler.waitForComplete();
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            if (throwable == null) {
                JMSDebug.JMSModule.debug("Sucessfully activated uniform distributed destination: " + this.name);
            } else {
                JMSDebug.JMSModule.debug("failed to activate uniform distributed destination: " + this.name, throwable);
            }
        }
        if (throwable != null) {
            if (throwable instanceof ModuleException) {
                throw (ModuleException)((Object)throwable);
            }
            throw new ModuleException(throwable);
        }
    }

    private void closeBeanUpdateListeners() {
        if (this.uddBeanListener != null) {
            this.uddBeanListener.close();
            this.uddBeanListener = null;
        }
    }

    private void openBeanUpdateListeners() {
        DescriptorBean descriptorBean = (DescriptorBean)this.specificBean;
        if (this.uddBeanListener != null) {
            this.uddBeanListener.open();
        } else {
            this.uddBeanListener = this.type == 0 ? new GenericBeanListener(descriptorBean, this, JMSBeanHelper.uniformDistributedQueueBeanSignatures) : new GenericBeanListener(descriptorBean, this, JMSBeanHelper.uniformDistributedTopicBeanSignatures);
            this.uddBeanListener.setCustomizer(this);
        }
    }

    private void activateMembers() {
        if (this.ddHandler != null) {
            this.ddHandler.updateMembers(this.fullMemberNames());
        }
    }

    private List fullMemberNames() {
        DistributedDestinationMemberBean[] distributedDestinationMemberBeanArray = this.getMemberBeans();
        ArrayList<String> arrayList = new ArrayList<String>(distributedDestinationMemberBeanArray.length);
        for (int i = 0; i < distributedDestinationMemberBeanArray.length; ++i) {
            DistributedDestinationMemberBean distributedDestinationMemberBean = distributedDestinationMemberBeanArray[i];
            String string = JMSDeploymentHelper.getMemberName(this.moduleName, distributedDestinationMemberBean);
            arrayList.add(string);
        }
        return arrayList;
    }

    public DistributedDestinationMemberBean[] getMemberBeans() {
        if (this.specificBean == null) {
            return new DistributedDestinationMemberBean[0];
        }
        if (this.type == 0) {
            UniformDistributedQueueBean uniformDistributedQueueBean = (UniformDistributedQueueBean)this.specificBean;
            return ((SyntheticDQBean)uniformDistributedQueueBean).getDistributedQueueMembers();
        }
        UniformDistributedTopicBean uniformDistributedTopicBean = (UniformDistributedTopicBean)this.specificBean;
        return ((SyntheticDTBean)uniformDistributedTopicBean).getDistributedTopicMembers();
    }

    public void deactivate() {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Start deactivate uniform distributed destination: " + this.name);
        }
        this.closeBeanUpdateListeners();
        if (this.ddHandler != null) {
            this.ddHandler.deactivate();
        } else if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("ddHandler is null for " + this.name);
        }
        DDScheduler.drain();
        Throwable throwable = DDScheduler.waitForComplete();
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            if (throwable == null) {
                JMSDebug.JMSModule.debug("Sucessfully deactivated uniform distributed destination: " + this.name);
            } else {
                JMSDebug.JMSModule.debug("failed to deactivate uniform distributed destination: " + this.name, throwable);
            }
        } else if (throwable != null) {
            JMSDebug.JMSModule.debug("ddHandler is null for " + this.name);
            throwable.printStackTrace();
        }
        this.ddHandler = null;
    }

    public void prepare() throws ModuleException {
        this.initializeWithBean();
        try {
            this.valJNDIName(this.jndiName);
        }
        catch (BeanUpdateRejectedException beanUpdateRejectedException) {
            throw new ModuleException(beanUpdateRejectedException.getMessage(), beanUpdateRejectedException.getCause());
        }
        if (this.type == 0) {
            this.queueForwardDelay = ((UniformDistributedQueueBean)this.specificBean).getForwardDelay();
            this.setResetDeliveryCountOnForward(((UniformDistributedQueueBean)this.specificBean).getResetDeliveryCountOnForward());
            if (JMSDebug.JMSConfig.isDebugEnabled()) {
                JMSDebug.JMSConfig.debug("UniformDistributedDestination.prepare()  queueForwardDelay " + this.queueForwardDelay + " resetDeliveryCount " + this.resetDeliveryCount);
            }
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Sucessfully prepared uniform distributed destination: " + this.name);
        }
    }

    private final void valJNDIName(String string) throws BeanUpdateRejectedException {
        this.internalValJndiName(string, false);
    }

    private final void internalValJndiName(String string, boolean bl) throws BeanUpdateRejectedException {
        if ((string = JMSServerUtilities.transformJNDIName(string)) == null) {
            return;
        }
        if (this.ddHandler.isActive() && this.jndiName != null && this.jndiName.equals(string)) {
            return;
        }
        Context context = JMSService.getContext(!bl);
        Object object = null;
        for (int i = 0; i < 40; ++i) {
            try {
                object = context.lookup(string);
            }
            catch (NameNotFoundException nameNotFoundException) {
                return;
            }
            catch (NamingException namingException) {
                throw new BeanUpdateRejectedException(namingException.getMessage(), (Throwable)namingException);
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        throw new BeanUpdateRejectedException("The proposed " + (bl ? "Local" : "") + " JNDI name " + string + " for destination " + this.name + " is already bound by another object of type " + (object == null ? "null" : object.getClass().getName()));
    }

    private void initializeWithBean() throws ModuleException {
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Initializing uniform distributed destination with Bean " + this.specificBean.getName());
        }
        try {
            this.initializeBeanUpdateListeners();
        }
        catch (JMSException jMSException) {
            throw new ModuleException(jMSException.getMessage(), (Throwable)((Object)jMSException));
        }
    }

    public void unprepare() {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Sucessfully unprepared uniform distributed destination: " + this.name);
        }
    }

    public int getLoadBalancingPolicyAsInt() {
        return UniformDistributedDestination.translateLoadBalancingPolicy(this.loadBalancingPolicy);
    }

    public String getLoadBalancingPolicy() {
        return this.loadBalancingPolicy;
    }

    public void setLoadBalancingPolicy(String string) {
        this.loadBalancingPolicy = string;
        if (this.ddHandler != null) {
            this.ddHandler.setLoadBalancingPolicyAsInt(UniformDistributedDestination.translateLoadBalancingPolicy(string));
        }
    }

    public static int translateLoadBalancingPolicy(String string) {
        int n = 0;
        if (string != null) {
            if (string.equals("Round-Robin")) {
                n = 0;
            } else if (string.equals("Random")) {
                n = 1;
            }
        }
        return n;
    }

    public String getForwardingPolicy() {
        return this.forwardingPolicy;
    }

    public void setForwardingPolicy(String string) {
        this.forwardingPolicy = string;
        if (this.ddHandler != null) {
            this.ddHandler.setForwardingPolicy(UniformDistributedDestination.translateForwardingPolicy(string));
        }
    }

    public int getForwardingPolicyAsInt() {
        return UniformDistributedDestination.translateForwardingPolicy(this.forwardingPolicy);
    }

    public static int translateForwardingPolicy(String string) {
        int n = 1;
        if (string != null) {
            if (string.equals(JMSConstants.FORWARDING_POLICY_REPLICATED)) {
                n = 1;
            } else if (string.equals(JMSConstants.FORWARDING_POLICY_PARTITIONED)) {
                n = 0;
            } else {
                throw new IllegalArgumentException("Unrecognized forwarding policy " + string + ". Allowed valid values=" + JMSConstants.FORWARDING_POLICY_REPLICATED + "," + JMSConstants.FORWARDING_POLICY_PARTITIONED);
            }
        }
        return n;
    }

    public boolean getResetDeliveryCountOnForward() {
        return this.resetDeliveryCount;
    }

    public void setResetDeliveryCountOnForward(boolean bl) {
        this.resetDeliveryCount = bl;
        if (this.ddHandler != null) {
            this.ddHandler.setResetDeliveryCountOnForward(bl);
        }
    }

    public int getForwardDelay() {
        return this.queueForwardDelay;
    }

    public void setForwardDelay(int n) {
        this.queueForwardDelay = n;
        if (this.ddHandler != null) {
            this.ddHandler.setForwardDelay(n);
        }
    }

    public void destroy() {
    }

    public void remove() {
    }

    public void finishAddDistributedQueueMembers(DistributedDestinationMemberBean distributedDestinationMemberBean, boolean bl) {
        this.finishAddDistributedDestinationMember(distributedDestinationMemberBean.getPhysicalDestinationName(), distributedDestinationMemberBean, bl);
    }

    private void finishAddDistributedDestinationMember(String string, DistributedDestinationMemberBean distributedDestinationMemberBean, boolean bl) {
        if (string == null) {
            return;
        }
        if (bl && this.ddHandler != null) {
            this.ddHandler.updateMembers(this.fullMemberNames());
        }
    }

    public void finishAddDistributedTopicMembers(DistributedDestinationMemberBean distributedDestinationMemberBean, boolean bl) {
        this.finishAddDistributedDestinationMember(distributedDestinationMemberBean.getPhysicalDestinationName(), distributedDestinationMemberBean, bl);
    }

    public void finishRemoveDistributedQueueMembers(DistributedDestinationMemberBean distributedDestinationMemberBean, boolean bl) throws BeanUpdateRejectedException {
        String string = JMSDeploymentHelper.getMemberName(this.moduleName, distributedDestinationMemberBean);
        this.finishRemoveDistributedDestinationMember(string, distributedDestinationMemberBean, bl);
    }

    private void finishRemoveDistributedDestinationMember(String string, DistributedDestinationMemberBean distributedDestinationMemberBean, boolean bl) throws BeanUpdateRejectedException {
        if (string == null) {
            return;
        }
        if (bl && this.ddHandler != null) {
            this.ddHandler.updateMembers(this.fullMemberNames());
        }
    }

    public void finishRemoveDistributedTopicMembers(DistributedDestinationMemberBean distributedDestinationMemberBean, boolean bl) throws BeanUpdateRejectedException {
        String string = JMSDeploymentHelper.getMemberName(this.moduleName, distributedDestinationMemberBean);
        this.finishRemoveDistributedDestinationMember(string, distributedDestinationMemberBean, bl);
    }

    public void activateFinished() {
    }

    public String getEntityName() {
        return this.specificBean.getName();
    }

    public int getType() {
        return this.type;
    }

    public boolean isDefaultUnitOfOrder() {
        return this.isDefaultUnitOfOrder;
    }

    public String getApplicationName() {
        if (this.appCtx != null) {
            return this.appCtx.getApplicationId();
        }
        return null;
    }

    public void rollbackChangeOfTargets() {
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String string) throws IllegalArgumentException {
        this.jndiName = JMSServerUtilities.transformJNDIName(string);
        if (this.ddHandler != null) {
            this.ddHandler.setJNDIName(string);
        }
    }

    public String getName() {
        return this.name;
    }

    public void prepareChangeOfTargets(List list, DomainMBean domainMBean) {
    }

    public String getSAFExportPolicy() {
        return this.safExportPolicy;
    }

    public void setSAFExportPolicy(String string) {
        this.safExportPolicy = string == null ? "All" : string;
        if (this.ddHandler != null) {
            this.ddHandler.setSAFExportPolicy(this.safExportPolicy);
        }
    }

    public String getUnitOfOrderRouting() {
        return this.unitOfOrderRouting;
    }

    public void setUnitOfOrderRouting(String string) {
        this.unitOfOrderRouting = string.intern();
        if (this.ddHandler != null) {
            this.ddHandler.setUnitOfOrderRouting(this.unitOfOrderRouting);
        }
    }

    public String getEARModuleName() {
        return this.EARModuleName;
    }

    public void activateChangeOfTargets() {
    }

    public String getReferenceName() {
        return null;
    }

    private class InteropMemberHandler
    implements BeanUpdateListener {
        DistributedDestinationMemberBean memberBean;
        boolean physicalDestinationNameSet;

        InteropMemberHandler(DistributedDestinationMemberBean distributedDestinationMemberBean) {
            this.memberBean = distributedDestinationMemberBean;
            this.physicalDestinationNameSet = this.memberBean.isSet(UniformDistributedDestination.PHYS_DEST_NAME);
            ((DescriptorBean)this.memberBean).addBeanUpdateListener((BeanUpdateListener)this);
        }

        private void close() {
            ((DescriptorBean)this.memberBean).removeBeanUpdateListener((BeanUpdateListener)this);
        }

        public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
            DistributedDestinationMemberBean distributedDestinationMemberBean = (DistributedDestinationMemberBean)beanUpdateEvent.getProposedBean();
            BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
            for (int i = 0; i < propertyUpdateArray.length; ++i) {
                BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
                String string = propertyUpdate.getPropertyName();
                if (!UniformDistributedDestination.PHYS_DEST_NAME.equals(string) || !this.physicalDestinationNameSet) continue;
                throw new BeanUpdateRejectedException("An attempt was made to change the physical destination from " + this.memberBean.getPhysicalDestinationName() + " to " + distributedDestinationMemberBean.getPhysicalDestinationName() + ".  This is not allowed.  The physical" + " destination may only be changed from an unset state to a particular physical destination");
            }
        }

        public void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
            BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
            for (int i = 0; i < propertyUpdateArray.length; ++i) {
                BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
                String string = propertyUpdate.getPropertyName();
                if (!UniformDistributedDestination.PHYS_DEST_NAME.equals(string)) continue;
                this.physicalDestinationNameSet = true;
                UniformDistributedDestination.this.finishAddDistributedDestinationMember(this.memberBean.getPhysicalDestinationName(), this.memberBean, true);
            }
        }

        public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
            DistributedDestinationMemberBean distributedDestinationMemberBean = (DistributedDestinationMemberBean)beanUpdateEvent.getProposedBean();
            BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
            for (int i = 0; i < propertyUpdateArray.length; ++i) {
                BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
                String string = propertyUpdate.getPropertyName();
                if (!UniformDistributedDestination.PHYS_DEST_NAME.equals(string)) continue;
                UniformDistributedDestination.this.finishAddDistributedDestinationMember(distributedDestinationMemberBean.getPhysicalDestinationName(), distributedDestinationMemberBean, false);
            }
        }
    }
}

