/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.deployer;

import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEUOWCallbackFactory;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.backend.udd.UDDEntity;
import weblogic.jms.common.JMSDebug;
import weblogic.logging.jms.JMSMessageLogger;
import weblogic.logging.jms.JMSMessageLoggerFactory;
import weblogic.management.DeploymentException;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.JMSMessageLogFileMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSSessionPoolMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.utils.GenericAdminHandler;
import weblogic.management.utils.GenericBeanListener;
import weblogic.messaging.kernel.UOWCallbackFactory;
import weblogic.messaging.kernel.internal.UOWSequenceImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.store.PersistentStoreManager;
import weblogic.store.admin.FileAdminHandler;
import weblogic.store.xa.PersistentStoreXA;

public final class BEAdminHandler
implements GenericAdminHandler {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final HashMap backendBeanSignatures = new HashMap();
    private static final HashMap backendAdditionSignatures = new HashMap();
    private BackEnd backEnd;
    private GenericBeanListener changeListener;

    public boolean isMigrationInProgress() {
        return JMSService.getJMSService().isMigrationInProgress();
    }

    public void setMigrationInProgress(boolean bl) {
        JMSService.getJMSService().setMigrationInProgress(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(DeploymentMBean deploymentMBean) throws DeploymentException {
        try {
            if (JMSDebug.JMSConfig.isDebugEnabled()) {
                JMSDebug.JMSConfig.debug("Adding JMSServer: " + deploymentMBean.getName());
            }
            if (deploymentMBean.getTargets().length > 1) {
                JMSLogger.logErrorBEMultiDeployed((String)deploymentMBean.getName());
                throw new DeploymentException("The JMS Server " + deploymentMBean.getName() + " may only be deployed on one server");
            }
            JMSServerMBean jMSServerMBean = (JMSServerMBean)deploymentMBean;
            SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID);
            try {
                this.backEnd = new BackEnd(jMSServerMBean.getName(), "JMSServer");
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
                throw throwable;
            }
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
            this.changeListener = new GenericBeanListener((DescriptorBean)jMSServerMBean, (Object)this.backEnd, (Map)backendBeanSignatures, backendAdditionSignatures);
            this.changeListener.setCustomizer(this.backEnd);
            this.changeListener.initialize();
            this.backEnd.setSessionPoolMBeans(jMSServerMBean.getJMSSessionPools());
            JMSService.getJMSService().getBEDeployer().addBackEnd(this.backEnd);
            BEAdminHandler bEAdminHandler = this;
            synchronized (bEAdminHandler) {
                UDDEntity.prepareLocalJMSServer((JMSServerMBean)deploymentMBean);
                try {
                    JMSService.getJMSService().startAddJMSServers(jMSServerMBean);
                }
                catch (BeanUpdateRejectedException beanUpdateRejectedException) {
                    throw new DeploymentException(beanUpdateRejectedException);
                }
            }
            if (jMSServerMBean.isBytesPagingEnabled() || jMSServerMBean.isMessagesPagingEnabled()) {
                JMSLogger.logServerPagingParametersDeprecated((String)deploymentMBean.getName());
            }
        }
        catch (JMSException jMSException) {
            JMSLogger.logErrorCreateBE((String)deploymentMBean.getName(), (Throwable)jMSException);
            throw new DeploymentException("Error preparing the JMS Server " + deploymentMBean.getName() + ": " + jMSException.toString(), jMSException);
        }
        catch (ManagementException managementException) {
            JMSLogger.logErrorCreateBE((String)deploymentMBean.getName(), (Throwable)managementException);
            throw new DeploymentException("Error preparing the JMS Server " + deploymentMBean.getName() + ": " + managementException.toString(), managementException);
        }
        catch (Throwable throwable) {
            JMSLogger.logErrorCreateBE((String)deploymentMBean.getName(), (Throwable)throwable);
            throw new DeploymentException("Internal error preparing the JMS server " + deploymentMBean.getName() + ": " + throwable.toString(), throwable);
        }
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Successfully prepared JMSServer: " + deploymentMBean.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(DeploymentMBean deploymentMBean) throws DeploymentException {
        JMSServerMBean jMSServerMBean = (JMSServerMBean)deploymentMBean;
        DeploymentException deploymentException = null;
        if (this.changeListener != null) {
            this.changeListener.close();
            this.changeListener = null;
        }
        this.changeListener = new GenericBeanListener((DescriptorBean)jMSServerMBean, (Object)this.backEnd, (Map)backendBeanSignatures, backendAdditionSignatures);
        this.changeListener.setCustomizer(this.backEnd);
        if (this.backEnd == null) {
            JMSLogger.logErrorDeployingBE((String)deploymentMBean.getName(), (String)"activate", (String)"prepare");
            throw new DeploymentException("Cannot activate the JMS Server " + deploymentMBean.getName() + " because it was not prepared");
        }
        try {
            this.backEnd.setPersistentStore(BEAdminHandler.findPersistentStore(jMSServerMBean));
            this.backEnd.setPagingDirectory(BEAdminHandler.findPagingDirectory(jMSServerMBean));
            this.backEnd.setPagingFileLockingEnabled(jMSServerMBean.isPagingFileLockingEnabled());
            this.backEnd.setJMSMessageLogger(BEAdminHandler.findJMSMessageLogger(jMSServerMBean));
            this.backEnd.open();
        }
        catch (JMSException jMSException) {
            JMSLogger.logErrorStartBE((String)deploymentMBean.getName(), (Throwable)jMSException);
            deploymentException = new DeploymentException("Error activating the JMS Server " + deploymentMBean.getName() + ": " + jMSException.toString(), jMSException);
        }
        catch (Throwable throwable) {
            JMSLogger.logErrorStartBE((String)deploymentMBean.getName(), (Throwable)throwable);
            deploymentException = new DeploymentException("Internal error activating the JMS Server " + deploymentMBean.getName() + ": " + throwable.toString(), throwable);
        }
        if (deploymentException != null) {
            this.backEnd.setHealthFailed((Exception)((Object)deploymentException));
            throw deploymentException;
        }
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Successfully activated JMSServer: " + deploymentMBean.getName());
        }
        BEAdminHandler bEAdminHandler = this;
        synchronized (bEAdminHandler) {
            UDDEntity.activateLocalJMSServer((JMSServerMBean)deploymentMBean);
            JMSService.getJMSService().finishAddJMSServers((JMSServerMBean)deploymentMBean, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(DeploymentMBean deploymentMBean) throws UndeploymentException {
        if (this.backEnd == null) {
            JMSLogger.logErrorDeployingBE((String)deploymentMBean.getName(), (String)"deactivate", (String)"activate");
            throw new UndeploymentException("Cannot deactivate the JMS Server " + deploymentMBean.getName() + " because it was not activated");
        }
        this.backEnd.close();
        BEAdminHandler bEAdminHandler = this;
        synchronized (bEAdminHandler) {
            UDDEntity.deactivateLocalJMSServer((JMSServerMBean)deploymentMBean);
            try {
                JMSService.getJMSService().startRemoveJMSServers((JMSServerMBean)deploymentMBean);
            }
            catch (BeanUpdateRejectedException beanUpdateRejectedException) {
                throw new UndeploymentException(beanUpdateRejectedException);
            }
        }
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Successffuly deactivated JMSServer: " + deploymentMBean.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unprepare(DeploymentMBean deploymentMBean) throws UndeploymentException {
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Removing JMSServer: " + deploymentMBean.getName());
        }
        if (this.backEnd == null) {
            JMSLogger.logErrorDeployingBE((String)deploymentMBean.getName(), (String)"unprepare", (String)"deactivate");
            throw new UndeploymentException("Cannot unprepare the JMS Server " + deploymentMBean.getName() + " because it was not deactivated");
        }
        this.backEnd.destroy();
        if (this.changeListener != null) {
            this.changeListener.close();
        }
        JMSService.getJMSService().getBEDeployer().removeBackEnd(this.backEnd);
        BEAdminHandler bEAdminHandler = this;
        synchronized (bEAdminHandler) {
            UDDEntity.unprepareLocalJMSServer((JMSServerMBean)deploymentMBean);
            JMSService.getJMSService().finishRemoveJMSServers((JMSServerMBean)deploymentMBean, true);
        }
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Successfuly removed JMSServer: " + deploymentMBean.getName());
        }
    }

    private static PersistentStoreXA findPersistentStore(JMSServerMBean jMSServerMBean) throws DeploymentException {
        if (!jMSServerMBean.getStoreEnabled()) {
            return null;
        }
        if (jMSServerMBean.getPersistentStore() != null) {
            String string = jMSServerMBean.getPersistentStore().getName();
            PersistentStoreXA persistentStoreXA = (PersistentStoreXA)PersistentStoreManager.getManager().getStore(string);
            if (persistentStoreXA == null) {
                throw new DeploymentException("The persistent store \"" + string + "\" does not exist");
            }
            if (JMSDebug.JMSBoot.isDebugEnabled()) {
                JMSDebug.JMSBoot.debug("JMSServer using the 9.0 store " + string);
            }
            return persistentStoreXA;
        }
        PersistentStoreXA persistentStoreXA = (PersistentStoreXA)PersistentStoreManager.getManager().getDefaultStore();
        if (persistentStoreXA == null) {
            throw new DeploymentException("The default persistent store does not exist");
        }
        if (JMSDebug.JMSBoot.isDebugEnabled()) {
            JMSDebug.JMSBoot.debug("JMSServer using the default store");
        }
        return persistentStoreXA;
    }

    private static String findPagingDirectory(JMSServerMBean jMSServerMBean) {
        String string;
        if (jMSServerMBean.getPagingDirectory() != null) {
            string = jMSServerMBean.getPagingDirectory();
            string = FileAdminHandler.canonicalizeDirectoryName(string);
        } else {
            String string2 = ManagementService.getRuntimeAccess(KERNEL_ID).getServer().getName();
            string = DomainDir.getTempDirForServer((String)string2);
        }
        return string;
    }

    private static JMSMessageLogger findJMSMessageLogger(JMSServerMBean jMSServerMBean) throws DeploymentException {
        try {
            JMSMessageLogFileMBean jMSMessageLogFileMBean = jMSServerMBean.getJMSMessageLogFile();
            return JMSMessageLoggerFactory.findOrCreateJMSMessageLogger(jMSMessageLogFileMBean);
        }
        catch (IOException iOException) {
            throw new DeploymentException("Cannot find or create JMS message log file for JMS server " + jMSServerMBean.getName(), iOException);
        }
    }

    static {
        backendBeanSignatures.put("BytesMaximum", Long.TYPE);
        backendBeanSignatures.put("BytesThresholdHigh", Long.TYPE);
        backendBeanSignatures.put("BytesThresholdLow", Long.TYPE);
        backendBeanSignatures.put("MessagesMaximum", Long.TYPE);
        backendBeanSignatures.put("MessagesThresholdHigh", Long.TYPE);
        backendBeanSignatures.put("MessagesThresholdLow", Long.TYPE);
        backendBeanSignatures.put("BlockingSendPolicy", String.class);
        backendBeanSignatures.put("ExpirationScanInterval", Integer.TYPE);
        backendBeanSignatures.put("MaximumMessageSize", Integer.TYPE);
        backendBeanSignatures.put("MessageBufferSize", Long.TYPE);
        backendBeanSignatures.put("PagingDirectory", String.class);
        backendBeanSignatures.put("PagingFileLockingEnabled", Boolean.TYPE);
        backendBeanSignatures.put("PagingMinWindowBufferSize", Integer.TYPE);
        backendBeanSignatures.put("PagingMaxWindowBufferSize", Integer.TYPE);
        backendBeanSignatures.put("PagingIoBufferSize", Integer.TYPE);
        backendBeanSignatures.put("PagingBlockSize", Integer.TYPE);
        backendBeanSignatures.put("PagingMaxFileSize", Long.TYPE);
        backendBeanSignatures.put("HostingTemporaryDestinations", Boolean.TYPE);
        backendBeanSignatures.put("TemporaryTemplateName", String.class);
        backendBeanSignatures.put("TemporaryTemplateResource", String.class);
        backendBeanSignatures.put("ProductionPausedAtStartup", String.class);
        backendBeanSignatures.put("InsertionPausedAtStartup", String.class);
        backendBeanSignatures.put("ConsumptionPausedAtStartup", String.class);
        backendBeanSignatures.put("AllowsPersistentDowngrade", Boolean.TYPE);
        backendAdditionSignatures.put("JMSSessionPools", JMSSessionPoolMBean.class);
        UOWSequenceImpl.setCallbackFactory((UOWCallbackFactory)new BEUOWCallbackFactory());
    }
}

