/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.deployer;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.naming.NamingException;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BETempDestinationFactory;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.backend.BackEndTempDestinationFactory;
import weblogic.jms.common.CDS;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class BEDeployer {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private BETempDestinationFactory beTempDestinationFactory;
    private static final String JMS_TEMP_DESTINATION_FTY_JNDI = "weblogic.jms.TempDestinationFactory";
    private Object shutdownLock;
    private final HashMap backEnds = new HashMap();
    private final HashMap backEndByIds = new HashMap();
    private long backEndsHighCount;
    private long backEndsTotalCount;
    private ArrayList tempDestFactories = new ArrayList();
    private int currentFactoryIndex = -1;
    private JMSService jmsService = null;

    public BEDeployer(JMSService jMSService) {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Constructing JMS BEDeployer");
        }
        this.jmsService = jMSService;
        this.beTempDestinationFactory = new BETempDestinationFactory();
        this.shutdownLock = this.backEnds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getShutdownLock() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.shutdownLock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBackEndsHighCount() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.backEndsHighCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBackEndsTotalCount() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.backEndsTotalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBackEnd(BackEnd backEnd) throws JMSException {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.jmsService.checkShutdown();
            if (this.backEnds.put(backEnd.getName(), backEnd) == null) {
                this.backEndsHighCount = Math.max((long)this.backEnds.size(), this.backEndsHighCount);
                ++this.backEndsTotalCount;
                this.backEndByIds.put(backEnd.getJMSServerId(), backEnd);
                InvocableManagerDelegate.delegate.invocableAdd(14, backEnd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBackEnd(BackEnd backEnd) {
        if (backEnd != null) {
            Object object = this.shutdownLock;
            synchronized (object) {
                this.backEnds.remove(backEnd.getName());
                this.backEndByIds.remove(backEnd.getJMSServerId());
                InvocableManagerDelegate.delegate.invocableRemove(14, backEnd.getJMSID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackEnd[] getBackEnds() {
        Object object = this.shutdownLock;
        synchronized (object) {
            BackEnd[] backEndArray = new BackEnd[this.backEnds.size()];
            return this.backEnds.values().toArray(backEndArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getBackEndsMap() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.backEnds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackEnd findBackEnd(String string) {
        Object object = this.shutdownLock;
        synchronized (object) {
            return (BackEnd)this.backEnds.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackEnd findBackEnd(JMSServerId jMSServerId) {
        Object object = this.shutdownLock;
        synchronized (object) {
            return (BackEnd)this.backEndByIds.get(jMSServerId);
        }
    }

    public BEDestinationImpl findBEDestination(String string) {
        BEDestinationImpl bEDestinationImpl = null;
        BackEnd[] backEndArray = this.getBackEnds();
        for (int i = 0; i < backEndArray.length; ++i) {
            bEDestinationImpl = backEndArray[i].findDestination(string);
            if (bEDestinationImpl == null) continue;
            return bEDestinationImpl;
        }
        return bEDestinationImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeploymentsStart() {
        Object object = this.shutdownLock;
        synchronized (object) {
            CDS.getCDS().postDeploymentsStart();
            BackEnd[] backEndArray = this.getBackEnds();
            if (backEndArray == null) {
                return;
            }
            for (int i = 0; i < backEndArray.length; ++i) {
                backEndArray[i].postDeploymentsStart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeploymentsStop() {
        Object object = this.shutdownLock;
        synchronized (object) {
            BackEnd[] backEndArray = this.getBackEnds();
            if (backEndArray == null) {
                return;
            }
            for (int i = 0; i < backEndArray.length; ++i) {
                backEndArray[i].postDeploymentsStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackEndTempDestinationFactory nextFactory() {
        Object object = this.shutdownLock;
        synchronized (object) {
            int n = this.tempDestFactories.size();
            if (n <= 0) {
                this.currentFactoryIndex = -1;
                return null;
            }
            if (this.currentFactoryIndex < 0 || this.currentFactoryIndex >= n) {
                this.currentFactoryIndex = 0;
            }
            BackEndTempDestinationFactory backEndTempDestinationFactory = (BackEndTempDestinationFactory)this.tempDestFactories.get(this.currentFactoryIndex++);
            if (this.currentFactoryIndex >= n) {
                this.currentFactoryIndex = 0;
            }
            return backEndTempDestinationFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTempDestinationFactory(BackEndTempDestinationFactory backEndTempDestinationFactory) throws NamingException {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.tempDestFactories.add(backEndTempDestinationFactory);
            if (this.tempDestFactories.size() == 1) {
                PrivilegedActionUtilities.bindAsSU(JMSService.getContext(true), JMS_TEMP_DESTINATION_FTY_JNDI, this.beTempDestinationFactory.getFactoryWrapper(), kernelId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTempDestinationFactory(BackEndTempDestinationFactory backEndTempDestinationFactory) throws NamingException {
        Object object = this.shutdownLock;
        synchronized (object) {
            Iterator iterator = this.tempDestFactories.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                BackEndTempDestinationFactory backEndTempDestinationFactory2 = (BackEndTempDestinationFactory)iterator.next();
                if (backEndTempDestinationFactory2 != backEndTempDestinationFactory) continue;
                bl = true;
                iterator.remove();
            }
            if (bl) {
                int n = this.tempDestFactories.size();
                if (n <= 0) {
                    this.currentFactoryIndex = -1;
                    PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(true), JMS_TEMP_DESTINATION_FTY_JNDI, kernelId);
                    try {
                        ServerHelper.unexportObject((Remote)this.beTempDestinationFactory, (boolean)true);
                    }
                    catch (NoSuchObjectException noSuchObjectException) {}
                } else if (this.currentFactoryIndex >= n) {
                    this.currentFactoryIndex = 0;
                }
            }
        }
    }

    public BETempDestinationFactory getBETempDestinationFactory() {
        return this.beTempDestinationFactory;
    }
}

