/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.deployer;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.deployer.DeployerConstants;
import weblogic.jms.frontend.FEConnectionFactory;
import weblogic.jms.frontend.FrontEnd;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class FEDeployer
implements DeployerConstants {
    private Object shutdownLock;
    private boolean initialized;
    private HashMap defaultConnectionFactories;
    private FrontEnd frontEnd;
    private JMSService jmsService;

    public FEDeployer(JMSService jMSService) throws ManagementException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Constructing JMS FEDeployer");
        }
        this.jmsService = jMSService;
        this.allocate();
    }

    public void initialize(FrontEnd frontEnd) {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Initializing JMS FEDeployer");
        }
        this.frontEnd = frontEnd;
        this.initializeConnectionFactories();
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        if (ManagementService.getRuntimeAccess(authenticatedSubject).getServer().isJMSDefaultConnectionFactoriesEnabled()) {
            this.deployDefaultConnectionFactories();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Shutting down JMS FEDeployer");
        }
        Object object = this.shutdownLock;
        synchronized (object) {
            try {
                this.undeployDefaultConnectionFactories();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public void allocate() {
        this.defaultConnectionFactories = new HashMap();
    }

    public FrontEnd getFrontEnd() {
        return this.frontEnd;
    }

    public void setFrontEnd(FrontEnd frontEnd) {
        this.frontEnd = frontEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getShutdownLock() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.shutdownLock;
        }
    }

    public void setShutdownLock(Object object) {
        this.shutdownLock = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeConnectionFactories() {
        FEConnectionFactory fEConnectionFactory = new FEConnectionFactory(this.frontEnd, DEFAULT_FACTORY_NAMES[0][0], DEFAULT_FACTORY_NAMES[0][1], false, false, "All");
        FEConnectionFactory fEConnectionFactory2 = new FEConnectionFactory(this.frontEnd, DEFAULT_FACTORY_NAMES[1][0], DEFAULT_FACTORY_NAMES[1][1], false, true, "All");
        FEConnectionFactory fEConnectionFactory3 = new FEConnectionFactory(this.frontEnd, DEFAULT_FACTORY_NAMES[2][0], DEFAULT_FACTORY_NAMES[2][1], false, true, "All", false, false);
        FEConnectionFactory fEConnectionFactory4 = new FEConnectionFactory(this.frontEnd, DEFAULT_FACTORY_NAMES[3][0], DEFAULT_FACTORY_NAMES[3][1], false, true, "All", false, true);
        FEConnectionFactory fEConnectionFactory5 = new FEConnectionFactory(this.frontEnd, DEFAULT_FACTORY_NAMES[4][0], DEFAULT_FACTORY_NAMES[4][1], false, true, "All", true, false);
        FEConnectionFactory fEConnectionFactory6 = new FEConnectionFactory(this.frontEnd, DEFAULT_FACTORY_NAMES[5][0], DEFAULT_FACTORY_NAMES[5][1], false, true, "Previous");
        FEConnectionFactory fEConnectionFactory7 = new FEConnectionFactory(this.frontEnd, DEFAULT_FACTORY_NAMES[6][0], DEFAULT_FACTORY_NAMES[6][1], true, true, "Previous");
        FEConnectionFactory fEConnectionFactory8 = new FEConnectionFactory(this.frontEnd, DEFAULT_FACTORY_NAMES[7][0], DEFAULT_FACTORY_NAMES[7][1], true, true, "Previous");
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.jmsService.isShutdown()) {
                return;
            }
            this.defaultConnectionFactories.put("DefaultConnectionFactory", fEConnectionFactory);
            this.defaultConnectionFactories.put("DefaultXAConnectionFactory", fEConnectionFactory2);
            this.defaultConnectionFactories.put("DefaultXAConnectionFactory0", fEConnectionFactory3);
            this.defaultConnectionFactories.put("DefaultXAConnectionFactory1", fEConnectionFactory4);
            this.defaultConnectionFactories.put("DefaultXAConnectionFactory2", fEConnectionFactory5);
            this.defaultConnectionFactories.put("MessageDrivenBeanConnectionFactory", fEConnectionFactory6);
            this.defaultConnectionFactories.put("QueueConnectionFactory", fEConnectionFactory7);
            this.defaultConnectionFactories.put("TopicConnectionFactory", fEConnectionFactory8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployDefaultConnectionFactories() {
        Iterator iterator;
        int n = 0;
        Object object = this.shutdownLock;
        synchronized (object) {
            iterator = ((HashMap)this.defaultConnectionFactories.clone()).values().iterator();
        }
        try {
            while (iterator.hasNext()) {
                FEConnectionFactory fEConnectionFactory = (FEConnectionFactory)iterator.next();
                if (this.jmsService.isActive()) {
                    fEConnectionFactory.bind();
                }
                this.frontEnd.connectionFactoryAdd(fEConnectionFactory);
                ++n;
            }
        }
        catch (JMSException jMSException) {
            JMSLogger.logConnFactoryFailed((String)this.jmsService.getMbeanName(), (Exception)((Object)jMSException));
        }
        JMSLogger.logCntDefCFactory((int)n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployDefaultConnectionFactories() throws JMSException {
        Iterator iterator;
        Object object = this.shutdownLock;
        synchronized (object) {
            iterator = ((HashMap)this.defaultConnectionFactories.clone()).values().iterator();
        }
        while (iterator.hasNext()) {
            try {
                object = (FEConnectionFactory)iterator.next();
                ((FEConnectionFactory)object).shutdown();
                Object object2 = this.shutdownLock;
                synchronized (object2) {
                    this.defaultConnectionFactories.remove(object);
                }
                this.frontEnd.connectionFactoryRemove((FEConnectionFactory)object);
            }
            catch (Throwable throwable) {}
        }
        JMSLogger.logCntDefCFactoryUndeployed((int)this.defaultConnectionFactories.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FEConnectionFactory[] getDefaultConnectionFactories() {
        Object object = this.shutdownLock;
        synchronized (object) {
            FEConnectionFactory[] fEConnectionFactoryArray = new FEConnectionFactory[this.defaultConnectionFactories.size()];
            return this.defaultConnectionFactories.values().toArray(fEConnectionFactoryArray);
        }
    }

    public FEConnectionFactory getDefaultConnectionFactory(String string) {
        return (FEConnectionFactory)this.defaultConnectionFactories.get(string);
    }
}

