/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dispatcher;

import javax.jms.JMSException;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.DispatcherPeerGoneListener;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.utils.StackTraceUtilsClient;

public final class DispatcherAdapter
implements JMSDispatcher {
    private final Dispatcher delegate;

    DispatcherAdapter(Dispatcher dispatcher) {
        this.delegate = dispatcher;
    }

    public void dispatchNoReply(Request request) throws JMSException {
        try {
            this.delegate.dispatchNoReply(request);
        }
        catch (DispatcherException dispatcherException) {
            throw DispatcherAdapter.convertToJMSExceptionAndThrow(dispatcherException);
        }
    }

    public void dispatchNoReplyWithId(Request request, int n) throws JMSException {
        try {
            this.delegate.dispatchNoReplyWithId(request, n);
        }
        catch (DispatcherException dispatcherException) {
            throw DispatcherAdapter.convertToJMSExceptionAndThrow(dispatcherException);
        }
    }

    public Response dispatchSync(Request request) throws JMSException {
        try {
            return this.delegate.dispatchSync(request);
        }
        catch (DispatcherException dispatcherException) {
            throw DispatcherAdapter.convertToJMSExceptionAndThrow(dispatcherException);
        }
    }

    public Response dispatchSyncTran(Request request) throws JMSException {
        try {
            return this.delegate.dispatchSyncTran(request);
        }
        catch (DispatcherException dispatcherException) {
            throw DispatcherAdapter.convertToJMSExceptionAndThrow(dispatcherException);
        }
    }

    public Response dispatchSyncNoTran(Request request) throws JMSException {
        try {
            return this.delegate.dispatchSyncNoTran(request);
        }
        catch (DispatcherException dispatcherException) {
            throw DispatcherAdapter.convertToJMSExceptionAndThrow(dispatcherException);
        }
    }

    public Response dispatchSyncNoTranWithId(Request request, int n) throws JMSException {
        try {
            return this.delegate.dispatchSyncNoTranWithId(request, n);
        }
        catch (DispatcherException dispatcherException) {
            throw DispatcherAdapter.convertToJMSExceptionAndThrow(dispatcherException);
        }
    }

    public DispatcherId getId() {
        return this.delegate.getId();
    }

    public boolean isLocal() {
        return this.delegate.isLocal();
    }

    public void dispatchAsync(Request request) throws DispatcherException {
        this.delegate.dispatchAsync(request);
    }

    public DispatcherPeerGoneListener addDispatcherPeerGoneListener(DispatcherPeerGoneListener dispatcherPeerGoneListener) {
        return this.delegate.addDispatcherPeerGoneListener(dispatcherPeerGoneListener);
    }

    public void removeDispatcherPeerGoneListener(DispatcherPeerGoneListener dispatcherPeerGoneListener) {
        this.delegate.removeDispatcherPeerGoneListener(dispatcherPeerGoneListener);
    }

    public Dispatcher getDelegate() {
        return this.delegate;
    }

    private static JMSException convertToJMSExceptionAndThrow(DispatcherException dispatcherException) throws JMSException {
        Throwable throwable = dispatcherException.getCause();
        while (throwable instanceof DispatcherException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof JMSException) {
            return (JMSException)StackTraceUtilsClient.getThrowableWithCause((Throwable)throwable);
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new weblogic.jms.common.JMSException(dispatcherException);
    }
}

