/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.internal;

import javax.jms.JMSException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.dotnet.proxy.internal.ProxyManagerImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyBootstrapResponse;
import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.ReceivedTwoWay;
import weblogic.jms.dotnet.transport.ServiceTwoWay;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.TransportError;

public class BootstrapService
implements ServiceTwoWay {
    private static final ProxyManagerImpl manager = ProxyManagerImpl.getProxyManager();

    public final void invoke(ReceivedTwoWay receivedTwoWay) {
        if (manager.isShutdown()) {
            receivedTwoWay.send(new TransportError(new JMSException("The JMS service is shutting down")));
            return;
        }
        MarshalWritable marshalWritable = null;
        MarshalReadable marshalReadable = receivedTwoWay.getRequest();
        switch (marshalReadable.getMarshalTypeCode()) {
            case 20000: {
                if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
                    JMSDebug.JMSDotNetProxy.debug("Got bootstrap request -- ");
                }
                Transport transport = receivedTwoWay.getTransport();
                transport.addMarshalReadableFactory(manager);
                transport.registerService(10004L, manager);
                marshalWritable = new ProxyBootstrapResponse(10004L);
                break;
            }
            default: {
                marshalWritable = new TransportError("Invalid MarshalReadableType : " + marshalReadable.getMarshalTypeCode(), false);
            }
        }
        receivedTwoWay.send(marshalWritable);
    }

    public void onPeerGone(TransportError transportError) {
    }

    public void onShutdown() {
    }

    public void onUnregister() {
    }
}

