/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.internal;

import java.security.PrivilegedExceptionAction;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.dotnet.proxy.internal.BaseProxy;
import weblogic.jms.dotnet.proxy.internal.ConnectionProxy;
import weblogic.jms.dotnet.proxy.internal.EncrypUtil;
import weblogic.jms.dotnet.proxy.internal.InitialContextProxy;
import weblogic.jms.dotnet.proxy.protocol.ProxyConnectionCreateRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyConnectionCreateResponse;
import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.ReceivedTwoWay;
import weblogic.jms.dotnet.transport.ServiceTwoWay;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.TransportError;
import weblogic.jms.extensions.WLConnection;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.subject.AbstractSubject;

public class ConnectionFactoryProxy
extends BaseProxy
implements ServiceTwoWay {
    private String jndiName;
    private ConnectionFactory factory;

    public ConnectionFactoryProxy(long l, String string, InitialContextProxy initialContextProxy, ConnectionFactory connectionFactory) {
        super(l, initialContextProxy);
        this.jndiName = string;
        this.factory = connectionFactory;
    }

    private final Connection createConnection() throws JMSException {
        return this.factory.createConnection();
    }

    private final Connection createConnection(String string, String string2) throws JMSException {
        return this.factory.createConnection(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MarshalWritable createConnection(ProxyConnectionCreateRequest proxyConnectionCreateRequest) {
        String string;
        String string2;
        try {
            string2 = proxyConnectionCreateRequest.getUserName();
            string2 = EncrypUtil.decryptString(this.getTransport(), string2);
            string = proxyConnectionCreateRequest.getPassword();
            string = EncrypUtil.decryptString(this.getTransport(), string);
        }
        catch (Exception exception) {
            return new TransportError(exception);
        }
        final String string3 = string2;
        final String string4 = string;
        boolean bl = proxyConnectionCreateRequest.isCreateXAConnection();
        Connection connection = null;
        AuthenticatedSubject authenticatedSubject = JMSSecurityHelper.getCurrentSubject();
        try {
            connection = (Connection)JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

                public Object run() throws JMSException {
                    if (string3 == null) {
                        return ConnectionFactoryProxy.this.createConnection();
                    }
                    return ConnectionFactoryProxy.this.createConnection(string3, string4);
                }
            });
            long l = this.getTransport().allocateServiceID();
            int n = ((WLConnection)connection).getAcknowledgePolicy();
            if (n != 2 && n != 1) {
                throw new JMSException("Unknown acknowledge policy " + n);
            }
            ((WLConnection)connection).setAcknowledgePolicy(2);
            ConnectionProxy connectionProxy = new ConnectionProxy(l, (InitialContextProxy)this.parent, connection, string3, string4, proxyConnectionCreateRequest.getListenerServiceId());
            this.getTransport().registerService(l, connectionProxy);
            ((InitialContextProxy)this.parent).addConnection(l, connectionProxy);
            if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
                JMSDebug.JMSDotNetProxy.debug("Created JMS connection: id = " + l + " client id = " + connection.getClientID());
            }
            ProxyConnectionCreateResponse proxyConnectionCreateResponse = new ProxyConnectionCreateResponse(l, connection.getClientID(), n, connectionProxy.getMetadata());
            return proxyConnectionCreateResponse;
        }
        catch (JMSException jMSException) {
            TransportError transportError = new TransportError(jMSException);
            return transportError;
        }
        finally {
            JMSSecurityHelper.pushSubject(authenticatedSubject);
        }
    }

    synchronized void remove(long l) {
    }

    public final void invoke(ReceivedTwoWay receivedTwoWay) {
        if (this.isShutdown()) {
            receivedTwoWay.send(new TransportError(new JMSException("The JMS service is shutting down")));
            return;
        }
        MarshalReadable marshalReadable = receivedTwoWay.getRequest();
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("Invoking: code = " + marshalReadable.getMarshalTypeCode() + " request = " + marshalReadable);
        }
        MarshalWritable marshalWritable = null;
        switch (marshalReadable.getMarshalTypeCode()) {
            case 9: {
                marshalWritable = this.createConnection((ProxyConnectionCreateRequest)marshalReadable);
                break;
            }
            default: {
                marshalWritable = new TransportError("Invalid MarshalReadableType : " + marshalReadable.getMarshalTypeCode(), false);
            }
        }
        receivedTwoWay.send(marshalWritable);
    }

    public void onPeerGone(TransportError transportError) {
    }

    public void onShutdown() {
    }

    public void onUnregister() {
    }

    public Transport getTransport() {
        return this.parent.getTransport();
    }

    InitialContextProxy getContext() {
        return this.parent.getContext();
    }

    public AbstractSubject getSubject() {
        return this.parent.getSubject();
    }
}

