/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.internal;

import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.security.auth.login.LoginException;
import weblogic.jms.client.ConnectionInternal;
import weblogic.jms.common.JMSConstants;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.dotnet.proxy.internal.BaseProxy;
import weblogic.jms.dotnet.proxy.internal.InitialContextProxy;
import weblogic.jms.dotnet.proxy.internal.SessionProxy;
import weblogic.jms.dotnet.proxy.protocol.ProxyConnectionCommandRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyConnectionMetaDataImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyConnectionSetClientIdRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyPushExceptionRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxySessionCreateRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxySessionCreateResponse;
import weblogic.jms.dotnet.proxy.protocol.ProxyVoidResponse;
import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.ReceivedTwoWay;
import weblogic.jms.dotnet.transport.SendHandlerOneWay;
import weblogic.jms.dotnet.transport.ServiceTwoWay;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.TransportError;
import weblogic.jms.extensions.WLConnection;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.subject.AbstractSubject;

public class ConnectionProxy
extends BaseProxy
implements ServiceTwoWay,
ExceptionListener {
    private Connection connection;
    private AbstractSubject subject;
    private final long listenerServiceId;
    private ProxyConnectionMetaDataImpl metadata;
    private Map<Long, SessionProxy> sessions = new HashMap<Long, SessionProxy>();

    ConnectionProxy(long l, InitialContextProxy initialContextProxy, final Connection connection, String string, String string2, long l2) throws JMSException {
        super(l, initialContextProxy);
        this.connection = connection;
        if (connection instanceof WLConnection) {
            ((WLConnection)connection).setReconnectPolicy(JMSConstants.RECONNECT_POLICY_NONE);
        }
        if (connection instanceof ConnectionInternal && ((ConnectionInternal)connection).getFEPeerInfo().getMajor() < 8) {
            throw new JMSException(".NET client cannot talk to a pre-8.1 server");
        }
        this.subject = null;
        if (string != null && string2 != null) {
            try {
                this.subject = JMSSecurityHelper.authenticatedSubject(string, string2);
            }
            catch (LoginException loginException) {
                throw new JMSException("User '" + string + "' does not have the permission!");
            }
        } else {
            this.subject = initialContextProxy.getSubject();
        }
        if (JMSSecurityHelper.isServerIdentity((AuthenticatedSubject)this.subject)) {
            this.subject = JMSSecurityHelper.getAnonymousSubject();
        }
        this.listenerServiceId = l2;
        JMSSecurityHelper.doAs(this.subject, new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                connection.setExceptionListener((ExceptionListener)ConnectionProxy.this);
                return null;
            }
        });
        this.metadata = new ProxyConnectionMetaDataImpl(connection.getMetaData());
    }

    private final synchronized void setClientId(final String string) throws JMSException {
        JMSSecurityHelper.doAs(this.subject, new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                if (ConnectionProxy.this.connection != null) {
                    ConnectionProxy.this.connection.setClientID(string);
                }
                return null;
            }
        });
    }

    private final synchronized void start() throws JMSException {
        JMSSecurityHelper.doAs(this.subject, new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                if (ConnectionProxy.this.connection != null) {
                    ConnectionProxy.this.connection.start();
                }
                return null;
            }
        });
    }

    private final synchronized void stop() throws JMSException {
        JMSSecurityHelper.doAs(this.subject, new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                if (ConnectionProxy.this.connection != null) {
                    ConnectionProxy.this.connection.stop();
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() throws JMSException {
        ConnectionProxy connectionProxy = this;
        synchronized (connectionProxy) {
            if ((this.state & 1) != 0) {
                return;
            }
            this.state = 1;
        }
        this.unregister();
        this.parent.remove(this.serviceId);
        JMSSecurityHelper.doAs(this.subject, new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                ConnectionProxy.this.connection.close();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister() {
        this.getTransport().unregisterService(this.serviceId);
        ConnectionProxy connectionProxy = this;
        synchronized (connectionProxy) {
            for (SessionProxy sessionProxy : this.sessions.values()) {
                sessionProxy.unregister();
            }
            this.sessions.clear();
        }
    }

    public final String toString() {
        return "Proxy for " + this.connection.toString();
    }

    private final MarshalWritable createSession(ProxySessionCreateRequest proxySessionCreateRequest) throws JMSException {
        final boolean bl = proxySessionCreateRequest.getTransacted();
        boolean bl2 = proxySessionCreateRequest.getXASession();
        int n = proxySessionCreateRequest.getAcknowledgeMode();
        long l = proxySessionCreateRequest.getSessionMsgListenerServiceId();
        final int n2 = n == 1 || n == 3 ? 2 : n;
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("CreateSession: transacted = " + bl + " ackMode = " + this.getAckModeString(n) + " adjusted ackMode = " + this.getAckModeString(n2));
        }
        Session session = (Session)JMSSecurityHelper.doAs(this.subject, new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                return ConnectionProxy.this.connection.createSession(bl, n2);
            }
        });
        long l2 = this.getTransport().allocateServiceID();
        SessionProxy sessionProxy = new SessionProxy(l2, this, session, n, l);
        this.getTransport().registerService(l2, sessionProxy);
        this.addSession(l2, sessionProxy);
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("Created JMS session: id = " + this.serviceId);
        }
        return new ProxySessionCreateResponse(l2, session);
    }

    private synchronized void addSession(long l, SessionProxy sessionProxy) throws JMSException {
        this.checkShutdownOrClosed("The connection to the proxy has been closed");
        this.sessions.put(l, sessionProxy);
    }

    synchronized void remove(long l) {
        this.sessions.remove(l);
    }

    public final void invoke(ReceivedTwoWay receivedTwoWay) {
        if (this.isShutdown()) {
            receivedTwoWay.send(new TransportError(new JMSException("The JMS service is shutting down")));
            return;
        }
        if (this.isClosed()) {
            receivedTwoWay.send(new TransportError(new JMSException("The connection has been closed")));
            return;
        }
        MarshalReadable marshalReadable = receivedTwoWay.getRequest();
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("Invoking: code = " + marshalReadable.getMarshalTypeCode() + " request = " + marshalReadable);
        }
        MarshalWritable marshalWritable = ProxyVoidResponse.THE_ONE;
        try {
            switch (marshalReadable.getMarshalTypeCode()) {
                case 30: {
                    marshalWritable = this.createSession((ProxySessionCreateRequest)marshalReadable);
                    break;
                }
                case 8: {
                    int n = ((ProxyConnectionCommandRequest)marshalReadable).getCommandCode();
                    if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
                        JMSDebug.JMSDotNetProxy.debug("Invoke(): CommandCode = " + ((ProxyConnectionCommandRequest)marshalReadable).getCommandCodeString());
                    }
                    try {
                        if (n == 1) {
                            this.start();
                            break;
                        }
                        if (n == 3) {
                            this.close();
                            break;
                        }
                        if (n == 2) {
                            this.stop();
                        }
                    }
                    catch (JMSException jMSException) {
                        marshalWritable = new TransportError(jMSException);
                    }
                    break;
                }
                case 11: {
                    this.setClientId(((ProxyConnectionSetClientIdRequest)marshalReadable).getClientId());
                    break;
                }
                default: {
                    marshalWritable = new TransportError("Invalid MarshalReadableType : " + marshalReadable.getMarshalTypeCode(), false);
                }
            }
        }
        catch (JMSException jMSException) {
            marshalWritable = new TransportError(jMSException);
        }
        receivedTwoWay.send(marshalWritable);
    }

    public void onPeerGone(TransportError transportError) {
    }

    public void onShutdown() {
    }

    public void onUnregister() {
    }

    Transport getTransport() {
        return this.parent.getTransport();
    }

    InitialContextProxy getContext() {
        return this.parent.getContext();
    }

    AbstractSubject getSubject() {
        return this.subject;
    }

    public ProxyConnectionMetaDataImpl getMetadata() {
        return this.metadata;
    }

    private String getAckModeString(int n) {
        switch (n) {
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
        }
        if (this.connection instanceof WLConnection && n == 4) {
            return "NO_ACKNOWLEDGE";
        }
        return "Invalid Ack Mode: " + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException jMSException) {
        try {
            this.close();
        }
        catch (JMSException jMSException2) {
            // empty catch block
        }
        ConnectionProxy connectionProxy = this;
        synchronized (connectionProxy) {
            Transport transport = this.getTransport();
            final SendHandlerOneWay sendHandlerOneWay = transport.createOneWay(this.listenerServiceId);
            final ProxyPushExceptionRequest proxyPushExceptionRequest = new ProxyPushExceptionRequest(jMSException);
            try {
                JMSSecurityHelper.doAs(JMSSecurityHelper.getAnonymousSubject(), new PrivilegedExceptionAction(){

                    public Object run() {
                        sendHandlerOneWay.send(proxyPushExceptionRequest);
                        return null;
                    }
                });
            }
            catch (JMSException jMSException3) {
                // empty catch block
            }
        }
    }
}

