/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.dotnet.proxy.internal;

import java.security.PrivilegedExceptionAction;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import weblogic.jms.client.WLConsumerImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.common.ObjectMessageImpl;
import weblogic.jms.dotnet.proxy.internal.BaseProxy;
import weblogic.jms.dotnet.proxy.internal.InitialContextProxy;
import weblogic.jms.dotnet.proxy.internal.SessionProxy;
import weblogic.jms.dotnet.proxy.protocol.ProxyBytesMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyConsumerCloseRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyConsumerReceiveRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyConsumerReceiveResponse;
import weblogic.jms.dotnet.proxy.protocol.ProxyConsumerSetListenerRequest;
import weblogic.jms.dotnet.proxy.protocol.ProxyConsumerSetListenerResponse;
import weblogic.jms.dotnet.proxy.protocol.ProxyHdrMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyMapMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyObjectMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyStreamMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyTextMessageImpl;
import weblogic.jms.dotnet.proxy.protocol.ProxyVoidResponse;
import weblogic.jms.dotnet.transport.MarshalReadable;
import weblogic.jms.dotnet.transport.MarshalWritable;
import weblogic.jms.dotnet.transport.ReceivedTwoWay;
import weblogic.jms.dotnet.transport.ServiceTwoWay;
import weblogic.jms.dotnet.transport.Transport;
import weblogic.jms.dotnet.transport.TransportError;
import weblogic.jms.extensions.WLAsyncSession;
import weblogic.security.subject.AbstractSubject;

public final class ConsumerProxy
extends BaseProxy
implements ServiceTwoWay {
    private MessageConsumer consumer;
    private WLAsyncSession wlAsyncSession;
    private WLConsumerImpl wlConsumerImpl;
    private ProxyMessageListener listener;
    private static final boolean USE_ASYNC;

    ConsumerProxy(long l, SessionProxy sessionProxy, MessageConsumer messageConsumer) {
        super(l, sessionProxy);
        this.consumer = messageConsumer;
        if (USE_ASYNC && sessionProxy.getSession() instanceof WLAsyncSession) {
            this.wlAsyncSession = (WLAsyncSession)sessionProxy.getSession();
        }
        if (messageConsumer instanceof WLConsumerImpl) {
            this.wlConsumerImpl = (WLConsumerImpl)messageConsumer;
        }
    }

    public final SessionProxy getSession() {
        return (SessionProxy)this.parent;
    }

    public final String toString() {
        return this.consumer.toString();
    }

    final void close() throws JMSException {
        this.close(null);
    }

    final void close(final ProxyConsumerCloseRequest proxyConsumerCloseRequest) throws JMSException {
        this.unregister();
        this.parent.remove(this.serviceId);
        JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                if (ConsumerProxy.this.wlConsumerImpl != null && proxyConsumerCloseRequest != null) {
                    ConsumerProxy.this.wlConsumerImpl.close(proxyConsumerCloseRequest.getSequenceNumber());
                }
                if (ConsumerProxy.this.consumer != null) {
                    ConsumerProxy.this.consumer.close();
                }
                ConsumerProxy.this.wlConsumerImpl = null;
                ConsumerProxy.this.consumer = null;
                return null;
            }
        });
    }

    void unregister() {
        this.getTransport().unregisterService(this.serviceId);
    }

    void remove(long l) {
    }

    private final void receiveAsync(ProxyConsumerReceiveRequest proxyConsumerReceiveRequest, ReceivedTwoWay receivedTwoWay) {
        final ProxyConsumerReceiveRequest proxyConsumerReceiveRequest2 = proxyConsumerReceiveRequest;
        proxyConsumerReceiveRequest2.setReceivedTwoWay(receivedTwoWay);
        proxyConsumerReceiveRequest2.setConsumerProxy(this);
        final long l = proxyConsumerReceiveRequest2.getTimeout();
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("ReceiveAsync(): timeout = " + l);
        }
        try {
            JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

                public Object run() {
                    if (l == 0L) {
                        ConsumerProxy.this.wlAsyncSession.receiveNoWaitAsync(ConsumerProxy.this.consumer, proxyConsumerReceiveRequest2);
                    } else if (l == -1L) {
                        ConsumerProxy.this.wlAsyncSession.receiveAsync(ConsumerProxy.this.consumer, proxyConsumerReceiveRequest2);
                    } else {
                        ConsumerProxy.this.wlAsyncSession.receiveAsync(ConsumerProxy.this.consumer, l, proxyConsumerReceiveRequest2);
                    }
                    return proxyConsumerReceiveRequest2;
                }
            });
        }
        catch (Throwable throwable) {
            proxyConsumerReceiveRequest2.onException(throwable);
        }
    }

    public void receiveException(Throwable throwable, ReceivedTwoWay receivedTwoWay) {
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("ReceiveAsync() failed:  throwable = " + throwable);
        }
        this.sendResult(receivedTwoWay, new TransportError(throwable));
    }

    private void sendResult(final ReceivedTwoWay receivedTwoWay, final MarshalWritable marshalWritable) {
        try {
            JMSSecurityHelper.doAs((AbstractSubject)anonymous, new PrivilegedExceptionAction(){

                public Object run() {
                    receivedTwoWay.send(marshalWritable);
                    return receivedTwoWay;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void receiveCompletion(Object object, ReceivedTwoWay receivedTwoWay) {
        this.sendResult(receivedTwoWay, this.asyncCompletion(object));
    }

    private MarshalWritable asyncCompletion(Object object) {
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("ReceiveAsync() returned:  response = " + object);
        }
        if (object instanceof Throwable) {
            return new TransportError((Throwable)object);
        }
        if (object != null && !(object instanceof Message)) {
            return new TransportError(new Error("Wrong response " + object + " is " + object.getClass().getName()));
        }
        try {
            return this.complete((Message)object);
        }
        catch (Throwable throwable) {
            return new TransportError(throwable);
        }
    }

    private MarshalWritable complete(Message message) throws JMSException {
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("Received: JMS message = " + message);
            if (message instanceof ObjectMessage) {
                JMSDebug.JMSDotNetProxy.debug(" Received: JMS message = " + ((ObjectMessageImpl)message).getPayload());
            }
        }
        ProxyMessageImpl proxyMessageImpl = message == null ? null : ConsumerProxy.createProxyMessageImpl(message);
        return new ProxyConsumerReceiveResponse(proxyMessageImpl);
    }

    private final MarshalWritable receiveSync(ProxyConsumerReceiveRequest proxyConsumerReceiveRequest) {
        final long l = proxyConsumerReceiveRequest.getTimeout();
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("ReceiveSync(): timeout = " + l);
        }
        try {
            Message message = (Message)JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

                public Object run() throws JMSException {
                    if (l == 0L) {
                        return ConsumerProxy.this.consumer.receiveNoWait();
                    }
                    if (l == -1L) {
                        return ConsumerProxy.this.consumer.receive();
                    }
                    return ConsumerProxy.this.consumer.receive(l);
                }
            });
            return this.complete(message);
        }
        catch (JMSException jMSException) {
            return new TransportError(jMSException);
        }
        catch (Throwable throwable) {
            return new TransportError(throwable);
        }
    }

    private final MarshalWritable setListener(final ProxyConsumerSetListenerRequest proxyConsumerSetListenerRequest) throws JMSException {
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("SetListener: hasListener = " + proxyConsumerSetListenerRequest.getHasListener());
        }
        if (proxyConsumerSetListenerRequest.getHasListener()) {
            this.wlConsumerImpl.setProxyID(proxyConsumerSetListenerRequest.getListenerServiceId());
            this.listener = new ProxyMessageListener(this, proxyConsumerSetListenerRequest.getListenerServiceId());
        } else {
            this.listener = null;
        }
        JMSSecurityHelper.doAs(this.getSubject(), new PrivilegedExceptionAction(){

            public Object run() throws JMSException {
                if (ConsumerProxy.this.wlConsumerImpl == null) {
                    throw new JMSException("not implemented");
                }
                ConsumerProxy.this.wlConsumerImpl.setMessageListener(ConsumerProxy.this.listener, proxyConsumerSetListenerRequest.getSequenceNumber());
                return null;
            }
        });
        return new ProxyConsumerSetListenerResponse();
    }

    public final void invoke(ReceivedTwoWay receivedTwoWay) {
        MarshalReadable marshalReadable = receivedTwoWay.getRequest();
        if (JMSDebug.JMSDotNetProxy.isDebugEnabled()) {
            JMSDebug.JMSDotNetProxy.debug("invoke():  code = " + marshalReadable.getMarshalTypeCode() + " request = " + marshalReadable);
        }
        MarshalWritable marshalWritable = null;
        try {
            switch (marshalReadable.getMarshalTypeCode()) {
                case 16: {
                    if (this.wlAsyncSession != null) {
                        this.receiveAsync((ProxyConsumerReceiveRequest)marshalReadable, receivedTwoWay);
                        return;
                    }
                    marshalWritable = this.receiveSync((ProxyConsumerReceiveRequest)marshalReadable);
                    break;
                }
                case 18: {
                    marshalWritable = this.setListener((ProxyConsumerSetListenerRequest)marshalReadable);
                    break;
                }
                case 12: {
                    this.close((ProxyConsumerCloseRequest)marshalReadable);
                    marshalWritable = ProxyVoidResponse.THE_ONE;
                    break;
                }
                default: {
                    marshalWritable = new TransportError("Invalid MarshalReadableType : " + marshalReadable.getMarshalTypeCode(), false);
                    break;
                }
            }
        }
        catch (JMSException jMSException) {
            marshalWritable = new TransportError(jMSException);
        }
        receivedTwoWay.send(marshalWritable);
    }

    public void onPeerGone(TransportError transportError) {
    }

    public void onShutdown() {
    }

    public void onUnregister() {
    }

    public Transport getTransport() {
        return this.parent.getTransport();
    }

    InitialContextProxy getContext() {
        return this.parent.getContext();
    }

    public AbstractSubject getSubject() {
        return this.parent.getSubject();
    }

    static ProxyMessageImpl createProxyMessageImpl(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            return new ProxyTextMessageImpl((TextMessage)message);
        }
        if (message instanceof BytesMessage) {
            return new ProxyBytesMessageImpl((BytesMessage)message);
        }
        if (message instanceof MapMessage) {
            return new ProxyMapMessageImpl((MapMessage)message);
        }
        if (message instanceof StreamMessage) {
            return new ProxyStreamMessageImpl((StreamMessage)message);
        }
        if (message instanceof ObjectMessage) {
            return new ProxyObjectMessageImpl((ObjectMessage)message);
        }
        if (message instanceof Message) {
            return new ProxyHdrMessageImpl(message);
        }
        throw new AssertionError((Object)("Unexpected message type " + message.getClass().getName()));
    }

    static {
        String string = null;
        boolean bl = true;
        try {
            string = System.getProperty("weblogic.jms.dotnet.RecvAsync");
            if (string != null) {
                bl = Boolean.valueOf(string);
            }
            if (!bl) {
                System.err.println("\n\nweblogic.jms.dotnet.proxy.internal.ConsumerProxy -Dweblogic.jms.dotnet.RecvAsync=" + bl);
            }
        }
        catch (Throwable throwable) {
            if (string != null) {
                System.err.println("\n\nproblem processing -Dweblogic.jms.dotnet.RecvAsync=" + string);
            }
            throwable.printStackTrace();
        }
        USE_ASYNC = bl;
    }

    public final class ProxyMessageListener
    implements MessageListener {
        private final ConsumerProxy consumer;
        private final long listenerServiceId;

        ProxyMessageListener(ConsumerProxy consumerProxy2, long l) {
            this.consumer = consumerProxy2;
            this.listenerServiceId = l;
        }

        SessionProxy getSession() {
            return (SessionProxy)this.consumer.getParent();
        }

        public final String toString() {
            return this.consumer.toString();
        }

        public void onMessage(Message message) {
        }
    }
}

